/*
 ______           _____            _               ____
|  ____|         |  __ \          (_)             |___ \
| |__ _   _ _ __ | |__) |__ _  ___ _ _ __   __ _    __) |
|  __| | | | '_ \|  _  // _` |/ __| | '_ \ / _` |  |__ <
| |  | |_| | | | | | \ \ (_| | (__| | | | | (_| |  ___) |
|_|   \__,_|_| |_|_|  \_\__,_|\___|_|_| |_|\__, | |____/
                                            __/ |
                                           |___/
Copyright (C) 2009 Slempkes Clément

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*/

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <SDL/SDL.h>
#include <SDL/SDL_image.h>
#include <SDL/SDL_mixer.h>
#include <time.h>
#include <string.h>

#include "pixel.h"
#include "const.h"
#include "funracing.h"

struct _config
{
    int medal;
    int sound;
    color playerColor1[4];
    color playerColor2[4];
    color playerColor3[4];
    int control[4];
    int nbrPlayer, nbrCPU, nbrLaps, botDim, selectFile;

}config = {0, 1, {{255,0,0},{76,255,0},{0,148,255},{255,216,0}}, {{127,0,0},{38,127,0},{0,74,127},{127,106,0}}, {{255,255,255},{255,255,255},{255,255,255},{255,255,255}}, {0,0,0,0}, 1, 7, 3, 0, 1};

Mix_Chunk *selectsound = NULL;
Mix_Chunk *entersound = NULL;
Mix_Chunk *changesound = NULL;
Mix_Chunk *colorselect = NULL;

SDL_Joystick *joystick[4];
SDL_Event event;
Uint8 *keyState = 0;
Uint32 pixel;
Uint8 r, g, b, a;

int title(SDL_Surface *screen)
{
    SDL_Surface *background = NULL, *menus = NULL, *filter = NULL, *tmp = NULL;
    SDL_Rect rect, clip;
    int close = 0, count = 0, prev = 0, current = 0, select = 0, keypass = 0, filterint = 255;

    //////////////////// Init ////////////////////

        read_config();

        SDL_JoystickEventState(SDL_ENABLE);

        for(count = 0; count < SDL_NumJoysticks(); count++)
        {
            joystick[count] = SDL_JoystickOpen(count);
        }

        if(config.control[0] > 2 + SDL_NumJoysticks()){config.control[0] = 0;}
        if(config.control[1] > 2 + SDL_NumJoysticks()){config.control[1] = 1;}
        if(config.control[2] > 2 + SDL_NumJoysticks()){config.control[2] = 2;}
        if(config.control[3] > 2 + SDL_NumJoysticks()){config.control[3] = 2;}

        selectsound = Mix_LoadWAV("data/sounds/roomkik.wav");
        if(selectsound == NULL)
        {
            fprintf(stderr, "Error : Can't load 'data/sounds/roomkik.wav'\n\n");
            error();
        }
        Mix_VolumeChunk(selectsound, VOLUME);

        entersound = Mix_LoadWAV("data/sounds/roomsnareswitch.wav");
        if(entersound == NULL)
        {
            fprintf(stderr, "Error : Can't load 'data/sounds/roomsnareswitch.wav'\n\n");
            error();
        }
        Mix_VolumeChunk(entersound, VOLUME);

        changesound = Mix_LoadWAV("data/sounds/perchardwinder.wav");
        if(changesound == NULL)
        {
            fprintf(stderr, "Error : Can't load 'data/sounds/perchardwinder.wav'\n\n");
            error();
        }
        Mix_VolumeChunk(changesound, VOLUME);

        colorselect = Mix_LoadWAV("data/sounds/colorselect.wav");
        if(colorselect == NULL)
        {
            fprintf(stderr, "Error : Can't load 'data/sounds/colorselect.wav'\n\n");
            error();
        }
        Mix_VolumeChunk(colorselect, VOLUME);

    //////////////////// End of init ////////////////////

    tmp = IMG_Load("data/sprites/background1.png");
    if(tmp == NULL)
    {
        fprintf(stderr, "Error: Can't load 'data/sprites/background1.png'\n\n");
        error();
    }
    background = SDL_DisplayFormatAlpha(tmp);

    SDL_FreeSurface(tmp);
    tmp = IMG_Load("data/sprites/menus.png");
    if(tmp == NULL)
    {
        fprintf(stderr, "Error: Can't load 'data/sprites/menus.png'\n\n");
        error();
    }
    menus = SDL_DisplayFormatAlpha(tmp);

    filter = SDL_CreateRGBSurface(SDL_HWSURFACE, SCREENW, SCREENH, 32, 0, 0, 0, 0);
    SDL_FillRect(filter, NULL, SDL_MapRGB(filter->format, 255, 255, 255));

    while(close == 0)
    {
        current = SDL_GetTicks();
        if (current - prev > (1000/FPS))
        {
            SDL_PollEvent(&event);
            keyState = SDL_GetKeyState(NULL);

            if(event.type == SDL_QUIT){close = 1;}

            if(keyState[SDLK_UP] || keyState[SDLK_DOWN] || keyState[SDLK_RETURN] || SDL_JoystickGetButton(joystick[0], 0) || SDL_JoystickGetAxis(joystick[0], 1) > 3200 || SDL_JoystickGetAxis(joystick[0], 1) < -3200)
            {
                if(keypass)
                {
                    keypass = 0;

                    if(keyState[SDLK_UP] || SDL_JoystickGetAxis(joystick[0], 1) < -3200)
                    {
                        if(config.sound){Mix_PlayChannel(-1, selectsound, 0);}

                        select--;
                        if(select < 0)
                        {
                            select = 3;
                        }
                    }

                    if(keyState[SDLK_DOWN] || SDL_JoystickGetAxis(joystick[0], 1) > 3200)
                    {
                        if(config.sound){Mix_PlayChannel(-1, selectsound, 0);}
                        select++;
                        if(select > 3)
                        {
                            select = 0;
                        }
                    }

                    if(keyState[SDLK_RETURN] || SDL_JoystickGetButton(joystick[0], 0))
                    {
                        if(config.sound){Mix_PlayChannel(-1, entersound, 0);}

                        if(select == 0)
                        {
                            filtering(screen);
                            filterint = 255;
                            if(play(screen) == 1){close = 1;}
                        }
                        else if(select == 1)
                        {
                            filtering(screen);
                            filterint = 255;
                            if(options(screen) == 1){close = 1;}
                        }
                        else if(select == 2)
                        {
                            filtering(screen);
                            filterint = 255;
                            if(credits(screen) == 1){close = 1;}
                        }
                        else if(select == 3)
                        {
                            close = 1;
                        }
                    }
                }
            }
            else{keypass = 1;}

            if(close == 0 && filterint > 0){filterint -= FILTERSTEP;}

            if(!close)
            {
                SDL_BlitSurface(background, NULL, screen, NULL);

                clip.w = menus->w / 2;
                clip.h = menus->h / 14;
                rect.x = SCREENW / 2 - menus->w / 4;

                //////////////////// play ////////////////////

                if(select == 0){clip.x = menus->w/2;}
                else{clip.x = 0;}
                clip.y = 0;

                rect.y = 270;
                SDL_BlitSurface(menus, &clip, screen, &rect);

                //////////////////// options ////////////////////

                if(select == 1){clip.x = menus->w / 2;}
                else{clip.x = 0;}
                clip.y = menus->h / 14;

                rect.y += menus->h / 14 + 15;
                SDL_BlitSurface(menus, &clip, screen, &rect);

                //////////////////// credits ////////////////////

                if(select == 2){clip.x = menus->w / 2;}
                else{clip.x = 0;}
                clip.y = (menus->h / 14) * 2;

                rect.y += menus->h / 14 + 15;
                SDL_BlitSurface(menus, &clip, screen, &rect);

                //////////////////// exit ////////////////////

                if(select == 3){clip.x = menus->w / 2;}
                else{clip.x = 0;}
                clip.y = (menus->h / 14) * 3;

                rect.y += (menus->h/14) + 15;
                SDL_BlitSurface(menus, &clip, screen, &rect);

                if(filterint > 0)
                {
                    SDL_SetAlpha(filter, SDL_SRCALPHA, filterint);
                    SDL_BlitSurface(filter, NULL, screen, NULL);
                }
            }

            SDL_Flip(screen);

            prev = current;
        }
        else
        {
            SDL_Delay((1000/FPS) - (current - prev));
        }
    }

    SDL_FreeSurface(background);
    SDL_FreeSurface(menus);
    SDL_FreeSurface(filter);
    SDL_FreeSurface(tmp);

    Mix_FreeChunk(selectsound);
    Mix_FreeChunk(entersound);
    Mix_FreeChunk(changesound);
    Mix_FreeChunk(colorselect);

    for(count = 0; count < SDL_NumJoysticks(); count++)
    {
        SDL_JoystickClose(joystick[count]);
    }

    save_config();

    return EXIT_SUCCESS;
}

int play(SDL_Surface *screen)
{
    SDL_Surface *background = NULL, *nbr = NULL, *text = NULL, *menus = NULL, *preview = NULL, *previews = NULL, *trackstat = NULL, *filter = NULL, *tmp = NULL;
    SDL_Rect rect, clip;

    FILE* file = NULL;
    int close = 0, rep = 0, select = 0, prev = 0, current = 0, filterint = 255, keypass = 0, nbrFile = 0, intLocked = 0, coverflowX = 0, coverflowXtarget = 0, playloop = 0;
    int nbrPlayer2 = 1, nbrCPU2 = 7, nbrLaps2 = 3, botDim2 = 0;
    double coverflowXspeed = 0;
    char tmpChar[CHARMAX] = "", mapFile[CHARMAX] = "";

    file = fopen("data/tracks/nbrtrack.txt", "r");
    if(file != NULL)
    {
        fscanf(file, "%d", &nbrFile);
        fclose(file);
    }
    else
    {
        fprintf(stderr, "Error: Can't load 'data/tracks/nbrtrack.txt'\n\n");
        error();
    }

    if(nbrFile == 0)
    {
        fprintf(stderr, "Error: Can't find tracks\n\n");
        error();
    }

    tmp = IMG_Load("data/sprites/background2.png");
    if(tmp == NULL)
    {
        fprintf(stderr, "Error: Can't load 'data/sprites/background2.png'\n\n");
        error();
    }
    background = SDL_DisplayFormatAlpha(tmp);

    SDL_FreeSurface(tmp);
    tmp = IMG_Load("data/sprites/nbr.png");
    if(tmp == NULL)
    {
        fprintf(stderr, "Error: Can't load 'data/sprites/nbr.png'\n\n");
        error();
    }
    nbr = SDL_DisplayFormatAlpha(tmp);

    SDL_FreeSurface(tmp);
    tmp = IMG_Load("data/sprites/text.png");
    if(tmp == NULL)
    {
        fprintf(stderr, "Error: Can't load 'data/sprites/text.png'\n\n");
        error();
    }
    text = SDL_DisplayFormatAlpha(tmp);

    SDL_FreeSurface(tmp);
    tmp = IMG_Load("data/sprites/menus.png");
    if(tmp == NULL)
    {
        fprintf(stderr, "Error: Can't load 'data/sprites/menus.png'\n\n");
        error();
    }
    menus = SDL_DisplayFormatAlpha(tmp);

    SDL_FreeSurface(tmp);
    tmp = IMG_Load("data/sprites/trackstat.png");
    if(tmp == NULL)
    {
        fprintf(stderr, "Error: Can't load 'data/sprites/trackstat.png'\n\n");
        error();
    }
    trackstat = SDL_DisplayFormatAlpha(tmp);

    filter = SDL_CreateRGBSurface(SDL_HWSURFACE, SCREENW, SCREENH, 32, 0, 0, 0, 0);
    SDL_FillRect(filter, NULL, SDL_MapRGB(filter->format, 255, 255, 255));

    previews = SDL_CreateRGBSurface(SDL_HWSURFACE, 149 * nbrFile, 112, 32, 0, 0, 0, 0);
    SDL_FillRect(previews, NULL, SDL_MapRGB(previews->format, 255, 255, 255));

    void getTrackInfo()
    {
        sprintf(tmpChar, "data/tracks/%d.track", config.selectFile);
        file = fopen(tmpChar, "r");
        if(file != NULL)
        {
            sprintf(mapFile, "%d.track", config.selectFile);
            sprintf(tmpChar, "data/tracks/%dpre.png", config.selectFile);

            SDL_FreeSurface(preview);
            SDL_FreeSurface(tmp);
            tmp = IMG_Load(tmpChar);
            if(tmp == NULL)
            {
                fprintf(stderr, "Invalid track : '%s'\n\n", mapFile);
                error();
            }
            preview = SDL_DisplayFormatAlpha(tmp);

            rect.x = 149 * (config.selectFile-1);
            rect.y = 0;
            clip.x = 0;
            clip.y = 0;
            clip.w = 149;
            clip.h = 112;
            SDL_BlitSurface(preview, &clip, previews, &rect);

            if(config.medal <= config.selectFile-1)
            {
                intLocked = 1;
                nbrPlayer2 = 1;
                fscanf(file, "%d\n%d\n%d\n", &nbrCPU2, &nbrLaps2, &botDim2);

                if(config.medal == config.selectFile-1){intLocked = 0;}
            }
            else if(config.medal > config.selectFile-1)
            {
                intLocked = 2;
            }

            if(config.nbrCPU > 15){config.nbrCPU = 15; fprintf(stderr, "Invalid track : '%s' (nbrCPU > 15)\n\n", mapFile);}
            else if(config.nbrCPU < 0){config.nbrCPU = 0; fprintf(stderr, "Invalid track : '%s' (nbrCPU < 0)\n\n", mapFile);}

            if(config.nbrLaps > 10){config.nbrLaps = 10; fprintf(stderr, "Invalid track : '%s' (nbrLaps > 10)\n\n", mapFile);}
            else if(config.nbrLaps < 0){config.nbrLaps = 0; fprintf(stderr, "Invalid track : '%s' (nbrLaps < 0)\n\n", mapFile);}

            if(config.botDim > 5){config.botDim = 5; fprintf(stderr, "Invalid track : '%s' (botDim > 5)\n\n", mapFile);}
            else if(config.botDim < 0){config.botDim = 0; fprintf(stderr, "Invalid track : '%s' (botDim < 0)\n\n", mapFile);}

            fclose(file);
        }
    }

    getTrackInfo();
    coverflowXtarget = (config.selectFile-1) * 149;
    coverflowX = coverflowXtarget;

    while(close == 0)
    {
        current = SDL_GetTicks();
        if (current - prev > (1000/FPS))
        {
            SDL_PollEvent(&event);
            keyState = SDL_GetKeyState(NULL);

            if (event.type == SDL_QUIT){close = 1; rep = 1;}

            if(keyState[SDLK_UP] || keyState[SDLK_DOWN] || keyState[SDLK_LEFT] || keyState[SDLK_RIGHT] || keyState[SDLK_RETURN] || keyState[SDLK_ESCAPE] || keyState[SDLK_BACKSPACE] || SDL_JoystickGetButton(joystick[0], 0) || SDL_JoystickGetButton(joystick[0], 5) || SDL_JoystickGetAxis(joystick[0], 1) > 3200 || SDL_JoystickGetAxis(joystick[0], 1) < -3200 || SDL_JoystickGetAxis(joystick[0], 0) > 3200 || SDL_JoystickGetAxis(joystick[0], 0) < -3200)
            {
                if(keypass)
                {
                    keypass = 0;

                    if(keyState[SDLK_ESCAPE] || keyState[SDLK_BACKSPACE] || SDL_JoystickGetButton(joystick[0], 5))
                    {
                        filtering(screen);
                        close = 1;
                        rep = 0;
                    }

                    if(keyState[SDLK_UP] || SDL_JoystickGetAxis(joystick[0], 1) < -3200)
                    {
                        if(config.sound){Mix_PlayChannel(-1, selectsound, 0);}

                        select--;
                        if(select < 0)
                        {
                            select = 6;
                        }
                    }

                    if(keyState[SDLK_DOWN] || SDL_JoystickGetAxis(joystick[0], 1) > 3200)
                    {
                        if(config.sound){Mix_PlayChannel(-1, selectsound, 0);}

                        select++;
                        if(select > 6)
                        {
                            select = 0;
                        }
                    }

                    if(keyState[SDLK_LEFT] || SDL_JoystickGetAxis(joystick[0], 0) < -3200)
                    {

                        if(select == 0)
                        {
                            config.selectFile--;
                            if(config.selectFile < 1)
                            {
                                config.selectFile = 1;
                            }
                            else
                            {
                                if(config.sound){Mix_PlayChannel(-1, changesound, 0);}
                            }

                            getTrackInfo();
                        }
                        else if(select == 1 && intLocked == 2)
                        {
                            if(config.sound){Mix_PlayChannel(-1, changesound, 0);}

                            config.nbrPlayer--;
                            if(config.nbrPlayer < 1)
                            {
                                config.nbrPlayer = 4;
                            }
                        }
                        else if(select == 2 && intLocked == 2)
                        {
                            if(config.sound){Mix_PlayChannel(-1, changesound, 0);}

                            config.nbrCPU--;
                            if(config.nbrCPU < 0)
                            {
                                config.nbrCPU = 15;
                            }
                        }
                        else if(select == 3 && intLocked == 2)
                        {
                            if(config.sound){Mix_PlayChannel(-1, changesound, 0);}

                            config.nbrLaps--;
                            if(config.nbrLaps < 1)
                            {
                                config.nbrLaps = 10;
                            }
                        }
                        else if(select == 4 && intLocked == 2)
                        {
                            if(config.sound){Mix_PlayChannel(-1, changesound, 0);}

                            config.botDim--;
                            if(config.botDim < 0)
                            {
                                config.botDim = 5;
                            }
                        }
                    }

                    if(keyState[SDLK_RIGHT] || SDL_JoystickGetAxis(joystick[0], 0) > 3200)
                    {
                        if(select == 0)
                        {
                            config.selectFile++;
                            if(config.selectFile > nbrFile)
                            {
                                config.selectFile = nbrFile;
                            }
                            else
                            {
                                if(config.sound){Mix_PlayChannel(-1, changesound, 0);}
                            }

                            getTrackInfo();
                        }
                        else if(select == 1 && intLocked == 2)
                        {
                            if(config.sound){Mix_PlayChannel(-1, changesound, 0);}

                            config.nbrPlayer++;
                            if(config.nbrPlayer > 4)
                            {
                                config.nbrPlayer = 1;
                            }
                        }
                        else if(select == 2 && intLocked == 2)
                        {
                            if(config.sound){Mix_PlayChannel(-1, changesound, 0);}

                            config.nbrCPU++;
                            if(config.nbrCPU > 15)
                            {
                                config.nbrCPU = 0;
                            }
                        }
                        else if(select == 3 && intLocked == 2)
                        {
                            if(config.sound){Mix_PlayChannel(-1, changesound, 0);}

                            config.nbrLaps++;
                            if(config.nbrLaps > 10)
                            {
                                config.nbrLaps = 1;
                            }
                        }
                        else if(select == 4 && intLocked == 2)
                        {
                            if(config.sound){Mix_PlayChannel(-1, changesound, 0);}

                            config.botDim++;
                            if(config.botDim > 5)
                            {
                                config.botDim = 0;
                            }
                        }
                    }

                    if(keyState[SDLK_RETURN] || SDL_JoystickGetButton(joystick[0], 0))
                    {
                        if(config.sound){Mix_PlayChannel(-1, entersound, 0);}

                        if(select < 6)
                        {
                            if(intLocked == 0 || intLocked == 2)
                            {
                                do
                                {
                                    filterint = 255;
                                    filtering(screen);

                                    if(config.medal <= config.selectFile-1){rep = gamePlay(screen, nbrPlayer2, nbrCPU2, nbrLaps2, botDim2, intLocked);}
                                    else{rep = gamePlay(screen, config.nbrPlayer, config.nbrCPU, config.nbrLaps, config.botDim, intLocked);}

                                    select = 0;
                                    playloop = 0;

                                    if(rep == 1)
                                    {
                                        close = 1;
                                    }
                                    else if(rep == 2)
                                    {
                                        playloop = 1;
                                    }
                                    else if(rep == 3 && intLocked == 0)
                                    {
                                        config.medal++;
                                        intLocked = 2;
                                    }
                                    else if(rep == 4 && intLocked == 0)
                                    {
                                        config.medal++;
                                        intLocked = 2;
                                        close = 1;
                                        rep = 1;
                                    }
                                    else if(rep == 5 && intLocked == 0)
                                    {
                                        config.medal++;
                                        intLocked = 2;
                                        playloop = 1;
                                    }

                                    save_config();
                                }
                                while(playloop == 1);
                            }
                        }
                        else if(select == 6)
                        {
                            filtering(screen);
                            close = 1;
                            rep = 0;
                        }
                    }
                }
            }
            else{keypass = 1;}

            if(close == 0 && filterint > 0){filterint -= FILTERSTEP;}

            coverflowXtarget = (config.selectFile-1) * 149;
            if(coverflowX > coverflowXtarget)
            {
                coverflowX -= 12;
                if(coverflowX < coverflowXtarget){coverflowX = coverflowXtarget;}
            }

            if(coverflowX < coverflowXtarget)
            {
                coverflowX += 12;
                if(coverflowX > coverflowXtarget){coverflowX = coverflowXtarget;}
            }

            coverflowX += coverflowXspeed;

            if(!close)
            {
                SDL_BlitSurface(background, NULL, screen, NULL);

                clip.x = menus->w/2;
                clip.y = (menus->h/14) * 14;
                clip.w = menus->w/2;
                clip.h = menus->h/14;

                ////////// Laps choice //////////

                if(select == 0){clip.x = menus->w/2;}
                else{clip.x = 0;}
                clip.y = (menus->h/14)*8;

                rect.x = SCREENW / 2 - menus->w / 4;
                rect.y = menus->h/14 + 120;
                SDL_BlitSurface(menus, &clip, screen, &rect);


                clip.x = coverflowX;
                clip.y = 0;
                clip.w = 149;
                clip.h = 112;

                rect.x = SCREENW / 2 - clip.w / 2;
                rect.y -= clip.h/2 - (menus->h/14)/2;
                SDL_BlitSurface(previews, &clip, screen, &rect);
                clip.x = 0;

                clip.w = 150;
                clip.h = 113;
                if(intLocked == 2)
                {
                    clip.y = 0;
                }
                else if(intLocked == 1)
                {
                    clip.y = trackstat->h/3;
                }
                else if(intLocked == 0)
                {
                    clip.y = (trackstat->h/3) * 2;
                }

                SDL_BlitSurface(trackstat, &clip, screen, &rect);

                ////////// config.nbrPlayer choice //////////

                if(select == 1){clip.x = menus->w/2;}
                else{clip.x = 0;}
                if(intLocked == 1 || intLocked == 0){clip.y = (menus->h/14)*12;}
                else{clip.y = (menus->h/14)*8;}
                clip.w = menus->w/2;
                clip.h = menus->h/14;

                rect.x = SCREENW / 2 - menus->w / 4;
                rect.y += menus->h/14 + 100;
                SDL_BlitSurface(menus, &clip, screen, &rect);


                clip.x = 0;
                if(config.medal <= (config.selectFile-1)){clip.y = nbrPlayer2 * (nbr->h / 17);}
                else{clip.y = config.nbrPlayer * (nbr->h / 17);}
                clip.w = nbr->w;
                clip.h = nbr->h / 17;

                rect.x = SCREENW / 2 - ((nbr->w + text->w + 5) / 2);
                SDL_BlitSurface(nbr, &clip, screen, &rect);

                clip.x = 0;
                if(config.nbrPlayer > 1){clip.y = 0;}
                else{clip.y = text->h/19;}
                clip.w = text->w;
                clip.h = text->h/19;

                rect.x += nbr->w+3;
                SDL_BlitSurface(text, &clip, screen, &rect);

                ////////// config.nbrCPU choice //////////

                if(select == 2){clip.x = menus->w/2;}
                else{clip.x = 0;}
                if(intLocked == 1 || intLocked == 0){clip.y = (menus->h/14)*12;}
                else{clip.y = (menus->h/14)*8;}
                clip.w = menus->w/2;
                clip.h = menus->h/14;

                rect.x = SCREENW / 2 - menus->w / 4;
                rect.y += menus->h/14 + 10;
                SDL_BlitSurface(menus, &clip, screen, &rect);

                clip.x = 0;
                if(config.medal <= (config.selectFile-1)){clip.y = nbrCPU2 * (nbr->h / 17);}
                else{clip.y = config.nbrCPU * (nbr->h / 17);}
                clip.w = nbr->w;
                clip.h = nbr->h / 17;

                rect.x = SCREENW / 2 - ((nbr->w + text->w + 5) / 2);
                SDL_BlitSurface(nbr, &clip, screen, &rect);

                clip.x = 0;
                if(config.medal <= (config.selectFile-1))
                {
                    if(config.nbrCPU > 1){clip.y = 2 * (text->h/19);}
                    else{clip.y = 3 * (text->h/19);}
                }
                else
                {
                    if(nbrCPU2 > 1){clip.y = 2 * (text->h/19);}
                    else{clip.y = 3 * (text->h/19);}
                }
                clip.w = text->w;
                clip.h = text->h/19;

                rect.x += nbr->w+3;
                SDL_BlitSurface(text, &clip, screen, &rect);

                ////////// config.nbrLaps choice //////////

                if(select == 3){clip.x = menus->w/2;}
                else{clip.x = 0;}
                if(intLocked == 1 || intLocked == 0){clip.y = (menus->h/14)*12;}
                else{clip.y = (menus->h/14)*8;}
                clip.w = menus->w/2;
                clip.h = menus->h/14;

                rect.x = SCREENW / 2 - menus->w / 4;
                rect.y += menus->h/14 + 10;
                SDL_BlitSurface(menus, &clip, screen, &rect);


                clip.x = 0;
                if(config.medal <= (config.selectFile-1)){clip.y = nbrLaps2 * (nbr->h / 17);}
                else{clip.y = config.nbrLaps * (nbr->h / 17);}
                clip.w = nbr->w;
                clip.h = nbr->h / 17;

                rect.x = SCREENW / 2 - ((nbr->w + text->w + 5) / 2);
                SDL_BlitSurface(nbr, &clip, screen, &rect);

                clip.x = 0;
                if(config.medal <= (config.selectFile-1))
                {
                    if(config.nbrLaps > 1){clip.y = 4 * (text->h/19);}
                    else{clip.y = 5 * (text->h/19);}
                }
                else
                {
                    if(nbrLaps2 > 1){clip.y = 4 * (text->h/19);}
                    else{clip.y = 5 * (text->h/19);}
                }
                clip.w = text->w;
                clip.h = text->h/19;

                rect.x += nbr->w+3;
                SDL_BlitSurface(text, &clip, screen, &rect);

                ////////// botDim choice //////////

                if(select == 4){clip.x = menus->w/2;}
                else{clip.x = 0;}
                if(intLocked == 1 || intLocked == 0){clip.y = (menus->h/14)*12;}
                else{clip.y = (menus->h/14)*8;}
                clip.w = menus->w/2;
                clip.h = menus->h/14;

                rect.x = SCREENW / 2 - menus->w / 4;
                rect.y += menus->h/14 + 10;
                SDL_BlitSurface(menus, &clip, screen, &rect);


                clip.x = 0;
                if(config.medal <= (config.selectFile-1)){clip.y = (13+botDim2) * (text->h / 19);}
                else{clip.y = (13+config.botDim) * (text->h / 19);}
                clip.w = text->w;
                clip.h = text->h / 17;

                rect.x = SCREENW / 2 - text->w / 2;
                SDL_BlitSurface(text, &clip, screen, &rect);

                ////////// Start button //////////

                if(select == 5){clip.x = menus->w/2;}
                else{clip.x = 0;}
                if(intLocked == 1){clip.y = (menus->h/14)*11;}
                else{clip.y = (menus->h/14)*4;}
                clip.w = menus->w/2;
                clip.h = menus->h/14;

                rect.y += (menus->h/14) + 20;
                rect.x = SCREENW / 2 - menus->w / 4;
                if(intLocked){SDL_BlitSurface(menus, &clip, screen, &rect);}
                else{SDL_BlitSurface(menus, &clip, screen, &rect);}

                ////////// Return button //////////

                if(select == 6){clip.x = menus->w/2;}
                else{clip.x = 0;}
                clip.y = (menus->h/14)*7;
                clip.w = menus->w/2;
                clip.h = menus->h/14;

                rect.y += (menus->h/14) + 10;
                SDL_BlitSurface(menus, &clip, screen, &rect);

                if(filterint > 0)
                {
                    SDL_SetAlpha(filter, SDL_SRCALPHA, filterint);
                    SDL_BlitSurface(filter, NULL, screen, NULL);
                }
            }

            SDL_Flip(screen);

            prev = current;
        }
        else
        {
            SDL_Delay((1000/FPS) - (current - prev));
        }
    }

    SDL_FreeSurface(background);
    SDL_FreeSurface(nbr);
    SDL_FreeSurface(text);
    SDL_FreeSurface(menus);
    SDL_FreeSurface(trackstat);
    SDL_FreeSurface(preview);
    SDL_FreeSurface(previews);
    SDL_FreeSurface(filter);
    SDL_FreeSurface(tmp);

    return rep;
}

int options(SDL_Surface *screen)
{
    SDL_Surface *background = NULL, *menus = NULL, *text = NULL, *nbr = NULL, *imgcolors = NULL, *s1 = NULL, *s2 = NULL, *s3 = NULL, *filter = NULL, *colorCadre = NULL, *tmp = NULL;
    SDL_Rect rect, clip;

    int close = 0, prev = 0, current = 0, rep = 0, select = 0, keypass = 0, filterint = 255, curX = 0, curY = 0, playerselect = 1, colorselect = 1, i = 0, j = 0;

    tmp = IMG_Load("data/sprites/background3.png");
    if(tmp == NULL)
    {
        fprintf(stderr, "Error : Can't load 'data/sprites/background3.png'\n\n");
        error();
    }
    background = SDL_DisplayFormatAlpha(tmp);

    SDL_FreeSurface(tmp);
    tmp = IMG_Load("data/sprites/menus.png");
    if(tmp == NULL)
    {
        fprintf(stderr, "Error : Can't load 'data/sprites/menus.png'\n\n");
        error();
    }
    menus = SDL_DisplayFormatAlpha(tmp);

    SDL_FreeSurface(tmp);
    tmp = IMG_Load("data/sprites/text.png");
    if(tmp == NULL)
    {
        fprintf(stderr, "Error : Can't load 'data/sprites/text.png'\n\n");
        error();
    }
    text = SDL_DisplayFormatAlpha(tmp);

    SDL_FreeSurface(tmp);
    tmp = IMG_Load("data/sprites/nbr.png");
    if(tmp == NULL)
    {
        fprintf(stderr, "Error : Can't load 'data/sprites/nbr.png'\n\n");
        error();
    }
    nbr = SDL_DisplayFormatAlpha(tmp);

    SDL_FreeSurface(tmp);
    tmp = IMG_Load("data/sprites/colors.png");
    if(tmp == NULL)
    {
        fprintf(stderr, "Error : Can't load 'data/sprites/colors.png'\n\n");
        error();
    }
    imgcolors = SDL_DisplayFormatAlpha(tmp);

    SDL_FreeSurface(tmp);
    tmp = IMG_Load("data/sprites/car.png");
    if(tmp == NULL)
    {
        fprintf(stderr, "Error : Can't load 'data/sprites/car.png'\n\n");
        error();
    }
    s1 = SDL_DisplayFormatAlpha(tmp);
    s2 = SDL_DisplayFormatAlpha(tmp);
    s3 = SDL_DisplayFormatAlpha(tmp);

    SDL_FreeSurface(tmp);
    tmp = IMG_Load("data/sprites/colorCadre.png");
    if(tmp == NULL)
    {
        fprintf(stderr, "Error : Can't load 'data/sprites/colorCadre.png'\n\n");
        error();
    }
    colorCadre = SDL_DisplayFormatAlpha(tmp);

    curX = imgcolors->w / 2;
    curY = imgcolors->h / 2;

    filter = SDL_CreateRGBSurface(SDL_HWSURFACE, SCREENW, SCREENH, 32, 0, 0, 0, 0);
    SDL_FillRect(filter, NULL, SDL_MapRGB(filter->format, 255, 255, 255));

    while(!close)
    {
        current = SDL_GetTicks();
        if (current - prev > (1000/FPS))
        {
            SDL_PollEvent(&event);
            keyState = SDL_GetKeyState(NULL);

            if (event.type == SDL_QUIT){close = 1; rep = 1;}

            if(keyState[SDLK_UP] || keyState[SDLK_DOWN] || keyState[SDLK_LEFT] || keyState[SDLK_RIGHT] || keyState[SDLK_RETURN] || keyState[SDLK_ESCAPE] || keyState[SDLK_BACKSPACE] || SDL_JoystickGetButton(joystick[0], 0) || SDL_JoystickGetButton(joystick[0], 5) || SDL_JoystickGetAxis(joystick[0], 1) > 3200 || SDL_JoystickGetAxis(joystick[0], 1) < -3200 || SDL_JoystickGetAxis(joystick[0], 0) > 3200 || SDL_JoystickGetAxis(joystick[0], 0) < -3200)
            {
                if(keypass)
                {
                    keypass = 0;

                    if(keyState[SDLK_ESCAPE] || keyState[SDLK_BACKSPACE] || SDL_JoystickGetButton(joystick[0], 5) == 1)
                    {
                        filtering(screen);
                        close = 1;
                        rep = 0;
                    }

                    if(keyState[SDLK_UP] || SDL_JoystickGetAxis(joystick[0], 1) < -3200)
                    {
                        if(config.sound){Mix_PlayChannel(-1, selectsound, 0);}
                        select--;
                        if(select < 0)
                        {
                            select = 5;
                        }
                    }

                    if(keyState[SDLK_DOWN] || SDL_JoystickGetAxis(joystick[0], 1) > 3200)
                    {
                        if(config.sound){Mix_PlayChannel(-1, selectsound, 0);}
                        select++;
                        if(select > 5)
                        {
                            select = 0;
                        }
                    }

                    if(keyState[SDLK_LEFT] || SDL_JoystickGetAxis(joystick[0], 0) < -3200)
                    {
                        if(select == 1){if(config.sound == 1){config.sound = 0; Mix_PlayChannel(-1, changesound, 0);}}
                        else if(select == 2)
                        {
                            if(config.sound){Mix_PlayChannel(-1, changesound, 0);}
                            playerselect--;
                            if(playerselect < 1)
                            {
                                playerselect = 4;
                            }
                        }
                        else if(select == 3)
                        {
                            if(config.sound){Mix_PlayChannel(-1, changesound, 0);}
                            config.control[playerselect-1]--;
                            if(config.control[playerselect-1] < 0)
                            {
                                config.control[playerselect-1] = 2 + SDL_NumJoysticks();
                            }
                        }
                        else if(select == 4)
                        {
                            if(config.sound){Mix_PlayChannel(-1, selectsound, 0);}
                            colorselect--;
                            if(colorselect < 1)
                            {
                                colorselect = 3;
                            }
                        }
                    }

                    if(keyState[SDLK_RIGHT] || SDL_JoystickGetAxis(joystick[0], 0) > 3200)
                    {
                        if(select == 1){if(config.sound == 0){config.sound = 1; Mix_PlayChannel(-1, changesound, 0);}}
                        else if(select == 2)
                        {
                            if(config.sound){Mix_PlayChannel(-1, changesound, 0);}
                            playerselect++;
                            if(playerselect > 4)
                            {
                                playerselect = 1;
                            }
                        }
                        else if(select == 3)
                        {
                            if(config.sound){Mix_PlayChannel(-1, changesound, 0);}
                            config.control[playerselect-1]++;
                            if(config.control[playerselect-1] >  2 + SDL_NumJoysticks())
                            {
                                config.control[playerselect-1] = 0;
                            }
                        }
                        else if(select == 4)
                        {
                            if(config.sound){Mix_PlayChannel(-1, selectsound, 0);}
                            colorselect++;
                            if(colorselect > 3)
                            {
                                colorselect = 1;
                            }
                        }
                    }

                    if(keyState[SDLK_RETURN] || SDL_JoystickGetButton(joystick[0], 0) == 1)
                    {
                        if(config.sound){Mix_PlayChannel(-1, entersound, 0);}

                        if(select == 4)
                        {
                            rep = choosecolors(screen, &curX, &curY);

                            if(rep == 1){close = 1; rep = 1;}

                            if(close == 0 && rep != 2)
                            {
                                SDL_LockSurface(imgcolors);
                                    pixel=getPixel(imgcolors, curX, curY);
                                    SDL_GetRGBA(pixel, imgcolors->format, &r, &g, &b, &a);
                                SDL_UnlockSurface(imgcolors);

                                if(colorselect == 1){config.playerColor1[playerselect-1].r = r; config.playerColor1[playerselect-1].g = g; config.playerColor1[playerselect-1].b = b;}
                                if(colorselect == 2){config.playerColor2[playerselect-1].r = r; config.playerColor2[playerselect-1].g = g; config.playerColor2[playerselect-1].b = b;}
                                if(colorselect == 3){config.playerColor3[playerselect-1].r = r; config.playerColor3[playerselect-1].g = g; config.playerColor3[playerselect-1].b = b;}
                            }
                        }
                        else if(select == 5)
                        {
                            filtering(screen);
                            close = 1;
                            rep = 0;
                        }
                    }
                }
            }
            else{keypass = 1;}

            if(close == 0 && filterint > 0){filterint -= FILTERSTEP;}

            if(!close)
            {
                SDL_BlitSurface(background, NULL, screen, NULL);

                clip.x = menus->w/2;
                clip.y = (menus->h/14) * 15;
                clip.w = menus->w/2;
                clip.h = menus->h/14;

                ////////// music //////////

                if(select == 0){clip.x = menus->w/2;}
                else{clip.x = 0;}

                clip.y = (menus->h/14) * 13;

                rect.x = SCREENW / 2 - menus->w / 4;
                rect.y = menus->h/14 + 115;
                SDL_BlitSurface(menus, &clip, screen, &rect);

                ////////// sound //////////

                if(select == 1){clip.x = menus->w/2;}
                else{clip.x = 0;}
                if(config.sound){clip.y = (menus->h/14) * 9;}
                else{clip.y = (menus->h/14) * 10;}

                rect.y += (menus->h/14) + 15;
                SDL_BlitSurface(menus, &clip, screen, &rect);

                ////////// player //////////

                if(select == 2){clip.x = menus->w / 2;}
                else{clip.x = 0;}
                clip.y = (menus->h / 14) * 8;

                rect.y += menus->h/14 + 15;
                SDL_BlitSurface(menus, &clip, screen, &rect);


                clip.x = 0;
                clip.y = text->h / 19;
                clip.w = text->w;
                clip.h = text->h / 19;

                rect.x = SCREENW / 2 - ((nbr->w + text->w + 5) / 2);
                SDL_BlitSurface(text, &clip, screen, &rect);


                clip.x = 0;
                clip.y = playerselect * (nbr->h / 17);
                clip.w = nbr->w;
                clip.h = nbr->h / 17;

                rect.x += text->w + 3;
                SDL_BlitSurface(nbr, &clip, screen, &rect);

                ////////// config.control //////////

                if(select == 3){clip.x = menus->w / 2;}
                else{clip.x = 0;}
                clip.y = (menus->h/14) * 8;
                clip.w = menus->w/2;
                clip.h = menus->h/14;

                rect.y += menus->h/14 + 15;
                rect.x = SCREENW / 2 - menus->w / 4;
                SDL_BlitSurface(menus, &clip, screen, &rect);


                clip.x = 0;
                clip.y = (text->h/19) * (config.control[playerselect-1] + 6);
                clip.w = text->w;
                clip.h = text->h/19;

                rect.x = SCREENW / 2 - text->w / 2;
                SDL_BlitSurface(text, &clip, screen, &rect);

                ///////////////////////////////////////////////////////

                rect.x = SCREENW / 2 - 130 / 2;
                rect.y += menus->h/14 + 15;

                clip.x = 0;
                clip.y = 0;
                clip.w = colorCadre->w / 2;
                clip.h = colorCadre->h;

                rect.w = 30;
                rect.h = 15;
                SDL_FillRect (screen, &rect,  SDL_MapRGB (screen->format, config.playerColor1[playerselect-1].r, config.playerColor1[playerselect-1].g, config.playerColor1[playerselect-1].b));
                rect.x -= 4;
                rect.y -= 4;
                if(select == 4 && colorselect == 1){clip.x = colorCadre->w / 2;}
                else{clip.x = 0;}
                SDL_BlitSurface(colorCadre, &clip, screen, &rect);
                rect.x += 4;
                rect.y += 4;

                rect.x += 50;

                rect.w = 30;
                rect.h = 15;
                SDL_FillRect (screen, &rect,  SDL_MapRGB (screen->format, config.playerColor2[playerselect-1].r, config.playerColor2[playerselect-1].g, config.playerColor2[playerselect-1].b));
                rect.x -= 4;
                rect.y -= 4;
                if(select == 4 && colorselect == 2){clip.x = colorCadre->w / 2;}
                else{clip.x = 0;}
                SDL_BlitSurface(colorCadre, &clip, screen, &rect);
                rect.x += 4;
                rect.y += 4;

                rect.x += 50;

                rect.w = 30;
                rect.h = 15;
                SDL_FillRect (screen, &rect,  SDL_MapRGB (screen->format, config.playerColor3[playerselect-1].r, config.playerColor3[playerselect-1].g, config.playerColor3[playerselect-1].b));
                rect.x -= 4;
                rect.y -= 4;
                if(select == 4 && colorselect == 3){clip.x = colorCadre->w / 2;}
                else{clip.x = 0;}
                SDL_BlitSurface(colorCadre, &clip, screen, &rect);
                rect.x += 4;
                rect.y += 4;


                clip.x = 0;
                clip.y = 0;
                clip.w = 19;
                clip.h = 19;

                SDL_LockSurface(s1);
                SDL_LockSurface(s2);
                SDL_LockSurface(s3);
                    for (i = clip.y; i < clip.y+19 ; i++)
                    {
                        for (j = 0; j < 19 ; j++)
                        {
                            pixel = getPixel(s1, j, i);
                            SDL_GetRGBA(pixel, s1->format, &r, &g, &b, &a);

                            if(r == 192 && g == 192 && b == 192)
                            {
                                pixel = SDL_MapRGB(s2->format, config.playerColor1[playerselect-1].r, config.playerColor1[playerselect-1].g, config.playerColor1[playerselect-1].b);
                                setPixel(s2, j, i, pixel);
                            }
                            else if(r == 128 && g == 128 && b == 128)
                            {
                                pixel = SDL_MapRGB(s2->format, config.playerColor2[playerselect-1].r, config.playerColor2[playerselect-1].g, config.playerColor2[playerselect-1].b);
                                setPixel(s2, j, i, pixel);
                            }
                            else if(r == 255 && g == 255 && b == 255)
                            {
                                pixel = SDL_MapRGB(s2->format, config.playerColor3[playerselect-1].r, config.playerColor3[playerselect-1].g, config.playerColor3[playerselect-1].b);
                                setPixel(s2, j, i, pixel);
                            }
                            else
                            {
                                pixel = SDL_MapRGBA(s2->format, r, g, b, a);
                                setPixel(s2, j, i, pixel);
                            }

                            pixel = getPixel(s1, j, i);
                            SDL_GetRGBA(pixel, s1->format, &r, &g, &b, &a);

                            if(a == 255)
                            {
                                pixel = SDL_MapRGBA(s3->format, 0, 0, 0, 80);
                                setPixel(s3, j, i, pixel);
                            }
                        }
                    }
                SDL_UnlockSurface(s1);
                SDL_UnlockSurface(s2);
                SDL_UnlockSurface(s3);

                rect.y += menus->h/14 + 15;
                rect.x = SCREENW / 2 - s1->w / 2;

                rect.x += 1;
                rect.y += 1;
                SDL_BlitSurface(s3, &clip, screen, &rect);
                rect.x -= 1;
                rect.y -= 1;
                SDL_BlitSurface(s2, &clip, screen, &rect);


                ////////// back //////////

                if(select == 5){clip.x = menus->w/2;}
                else{clip.x = 0;}
                clip.y = (menus->h/14)*7;
                clip.w = menus->w/2;
                clip.h = menus->h/14;

                rect.y += 40;
                rect.x = SCREENW / 2 - menus->w / 4;
                SDL_BlitSurface(menus, &clip, screen, &rect);

                if(filterint > 0)
                {
                    SDL_SetAlpha(filter, SDL_SRCALPHA, filterint);
                    SDL_BlitSurface(filter, NULL, screen, NULL);
                }
            }

            SDL_Flip(screen);

            prev = current;
        }
        else
        {
            SDL_Delay((1000/FPS) - (current - prev));
        }
    }


    SDL_FreeSurface(background);
    SDL_FreeSurface(menus);
    SDL_FreeSurface(text);
    SDL_FreeSurface(nbr);
    SDL_FreeSurface(imgcolors);
    SDL_FreeSurface(s1);
    SDL_FreeSurface(s2);
    SDL_FreeSurface(s3);
    SDL_FreeSurface(colorCadre);
    SDL_FreeSurface(filter);
    SDL_FreeSurface(tmp);

    return rep;
}

int choosecolors(SDL_Surface *screen, int *pointeurcurX, int *pointeurcurY)
{
    SDL_Surface *screen2 = NULL, *imgcolors = NULL, *cursor= NULL, *tmp = NULL;;
    SDL_Rect rect;
    int close = 0, rep = 0, prev = 0, current = 0, keypass = 0;

    tmp = IMG_Load("data/sprites/colors.png");
    if(tmp == NULL)
    {
        fprintf(stderr, "Error: Can't load 'data/sprites/colors.png'\n\n");
        error();
    }
    imgcolors = SDL_DisplayFormatAlpha(tmp);

    SDL_FreeSurface(tmp);
    tmp = IMG_Load("data/sprites/cursor.png");
    if(tmp == NULL)
    {
        fprintf(stderr, "Error: Can't load 'data/sprites/cursor.png'\n\n");
        error();
    }
    cursor = SDL_DisplayFormatAlpha(tmp);

    screen2 = SDL_CreateRGBSurface(SDL_HWSURFACE, SCREENW, SCREENH, 32, 0, 0, 0, 0);;
    SDL_BlitSurface(screen, NULL, screen2, NULL);

    rect.x = SCREENW / 2 - imgcolors->w / 2;
    rect.y = SCREENH / 2 - imgcolors->h / 2;
    SDL_BlitSurface(imgcolors, NULL, screen2, &rect);

    while(!close)
    {
        current = SDL_GetTicks();
        if (current - prev > (1000/FPS))
        {
            SDL_PollEvent(&event);
            keyState = SDL_GetKeyState(NULL);

            if (event.type == SDL_QUIT){close = 1; rep = 1;}

            if(keyState[SDLK_UP] || keyState[SDLK_DOWN] || keyState[SDLK_LEFT] || keyState[SDLK_RIGHT] || keyState[SDLK_RETURN] || keyState[SDLK_ESCAPE] || keyState[SDLK_BACKSPACE] || SDL_JoystickGetButton(joystick[0], 0) || SDL_JoystickGetButton(joystick[0], 5) || SDL_JoystickGetAxis(joystick[0], 1) > 3200 || SDL_JoystickGetAxis(joystick[0], 1) < -3200 || SDL_JoystickGetAxis(joystick[0], 0) > 3200 || SDL_JoystickGetAxis(joystick[0], 0) < -3200)
            {
                if(keypass)
                {
                    if(keyState[SDLK_ESCAPE] || keyState[SDLK_BACKSPACE] || SDL_JoystickGetButton(joystick[0], 5))
                    {
                        close = 1;
                        rep = 2;
                    }

                    if(keyState[SDLK_UP] || SDL_JoystickGetAxis(joystick[0], 1) < -3200)
                    {
                        *pointeurcurY -= 1;
                        if(*pointeurcurY < 32){*pointeurcurY = 32;};
                    }

                    if(keyState[SDLK_DOWN] || SDL_JoystickGetAxis(joystick[0], 1) > 3200)
                    {
                        *pointeurcurY += 1;
                        if(*pointeurcurY > imgcolors->h - 4){*pointeurcurY = imgcolors->h - 4;};
                    }

                    if(keyState[SDLK_LEFT] || SDL_JoystickGetAxis(joystick[0], 0) < -3200)
                    {
                        *pointeurcurX -= 1;
                        if(*pointeurcurX < 3){*pointeurcurX = 3;};
                    }

                    if(keyState[SDLK_RIGHT] || SDL_JoystickGetAxis(joystick[0], 0) > 3200)
                    {
                        *pointeurcurX += 1;
                        if(*pointeurcurX > imgcolors->w - 4){*pointeurcurX = imgcolors->w - 4;};
                    }

                    if(keyState[SDLK_RETURN] || SDL_JoystickGetButton(joystick[0], 0))
                    {
                        close = 1;
                        if(config.sound){Mix_PlayChannel(-1, colorselect, 0);}
                    }
                }
            }
            else{keypass = 1;}

            if(!close)
            {
                SDL_BlitSurface(screen2, NULL, screen, NULL);

                SDL_LockSurface(imgcolors);
                    pixel = getPixel(imgcolors, *pointeurcurX, *pointeurcurY);
                    SDL_GetRGBA(pixel, imgcolors->format, &r, &g, &b, &a);
                SDL_UnlockSurface(imgcolors);

                rect.w = 291;
                rect.h = 20;
                rect.x = SCREENW / 2 - 291 / 2;
                rect.y = (SCREENH / 2 - imgcolors->h / 2) + 6;
                SDL_FillRect(screen, &rect,  SDL_MapRGB (screen->format, r, g, b));

                rect.x = (SCREENW / 2 - imgcolors->w/2) + (*pointeurcurX - cursor->w / 2);
                rect.y = (SCREENH / 2 - imgcolors->h/2) + (*pointeurcurY - cursor->h / 2);
                SDL_BlitSurface(cursor, NULL, screen, &rect);
            }

            SDL_Flip(screen);

            prev = current;
        }
        else
        {
            SDL_Delay((1000/FPS) - (current - prev));
        }
    }

    SDL_FreeSurface(screen2);
    SDL_FreeSurface(imgcolors);
    SDL_FreeSurface(cursor);
    SDL_FreeSurface(tmp);

    return rep;
}

int credits(SDL_Surface *screen)
{
    SDL_Surface *background = NULL, *filter = NULL, *tmp = NULL;

    int close = 0, rep = 0, prev = 0, current = 0, filterint = 255, keypass = 0;

    tmp = IMG_Load("data/sprites/background4.png");
    if(tmp == NULL)
    {
        fprintf(stderr, "Error: Can't load 'data/sprites/background4.png'\n\n");
        error();
    }
    background = SDL_DisplayFormatAlpha(tmp);

    filter = SDL_CreateRGBSurface(SDL_HWSURFACE, SCREENW, SCREENH, 32, 0, 0, 0, 0);
    SDL_FillRect(filter, NULL, SDL_MapRGB(filter->format, 255, 255, 255));

    while(close == 0)
    {
        current = SDL_GetTicks();
        if (current - prev > (1000/FPS))
        {
            SDL_PollEvent(&event);
            keyState = SDL_GetKeyState(NULL);

            if(event.type == SDL_QUIT){close = 1; rep = 1;}

            if(keyState[SDLK_RETURN] || keyState[SDLK_ESCAPE] || keyState[SDLK_BACKSPACE] || SDL_JoystickGetButton(joystick[0], 0) || SDL_JoystickGetButton(joystick[0], 5) || SDL_JoystickGetAxis(joystick[0], 1) > 3200 || SDL_JoystickGetAxis(joystick[0], 1) < -3200)
            {
                if(keypass)
                {
                    if(event.key.keysym.sym == SDLK_ESCAPE || keyState[SDLK_BACKSPACE] || SDL_JoystickGetButton(joystick[0], 0))
                    {
                        filtering(screen);
                        close = 1;
                        rep = 0;
                    }

                    if(event.key.keysym.sym == SDLK_RETURN || SDL_JoystickGetButton(joystick[0], 5))
                    {
                        if(config.sound){Mix_PlayChannel(-1, entersound, 0);}
                        filtering(screen);
                        close = 1;
                        rep = 0;
                    }
                }
            }
            else{keypass = 1;}

            if(close == 0 && filterint > 0){filterint -= FILTERSTEP;}

            if(!close)
            {
                SDL_BlitSurface(background, NULL, screen, NULL);

                if(filterint > 0)
                {
                    SDL_SetAlpha(filter, SDL_SRCALPHA, filterint);
                    SDL_BlitSurface(filter, NULL, screen, NULL);
                }
            }

            SDL_Flip(screen);

            prev = current;
        }
        else
        {
            SDL_Delay((1000/FPS) - (current - prev));
        }
    }

    SDL_FreeSurface(background);
    SDL_FreeSurface(filter);
    SDL_FreeSurface(tmp);

    return rep;
}


int gamePlay(SDL_Surface *screen, int nbrPlayer, int nbrCPU, int nbrLaps, int botDim, int intLocked)
{
    srand(time(NULL));
    SDL_Surface *tmp = NULL, *s1 = NULL, *s2 = NULL, *s3 = NULL, *s4 = NULL, *startimg = NULL, *msg = NULL, *msgColor = NULL, *rank = NULL, *text = NULL, *nbr = NULL, *tableTop = NULL, *tableMid = NULL, *tableBot = NULL, *finish = NULL, *raceMap = NULL, *racePic = NULL, *colision = NULL, *menus = NULL, *filter = NULL;
    SDL_Rect rect, clip;
    int tmpInt = 0, close = 0, prev = 0, current = 0, count = 0, i = 0, j = 0, rep = 0, winCount = 1, startAngle = 1, startX = 0, startY = 0, nbrCol = 4, nbrBorne = 0, p1 = 0, p2 = 0, p3 = 0, startframe = 0, filterint = 255, keypass = 0, keypass2 = 0;
    double tmpDouble = 0;
    char tmpChar[CHARMAX] = "", mapFile[CHARMAX] = "";
    FILE* file = NULL;
    Uint32 timeBlink = 0;

    car gamePlayer[nbrPlayer];
    car gameCPU[nbrCPU];

    color CPUColor1[nbrCPU];
    color CPUColor2[nbrCPU];
    color CPUColor3[nbrCPU];

    Mix_Chunk *tut_sound = NULL;
    Mix_Chunk *tit_sound = NULL;
    Mix_Chunk *laps_sound = NULL;
    Mix_Chunk *finish_sound = NULL;
    Mix_Chunk *skid_sound[4] = {NULL};

    sprintf(tmpChar, "data/tracks/%d.track", config.selectFile);
    file = fopen(tmpChar, "r");
    if (file != NULL)
    {
        sprintf(mapFile, "%d.track", config.selectFile);
        sprintf(tmpChar, "data/tracks/%dmap.png", config.selectFile);

        tmp = IMG_Load(tmpChar);
        if(tmp == NULL || tmp->w != 640 || tmp->h != 480)
        {
            fprintf(stderr, "Invalid track : '%s' (Error : Can't load '%s')\n\n", mapFile, tmpChar);
            error();
        }
        raceMap = SDL_DisplayFormatAlpha(tmp);

        sprintf(tmpChar, "data/tracks/%dpic.png", config.selectFile);

        SDL_FreeSurface(tmp);
        tmp = IMG_Load(tmpChar);
        if(tmp == NULL || tmp->w != 640 || tmp->h != 480)
        {
            fprintf(stderr, "Invalid track : '%s' (Error : Can't load '%s')\n\n", mapFile, tmpChar);
            error();
        }
        racePic = SDL_DisplayFormatAlpha(tmp);


        if(intLocked == 0){fscanf(file, "%d\n%d\n%d\n", &nbrCPU, &nbrLaps, &botDim);}
        else{fscanf(file, "%d\n%d\n%d\n", &tmpInt, &tmpInt, &tmpInt);}

        if(nbrCPU > 15){nbrCPU = 15; fprintf(stderr, "Invalid track : '%s' (nbrCPU > 15)\n\n", mapFile);}
        else if(nbrCPU < 0){nbrCPU = 0; fprintf(stderr, "Invalid track : '%s' (nbrCPU < 0)\n\n", mapFile);}

        if(nbrLaps > 10){nbrLaps = 10; fprintf(stderr, "Invalid track : '%s' (nbrLaps > 10)\n\n", mapFile);}
        else if(nbrLaps < 0){nbrLaps = 0; fprintf(stderr, "Invalid track : '%s' (nbrLaps < 0)\n\n", mapFile);}

        if(botDim > 5){botDim = 5; fprintf(stderr, "Invalid track : '%s' (botDim > 5)\n\n", mapFile);}
        else if(botDim < 0){botDim = 0; fprintf(stderr, "Invalid track : '%s' (botDim < 0)\n\n", mapFile);}

        fscanf(file, "%d\n%d\n%d\n%d\n%d\n", &nbrBorne, &startX, &startY, &startAngle, &nbrCol);

        if(startX > SCREENW){startX = 320; fprintf(stderr, "Invalid track : '%s' (startX > 640)\n\n", mapFile);}
        if(startY > SCREENH){startY = 240; fprintf(stderr, "Invalid track : '%s' (startY > 480)\n\n", mapFile);}
        if(nbrCol < 1){nbrCol = 1; fprintf(stderr, "Invalid track : '%s' (nbrCol < 1)\n\n", mapFile);}

        fclose(file);
    }
    else{fprintf(stderr, "Error : Can't load '%s'\n\n", mapFile);error(screen);}


    SDL_FreeSurface(tmp);
    tmp = IMG_Load("data/sprites/car.png");
    if(tmp == NULL)
    {
        fprintf(stderr, "Error : Can't load 'data/sprites/car.png'\n\n");
        error();
    }
    s1 = SDL_DisplayFormatAlpha(tmp);
    s2 = SDL_DisplayFormatAlpha(tmp);
    s3 = SDL_DisplayFormatAlpha(tmp);
    s4 = SDL_DisplayFormatAlpha(tmp);


    SDL_FreeSurface(tmp);
    tmp = IMG_Load("data/sprites/rank.png");
    if(tmp == NULL)
    {
        fprintf(stderr, "Error: Can't load 'data/sprites/rank.png'\n\n");
        error();
    }
    rank = SDL_DisplayFormatAlpha(tmp);

    SDL_FreeSurface(tmp);
    tmp = IMG_Load("data/sprites/text.png");
    if(tmp == NULL)
    {
        fprintf(stderr, "Error : Can't load 'data/sprites/text.png'\n\n");
        error();
    }
    text = SDL_DisplayFormatAlpha(tmp);

    SDL_FreeSurface(tmp);
    tmp = IMG_Load("data/sprites/nbr.png");
    if(tmp == NULL)
    {
        fprintf(stderr, "Error : Can't load 'data/sprites/nbr.png'\n\n");
        error();
    }
    nbr = SDL_DisplayFormatAlpha(tmp);

    SDL_FreeSurface(tmp);
    tmp = IMG_Load("data/sprites/top.png");
    if(tmp == NULL)
    {
        fprintf(stderr, "Error : Can't load 'data/sprites/top.png'\n\n");
        error();
    }
    tableTop = SDL_DisplayFormatAlpha(tmp);

    SDL_FreeSurface(tmp);
    tmp = IMG_Load("data/sprites/middle.png");
    if(tmp == NULL)
    {
        fprintf(stderr, "Error : Can't load 'data/sprites/middle.png'\n\n");
        error();
    }
    tableMid = SDL_DisplayFormatAlpha(tmp);

    SDL_FreeSurface(tmp);
    tmp = IMG_Load("data/sprites/bottom.png");
    if(tmp == NULL)
    {
        fprintf(stderr, "Error : Can't load 'data/sprites/bottom.png'\n\n");
        error();
    }
    tableBot = SDL_DisplayFormatAlpha(tmp);

    SDL_FreeSurface(tmp);
    tmp = IMG_Load("data/sprites/finish.png");
    if(tmp == NULL)
    {
        fprintf(stderr, "Error : Can't load 'data/sprites/finish.png'\n\n");
        error();
    }
    finish = SDL_DisplayFormatAlpha(tmp);

    SDL_FreeSurface(tmp);
    tmp = IMG_Load("data/sprites/start.png");
    if(tmp == NULL)
    {
        fprintf(stderr, "Error : Can't load 'data/sprites/start.png'\n\n");
        error();
    }
    startimg = SDL_DisplayFormatAlpha(tmp);

    SDL_FreeSurface(tmp);
    tmp = IMG_Load("data/sprites/msg.png");
    if(tmp == NULL)
    {
        fprintf(stderr, "Error : Can't load 'data/sprites/msg.png'\n\n");
        error();
    }
    msg = SDL_DisplayFormatAlpha(tmp);
    msgColor = SDL_DisplayFormatAlpha(tmp);

    colision = SDL_CreateRGBSurface(SDL_HWSURFACE, raceMap->w, raceMap->h, 32, 0, 0, 0, 0);
    SDL_FillRect(colision, NULL, SDL_MapRGBA(colision->format, 0,0, 0, 255));

    SDL_FreeSurface(tmp);
    tmp = IMG_Load("data/sprites/menus.png");
    if(tmp == NULL)
    {
        fprintf(stderr, "Error: Can't load 'data/sprites/menus.png'\n\n");
        error();
    }
    menus = SDL_DisplayFormatAlpha(tmp);

    filter = SDL_CreateRGBSurface(SDL_HWSURFACE, SCREENW, SCREENH, 32, 0, 0, 0, 0);
    SDL_FillRect(filter, NULL, SDL_MapRGB(filter->format, 255, 255, 255));


//// Son

    tut_sound = Mix_LoadWAV( "data/sounds/tut.wav");
    if(tut_sound == NULL)
    {
        fprintf(stderr, "Error : Can't load 'data/sounds/tut.wav'\n\n");
        error();
    }
    Mix_VolumeChunk(tut_sound, VOLUME);

    tit_sound = Mix_LoadWAV("data/sounds/tit.wav");
    if(tit_sound == NULL)
    {
        fprintf(stderr, "Error : Can't load 'data/sounds/tit.wav'\n\n");
        error();
    }
    Mix_VolumeChunk(tit_sound, VOLUME);

    laps_sound = Mix_LoadWAV("data/sounds/laps.wav");
    if(laps_sound == NULL)
    {
        fprintf(stderr, "Error : Can't load 'data/sounds/laps.wav'\n\n");
        error();
    }
    Mix_VolumeChunk(laps_sound, VOLUME);

    finish_sound = Mix_LoadWAV("data/sounds/finish.wav");
    if(finish_sound == NULL)
    {
        fprintf(stderr, "Error : Can't load 'data/sounds/finish.wav'\n\n");
        error();
    }
    Mix_VolumeChunk(finish_sound, VOLUME);

    for (count = 0; count < 4 ; count++)
    {
        skid_sound[count] = Mix_LoadWAV("data/sounds/skid.wav");
        if(skid_sound[count] == NULL)
        {
            fprintf(stderr, "Error : Can't load 'data/sounds/skid.wav'\n\n");
            error();
        }
    }


    for(count = 0; count < nbrCPU ; count++)
    {
        if(startAngle == 1)
        {
            gameCPU[count].px = (startX + 20 / 2) + (count % nbrCol) * 20;
            gameCPU[count].py = (startY + 20 / 2) + (count / nbrCol) * 20;
            gameCPU[count].angleR = (rand() % (30 + 30 + 1)) - 30;
            gameCPU[count].angleM = gameCPU[count].angleR;
        }
        else if(startAngle == 2)
        {
            gameCPU[count].px = (startX + 20 / 2) + (count / nbrCol) * 20;
            gameCPU[count].py = (startY + 20 / 2) + (count % nbrCol) * 20;
            gameCPU[count].angleR = (rand() % (-60 + 120) + 1) - 120;
            gameCPU[count].angleM = gameCPU[count].angleR;
        }
        else if(startAngle == 3)
        {
            gameCPU[count].px = (startX + 20 / 2) + (count % nbrCol) * 20;
            gameCPU[count].py = (startY + 20 / 2) - (count / nbrCol) * 20;
            gameCPU[count].angleR = (rand() % (210 - 150 + 1)) + 150;
            gameCPU[count].angleM = gameCPU[count].angleR;
        }
        else
        {
            gameCPU[count].px = (startX + 20 / 2) - (count / nbrCol) * 20;
            gameCPU[count].py = (startY + 20 / 2) + (count % nbrCol) * 20;
            gameCPU[count].angleR = (rand() % (120 - 60 + 1)) + 60;
            gameCPU[count].angleM = gameCPU[count].angleR;
        }

        gameCPU[count].speed = 0;

        gameCPU[count].laps = -1;
        gameCPU[count].borne = 1;
        gameCPU[count].msgCount = 0;
        gameCPU[count].stat = 0;

        gameCPU[count].detectRoad = 10;
        tmpInt = 17 - (nbrPlayer+nbrCPU-2);
        gameCPU[count].dif = (rand() % (17 - tmpInt + 1)) + tmpInt;

        CPUColor1[count].r = ((rand() % (3 - 0 + 1)) + 0) * 85;
        CPUColor1[count].g = ((rand() % (3 - 0 + 1)) + 0) * 85;
        CPUColor1[count].b = ((rand() % (3 - 0 + 1)) + 0) * 85;
        CPUColor2[count].r = ((rand() % (3 - 0 + 1)) + 0) * 85;
        CPUColor2[count].g = ((rand() % (3 - 0 + 1)) + 0) * 85;
        CPUColor2[count].b = ((rand() % (3 - 0 + 1)) + 0) * 85;
        CPUColor3[count].r = ((rand() % (3 - 0 + 1)) + 0) * 85;
        CPUColor3[count].g = ((rand() % (3 - 0 + 1)) + 0) * 85;
        CPUColor3[count].b = ((rand() % (3 - 0 + 1)) + 0) * 85;
    }

    for (count = 0; count < nbrPlayer ; count++)
    {
        if(startAngle == 1)
        {
            gamePlayer[count].px = (startX + 20 / 2) + ((nbrCPU + count) % nbrCol) * 20;
            gamePlayer[count].py = (startY + 20 / 2) + ((nbrCPU + count) / nbrCol) * 20;
            gamePlayer[count].angleR = (rand() % (30 + 30 + 1)) - 30;
            gamePlayer[count].angleM = gamePlayer[count].angleR;
        }
        else if(startAngle == 2)
        {
            gamePlayer[count].px = (startX + 20 / 2) + ((nbrCPU + count) / nbrCol) * 20;
            gamePlayer[count].py = (startY + 20 / 2) + ((nbrCPU + count) % nbrCol) * 20;
            gamePlayer[count].angleR = (rand() % (-60 + 120) + 1) - 120;
            gamePlayer[count].angleM = gamePlayer[count].angleR;
        }
        else if(startAngle == 3)
        {
            gamePlayer[count].px = (startX + 20 / 2) + ((nbrCPU + count) % nbrCol) * 20;
            gamePlayer[count].py = (startY + 20 / 2) - ((nbrCPU + count) / nbrCol) * 20;
            gamePlayer[count].angleR = (rand() % (210 - 150 + 1)) + 150;
            gamePlayer[count].angleM = gamePlayer[count].angleR;
        }
        else
        {
            gamePlayer[count].px = (startX + 20 / 2) - ((nbrCPU + count) / nbrCol) * 20;
            gamePlayer[count].py = (startY + 20 / 2) + ((nbrCPU + count) % nbrCol) * 20;
            gamePlayer[count].angleR = (rand() % (120 - 60 + 1)) + 60;
            gamePlayer[count].angleM = gamePlayer[count].angleR;
        }


        gamePlayer[count].speed = 0;

        gamePlayer[count].laps = -1;
        gamePlayer[count].borne = 1;
        gamePlayer[count].msgCount = 0;
        gamePlayer[count].stat = 0;
    }

	while(!close)
	{
        current = SDL_GetTicks();

        if (current - prev > (1000/FPS))
        {
            SDL_PollEvent(&event);
            keyState = SDL_GetKeyState(NULL);

            timeBlink = SDL_GetTicks() / 300;

            if(event.type == SDL_QUIT){close = 1; rep = 1;}

            if(keyState[SDLK_RETURN] || SDL_JoystickGetButton(joystick[0], 0))
            {
                if(keypass2)
                {
                    keypass2 = 0;

                    if(winCount > 1)
                    {
                        if(keyState[SDLK_RETURN] || SDL_JoystickGetButton(joystick[0], 0))
                        {
                            close = 1;
                            rep = 0;
                            filtering(screen);
                        }
                    }
                }
            }
            else{keypass2 = 1;}

            if(keyState[SDLK_p] || keyState[SDLK_ESCAPE] || keyState[SDLK_BACKSPACE] || SDL_JoystickGetButton(joystick[0], 5) || SDL_JoystickGetButton(joystick[0], 9))
            {
                if(keypass)
                {
                    keypass = 0;

                    if(keyState[SDLK_p] || keyState[SDLK_ESCAPE] || keyState[SDLK_BACKSPACE] || SDL_JoystickGetButton(joystick[0], 5) || SDL_JoystickGetButton(joystick[0], 9))
                    {
                        if(config.sound){Mix_HaltChannel(-1);Mix_PauseMusic();}
                        if(startframe > 50){startframe = 50;}

                        rep = pause(screen);

                        if(rep == 1){close = 1;}
                        if(rep == 2){close = 1;}
                        if(rep == 3){close = 1; rep = 0;filtering(screen);}

                        if(config.sound){Mix_ResumeMusic();}
                    }
                }
            }
            else{keypass = 1;}


            if(startframe > 200)
            {
                for (count = 0; count < nbrCPU ; count++)
                {
                    i = (gameCPU[count].px + cos((gameCPU[count].angleR - 90) * M_PI / 180) * ((17 / 2)-2) ) + (cos((gameCPU[count].angleR) * M_PI / 180) * (14 / 2) );
                    j = (gameCPU[count].py + sin((gameCPU[count].angleR - 90) * M_PI / 180) * ((17 / 2)-2) ) + (sin((gameCPU[count].angleR) * M_PI / 180) * (14 / 2) );
                    if(i >= 1 && i <= SCREENW-1 && j >= 1 && j <= SCREENH-1)
                    {
                        SDL_LockSurface(colision);
                            pixel = getPixel(colision, i, j);
                            SDL_GetRGBA(pixel, colision->format, &r, &g, &b, &a);
                        SDL_UnlockSurface(colision);
                    }
                    else{r = -1;}
                    if(r != 255 && r != gameCPU[count].colorCol)
                    {
                        gameCPU[count].angleM -= COLROTATE;
                        gameCPU[count].angleR -= COLROTATE;
                    }

                    if(i >= 1 && i <= SCREENW-1 && j >= 1 && j <= SCREENH-1)
                    {
                        SDL_LockSurface(raceMap);
                            pixel = getPixel(raceMap, i, j);
                            SDL_GetRGBA(pixel, raceMap->format, &r, &g, &b, &a);
                        SDL_UnlockSurface(raceMap);
                    }
                    else{g = 0;}
                    if(g == 0)
                    {
                        gameCPU[count].angleM -= COLROTATE;
                        gameCPU[count].angleR -= COLROTATE;
                    }

/////////////////////////////////////////////

                    i = (gameCPU[count].px + cos((gameCPU[count].angleR - 90) * M_PI / 180) * ((17 / 2)-2) ) + (cos((gameCPU[count].angleR-180) * M_PI / 180) * (14 / 2) );
                    j = (gameCPU[count].py + sin((gameCPU[count].angleR - 90) * M_PI / 180) * ((17 / 2)-2) ) + (sin((gameCPU[count].angleR-180) * M_PI / 180) * (14 / 2) );
                    if(i >= 1 && i <= SCREENW-1 && j >= 1 && j <= SCREENH-1)
                    {
                        SDL_LockSurface(colision);
                            pixel = getPixel(colision, i, j);
                            SDL_GetRGBA(pixel, colision->format, &r, &g, &b, &a);
                        SDL_UnlockSurface(colision);
                    }
                    else{r = -1;}
                    if(r != 255 && r != gameCPU[count].colorCol)
                    {
                        gameCPU[count].angleM += COLROTATE;
                        gameCPU[count].angleR += COLROTATE;
                    }

                    if(i >= 1 && i <= SCREENW-1 && j >= 1 && j <= SCREENH-1)
                    {
                        SDL_LockSurface(raceMap);
                            pixel = getPixel(raceMap, i, j);
                            SDL_GetRGBA(pixel, raceMap->format, &r, &g, &b, &a);
                        SDL_UnlockSurface(raceMap);
                    }
                    else{g = 0;}
                    if(g == 0)
                    {
                        gameCPU[count].angleM += COLROTATE;
                        gameCPU[count].angleR += COLROTATE;
                    }

/////////////////////////////////////////////

                    i = (gameCPU[count].px + cos((gameCPU[count].angleR + 90) * M_PI / 180) * ((17 / 2)-2) ) + (cos((gameCPU[count].angleR) * M_PI / 180) * (14 / 2) );
                    j = (gameCPU[count].py + sin((gameCPU[count].angleR + 90) * M_PI / 180) * ((17 / 2)-2) ) + (sin((gameCPU[count].angleR) * M_PI / 180) * (14 / 2) );
                    if(i >= 1 && i <= SCREENW-1 && j >= 1 && j <= SCREENH-1)
                    {
                        SDL_LockSurface(colision);
                            pixel = getPixel(colision, i, j);
                            SDL_GetRGBA(pixel, colision->format, &r, &g, &b, &a);
                        SDL_UnlockSurface(colision);
                    }
                    else{r = -1;}
                    if(r != 255 && r != gameCPU[count].colorCol)
                    {
                        gameCPU[count].angleM += COLROTATE;
                        gameCPU[count].angleR += COLROTATE;
                    }

                    if(i >= 1 && i <= SCREENW-1 && j >= 1 && j <= SCREENH-1)
                    {
                        SDL_LockSurface(raceMap);
                            pixel = getPixel(raceMap, i, j);
                            SDL_GetRGBA(pixel, raceMap->format, &r, &g, &b, &a);
                        SDL_UnlockSurface(raceMap);
                    }
                    else{g = 0;}
                    if(g == 0)
                    {
                        gameCPU[count].angleM += COLROTATE;
                        gameCPU[count].angleR += COLROTATE;
                    }

/////////////////////////////////////////////

                    i = (gameCPU[count].px + cos((gameCPU[count].angleR + 90) * M_PI / 180) * ((17 / 2)-2) ) + (cos((gameCPU[count].angleR-180) * M_PI / 180) * (14 / 2) );
                    j = (gameCPU[count].py + sin((gameCPU[count].angleR + 90) * M_PI / 180) * ((17 / 2)-2) ) + (sin((gameCPU[count].angleR-180) * M_PI / 180) * (14 / 2) );
                    if(i >= 1 && i <= SCREENW-1 && j >= 1 && j <= SCREENH-1)
                    {
                        SDL_LockSurface(colision);
                            pixel = getPixel(colision, i, j);
                            SDL_GetRGBA(pixel, colision->format, &r, &g, &b, &a);
                        SDL_UnlockSurface(colision);
                    }
                    else{r = -1;}
                    if(r != 255 && r != gameCPU[count].colorCol)
                    {
                        gameCPU[count].angleM -= COLROTATE;
                        gameCPU[count].angleR -= COLROTATE;
                    }

                    if(i >= 1 && i <= SCREENW-1 && j >= 1 && j <= SCREENH-1)
                    {
                        SDL_LockSurface(raceMap);
                            pixel = getPixel(raceMap, i, j);
                            SDL_GetRGBA(pixel, raceMap->format, &r, &g, &b, &a);
                        SDL_UnlockSurface(raceMap);
                    }
                    else{g = 0;}
                    if(g == 0)
                    {
                        gameCPU[count].angleM -= COLROTATE;
                        gameCPU[count].angleR -= COLROTATE;
                    }

/////////////////////////////////////////////

                    i = (gameCPU[count].px + cos((gameCPU[count].angleR - 90) * M_PI / 180) * (17 / 2) );
                    j = (gameCPU[count].py + sin((gameCPU[count].angleR - 90) * M_PI / 180) * (17 / 2) );
                    if(i >= 1 && i <= SCREENW-1 && j >= 1 && j <= SCREENH-1)
                    {
                        SDL_LockSurface(colision);
                            pixel = getPixel(colision, i, j);
                            SDL_GetRGBA(pixel, colision->format, &r, &g, &b, &a);
                        SDL_UnlockSurface(colision);
                    }
                    else{r = -1;}
                    if(r != 255 && r != gameCPU[count].colorCol)
                    {
                        gameCPU[count].px = gameCPU[count].px + cos((gameCPU[count].angleM + 90) * M_PI / 180) * COLMOVE;
                        gameCPU[count].py = gameCPU[count].py + sin((gameCPU[count].angleM + 90) * M_PI / 180) * COLMOVE;
                        gameCPU[count].speed -= COLSPEEDMOINS;
                    }

                    if(i >= 1 && i <= SCREENW-1 && j >= 1 && j <= SCREENH-1)
                    {
                        SDL_LockSurface(raceMap);
                            pixel = getPixel(raceMap, i, j);
                            SDL_GetRGBA(pixel, raceMap->format, &r, &g, &b, &a);
                        SDL_UnlockSurface(raceMap);
                    }
                    else{g = 0;}
                    if(g == 0)
                    {
                        gameCPU[count].px = gameCPU[count].px + cos((gameCPU[count].angleM + 90) * M_PI / 180) * COLMOVE;
                        gameCPU[count].py = gameCPU[count].py + sin((gameCPU[count].angleM + 90) * M_PI / 180) * COLMOVE;
                        gameCPU[count].speed -= COLSPEEDMOINS;
                    }

                    tmpDouble = (double)botDim / 10;

                    if(gameCPU[count].speed > g / (255/GAMEMAXSPEED) - 0.5 + tmpDouble)
                    {
                        gameCPU[count].speed = g / (255/GAMEMAXSPEED) - 0.5 + tmpDouble;
                    }

/////////////////////////////////////////////

                    i = (gameCPU[count].px + cos((gameCPU[count].angleR + 90) * M_PI / 180) * (17 / 2) );
                    j = (gameCPU[count].py + sin((gameCPU[count].angleR + 90) * M_PI / 180) * (17 / 2) );
                    if(i >= 1 && i <= SCREENW-1 && j >= 1 && j <= SCREENH-1)
                    {
                        SDL_LockSurface(colision);
                            pixel = getPixel(colision, i, j);
                            SDL_GetRGBA(pixel, colision->format, &r, &g, &b, &a);
                        SDL_UnlockSurface(colision);
                    }
                    else{r = -1;}
                    if(r != 255 && r != gameCPU[count].colorCol)
                    {
                        gameCPU[count].px = gameCPU[count].px + cos((gameCPU[count].angleM - 90) * M_PI / 180) * COLMOVE;
                        gameCPU[count].py = gameCPU[count].py + sin((gameCPU[count].angleM - 90) * M_PI / 180) * COLMOVE;
                        gameCPU[count].speed += COLSPEEDMOINS;
                    }

                    if(i >= 1 && i <= SCREENW-1 && j >= 1 && j <= SCREENH-1)
                    {
                        SDL_LockSurface(raceMap);
                            pixel = getPixel(raceMap, i, j);
                            SDL_GetRGBA(pixel, raceMap->format, &r, &g, &b, &a);
                        SDL_UnlockSurface(raceMap);
                    }
                    else{g = 0;}
                    if(g == 0)
                    {
                        gameCPU[count].px = gameCPU[count].px + cos((gameCPU[count].angleM - 90) * M_PI / 180) * COLMOVE;
                        gameCPU[count].py = gameCPU[count].py + sin((gameCPU[count].angleM - 90) * M_PI / 180) * COLMOVE;
                        gameCPU[count].speed += COLSPEEDMOINS;
                    }

                    tmpDouble = (double)botDim / 10;

                    if(gameCPU[count].speed < -g / (255/GAMEMAXSPEED) - 0.5 + tmpDouble)
                    {
                        gameCPU[count].speed = -g / (255/GAMEMAXSPEED) - 0.5 + tmpDouble;
                    }

/////////////////////////////////////////////

                    i = (gameCPU[count].px + cos((gameCPU[count].angleR) * M_PI / 180) * (14 / 2) );
                    j = (gameCPU[count].py + sin((gameCPU[count].angleR) * M_PI / 180) * (14 / 2) );
                    if(i >= 1 && i <= SCREENW-1 && j >= 1 && j <= SCREENH-1)
                    {
                        SDL_LockSurface(colision);
                            pixel = getPixel(colision, i, j);
                            SDL_GetRGBA(pixel, colision->format, &r, &g, &b, &a);
                        SDL_UnlockSurface(colision);
                    }
                    else{r = -1;}
                    if(r != 255 && r != gameCPU[count].colorCol)
                    {
                        gameCPU[count].px = gameCPU[count].px + cos((gameCPU[count].angleM - 180) * M_PI / 180) * COLMOVE;
                        gameCPU[count].py = gameCPU[count].py + sin((gameCPU[count].angleM - 180) * M_PI / 180) * COLMOVE;
                    }

                    if(i >= 1 && i <= SCREENW-1 && j >= 1 && j <= SCREENH-1)
                    {
                        SDL_LockSurface(raceMap);
                            pixel = getPixel(raceMap, i, j);
                            SDL_GetRGBA(pixel, raceMap->format, &r, &g, &b, &a);
                        SDL_UnlockSurface(raceMap);
                    }
                    else{g = 0;}
                    if(g == 0)
                    {
                        gameCPU[count].px = gameCPU[count].px + cos((gameCPU[count].angleM - 180) * M_PI / 180) * COLMOVE;
                        gameCPU[count].py = gameCPU[count].py + sin((gameCPU[count].angleM - 180) * M_PI / 180) * COLMOVE;
                    }

/////////////////////////////////////////////

                    i = (gameCPU[count].px + cos((gameCPU[count].angleR - 180) * M_PI / 180) * (14 / 2) );
                    j = (gameCPU[count].py + sin((gameCPU[count].angleR - 180) * M_PI / 180) * (14 / 2) );
                    if(i >= 1 && i <= SCREENW-1 && j >= 1 && j <= SCREENH-1)
                    {
                        SDL_LockSurface(colision);
                            pixel = getPixel(colision, i, j);
                            SDL_GetRGBA(pixel, colision->format, &r, &g, &b, &a);
                        SDL_UnlockSurface(colision);
                    }
                    else{r = -1;}
                    if(r != 255 && r != gameCPU[count].colorCol)
                    {
                        gameCPU[count].px = gameCPU[count].px + cos((gameCPU[count].angleM) * M_PI / 180) * COLMOVE;
                        gameCPU[count].py = gameCPU[count].py + sin((gameCPU[count].angleM) * M_PI / 180) * COLMOVE;
                    }

                    if(i >= 1 && i <= SCREENW-1 && j >= 1 && j <= SCREENH-1)
                    {
                        SDL_LockSurface(raceMap);
                            pixel = getPixel(raceMap, i, j);
                            SDL_GetRGBA(pixel, raceMap->format, &r, &g, &b, &a);
                        SDL_UnlockSurface(raceMap);
                    }
                    else{g = 0;}
                    if(g == 0)
                    {
                        gameCPU[count].px = gameCPU[count].px + cos((gameCPU[count].angleM) * M_PI / 180) * COLMOVE;
                        gameCPU[count].py = gameCPU[count].py + sin((gameCPU[count].angleM) * M_PI / 180) * COLMOVE;
                    }


                    if(gameCPU[count].stat == 0)
                    {

                        i = (gameCPU[count].px + cos((gameCPU[count].angleR - 90) * M_PI / 180) * (fabs(gameCPU[count].speed) * POINT1 + gameCPU[count].dif));
                        j = (gameCPU[count].py + sin((gameCPU[count].angleR - 90) * M_PI / 180) * (fabs(gameCPU[count].speed) * POINT1 + gameCPU[count].dif));
                        if(i >= 1 && i <= SCREENW-1 && j >= 1 && j <= SCREENH-1)
                        {
                            SDL_LockSurface(raceMap);
                                pixel = getPixel(raceMap, i, j);
                                SDL_GetRGBA(pixel, raceMap->format, &r, &g, &b, &a);
                            SDL_UnlockSurface(raceMap);
                        }
                        else{b = 0;}

                        if(b == 255){p1 = 1;}
                        else{p1 = 0;}


                        i = (gameCPU[count].px + cos((gameCPU[count].angleR - 90) * M_PI / 180) * (fabs(gameCPU[count].speed) * POINT23 + gameCPU[count].dif) )  +  (cos((gameCPU[count].angleR-180) * M_PI / 180) * (gameCPU[count].detectRoad + gameCPU[count].dif) );
                        j = (gameCPU[count].py + sin((gameCPU[count].angleR - 90) * M_PI / 180) * (fabs(gameCPU[count].speed) * POINT23 + gameCPU[count].dif) )  +  (sin((gameCPU[count].angleR-180) * M_PI / 180) * (gameCPU[count].detectRoad + gameCPU[count].dif) );
                        if(i >= 1 && i <= SCREENW-1 && j >= 1 && j <= SCREENH-1)
                        {
                            SDL_LockSurface(raceMap);
                                pixel=getPixel(raceMap, i, j);
                                SDL_GetRGBA(pixel, raceMap->format, &r, &g, &b, &a);
                            SDL_UnlockSurface(raceMap);
                        }
                        else{b = 0;}

                        if(b == 255){p2 = 1;}
                        else{p2 = 0;}


                        i = (gameCPU[count].px + cos((gameCPU[count].angleR - 90) * M_PI / 180) * (fabs(gameCPU[count].speed) * POINT23 + gameCPU[count].dif) )  +  (cos((gameCPU[count].angleR) * M_PI / 180) * (gameCPU[count].detectRoad + gameCPU[count].dif) );
                        j = (gameCPU[count].py + sin((gameCPU[count].angleR - 90) * M_PI / 180) * (fabs(gameCPU[count].speed) * POINT23 + gameCPU[count].dif) )  +  (sin((gameCPU[count].angleR) * M_PI / 180) * (gameCPU[count].detectRoad + gameCPU[count].dif) );
                        if(i >= 1 && i <= SCREENW-1 && j >= 1 && j <= SCREENH-1)
                        {
                            SDL_LockSurface(raceMap);
                                pixel=getPixel(raceMap, i, j);
                                SDL_GetRGBA(pixel, raceMap->format, &r, &g, &b, &a);
                            SDL_UnlockSurface(raceMap);
                        }
                        else{b = 0;}

                        if(b == 255){p3 = 1;}
                        else{p3 = 0;}


                        if(p2 != 1 && p1 != 1 && p3 != 1)
                        {
                            gameCPU[count].speed -= SPEEDUP;
                            if(gameCPU[count].detectRoad < 30)
                            {
                                gameCPU[count].detectRoad += 3;
                            }
                        }
                        else if(p2 == 1 && p1 == 1 && p3 == 1)
                        {
                            gameCPU[count].speed += SPEEDUP;

                            if(gameCPU[count].detectRoad < 30)
                            {
                                gameCPU[count].detectRoad += 3;
                            }
                        }
                        else if(p2 == 1 && p1 != 1 && p3 == 1)
                        {
                            gameCPU[count].speed += SPEEDUP;

                            if(gameCPU[count].detectRoad > 15)
                            {
                                gameCPU[count].detectRoad -= 3;
                            }
                        }
                        else if(p2 != 1 && p1 == 1 && p3 != 1)
                        {
                            gameCPU[count].speed += SPEEDUP;

                            if(gameCPU[count].detectRoad > 10)
                            {
                                gameCPU[count].detectRoad -= 3;
                            }
                        }
                        else if(p2 != 1 && p1 == 1 && p3 == 1)
                        {
                            gameCPU[count].speed += SPEEDUP;

                            gameCPU[count].angleR += TURN;
                        }
                        else if(p2 == 1 && p1 == 1 && p3 != 1)
                        {
                            gameCPU[count].speed += SPEEDUP;

                            gameCPU[count].angleR -= TURN;
                        }
                        else if(p2 != 1 && p1 != 1 && p3 == 1)
                        {
                            gameCPU[count].speed += SPEEDUP;

                            gameCPU[count].angleR += TURN;
                        }
                        else if(p2 == 1 && p1 != 1 && p3 != 1)
                        {
                            gameCPU[count].speed += SPEEDUP;

                            gameCPU[count].angleR -= TURN;
                        }
                    }


                    if(gameCPU[count].speed > SKYDSPEEDLIMIT || gameCPU[count].speed < -SKYDSPEEDLIMIT)
                    {
                        if(gameCPU[count].angleM < gameCPU[count].angleR)
                        {
                            gameCPU[count].angleM += BOTSKYD;
                            if(gameCPU[count].angleM > gameCPU[count].angleR){gameCPU[count].angleM = gameCPU[count].angleR;}
                        }
                        else if(gameCPU[count].angleM > gameCPU[count].angleR)
                        {
                            gameCPU[count].angleM -= BOTSKYD;
                            if(gameCPU[count].angleM < gameCPU[count].angleR){gameCPU[count].angleM = gameCPU[count].angleR;}
                        }
                    }else{gameCPU[count].angleM = gameCPU[count].angleR;}


                    if(gameCPU[count].speed > 0)
                    {
                        gameCPU[count].speed -= CARBRAKE + fabs(gameCPU[count].angleM - gameCPU[count].angleR) / (40/SKYDBRAKE);
                        if(gameCPU[count].speed < 0){gameCPU[count].speed = 0;}
                    }
                    else if(gameCPU[count].speed < 0)
                    {
                        gameCPU[count].speed += CARBRAKE + fabs(gameCPU[count].angleM - gameCPU[count].angleR) / (40/SKYDBRAKE);
                        if(gameCPU[count].speed > 0){gameCPU[count].speed = 0;}
                    }


                    if(gameCPU[count].px >= 0 && gameCPU[count].px <= raceMap->w && gameCPU[count].py >= 0 && gameCPU[count].py <= raceMap->h)
                    {
                        SDL_LockSurface(raceMap);
                            pixel = getPixel(raceMap, gameCPU[count].px, gameCPU[count].py);
                            SDL_GetRGB(pixel, raceMap->format, &r, &g, &b);
                        SDL_UnlockSurface(raceMap);

                        r /= 10;

                        if(r == gameCPU[count].borne)
                        {
                            gameCPU[count].borne++;
                            if(gameCPU[count].borne > nbrBorne)
                            {
                                gameCPU[count].borne = 1;
                            }

                            else if(gameCPU[count].borne == 2)
                            {
                                gameCPU[count].laps++;
                            }

                        }
                    }

                    if(gameCPU[count].stat == 0 && gameCPU[count].laps == nbrLaps)
                    {
                        gameCPU[count].stat = winCount;
                        winCount++;
                    }
                }

                for (count = 0 ; count < nbrPlayer ; count++)
                {

                    i = (gamePlayer[count].px + cos((gamePlayer[count].angleR - 90) * M_PI / 180) * ((17 / 2)-2) ) + (cos((gamePlayer[count].angleR) * M_PI / 180) * (14 / 2) );
                    j = (gamePlayer[count].py + sin((gamePlayer[count].angleR - 90) * M_PI / 180) * ((17 / 2)-2) ) + (sin((gamePlayer[count].angleR) * M_PI / 180) * (14 / 2) );
                    if(i >= 1 && i <= SCREENW-1 && j >= 1 && j <= SCREENH-1)
                    {
                        SDL_LockSurface(colision);
                            pixel = getPixel(colision, i, j);
                            SDL_GetRGBA(pixel, colision->format, &r, &g, &b, &a);
                        SDL_UnlockSurface(colision);
                    }
                    else{r = -1;}
                    if(r != 255 && r != gamePlayer[count].colorCol)
                    {
                        gamePlayer[count].angleM -= COLROTATE;
                        gamePlayer[count].angleR -= COLROTATE;
                    }

                    if(i >= 1 && i <= SCREENW-1 && j >= 1 && j <= SCREENH-1)
                    {
                        SDL_LockSurface(raceMap);
                            pixel = getPixel(raceMap, i, j);
                            SDL_GetRGBA(pixel, raceMap->format, &r, &g, &b, &a);
                        SDL_UnlockSurface(raceMap);
                    }
                    else{g = 0;}
                    if(g == 0)
                    {
                        gamePlayer[count].angleM -= COLROTATE;
                        gamePlayer[count].angleR -= COLROTATE;
                    }

/////////////////////////////////////////////

                    i = (gamePlayer[count].px + cos((gamePlayer[count].angleR - 90) * M_PI / 180) * ((17 / 2)-2) ) + (cos((gamePlayer[count].angleR-180) * M_PI / 180) * (14 / 2) );
                    j = (gamePlayer[count].py + sin((gamePlayer[count].angleR - 90) * M_PI / 180) * ((17 / 2)-2) ) + (sin((gamePlayer[count].angleR-180) * M_PI / 180) * (14 / 2) );
                    if(i >= 1 && i <= SCREENW-1 && j >= 1 && j <= SCREENH-1)
                    {
                        SDL_LockSurface(colision);
                            pixel = getPixel(colision, i, j);
                            SDL_GetRGBA(pixel, colision->format, &r, &g, &b, &a);
                        SDL_UnlockSurface(colision);
                    }
                    else{r = -1;}
                    if(r != 255 && r != gamePlayer[count].colorCol)
                    {
                        gamePlayer[count].angleM += COLROTATE;
                        gamePlayer[count].angleR += COLROTATE;
                    }

                    if(i >= 1 && i <= SCREENW-1 && j >= 1 && j <= SCREENH-1)
                    {
                        SDL_LockSurface(raceMap);
                            pixel = getPixel(raceMap, i, j);
                            SDL_GetRGBA(pixel, raceMap->format, &r, &g, &b, &a);
                        SDL_UnlockSurface(raceMap);
                    }
                    else{g = 0;}
                    if(g == 0)
                    {
                        gamePlayer[count].angleM += COLROTATE;
                        gamePlayer[count].angleR += COLROTATE;
                    }

/////////////////////////////////////////////

                    i = (gamePlayer[count].px + cos((gamePlayer[count].angleR + 90) * M_PI / 180) * ((17 / 2)-2) ) + (cos((gamePlayer[count].angleR) * M_PI / 180) * (14 / 2) );
                    j = (gamePlayer[count].py + sin((gamePlayer[count].angleR + 90) * M_PI / 180) * ((17 / 2)-2) ) + (sin((gamePlayer[count].angleR) * M_PI / 180) * (14 / 2) );
                    if(i >= 1 && i <= SCREENW-1 && j >= 1 && j <= SCREENH-1)
                    {
                        SDL_LockSurface(colision);
                            pixel = getPixel(colision, i, j);
                            SDL_GetRGBA(pixel, colision->format, &r, &g, &b, &a);
                        SDL_UnlockSurface(colision);
                    }
                    else{r = -1;}
                    if(r != 255 && r != gamePlayer[count].colorCol)
                    {
                        gamePlayer[count].angleM += COLROTATE;
                        gamePlayer[count].angleR += COLROTATE;
                    }

                    if(i >= 1 && i <= SCREENW-1 && j >= 1 && j <= SCREENH-1)
                    {
                        SDL_LockSurface(raceMap);
                            pixel = getPixel(raceMap, i, j);
                            SDL_GetRGBA(pixel, raceMap->format, &r, &g, &b, &a);
                        SDL_UnlockSurface(raceMap);
                    }
                    else{g = 0;}
                    if(g == 0)
                    {
                        gamePlayer[count].angleM += COLROTATE;
                        gamePlayer[count].angleR += COLROTATE;
                    }

/////////////////////////////////////////////

                    i = (gamePlayer[count].px + cos((gamePlayer[count].angleR + 90) * M_PI / 180) * ((17 / 2)-2) ) + (cos((gamePlayer[count].angleR-180) * M_PI / 180) * (14 / 2) );
                    j = (gamePlayer[count].py + sin((gamePlayer[count].angleR + 90) * M_PI / 180) * ((17 / 2)-2) ) + (sin((gamePlayer[count].angleR-180) * M_PI / 180) * (14 / 2) );
                    if(i >= 1 && i <= SCREENW-1 && j >= 1 && j <= SCREENH-1)
                    {
                        SDL_LockSurface(colision);
                            pixel = getPixel(colision, i, j);
                            SDL_GetRGBA(pixel, colision->format, &r, &g, &b, &a);
                        SDL_UnlockSurface(colision);
                    }
                    else{r = -1;}
                    if(r != 255 && r != gamePlayer[count].colorCol)
                    {
                        gamePlayer[count].angleM -= COLROTATE;
                        gamePlayer[count].angleR -= COLROTATE;
                    }

                    if(i >= 1 && i <= SCREENW-1 && j >= 1 && j <= SCREENH-1)
                    {
                        SDL_LockSurface(raceMap);
                            pixel = getPixel(raceMap, i, j);
                            SDL_GetRGBA(pixel, raceMap->format, &r, &g, &b, &a);
                        SDL_UnlockSurface(raceMap);
                    }
                    else{g = 0;}
                    if(g == 0)
                    {
                        gamePlayer[count].angleM -= COLROTATE;
                        gamePlayer[count].angleR -= COLROTATE;
                    }

/////////////////////////////////////////////

                    i = (gamePlayer[count].px + cos((gamePlayer[count].angleR - 90) * M_PI / 180) * (17 / 2) );
                    j = (gamePlayer[count].py + sin((gamePlayer[count].angleR - 90) * M_PI / 180) * (17 / 2) );
                    if(i >= 1 && i <= SCREENW-1 && j >= 1 && j <= SCREENH-1)
                    {
                        SDL_LockSurface(colision);
                            pixel = getPixel(colision, i, j);
                            SDL_GetRGBA(pixel, colision->format, &r, &g, &b, &a);
                        SDL_UnlockSurface(colision);
                    }
                    else{r = -1;}
                    if(r != 255 && r != gamePlayer[count].colorCol)
                    {
                        gamePlayer[count].px = gamePlayer[count].px + cos((gamePlayer[count].angleM + 90) * M_PI / 180) * COLMOVE;
                        gamePlayer[count].py = gamePlayer[count].py + sin((gamePlayer[count].angleM + 90) * M_PI / 180) * COLMOVE;
                        gamePlayer[count].speed -= COLSPEEDMOINS;
                    }

                    if(i >= 1 && i <= SCREENW-1 && j >= 1 && j <= SCREENH-1)
                    {
                        SDL_LockSurface(raceMap);
                            pixel = getPixel(raceMap, i, j);
                            SDL_GetRGBA(pixel, raceMap->format, &r, &g, &b, &a);
                        SDL_UnlockSurface(raceMap);
                    }
                    else{g = 0;}
                    if(g == 0)
                    {
                        gamePlayer[count].px = gamePlayer[count].px + cos((gamePlayer[count].angleM + 90) * M_PI / 180) * COLMOVE;
                        gamePlayer[count].py = gamePlayer[count].py + sin((gamePlayer[count].angleM + 90) * M_PI / 180) * COLMOVE;
                        gamePlayer[count].speed -= COLSPEEDMOINS;
                    }

                    if(gamePlayer[count].speed > g / (255/GAMEMAXSPEED))
                    {
                        gamePlayer[count].speed = g / (255/GAMEMAXSPEED);
                    }

/////////////////////////////////////////////

                    i = (gamePlayer[count].px + cos((gamePlayer[count].angleR + 90) * M_PI / 180) * (17 / 2) );
                    j = (gamePlayer[count].py + sin((gamePlayer[count].angleR + 90) * M_PI / 180) * (17 / 2) );
                    if(i >= 1 && i <= SCREENW-1 && j >= 1 && j <= SCREENH-1)
                    {
                        SDL_LockSurface(colision);
                            pixel = getPixel(colision, i, j);
                            SDL_GetRGBA(pixel, colision->format, &r, &g, &b, &a);
                        SDL_UnlockSurface(colision);
                    }
                    else{r = -1;}
                    if(r != 255 && r != gamePlayer[count].colorCol)
                    {
                        gamePlayer[count].px = gamePlayer[count].px + cos((gamePlayer[count].angleM - 90) * M_PI / 180) * COLMOVE;
                        gamePlayer[count].py = gamePlayer[count].py + sin((gamePlayer[count].angleM - 90) * M_PI / 180) * COLMOVE;
                        gamePlayer[count].speed += COLSPEEDMOINS;
                    }


                    if(i >= 1 && i <= SCREENW-1 && j >= 1 && j <= SCREENH-1)
                    {
                        SDL_LockSurface(raceMap);
                            pixel = getPixel(raceMap, i, j);
                            SDL_GetRGBA(pixel, raceMap->format, &r, &g, &b, &a);
                        SDL_UnlockSurface(raceMap);
                    }
                    else{g = 0;}
                    if(g == 0)
                    {
                        gamePlayer[count].px = gamePlayer[count].px + cos((gamePlayer[count].angleM - 90) * M_PI / 180) * COLMOVE;
                        gamePlayer[count].py = gamePlayer[count].py + sin((gamePlayer[count].angleM - 90) * M_PI / 180) * COLMOVE;
                        gamePlayer[count].speed += COLSPEEDMOINS;
                    }

                    if(gamePlayer[count].speed < -g / (255/GAMEMAXSPEED))
                    {
                        gamePlayer[count].speed = -g / (255/GAMEMAXSPEED);
                    }

/////////////////////////////////////////////

                    i = (gamePlayer[count].px + cos((gamePlayer[count].angleR) * M_PI / 180) * (14 / 2) );
                    j = (gamePlayer[count].py + sin((gamePlayer[count].angleR) * M_PI / 180) * (14 / 2) );
                    if(i >= 1 && i <= SCREENW-1 && j >= 1 && j <= SCREENH-1)
                    {
                        SDL_LockSurface(colision);
                            pixel = getPixel(colision, i, j);
                            SDL_GetRGBA(pixel, colision->format, &r, &g, &b, &a);
                        SDL_UnlockSurface(colision);
                    }
                    else{r = -1;}
                    if(r != 255 && r != gamePlayer[count].colorCol)
                    {
                        gamePlayer[count].px = gamePlayer[count].px + cos((gamePlayer[count].angleM - 180) * M_PI / 180) * COLMOVE;
                        gamePlayer[count].py = gamePlayer[count].py + sin((gamePlayer[count].angleM - 180) * M_PI / 180) * COLMOVE;
                    }

                    if(i >= 1 && i <= SCREENW-1 && j >= 1 && j <= SCREENH-1)
                    {
                        SDL_LockSurface(raceMap);
                            pixel = getPixel(raceMap, i, j);
                            SDL_GetRGBA(pixel, raceMap->format, &r, &g, &b, &a);
                        SDL_UnlockSurface(raceMap);
                    }
                    else{g = 0;}
                    if(g == 0)
                    {
                        gamePlayer[count].px = gamePlayer[count].px + cos((gamePlayer[count].angleM - 180) * M_PI / 180) * COLMOVE;
                        gamePlayer[count].py = gamePlayer[count].py + sin((gamePlayer[count].angleM - 180) * M_PI / 180) * COLMOVE;
                    }

/////////////////////////////////////////////

                    i = (gamePlayer[count].px + cos((gamePlayer[count].angleR - 180) * M_PI / 180) * (14 / 2) );
                    j = (gamePlayer[count].py + sin((gamePlayer[count].angleR - 180) * M_PI / 180) * (14 / 2) );
                    if(i >= 1 && i <= SCREENW-1 && j >= 1 && j <= SCREENH-1)
                    {
                        SDL_LockSurface(colision);
                            pixel = getPixel(colision, i, j);
                            SDL_GetRGBA(pixel, colision->format, &r, &g, &b, &a);
                        SDL_UnlockSurface(colision);
                    }
                    else{r = -1;}
                    if(r != 255 && r != gamePlayer[count].colorCol)
                    {
                        gamePlayer[count].px = gamePlayer[count].px + cos((gamePlayer[count].angleM) * M_PI / 180) * COLMOVE;
                        gamePlayer[count].py = gamePlayer[count].py + sin((gamePlayer[count].angleM) * M_PI / 180) * COLMOVE;
                    }

                    if(i >= 1 && i <= SCREENW-1 && j >= 1 && j <= SCREENH-1)
                    {
                        SDL_LockSurface(raceMap);
                            pixel = getPixel(raceMap, i, j);
                            SDL_GetRGBA(pixel, raceMap->format, &r, &g, &b, &a);
                        SDL_UnlockSurface(raceMap);
                    }
                    else{g = 0;}
                    if(g == 0)
                    {
                        gamePlayer[count].px = gamePlayer[count].px + cos((gamePlayer[count].angleM) * M_PI / 180) * COLMOVE;
                        gamePlayer[count].py = gamePlayer[count].py + sin((gamePlayer[count].angleM) * M_PI / 180) * COLMOVE;
                    }


                    if(gamePlayer[count].stat == 0)
                    {
                        switch(config.control[count])
                        {
                            case 0:
                                if(keyState[SDLK_UP])
                                {
                                    gamePlayer[count].speed += SPEEDUP;
                                }
                                if(keyState[SDLK_DOWN])
                                {
                                    gamePlayer[count].speed -= SPEEDUP;
                                }
                                if(keyState[SDLK_LEFT])
                                {
                                    if(gamePlayer[count].speed > SPEEDUP*2 || gamePlayer[count].speed < -SPEEDUP*2)
                                    {
                                        gamePlayer[count].angleR -= TURN;
                                    }
                                }
                                if(keyState[SDLK_RIGHT])
                                {
                                    if(gamePlayer[count].speed > SPEEDUP*2 || gamePlayer[count].speed < -SPEEDUP*2)
                                    {
                                        gamePlayer[count].angleR += TURN;
                                    }
                                }
                                break;
                            case 1:
                                if(keyState[SDLK_e])
                                {
                                    gamePlayer[count].speed += SPEEDUP;
                                }
                                if(keyState[SDLK_d])
                                {
                                    gamePlayer[count].speed -= SPEEDUP;
                                }
                                if(keyState[SDLK_s])
                                {
                                    if(gamePlayer[count].speed > SPEEDUP*2 || gamePlayer[count].speed < -SPEEDUP*2)
                                    {
                                        gamePlayer[count].angleR -= TURN;
                                    }
                                }
                                if(keyState[SDLK_f])
                                {
                                    if(gamePlayer[count].speed > SPEEDUP*2 || gamePlayer[count].speed < -SPEEDUP*2)
                                    {
                                        gamePlayer[count].angleR += TURN;
                                    }
                                }
                                break;

                            case 2:

                                if(SDL_GetMouseState(NULL, NULL)&SDL_BUTTON(1) && SDL_GetMouseState(NULL, NULL)&SDL_BUTTON(3))
                                {
                                    gamePlayer[count].speed -= SPEEDUP;
                                }
                                else
                                {
                                    gamePlayer[count].speed += SPEEDUP;
                                }

                                if(SDL_GetMouseState(NULL, NULL)&SDL_BUTTON(1))
                                {
                                    if(gamePlayer[count].speed > SPEEDUP*2 || gamePlayer[count].speed < -SPEEDUP*2)
                                    {
                                        gamePlayer[count].angleR -= TURN;
                                    }
                                }
                                if(SDL_GetMouseState(NULL, NULL)&SDL_BUTTON(3))
                                {
                                    if(gamePlayer[count].speed > SPEEDUP*2 || gamePlayer[count].speed < -SPEEDUP*2)
                                    {
                                        gamePlayer[count].angleR += TURN;
                                    }
                                }
                                break;
                            if(SDL_NumJoysticks() > 0)
                            {
                            case 3:
                                if(SDL_JoystickGetButton(joystick[config.control[count]-3], 0)) //Up
                                {
                                    gamePlayer[count].speed += SPEEDUP;
                                }
                                if(SDL_JoystickGetButton(joystick[config.control[count]-3], 1)) //Down
                                {
                                    gamePlayer[count].speed -= SPEEDUP;
                                }
                                if(SDL_JoystickGetAxis(joystick[config.control[count]-3], 0) < -3200) //Left
                                {
                                    if(gamePlayer[count].speed > SPEEDUP*2 || gamePlayer[count].speed < -SPEEDUP*2)
                                    {
                                        gamePlayer[count].angleR -= TURN;
                                    }
                                }
                                if(SDL_JoystickGetAxis(joystick[config.control[count]-3], 0) > 3200) //Right
                                {
                                    if(gamePlayer[count].speed > SPEEDUP*2 || gamePlayer[count].speed < -SPEEDUP*2)
                                    {
                                        gamePlayer[count].angleR += TURN;
                                    }
                                }
                                break;
                            }
                            if(SDL_NumJoysticks() > 1)
                            {
                            case 4:
                                if(SDL_JoystickGetButton(joystick[config.control[count]-3], 0)) //Up
                                {
                                    gamePlayer[count].speed += SPEEDUP;
                                }
                                if(SDL_JoystickGetButton(joystick[config.control[count]-3], 1)) //Down
                                {
                                    gamePlayer[count].speed -= SPEEDUP;
                                }
                                if(SDL_JoystickGetAxis(joystick[config.control[count]-3], 0) < -3200) //Left
                                {
                                    if(gamePlayer[count].speed > SPEEDUP*2 || gamePlayer[count].speed < -SPEEDUP*2)
                                    {
                                        gamePlayer[count].angleR -= TURN;
                                    }
                                }
                                if(SDL_JoystickGetAxis(joystick[config.control[count]-3], 0) > 3200) //Right
                                {
                                    if(gamePlayer[count].speed > SPEEDUP*2 || gamePlayer[count].speed < -SPEEDUP*2)
                                    {
                                        gamePlayer[count].angleR += TURN;
                                    }
                                }
                                break;
                            }
                            if(SDL_NumJoysticks() > 2)
                            {
                            case 5:
                                if(SDL_JoystickGetButton(joystick[config.control[count]-3], 0)) //Up
                                {
                                    gamePlayer[count].speed += SPEEDUP;
                                }
                                if(SDL_JoystickGetButton(joystick[config.control[count]-3], 1)) //Down
                                {
                                    gamePlayer[count].speed -= SPEEDUP;
                                }
                                if(SDL_JoystickGetAxis(joystick[config.control[count]-3], 0) < -3200) //Left
                                {
                                    if(gamePlayer[count].speed > SPEEDUP*2 || gamePlayer[count].speed < -SPEEDUP*2)
                                    {
                                        gamePlayer[count].angleR -= TURN;
                                    }
                                }
                                if(SDL_JoystickGetAxis(joystick[config.control[count]-3], 0) > 3200) //Right
                                {
                                    if(gamePlayer[count].speed > SPEEDUP*2 || gamePlayer[count].speed < -SPEEDUP*2)
                                    {
                                        gamePlayer[count].angleR += TURN;
                                    }
                                }
                                break;
                            }
                            if(SDL_NumJoysticks() > 3)
                            {
                            case 6:
                                if(SDL_JoystickGetButton(joystick[config.control[count]-3], 0)) //Up
                                {
                                    gamePlayer[count].speed += SPEEDUP;
                                }
                                if(SDL_JoystickGetButton(joystick[config.control[count]-3], 1)) //Down
                                {
                                    gamePlayer[count].speed -= SPEEDUP;
                                }
                                if(SDL_JoystickGetAxis(joystick[config.control[count]-3], 0) < -3200) //Left
                                {
                                    if(gamePlayer[count].speed > SPEEDUP*2 || gamePlayer[count].speed < -SPEEDUP*2)
                                    {
                                        gamePlayer[count].angleR -= TURN;
                                    }
                                }
                                if(SDL_JoystickGetAxis(joystick[config.control[count]-3], 0) > 3200) //Right
                                {
                                    if(gamePlayer[count].speed > SPEEDUP*2 || gamePlayer[count].speed < -SPEEDUP*2)
                                    {
                                        gamePlayer[count].angleR += TURN;
                                    }
                                }
                                break;
                            }
                        }
                    }

                    if(gamePlayer[count].speed > SKYDSPEEDLIMIT || gamePlayer[count].speed < -SKYDSPEEDLIMIT)
                    {
                        if(gamePlayer[count].angleM < gamePlayer[count].angleR)
                        {
                            gamePlayer[count].angleM += PLAYERSKYD;
                            if(gamePlayer[count].angleM > gamePlayer[count].angleR){gamePlayer[count].angleM = gamePlayer[count].angleR;}
                        }
                        else if(gamePlayer[count].angleM > gamePlayer[count].angleR)
                        {
                            gamePlayer[count].angleM -= PLAYERSKYD;
                            if(gamePlayer[count].angleM < gamePlayer[count].angleR){gamePlayer[count].angleM = gamePlayer[count].angleR;}
                        }
                    }else{gamePlayer[count].angleM = gamePlayer[count].angleR;}


                    if(gamePlayer[count].speed > 0)
                    {
                        gamePlayer[count].speed -= CARBRAKE + fabs(gamePlayer[count].angleM - gamePlayer[count].angleR) / (40/SKYDBRAKE);
                        if(gamePlayer[count].speed < 0){gamePlayer[count].speed = 0;}
                    }
                    else if(gamePlayer[count].speed < 0)
                    {
                        gamePlayer[count].speed += CARBRAKE + fabs(gamePlayer[count].angleM - gamePlayer[count].angleR) / (40/SKYDBRAKE);
                        if(gamePlayer[count].speed > 0){gamePlayer[count].speed = 0;}
                    }


                    if(gamePlayer[count].px >= 1 && gamePlayer[count].px <= SCREENW-1 && gamePlayer[count].py >= 1 && gamePlayer[count].py <= SCREENH-1)
                    {
                        SDL_LockSurface(raceMap);
                            pixel = getPixel(raceMap, gamePlayer[count].px, gamePlayer[count].py);
                            SDL_GetRGB(pixel, raceMap->format, &r, &g, &b);
                        SDL_UnlockSurface(raceMap);

                        r /= 10;

                        if(r == gamePlayer[count].borne)
                        {
                            gamePlayer[count].borne++;
                            if(gamePlayer[count].borne > nbrBorne)
                            {
                                gamePlayer[count].borne = 1;
                            }
                            else if(gamePlayer[count].borne == 2)
                            {
                                gamePlayer[count].laps++;
                                if(gamePlayer[count].laps > 0 && gamePlayer[count].laps != nbrLaps)
                                {
                                    if(config.sound){Mix_PlayChannel(9, laps_sound, 0);}

                                    if(gamePlayer[count].laps == nbrLaps-1)
                                    {
                                        gamePlayer[count].msgID = 8;
                                        gamePlayer[count].msgCount = 100;
                                    }
                                    else
                                    {
                                        gamePlayer[count].msgID = gamePlayer[count].laps-1;
                                        gamePlayer[count].msgCount = 100;
                                    }
                                }
                            }
                        }
                    }

                    if(gamePlayer[count].stat == 0 && gamePlayer[count].laps == nbrLaps)
                    {
                        if(config.sound){Mix_PlayChannel(-1, finish_sound, 0);}

                        gamePlayer[count].stat = winCount;
                        winCount++;
                    }

                    if(fabs(gamePlayer[count].angleM - gamePlayer[count].angleR) > 25 && gamePlayer[count].speed > 2)
                    {
                        if(config.sound && gamePlayer[count].skidpass){Mix_PlayChannel(5+count, skid_sound[count], 0);gamePlayer[count].skidpass = 0;}
                    }
                    else{if(config.sound){Mix_HaltChannel(5+count);gamePlayer[count].skidpass = 1;}}
                }
            }

            if(close == 0 && filterint > 0){filterint -= FILTERSTEP;}

            SDL_FillRect(colision, NULL, SDL_MapRGB(colision->format, 255, 255, 255));
            SDL_BlitSurface(racePic, NULL, screen, NULL);

            if(!close)
            {
                for (count = 0 ; count < nbrCPU ; count++)
                {
                    ////////////////////Calculate////////////////////

                    if(startframe > 200)
                    {
                        gameCPU[count].px += cos((gameCPU[count].angleM - 90) * M_PI / 180) * gameCPU[count].speed;
                        gameCPU[count].py += sin((gameCPU[count].angleM - 90) * M_PI / 180) * gameCPU[count].speed;
                    }

                    rect.x = gameCPU[count].px - (19 / 2);
                    rect.y = gameCPU[count].py - (19 / 2);

                    clip.x = 0;
                    clip.y = 0;
                    clip.w = 19;
                    clip.h = 19;

                    if(gameCPU[count].angleR < 0)
                    {
                        clip.y = 360 + (gameCPU[count].angleR - ((int)(gameCPU[count].angleR/360)*360));
                    }
                    else
                    {
                        clip.y = gameCPU[count].angleR - ((int)(gameCPU[count].angleR/360)*360);
                    }

                    clip.y = clip.y / 5 * 19;

                    ////////////////////Blit////////////////////

                    SDL_LockSurface(s1);
                    SDL_LockSurface(s2);
                    SDL_LockSurface(s3);
                    SDL_LockSurface(s4);
                        for (i = clip.y; i < clip.y+19 ; i++)
                        {
                            for (j = 0; j < 19 ; j++)
                            {
                                pixel = getPixel(s1, j, i);
                                SDL_GetRGBA(pixel, s1->format, &r, &g, &b, &a);

                                if(r == 192 && g == 192 && b == 192)
                                {
                                    pixel = SDL_MapRGB(s2->format, CPUColor1[count].r, CPUColor1[count].g, CPUColor1[count].b);
                                    setPixel(s2, j, i, pixel);
                                }
                                else if(r == 128 && g == 128 && b == 128)
                                {
                                    pixel = SDL_MapRGB(s2->format, CPUColor2[count].r, CPUColor2[count].g, CPUColor2[count].b);
                                    setPixel(s2, j, i, pixel);
                                }
                                else if(r == 255 && g == 255 && b == 255)
                                {
                                    pixel = SDL_MapRGB(s2->format, CPUColor3[count].r, CPUColor3[count].g, CPUColor3[count].b);
                                    setPixel(s2, j, i, pixel);
                                }
                                else
                                {
                                    pixel = SDL_MapRGBA(s2->format, r, g, b, a);
                                    setPixel(s2, j, i, pixel);
                                }

                                pixel = getPixel(s1, j, i);
                                SDL_GetRGBA(pixel, s1->format, &r, &g, &b, &a);

                                if(a == 255)
                                {
                                    pixel = SDL_MapRGBA(s3->format, (count*2)+100, 0, 0, 127);
                                    setPixel(s3, j, i, pixel);

                                    pixel = SDL_MapRGBA(s4->format, 0, 0, 0, 80);
                                    setPixel(s4, j, i, pixel);
                                }
                            }
                        }
                    SDL_UnlockSurface(s1);
                    SDL_UnlockSurface(s2);
                    SDL_UnlockSurface(s3);
                    SDL_UnlockSurface(s4);

                    SDL_BlitSurface(s3, &clip, colision, &rect);
                    SDL_LockSurface(colision);
                        pixel = getPixel(colision, gameCPU[count].px, gameCPU[count].py);
                        SDL_GetRGBA(pixel, colision->format, &r, &g, &b, &a);

                        gameCPU[count].colorCol = r;
                    SDL_UnlockSurface(colision);

                    rect.x += 1;
                    rect.y += 1;
                    SDL_BlitSurface(s4, &clip, screen, &rect);
                    rect.x -= 1;
                    rect.y -= 1;

                    SDL_BlitSurface(s2, &clip, screen, &rect);
                }


                for (count = 0 ; count < nbrPlayer ; count++)
                {
                    ////////////////////Calculate////////////////////

                    if(startframe > 200)
                    {
                        gamePlayer[count].px += cos((gamePlayer[count].angleM - 90) * M_PI / 180) * gamePlayer[count].speed;
                        gamePlayer[count].py += sin((gamePlayer[count].angleM - 90) * M_PI / 180) * gamePlayer[count].speed;
                    }

                    rect.x = gamePlayer[count].px - (19 / 2);
                    rect.y = gamePlayer[count].py - (19 / 2);

                    clip.x = 0;
                    clip.y = 0;
                    clip.w = 19;
                    clip.h = 19;

                    if(gamePlayer[count].angleR < 0)
                    {
                        clip.y = 360 + (gamePlayer[count].angleR - ((int)(gamePlayer[count].angleR/360)*360));
                    }
                    else
                    {
                        clip.y = gamePlayer[count].angleR - ((int)(gamePlayer[count].angleR/360)*360);
                    }

                    clip.y = clip.y / 5 * 19;


                    ////////////////////Blit////////////////////

                    SDL_LockSurface(s1);
                    SDL_LockSurface(s2);
                    SDL_LockSurface(s3);
                    SDL_LockSurface(s4);
                        for (i = clip.y; i < clip.y+19 ; i++)
                        {
                            for (j = 0; j < 19 ; j++)
                            {
                                pixel = getPixel(s1, j, i);
                                SDL_GetRGBA(pixel, s1->format, &r, &g, &b, &a);

                                if(r == 192 && g == 192 && b == 192)
                                {
                                    pixel = SDL_MapRGB(s2->format, config.playerColor1[count].r, config.playerColor1[count].g, config.playerColor1[count].b);
                                    setPixel(s2, j, i, pixel);
                                }
                                else if(r == 128 && g == 128 && b == 128)
                                {
                                    pixel = SDL_MapRGB(s2->format, config.playerColor2[count].r, config.playerColor2[count].g, config.playerColor2[count].b);
                                    setPixel(s2, j, i, pixel);
                                }
                                else if(r == 255 && g == 255 && b == 255)
                                {
                                    pixel = SDL_MapRGB(s2->format, config.playerColor3[count].r, config.playerColor3[count].g, config.playerColor3[count].b);
                                    setPixel(s2, j, i, pixel);
                                }
                                else
                                {
                                    pixel = SDL_MapRGBA(s2->format, r, g, b, a);
                                    setPixel(s2, j, i, pixel);
                                }

                                pixel = getPixel(s1, j, i);
                                SDL_GetRGBA(pixel, s1->format, &r, &g, &b, &a);

                                if(a == 255)
                                {
                                    pixel = SDL_MapRGBA(s3->format, (count*2)+1, 0, 0, 127);
                                    setPixel(s3, j, i, pixel);

                                    pixel = SDL_MapRGBA(s4->format, 0, 0, 0, 80);
                                    setPixel(s4, j, i, pixel);
                                }
                            }
                        }
                    SDL_UnlockSurface(s1);
                    SDL_UnlockSurface(s2);
                    SDL_UnlockSurface(s3);
                    SDL_UnlockSurface(s4);

                    SDL_BlitSurface(s3, &clip, colision, &rect);
                    SDL_LockSurface(colision);
                        pixel = getPixel(colision, gamePlayer[count].px, gamePlayer[count].py);
                        SDL_GetRGBA(pixel, colision->format, &r, &g, &b, &a);

                        gamePlayer[count].colorCol = r;
                    SDL_UnlockSurface(colision);

                    if(startframe < 100)
                    {
                        if(timeBlink % 2 == 0)
                        {
                            rect.x += 1;
                            rect.y += 1;
                            SDL_BlitSurface(s4, &clip, screen, &rect);
                            rect.x -= 1;
                            rect.y -= 1;

                            SDL_BlitSurface(s2, &clip, screen, &rect);
                        }
                    }
                    else
                    {
                        rect.x += 1;
                        rect.y += 1;
                        SDL_BlitSurface(s4, &clip, screen, &rect);
                        rect.x -= 1;
                        rect.y -= 1;

                        SDL_BlitSurface(s2, &clip, screen, &rect);
                    }

                    /////////////////////MSG///////////////////////

                    if(gamePlayer[count].msgCount > 0)
                    {
                        clip.x = 0;
                        clip.y = gamePlayer[count].msgID * (msg->h/9);
                        clip.w = msg->w;
                        clip.h = (msg->h/9);

                        SDL_LockSurface(msgColor);
                        SDL_LockSurface(msg);
                            for (i = clip.y; i < clip.y+(msg->h/9) ; i++)
                            {
                                for (j = 0; j < msg->w ; j++)
                                {
                                    pixel = getPixel(msg, j, i);
                                    SDL_GetRGBA(pixel, msg->format, &r, &g, &b, &a);

                                    if(r == 128 && g == 128 && b == 128)
                                    {
                                        pixel = SDL_MapRGBA(msgColor->format, config.playerColor1[count].r, config.playerColor1[count].g, config.playerColor1[count].b, a);
                                        setPixel(msgColor, j, i, pixel);
                                    }
                                }
                            }
                        SDL_UnlockSurface(msgColor);
                        SDL_UnlockSurface(msg);

                        rect.x = gamePlayer[count].px - msg->w / 2;
                        rect.y = gamePlayer[count].py - (msg->h/9) - 5;

                        SDL_BlitSurface(msgColor, &clip, screen, &rect);
                    }
                    gamePlayer[count].msgCount--;
                }


                if(startframe < 50)
                {
                    rect.x = (screen->w / 2) - ((startimg->w / 5) /2);
                    rect.y = (startframe - 50) / 2;

                    clip.w = startimg->w / 5;
                    clip.h = startimg->h;
                    clip.x = 0;
                    clip.y = 0;

                    SDL_BlitSurface(startimg, &clip, screen, &rect);
                }
                else if(startframe >= 50 && startframe < 100)
                {
                    rect.x = (screen->w / 2) - ((startimg->w / 5) /2);
                    rect.y = 0;

                    if(startframe == 50){if(config.sound){Mix_PlayChannel(-1, tut_sound, 0);}}

                    clip.w = startimg->w / 5;
                    clip.h = startimg->h;
                    clip.x = startimg->w / 5;
                    clip.y = 0;

                    SDL_BlitSurface(startimg, &clip, screen, &rect);

                }
                else if(startframe >= 100 && startframe < 150)
                {
                    if(startframe == 100){if(config.sound){Mix_PlayChannel(-1, tut_sound, 0);}}

                    rect.x = (screen->w / 2) - ((startimg->w / 5) /2);
                    rect.y = 0;

                    clip.w = startimg->w / 5;
                    clip.h = startimg->h;
                    clip.x = (startimg->w / 5) * 2;
                    clip.y = 0;

                    SDL_BlitSurface(startimg, &clip, screen, &rect);
                }
                else if(startframe >= 150 && startframe < 200)
                {
                    if(startframe == 150){if(config.sound){Mix_PlayChannel(-1, tut_sound, 0);}}

                    rect.x = (screen->w / 2) - ((startimg->w / 5) /2);
                    rect.y = 0;

                    clip.w = startimg->w / 5;
                    clip.h = startimg->h;
                    clip.x = (startimg->w / 5) * 3;
                    clip.y = 0;

                    SDL_BlitSurface(startimg, &clip, screen, &rect);
                }
                else if(startframe >= 200 && startframe < 250)
                {
                    if(startframe == 200)
                    {
                        if(config.sound){Mix_PlayChannel(-1, tit_sound, 0);}
                    }

                    rect.x = (screen->w / 2) - ((startimg->w / 5) /2);
                    rect.y = 0;

                    clip.w = startimg->w / 5;
                    clip.h = startimg->h;
                    clip.x = (startimg->w / 5) * 4;
                    clip.y = 0;

                    SDL_BlitSurface(startimg, &clip, screen, &rect);
                }
                else if(startframe >= 250 && startframe < 500)
                {
                    rect.x = (screen->w / 2) - ((startimg->w / 5) / 2);
                    rect.y = -(startframe - 250) / 2;

                    clip.w = startimg->w / 5;
                    clip.h = startimg->h;
                    clip.x = (startimg->w / 5) * 4;
                    clip.y = 0;

                    SDL_BlitSurface(startimg, &clip, screen, &rect);
                }

                startframe++;

                if(winCount > 1)
                {
                    rect.x = SCREENW / 2 - finish->w / 2;
                    rect.y = 0;

                    SDL_BlitSurface(finish, NULL, screen, &rect);

                    for (count = 0 ; count < nbrCPU ; count++)
                    {
                        if(gameCPU[count].stat > 0 && gameCPU[count].stat <= 11)
                        {
                            SDL_LockSurface(s1);
                            SDL_LockSurface(s2);
                            SDL_LockSurface(s4);
                                for (i = 0; i < 19 ; i++)
                                {
                                    for (j = 0; j < 19 ; j++)
                                    {
                                        pixel = getPixel(s1, j, i);
                                        SDL_GetRGBA(pixel, s1->format, &r, &g, &b, &a);

                                        if(r == 192 && g == 192 && b == 192)
                                        {
                                            pixel = SDL_MapRGB(s2->format, CPUColor1[count].r, CPUColor1[count].g, CPUColor1[count].b);
                                            setPixel(s2, j, i, pixel);
                                        }
                                        else if(r == 128 && g == 128 && b == 128)
                                        {
                                            pixel = SDL_MapRGB(s2->format, CPUColor2[count].r, CPUColor2[count].g, CPUColor2[count].b);
                                            setPixel(s2, j, i, pixel);
                                        }
                                        else if(r == 255 && g == 255 && b == 255)
                                        {
                                            pixel = SDL_MapRGB(s2->format, CPUColor3[count].r, CPUColor3[count].g, CPUColor3[count].b);
                                            setPixel(s2, j, i, pixel);
                                        }
                                        else
                                        {
                                            pixel = SDL_MapRGBA(s2->format, r, g, b, a);
                                            setPixel(s2, j, i, pixel);
                                        }

                                        pixel = getPixel(s1, j, i);
                                        SDL_GetRGBA(pixel, s1->format, &r, &g, &b, &a);

                                        if(a == 255)
                                        {
                                            pixel = SDL_MapRGBA(s4->format, 0, 0, 0, 100);
                                            setPixel(s4, j, i, pixel);
                                        }
                                    }
                                }
                            SDL_UnlockSurface(s1);
                            SDL_UnlockSurface(s2);
                            SDL_UnlockSurface(s4);

                            rect.x = SCREENW/2 - tableTop->w/2;

                            if(gameCPU[count].stat == 1)
                            {
                                if(nbrPlayer + nbrCPU >= 11){rect.y = (SCREENH / 2 - (11 * tableTop->h) / 2) + (gameCPU[count].stat-1) * tableTop->h;}
                                else{rect.y = (SCREENH / 2 - ((nbrPlayer + nbrCPU) * tableTop->h) / 2) + (gameCPU[count].stat-1) * tableTop->h;}
                                SDL_BlitSurface(tableTop, NULL, screen, &rect);

                                if(winCount == 2)
                                {
                                    rect.y += tableTop->h;
                                    SDL_BlitSurface(tableBot, NULL, screen, &rect);
                                }
                            }
                            else if(gameCPU[count].stat == 11 || gameCPU[count].stat == winCount-1)
                            {
                                if(nbrPlayer + nbrCPU >= 11){rect.y = (SCREENH / 2 - (11 * tableTop->h) / 2) + (gameCPU[count].stat-1) * tableTop->h;}
                                else{rect.y = (SCREENH / 2 - ((nbrPlayer + nbrCPU) * tableTop->h) / 2) + (gameCPU[count].stat-1) * tableTop->h;}
                                SDL_BlitSurface(tableBot, NULL, screen, &rect);
                            }
                            else
                            {
                                if(nbrPlayer + nbrCPU >= 11){rect.y = (SCREENH / 2 - (11 * tableTop->h) / 2) + (gameCPU[count].stat-1) * tableTop->h;}
                                else{rect.y = (SCREENH / 2 - ((nbrPlayer + nbrCPU) * tableTop->h) / 2) + (gameCPU[count].stat-1) * tableTop->h;}
                                SDL_BlitSurface(tableMid, NULL, screen, &rect);
                            }

                            if(nbrPlayer + nbrCPU >= 11){rect.y = (SCREENH / 2 - (11 * tableTop->h) / 2) + (gameCPU[count].stat-1) * tableTop->h + 2;}
                            else{rect.y = (SCREENH / 2 - ((nbrPlayer + nbrCPU) * tableTop->h) / 2) + (gameCPU[count].stat-1) * tableTop->h + 2;}

                            if(gameCPU[count].stat == 11)
                            {
                                rect.x = SCREENW / 2 - rank->w / 2;

                                clip.x = 0;
                                clip.y = (rank->h / 11) * 10;
                                clip.w = rank->w;
                                clip.h = rank->h / 11;
                                SDL_BlitSurface(rank, &clip, screen, &rect);
                            }
                            else
                            {
                                rect.x = SCREENW / 2 - (rank->w + 3 + s2->w + 3 + text->w + 3 + nbr->w) / 2;

                                clip.x = 0;
                                clip.y = (gameCPU[count].stat-1)*(rank->h / 11);
                                clip.w = rank->w;
                                clip.h = rank->h / 11;
                                SDL_BlitSurface(rank, &clip, screen, &rect);

                                rect.x += rank->w + 3;

                                clip.x = 0;
                                clip.y = 0;
                                clip.w = 19;
                                clip.h = 19;

                                rect.y += 3;

                                rect.x += 1;
                                rect.y += 1;
                                SDL_BlitSurface(s4, &clip, screen, &rect);
                                rect.x -= 1;
                                rect.y -= 1;

                                SDL_BlitSurface(s2, &clip, screen, &rect);
                                rect.y -= 3;


                                rect.x += s2->w + 3;

                                clip.x = 0;
                                clip.y = (text->h / 19) * 3;
                                clip.w = text->w;
                                clip.h = text->h / 19;
                                SDL_BlitSurface(text, &clip, screen, &rect);

                                rect.x += text->w + 3;

                                clip.x = 0;
                                clip.y = (count+1)*(nbr->h / 17);
                                clip.w = nbr->w;
                                clip.h = nbr->h / 17;
                                SDL_BlitSurface(nbr, &clip, screen, &rect);
                            }
                        }
                    }

                    for (count = 0 ; count < nbrPlayer ; count++)
                    {
                        if(gamePlayer[count].stat != 0 && gamePlayer[count].stat <= 11)
                        {
                            SDL_LockSurface(s1);
                            SDL_LockSurface(s2);
                            SDL_LockSurface(s4);
                                for (i = 0; i < 19 ; i++)
                                {
                                    for (j = 0; j < 19 ; j++)
                                    {
                                        pixel = getPixel(s1, j, i);
                                        SDL_GetRGBA(pixel, s1->format, &r, &g, &b, &a);

                                        if(r == 192 && g == 192 && b == 192)
                                        {
                                            pixel = SDL_MapRGB(s2->format, config.playerColor1[count].r, config.playerColor1[count].g, config.playerColor1[count].b);
                                            setPixel(s2, j, i, pixel);
                                        }
                                        else if(r == 128 && g == 128 && b == 128)
                                        {
                                            pixel = SDL_MapRGB(s2->format, config.playerColor2[count].r, config.playerColor2[count].g, config.playerColor2[count].b);
                                            setPixel(s2, j, i, pixel);
                                        }
                                        else if(r == 255 && g == 255 && b == 255)
                                        {
                                            pixel = SDL_MapRGB(s2->format, config.playerColor3[count].r, config.playerColor3[count].g, config.playerColor3[count].b);
                                            setPixel(s2, j, i, pixel);
                                        }
                                        else
                                        {
                                            pixel = SDL_MapRGBA(s2->format, r, g, b, a);
                                            setPixel(s2, j, i, pixel);
                                        }

                                        pixel = getPixel(s1, j, i);
                                        SDL_GetRGBA(pixel, s1->format, &r, &g, &b, &a);

                                        if(a == 255)
                                        {
                                            pixel = SDL_MapRGBA(s4->format, 0, 0, 0, 100);
                                            setPixel(s4, j, i, pixel);
                                        }
                                    }
                                }
                            SDL_UnlockSurface(s1);
                            SDL_UnlockSurface(s2);
                            SDL_UnlockSurface(s4);

                            rect.x = SCREENW/2 - tableTop->w/2;

                            if(gamePlayer[count].stat == 1)
                            {
                                if(nbrPlayer + nbrCPU >= 11){rect.y = (SCREENH / 2 - (11 * tableTop->h) / 2) + (gamePlayer[count].stat-1) * tableTop->h;}
                                else{rect.y = (SCREENH / 2 - ((nbrPlayer + nbrCPU) * tableTop->h) / 2) + (gamePlayer[count].stat-1) * tableTop->h;}
                                SDL_BlitSurface(tableTop, NULL, screen, &rect);

                                if(winCount == 2)
                                {
                                    rect.y += tableTop->h;
                                    SDL_BlitSurface(tableBot, NULL, screen, &rect);
                                }
                            }
                            else if(gamePlayer[count].stat == 11 || gamePlayer[count].stat == winCount-1)
                            {
                                if(nbrPlayer + nbrCPU >= 11){rect.y = (SCREENH / 2 - (11 * tableTop->h) / 2) + (gamePlayer[count].stat-1) * tableTop->h;}
                                else{rect.y = (SCREENH / 2 - ((nbrPlayer + nbrCPU) * tableTop->h) / 2) + (gamePlayer[count].stat-1) * tableTop->h;}
                                SDL_BlitSurface(tableBot, NULL, screen, &rect);
                            }
                            else
                            {
                                if(nbrPlayer + nbrCPU >= 11){rect.y = (SCREENH / 2 - (11 * tableTop->h) / 2) + (gamePlayer[count].stat-1) * tableTop->h;}
                                else{rect.y = (SCREENH / 2 - ((nbrPlayer + nbrCPU) * tableTop->h) / 2) + (gamePlayer[count].stat-1) * tableTop->h;}
                                SDL_BlitSurface(tableMid, NULL, screen, &rect);
                            }

                            if(nbrPlayer + nbrCPU >= 11){rect.y = (SCREENH / 2 - (11 * tableTop->h) / 2) + (gamePlayer[count].stat-1) * tableTop->h + 2;}
                            else{rect.y = (SCREENH / 2 - ((nbrPlayer + nbrCPU) * tableTop->h) / 2) + (gamePlayer[count].stat-1) * tableTop->h + 2;}

                            if(gamePlayer[count].stat == 11)
                            {
                                rect.x = SCREENW / 2 - rank->w / 2;

                                clip.x = 0;
                                clip.y = (rank->h / 11) * 10;
                                clip.w = rank->w;
                                clip.h = rank->h / 11;
                                SDL_BlitSurface(rank, &clip, screen, &rect);
                            }
                            else
                            {
                                rect.x = SCREENW / 2 - (rank->w + 3 + s2->w + 3 + text->w + 3 + nbr->w) / 2;

                                clip.x = 0;
                                clip.y = (gamePlayer[count].stat-1)*(rank->h / 11);
                                clip.w = rank->w;
                                clip.h = rank->h / 11;
                                SDL_BlitSurface(rank, &clip, screen, &rect);

                                rect.x += rank->w + 3;

                                clip.x = 0;
                                clip.y = 0;
                                clip.w = 19;
                                clip.h = 19;

                                rect.y += 3;

                                rect.x += 1;
                                rect.y += 1;
                                SDL_BlitSurface(s4, &clip, screen, &rect);
                                rect.x -= 1;
                                rect.y -= 1;

                                SDL_BlitSurface(s2, &clip, screen, &rect);
                                rect.y -= 3;


                                rect.x += s2->w + 3;

                                clip.x = 0;
                                clip.y = text->h / 19;
                                clip.w = text->w;
                                clip.h = text->h / 19;
                                SDL_BlitSurface(text, &clip, screen, &rect);

                                rect.x += text->w + 3;

                                clip.x = 0;
                                clip.y = (count+1)*(nbr->h / 17);
                                clip.w = nbr->w;
                                clip.h = nbr->h / 17;
                                SDL_BlitSurface(nbr, &clip, screen, &rect);
                            }
                        }
                    }

                    clip.w = menus->w / 2;
                    clip.h = menus->h / 14;

                    ///////////// back //////////////

                    clip.x = menus->w/2;
                    clip.y = clip.h * 7;

                    rect.x = SCREENW / 2 - menus->w / 4;
                    rect.y = SCREENH - (clip.h + 30);
                    SDL_BlitSurface(menus, &clip, screen, &rect);
                }

                if(filterint > 0)
                {
                    SDL_SetAlpha(filter, SDL_SRCALPHA, filterint);
                    SDL_BlitSurface(filter, NULL, screen, NULL);
                }


                SDL_Flip(screen);
            }

            prev = current;
        }
        else
        {
            SDL_Delay((1000/FPS) - (current - prev));
        }
	}


    Mix_FreeChunk(tut_sound);
    Mix_FreeChunk(tit_sound);
    Mix_FreeChunk(laps_sound);
    Mix_FreeChunk(finish_sound);
    for (count = 0; count < 4 ; count++){Mix_FreeChunk(skid_sound[count]);}

    SDL_FreeSurface(tmp);
    SDL_FreeSurface(startimg);
    SDL_FreeSurface(msg);
    SDL_FreeSurface(msgColor);
    SDL_FreeSurface(rank);
    SDL_FreeSurface(text);
    SDL_FreeSurface(nbr);
    SDL_FreeSurface(colision);
    SDL_FreeSurface(racePic);
    SDL_FreeSurface(raceMap);
    SDL_FreeSurface(s1);
    SDL_FreeSurface(s2);
    SDL_FreeSurface(s3);
    SDL_FreeSurface(s4);
    SDL_FreeSurface(tableTop);
    SDL_FreeSurface(tableMid);
    SDL_FreeSurface(tableBot);
    SDL_FreeSurface(finish);
    SDL_FreeSurface(menus);
    SDL_FreeSurface(filter);

    if(gamePlayer[0].stat == 1)
    {
        if(rep == 0){rep = 3;}
        if(rep == 1){rep = 4;}
        if(rep == 2){rep = 5;}
    }

    return rep;
}

int pause(SDL_Surface *screen)
{
    SDL_Surface *background = NULL, *menus = NULL, *tmp = NULL, *oldscreen = NULL;;
    SDL_Rect rect, clip;

    int close = 0, prev = 0, current = 0, rep = 0, select = 0, keypass = 0;

    tmp = IMG_Load("data/sprites/background5.png");
    if(tmp == NULL)
    {
        fprintf(stderr, "Error : Can't load 'data/sprites/background5.png'\n\n");
        error();
    }
    background = SDL_DisplayFormatAlpha(tmp);

    SDL_FreeSurface(tmp);
    tmp = IMG_Load("data/sprites/menus.png");
    if(tmp == NULL)
    {
        fprintf(stderr, "Error : Can't load 'data/sprites/menus.png'\n\n");
        error();
    }
    menus = SDL_DisplayFormatAlpha(tmp);

    oldscreen = SDL_CreateRGBSurface(SDL_HWSURFACE, SCREENW, SCREENH, 32, 0, 0, 0, 0);
    SDL_BlitSurface(screen, NULL, oldscreen, NULL);

    while(!close)
    {
        current = SDL_GetTicks();
        if (current - prev > (1000/FPS))
        {
            SDL_PollEvent(&event);
            keyState = SDL_GetKeyState(NULL);

            if (event.type == SDL_QUIT){close = 1; rep = 1;}

            if(keyState[SDLK_UP] || keyState[SDLK_DOWN] || keyState[SDLK_RETURN] || keyState[SDLK_ESCAPE] || keyState[SDLK_p] || SDL_JoystickGetButton(joystick[0], 9) == 1 || SDL_JoystickGetButton(joystick[0], 0) || SDL_JoystickGetButton(joystick[0], 5) || SDL_JoystickGetAxis(joystick[0], 1) > 3200 || SDL_JoystickGetAxis(joystick[0], 1) < -3200)
            {
                if(keypass)
                {
                    keypass = 0;

                    if(keyState[SDLK_ESCAPE] || keyState[SDLK_p] || SDL_JoystickGetButton(joystick[0], 5) == 1 || SDL_JoystickGetButton(joystick[0], 9) == 1)
                    {
                        close = 1;
                        rep = 0;
                    }

                    if(keyState[SDLK_UP] || SDL_JoystickGetAxis(joystick[0], 1) < -3200)
                    {
                        if(config.sound){Mix_PlayChannel(-1, selectsound, 0);}
                        select--;
                        if(select < 0)
                        {
                            select = 2;
                        }
                    }

                    if(keyState[SDLK_DOWN] || SDL_JoystickGetAxis(joystick[0], 1) > 3200)
                    {
                        if(config.sound){Mix_PlayChannel(-1, selectsound, 0);}
                        select++;
                        if(select > 2)
                        {
                            select = 0;
                        }
                    }

                    if(keyState[SDLK_RETURN] || SDL_JoystickGetButton(joystick[0], 0) == 1)
                    {
                        if(config.sound){Mix_PlayChannel(-1, entersound, 0);}

                        if(select == 0)
                        {
                            close = 1;
                            rep = 0;
                        }
                        else if(select == 1)
                        {
                            close = 1;
                            rep = 2;
                        }
                        else if(select == 2)
                        {
                            close = 1;
                            rep = 3;
                        }
                    }
                }
            }
            else{keypass = 1;}

            if(!close)
            {
                SDL_BlitSurface(oldscreen, NULL, screen, NULL);

                SDL_BlitSurface(background, NULL, screen, NULL);

                clip.w = menus->w / 2;
                clip.h = menus->h / 14;
                rect.x = SCREENW / 2 - menus->w / 4;

                //////////////////// resume ////////////////////

                if(select == 0){clip.x = menus->w/2;}
                else{clip.x = 0;}
                clip.y = (menus->h / 14) * 5;

                rect.y = 270;
                SDL_BlitSurface(menus, &clip, screen, &rect);

                //////////////////// restart ////////////////////

                if(select == 1){clip.x = menus->w / 2;}
                else{clip.x = 0;}
                clip.y = (menus->h / 14) * 6;

                rect.y += menus->h / 14 + 15;
                SDL_BlitSurface(menus, &clip, screen, &rect);

                //////////////////// back to menu ////////////////////

                if(select == 2){clip.x = menus->w / 2;}
                else{clip.x = 0;}
                clip.y = (menus->h / 14) * 7;

                rect.y += menus->h / 14 + 15;
                SDL_BlitSurface(menus, &clip, screen, &rect);
            }

            SDL_Flip(screen);

            prev = current;
        }
        else
        {
            SDL_Delay((1000/FPS) - (current - prev));
        }
    }


    SDL_FreeSurface(background);
    SDL_FreeSurface(menus);
    SDL_FreeSurface(tmp);

    return rep;
}


int filtering(SDL_Surface *screen)
{
    SDL_Surface *filter = NULL;

    int prev = 0, current = 0, filterint = 0;

    filter = SDL_CreateRGBSurface(SDL_HWSURFACE, SCREENW, SCREENH, 32, 0, 0, 0, 0);
    SDL_FillRect(filter, NULL, SDL_MapRGB(filter->format, 255, 255, 255));

    while(filterint < 255)
    {
        current = SDL_GetTicks();
        if (current - prev > (1000/FPS))
        {
            SDL_PollEvent(&event);

            if(filterint < 255)
            {
                filterint += FILTERSTEP;
                if(filterint > 255){filterint = 255;}
            }


            SDL_SetAlpha(filter, SDL_SRCALPHA, filterint);
            SDL_BlitSurface(filter, NULL, screen, NULL);

            SDL_Flip(screen);

            prev = current;
        }
        else
        {
            SDL_Delay((1000/FPS) - (current - prev));
        }
    }

    SDL_FreeSurface(filter);

    return 0;
}

int error()
{
    save_config();
    Mix_CloseAudio();
    SDL_Quit();

    exit(EXIT_FAILURE);
}

void read_config()
{
    FILE *file;

    if((file = fopen("config.cfg","rb")) == NULL)
    {
        save_config();
        return;
    }

    fread(&config, sizeof(struct _config), 1, file);
    fclose(file);
}

int save_config()
{
    FILE *file;

    if((file = fopen("config.cfg","wb")) == NULL)
    {
        fprintf(stderr, "Error: Can't create 'config.cfg'\n\n");
        return 1;
    }

    fwrite(&config, sizeof(struct _config), 1, file);
    fclose(file);

    return 0;
}
