/*
 ______           _____            _               ____
|  ____|         |  __ \          (_)             |___ \
| |__ _   _ _ __ | |__) |__ _  ___ _ _ __   __ _    __) |
|  __| | | | '_ \|  _  // _` |/ __| | '_ \ / _` |  |__ <
| |  | |_| | | | | | \ \ (_| | (__| | | | | (_| |  ___) |
|_|   \__,_|_| |_|_|  \_\__,_|\___|_|_| |_|\__, | |____/
                                            __/ |
                                           |___/
Copyright (C) 2009 Slempkes Clment

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*/

#include <stdlib.h>
#include <stdio.h>
#include <SDL/SDL.h>
#include <SDL/SDL_mixer.h>
#include <SDL/SDL_image.h>

#include "const.h"
#include "funracing.h"

int main(int argc, char *argv[])
{
    SDL_Surface *screen = NULL;

    SDL_Init(SDL_INIT_VIDEO | SDL_INIT_JOYSTICK | SDL_INIT_AUDIO);

    Mix_OpenAudio(44100, MIX_DEFAULT_FORMAT, MIX_DEFAULT_CHANNELS, 1024);
    Mix_AllocateChannels(10);

    SDL_ShowCursor(0);

    if(SDL_NumJoysticks() == 0){fprintf(stderr, "Warning : No joysticks are available.\n\n");}

    screen = SDL_SetVideoMode(SCREENW, SCREENH, 32, SDL_HWSURFACE | SDL_DOUBLEBUF);
    SDL_WM_SetCaption("FunRacing", NULL);

    title(screen);

    Mix_CloseAudio();
    SDL_Quit();

    return EXIT_SUCCESS;
}
