
import os

class HighScores():
	
	def __init__(self):
		self.items = []
		self.load()
		
	def load(self):
		fp = open(os.path.join("data", "highscores.dat"))
		content = fp.read()
		
		player = ""
		score = ""
		readplayer = 1
		
		for i in range(0, len(content)):
			if content[i] == '\n':
				if readplayer:
					readplayer = 0
				else:
					self.add(HighScoreEntry(player, score))
					readplayer = 1
					player = ""
					score = ""
			else:
				if readplayer:
					player += content[i]
				else:
					score += content[i]
				
		fp.close()
		
	def save(self):
		fp = open(os.path.join("data", "highscores.dat"), "w")
		res = ""
		for item in self.items:
			res += item.name + "\n" + item.score + "\n"
		fp.write(res)
		fp.close()
		
	def add(self, item):
		newl = []
		inserted = 0
		if len(self.items) == 0:
			self.items = [item]
			return
		for i in self.items:
			if int(item.score) < int(i.score):
				newl.append(i)
			else:
				if not inserted:
					newl.append(item)
					inserted =1
				newl.append(i)
		if not inserted:
			newl.append(item)
		self.items = newl

class HighScoreEntry():
	
	def __init__(self, name, score):
		self.name = name
		self.score = score
