
class Menu():
	"""The class for the menu"""
	def __init__(self):
		self.submenu = None
		self.items = []
		self.selected = None
		
	def addItem(self, item):																								
		self.items.append(item)
		
	def movedown(self):
		if self.selected == None:
			self.selected = -1
		
		if self.selected < len(self.items) - 1:
			self.selected += 1
		else:
			self.selected = 0
		if self.items[self.selected].selectable == 0:
			self.movedown()
			
		
	def moveup(self):
		if self.selected == None:
			self.selected = len(self.items)
			
		if self.selected > 0:
			self.selected -= 1
		else:
			self.selected = len(self.items) - 1
		
		if self.items[self.selected].selectable == 0:
			self.moveup()
	
	def clear(self):
		del self.items
		self.items = []
	
	def mainmenu(self):
		self.clear()
		self.addItem(MenuItem("New Game", "newgame"))
		self.addItem(MenuItem("Options", "options"))
		self.addItem(MenuItem("Highscores", "scores"))
		self.addItem(MenuItem("Credits", "credits"))
		self.addItem(MenuItem("Quit", "quit"))
		self.selected = None
		self.movedown()
		
	def ingamemenu(self):
		self.clear()
		self.addItem(MenuItem("Return", "returntogame"))
		self.addItem(MenuItem("New Game", "newgame"))
		self.addItem(MenuItem("Options", "options"))
		self.addItem(MenuItem("Highscores", "scores"))
		self.addItem(MenuItem("Credits", "credits"))
		self.addItem(MenuItem("Quit", "quit"))
		self.selected = None	
		self.movedown()
		
	def creditsmenu(self):
		self.clear()
		self.addItem(MenuItem("Programming", ""))
		newm = MenuItem("Bart Spaans", "")
		newm.align = "right"
		self.addItem(newm)
		self.addItem(MenuItem("Graphics", ""))
		newm = MenuItem("Bart Spaans", "")
		newm.align = "right"
		self.addItem(newm)
		self.addItem(MenuItem("Testing", ""))
		newm = MenuItem("Vreni Posthuma", "")
		newm.align = "right"
		self.addItem(newm)
		self.addItem(MenuItem("Back", "mainmenu"))
		self.selected = None
		self.movedown()
		
	def highscoresmenu(self, highscores):
		self.clear()
		c = 0
		for score in highscores.items:
			if c < 4:
				self.addItem(MenuItem(score.name, ""))
				newm = MenuItem(score.score, "")
				newm.align = "right"
				self.addItem(newm)
			c += 1
		self.addItem(MenuItem("Back", "mainmenu"))
		self.selected = None
		

class MenuItem():
	"""Menu items"""
	def __init__(self, caption, changestate):
		self.caption = caption
		if changestate == "":
			self.selectable = 0
			self.align = "left"
		else:
			self.selectable = 1
			self.align = "center"
			self.changestate = changestate
