#!/usr/bin/env python
#
# Paratrooper
# Check the README.txt file for more information.


#test modules
try:
	import sys
	import random
	import pygame
	from pygame.locals import *

	"""Paratrooper Classess"""
	from sprites import *
	from menu import *
	from highscores import *
except ImportError, err:
	print "Paratrooper Error: ", err
	sys.exit(2)


# GLOBAL VARIABLES
# scores
HELI_SHOT = 50
PLANE_SHOT = 60
BOMB_SHOT = 90
PARA_SHOT = 75
BOSS_HIT = 30
BOSS_DEAD = 5000
TROOPER_SHOT = 25
TROOPER_DROPPED = 100


#CLASSES
class Game():
	"""The paratrooper Game class"""
	
	def __init__(self):
		
		self.highscores = HighScores()
		self.sounds = Sounds()
		self.menu = Menu()
		self.menu.mainmenu()
		
		self.fadecolor = (0,0,0)
		self.state = "mainmenu"
		self.t = 0
		self.max = 0
		self.nextstate = ""
		self.reset()
		try:
			self.player_name = os.environ["USER"]
		except KeyError:
			try:
				self.player_name = os.environ["USERNAME"]
			except KeyError:
				self.player_name = "PlayerX"
	def start(self):
		self.state = "ingame"

	def menu_down(self):
		self.menu.movedown()
		
	def menu_up(self):
		self.menu.moveup()

	def menu_select(self):
		if self.menu.selected != None:
			newstate = self.menu.items[self.menu.selected].changestate
			if newstate == "mainmenu":
				self.menu.mainmenu()
			elif newstate == "credits":
				self.menu.creditsmenu()
			elif newstate == "scores":
				self.menu.highscoresmenu(self.highscores)
			elif newstate == "newgame":
				self.max = 30
				self.nextstate = "reset"
				self.state = "fadeout_y"
			elif newstate == "returntogame":
				self.max = 30
				self.nextstate = "ingame"
				self.state = "fadein_y"
			else:
				self.state = newstate
				
	def ingamemenu(self):
		self.state = "mainmenu"
		self.menu.ingamemenu()
		
	def get_current_menu(self):
		return self.menu.items
		
	def reset(self):
		self.score = 0
		self.ups = 3
		
	def takelife(self):
		if self.ups != 1:
			self.ups -= 1
			self.state = "restartlevel"
		else:
			self.state = "gameover"



class Sounds():
	
	def __init__(self):
		self.shot = pygame.mixer.Sound(os.path.join("data", "shot1.wav"))
		self.explosion = pygame.mixer.Sound(os.path.join("data", "shot2.wav"))
		self.troopershot = pygame.mixer.Sound(os.path.join("data", "explosion.wav"))
		pygame.mixer.music.load(os.path.join("data", "track.mp3"))
		pygame.mixer.music.play()


def main(): 

	#init pygame
	pygame.init()
	pygame.font.init()
	pygame.mixer.init()
	
	screen = pygame.display.set_mode((800,600))
	area = screen.get_rect()
	pygame.display.set_caption("Paratrooper")
	
	#init paratroopers
	game = Game()
	
	#init background
	background, brect = load_img('back.png')
	stillbackground, sbrect = load_img('back.png')

	cannonbase = pygame.Surface((48,16))
	cannonbase = cannonbase.convert()
	cannonbase2 = pygame.Surface((32, 16))
	cannonbase2 = cannonbase2.convert()
	
	cbrect = cannonbase.get_rect()
	cbrect2 = cannonbase2.get_rect()
	cbrect.midbottom = area.midbottom
	cbrect2.midbottom = cbrect.midtop

	#init sprites
	cannon = Cannon()
	cannonsprite = pygame.sprite.RenderPlain(cannon)
	bulletsprites = pygame.sprite.RenderPlain()
	helisprites = pygame.sprite.RenderPlain()
	planesprites = pygame.sprite.RenderPlain()
	bombsprites = pygame.sprite.RenderPlain()
	parasprites = pygame.sprite.RenderPlain()
	troopersprites = pygame.sprite.RenderPlain()
	droppingsprites = pygame.sprite.RenderPlain()
	cloudsprites = pygame.sprite.RenderPlain()
	explosionsprites = pygame.sprite.RenderPlain()
	bosssprite = pygame.sprite.RenderPlain()

	#init fonts
	menufont_h1 = pygame.font.Font(None, 50)
	menufont_h2 = pygame.font.Font(None, 40)
	menufont_h3 = pygame.font.Font(None, 30)
	scorefont = pygame.font.Font(None, 30)

	#blit everything
	screen.blit(background, (0,0))
	screen.blit(cannonbase, cbrect)
	screen.blit(cannonbase2, cbrect2)
	
	stillbackground.blit(cannonbase, cbrect)
	stillbackground.blit(cannonbase2, cbrect2)
	cannonsprite.draw(stillbackground)
	cannonsprite.draw(screen)
	
	pygame.display.flip()

	clock = pygame.time.Clock()
	
	shoot = False 
	shoot_lock = 8 
	t = 0
	boss_defeated = False

	#the main loop
	while 1: 

		clock.tick(50)
		
		if game.state == "ingame":

			for event in pygame.event.get():
				if event.type == QUIT:
					sys.exit()
				elif event.type == KEYUP:
					if event.key == K_LEFT and cannon.state == "anticlockwise":
						cannon.halt()
					elif event.key == K_RIGHT and cannon.state == "clockwise":
						cannon.halt()
					elif event.key == K_SPACE:
						shoot = False
					elif event.key == K_UP:
						shoot = False
				elif event.type == KEYDOWN:
					if event.key == K_LEFT:
						cannon.moveAntiClockwise()
					elif event.key == K_RIGHT:
						cannon.moveClockwise()
					elif event.key == K_UP:
						shoot = True
						t= 0
					elif event.key == K_q:
						game.ingamemenu()
					elif event.key == K_a:
						shoot = True
						t= 0
					elif event.key == K_z:
						shoot = False
					elif event.key == K_SPACE:
						shoot = True
						t = 0
			if shoot and t % shoot_lock == 0:
				#shoot a bullet
				newbullet = Bullet()
				newbullet.direction = cannon.angle
				newbullet.image = pygame.transform.rotate(newbullet.image, newbullet.direction)
				newbullet.rect = newbullet.image.get_rect()
				newbullet.rect.midbottom = area.midbottom
				newbullet.rect = newbullet.rect.move((0, -24))
				game.sounds.shot.play()
				t = 0

				if game.score >= 3000:
					newbullet.direction = cannon.angle + 7
					bulletsprites.add(newbullet)
					newbullet = Bullet()
					newbullet.direction = cannon.angle -7
					newbullet.image = pygame.transform.rotate(newbullet.image, newbullet.direction)
					newbullet.rect = newbullet.image.get_rect()
					newbullet.rect.midbottom = area.midbottom
					newbullet.rect = newbullet.rect.move((0, -28))
					bulletsprites.add(newbullet)
				else:
					bulletsprites.add(newbullet)

			t += 1
						
			#HELICOPTERS			
			
			#Should there be any new Helicopters?
			if random.randrange(0, 140) == 1:
				heli = Helicopter()
				if random.randrange(0, 2) == 1:
					heli.rect.topright = screen.get_rect().topright
					heli.direction = -1
				else:
					heli.rect.topleft = area.topleft
					heli.rect = heli.rect.move((0, 50))
					heli.flipimages()
					heli.direction = 1
					
				helisprites.add(heli)
			
			#Are there any helicopters that can be removed?
			#If not; do we need any more paratroopers?
			if game.score < 6500:
				ch = 150 - (game.score / 500) * 10
			else:
				ch = 20

			para_chance = ch* len(helisprites.sprites());
			for heli in helisprites.sprites():
				if heli.rect.left > area.right and heli.direction == 1:
					helisprites.remove(heli)
				elif heli.rect.right < area.left and heli.direction == -1:
					helisprites.remove(heli)	
				elif random.randrange(0, para_chance) == 1:
					para = Parachute()
					para.rect.midtop = heli.rect.midbottom
					parasprites.add(para)
					
					trooper = Trooper()
					trooper.rect.midtop = para.rect.midbottom
					troopersprites.add(trooper)
					
					#link them together
					trooper.para = para
					para.trooper = trooper

			#AIRPLANES
			#Should there be any new Airplanes?
			if game.score < 10000:
				ch = 150 - (game.score / 750) * 10
			else:
				ch = 20
			if game.score >= 400 and random.randrange(0, ch) == 1:
				plane = Airplane()
				if random.randrange(0, 2) == 1:
					plane.rect.topright = screen.get_rect().topright
					plane.flip()
				else:
					plane.rect.topleft = area.topleft
					plane.rect = plane.rect.move((0,50))
				planesprites.add(plane)

			#Should we remove any airplanes?
			#If not, should we drop some bombs?
			#Or some paratroopers, maybe?
			for plane in planesprites.sprites():
				if plane.rect.left > area.right and plane.direction ==1:
					planesprites.remove(plane)
				elif plane.rect.right < area.left and plane.direction == -1:
					planesprites.remove(plane)
				elif plane.droppedbomb == False and game.score >= 1000:
					bomb = PlaneBomb()
					dy = area.bottom - plane.rect.bottom
					steps = dy / bomb.speed
					borderx = steps * plane.speed
					bomb.rect.midtop = plane.rect.midbottom

					if plane.direction == 1 and plane.rect.centerx > area.centerx - borderx:
						bomb.dy = plane.speed
						bombsprites.add(bomb)
						plane.droppedbomb = True
					elif plane.direction ==-1 and plane.rect.centerx < area.centerx + borderx:
						bomb.dy = plane.speed * -1
						bombsprites.add(bomb)
						plane.droppedbomb = True
				elif ((plane.drop_troopers and plane.troopers) != 0 and plane.trooperlock == 0) and game.score >= 2000:
					plane.troopers -= 1
					plane.trooperlock = 3
					#new trooper
					para = Parachute()
					para.rect.midtop = plane.rect.midbottom
					parasprites.add(para)
					
					trooper = Trooper()
					trooper.rect.midtop = para.rect.midbottom
					troopersprites.add(trooper)
					
					#link them together
					trooper.para = para
					para.trooper = trooper
				if plane.trooperlock > 0:
					plane.trooperlock -= 1

			#THE BOSS
			# is it time for him to appear?
			if game.score >= 10000 and len(bosssprite.sprites()) == 0 and not boss_defeated:
					boss = Boss(area)
					boss.rect.topright = area.topright
					bosssprite.add(boss)

			# is it time for him to disappear?
			# or should he drop a bomb?
			for boss in bosssprite.sprites():
				if boss.hits == 0:
					screen.blit(background, boss.rect, boss.rect)
					bosssprite.remove(boss)
					expl = Explosion(boss.rect)
					explosionsprites.add(expl)
					game.score += BOSS_DEAD
					boss_defeated = True
				boss.t += 1
				if boss.t == boss.shoot_speed:
					boss.t = 0;
					bomb = PlaneBomb()
					dy = area.bottom - boss.rect.bottom
					steps = dy / bomb.speed
					borderx = steps * boss.speed
					bomb.rect.midtop = boss.rect.midbottom

					if boss.direction == 1 and boss.rect.centerx > area.centerx - borderx:
						bomb.dy = boss.speed
						bombsprites.add(bomb)
					elif boss.direction ==-1 and boss.rect.centerx < area.centerx + borderx:
						bomb.dy = boss.speed * -1
						bombsprites.add(bomb)


			#BOMBS
			#Should we remove any?
			for bomb in bombsprites.sprites():
				if bomb.rect.bottom > area.bottom:
					screen.blit(background, bomb.rect, bomb.rect)
					bombsprites.remove(bomb)
					bomb.rect.bottom = area.bottom
					expl = Explosion(bomb.rect)
					explosionsprites.add(expl)

			#PARATROOPERS
			#Should we remove any parachutes
			for para in parasprites.sprites():
				if para.removePlease:
					screen.blit(background, para.rect, para.rect)
					parasprites.remove(para)
			
			
			# BULLETS
			# Shoulld we remove any bullets?
			for bullet in bulletsprites.sprites():
				if bullet.rect.bottom < area.top or bullet.rect.right < area.left or bullet.rect.left > area.right:
					bulletsprites.remove(bullet)
					
			
			# CLOUDS
			# Should we remove any clouds
			# or should we create some?
			for cloud in cloudsprites.sprites():
				if (cloud.rect.right < area.left and cloud.direction == -1) or (cloud.rect.left > area.right and cloud.direction == 1):
					cloudsprites.remove(cloud)
				
			if random.randrange(0, 100) == 1:
				cloud = Cloud()
			
				f = random.randrange(4, 8) / 6.0
				cloud.image = pygame.transform.scale(cloud.image, (int(cloud.rect.width * f) , int(cloud.rect.height * f)))
				cloud.rect = cloud.image.get_rect()
				
				if random.randrange(0,2) == 1:
					cloud.direction = -1
					cloud.rect.topleft = area.topright
				else:
					cloud.direction = 1
					cloud.rect.topright = area.topleft
				
				cloud.image = pygame.transform.flip(cloud.image, random.randrange(0, 2) -1, random.randrange(0, 2) -1)
				cloud.rect = cloud.rect.move((0, random.randrange(-50, 150)))
				
				cloudsprites.add(cloud)
			
			#COLLISIONS
			# Are their any helis hit?
			heli_killed_dict = pygame.sprite.groupcollide(bulletsprites, helisprites, 1, 1)
			for bullet in heli_killed_dict:
				screen.blit(background, bullet.rect, bullet.rect)
				for heli in heli_killed_dict[bullet]:
					screen.blit(background, heli.rect, heli.rect)
					explosion = Explosion(heli.rect)
					explosionsprites.add(explosion)
					game.score += HELI_SHOT
					game.sounds.explosion.play()
			# Any planes?
			plane_killed_dict = pygame.sprite.groupcollide(bulletsprites, planesprites, 1, 1)
			for bullet in plane_killed_dict:
				screen.blit(background, bullet.rect, bullet.rect)
				for plane in plane_killed_dict[bullet]:
					screen.blit(background, plane.rect, plane.rect)
					explosion = Explosion(plane.rect)
					explosionsprites.add(explosion)
					game.score += PLANE_SHOT
					game.sounds.explosion.play()
					
			# Any troopers got killed?
			trooper_killed_dict = pygame.sprite.groupcollide(bulletsprites, troopersprites, 1, 1)
			for bullet in trooper_killed_dict:
				screen.blit(background, bullet.rect, bullet.rect)
				for trooper in trooper_killed_dict[bullet]:
					screen.blit(background, trooper.rect,trooper.rect)
					screen.blit(background, trooper.para.rect, trooper.para.rect)
					parasprites.remove(trooper.para)
					game.sounds.troopershot.play()
					game.score += TROOPER_SHOT
			
			# Did you hit a bomb?
			bomb_hit_dict = pygame.sprite.groupcollide(bulletsprites, bombsprites, 1, 1)
			for bullet in bomb_hit_dict:
				screen.blit(background, bullet.rect, bullet.rect)
				for bomb in bomb_hit_dict[bullet]:
					screen.blit(background, bomb.rect, bomb.rect)
					explosion = Explosion(bomb.rect)
					explosionsprites.add(explosion)
					game.score += BOMB_SHOT
					game.sounds.explosion.play()

			# The boss?
			boss_hit_dict = pygame.sprite.groupcollide(bulletsprites, bosssprite, 1, 0)
			for bullet in boss_hit_dict:
				screen.blit(background, bullet.rect, bullet.rect);
				for boss in boss_hit_dict[bullet]:
					screen.blit(background, boss.rect, boss.rect)
					boss.hits -= 1
					explosion = Explosion(boss.rect)
					explosionsprites.add(explosion)
					game.score += BOSS_HIT
					game.sounds.explosion.play()


			# Did a bomb hit the cannon?
			cannon_hit_dict = pygame.sprite.groupcollide(bombsprites, cannonsprite, 1, 0)
			for bomb in cannon_hit_dict:
				screen.blit(background, bomb.rect, bomb.rect)
				for cannon in cannon_hit_dict[bomb]:
					screen.blit(background, cannon.rect, cannon.rect)
					explosionsprites.add(Explosion(cannon.rect))
					explosionsprites.add(Explosion(cannon.rect.move(random.randrange(-50, 50), random.randrange(-50,50))))
					explosionsprites.add(Explosion(cannon.rect.move(random.randrange(-50, 50), random.randrange(-50,50))))
					explosionsprites.add(Explosion(cannon.rect.move(random.randrange(-50, 50), random.randrange(-50,50))))
					game.sounds.explosion.play()
					game.takelife()

			# Did a bullet hit a parachute?
			para_hit_dict = pygame.sprite.groupcollide(bulletsprites, parasprites, 1, 1)
			for bullet in para_hit_dict:
				screen.blit(background, bullet.rect, bullet.rect)
				for para in para_hit_dict[bullet]:
					screen.blit(background, para.rect, para.rect)
					para.trooper.speed *= 2
					para.trooper.dropping = 1
					droppingsprites.add(para.trooper)
					game.score += PARA_SHOT
	
			# Did a dropping trooper crush another trooper?
			hit_trooper = pygame.sprite.groupcollide(droppingsprites, troopersprites, 0, 0)
			for trooper in hit_trooper:
				for hittrooper in hit_trooper[trooper]:
					if trooper != hittrooper:
						droppingsprites.remove(trooper)
						troopersprites.remove(hittrooper)
						screen.blit(background, trooper.rect, trooper.rect)
						screen.blit(background, hittrooper.rect, hittrooper.rect)
						game.sounds.troopershot.play()
						game.score += TROOPER_DROPPED
				
			# Did a dropping trooper drop dead?
			for trooper in droppingsprites.sprites():
				if trooper.falling == 0:
					droppingsprites.remove(trooper)
					troopersprites.remove(trooper)
					screen.blit(background, trooper.rect, trooper.rect)


			#TROOPERS
			# Can a trooper climb or walk?
			climbers_l = []
			climbers_r = []
			climbers_l2 = []
			climbers_r2 = []
			walk_l1 = []
			walk_l2 = []
			walk_r1 = []
			walk_r2 = []
			
			for trooper in troopersprites.sprites():
				if trooper.stopped:
					
					#climb
					if trooper.rect.right == area.centerx - 24:
						climbers_r.append(trooper)
						if len(climbers_r) > 1:
							trooper.climb = 1
					elif trooper.rect.left == area.centerx + 24:
						climbers_l.append(trooper)
						if len(climbers_l) > 1:
							trooper.climb = 1
							
					#climb2
					elif trooper.rect.right == area.centerx - 16:
						climbers_r2.append(trooper)
						if len(climbers_r2) > 1:
							trooper.climb2 = 1
					elif trooper.rect.left == area.centerx + 16:
						climbers_l2.append(trooper)
						if len(climbers_l2) > 1:
							trooper.climb2 = 1
							
					#walk1
					if trooper.rect.right == area.centerx - 32:
						walk_l1.append(trooper)
						if len(walk_l1) > 1:
							trooper.walk1 = 1
							trooper.stopped = 0
					elif trooper.rect.left == area.centerx + 32:
						walk_r1.append(trooper)
						if len(walk_r1) > 1:
							trooper.walk1 = 1
							trooper.stopped = 0
							
					#walk2
					elif trooper.rect.left > area.centerx + 16 and trooper.rect.bottom == area.bottom - 15:
						walk_r2.append(trooper)
						if len(walk_r2) > 1:
							trooper.walk2 = 1
							trooper.stopped = 0
					elif trooper.rect.right < area.centerx - 16 and trooper.rect.bottom == area.bottom - 15:
						walk_l2.append(trooper)
						if len(walk_l2) > 1:
							trooper.walk2 = 1
							trooper.stopped = 0
					
					# did any trooper reach the cannon?
					elif trooper.rect.bottom == area.bottom - 31:
						if trooper.rect.left > area.centerx - 12 and trooper.rect.right < area.centerx + 12:
							explosionsprites.add(Explosion(trooper.rect))
							explosionsprites.add(Explosion(trooper.rect.move(random.randrange(-50, 50), random.randrange(-50,50))))
							explosionsprites.add(Explosion(trooper.rect.move(random.randrange(-50, 50), random.randrange(-50,50))))
							explosionsprites.add(Explosion(trooper.rect.move(random.randrange(-50, 50), random.randrange(-50,50))))
							game.takelife()
							game.sounds.explosion.play()
							
					
			# Showing score on the screen
			s1 = "Score: " + str(game.score)
			s2 = "Cannons: " + str(game.ups)
			stext1 = scorefont.render(s1, 1, (0,0,0))
			stext2 = scorefont.render(s2, 1, (0,0,0))
	
			screen.blit(background, cannon.rect, cannon.rect)
			for bullet in bulletsprites.sprites():
				screen.blit(background, bullet.rect, bullet.rect)
			for heli in helisprites.sprites():
				screen.blit(background, heli.rect, heli.rect)
			for plane in planesprites.sprites():
				screen.blit(background, plane.rect, plane.rect)
			for bomb in bombsprites.sprites():
				screen.blit(background, bomb.rect, bomb.rect)
			for para in parasprites.sprites():
				screen.blit(background, para.rect, para.rect)
			for trooper in troopersprites.sprites():
				screen.blit(background, trooper.rect, trooper.rect)
			for cloud in cloudsprites.sprites():
				screen.blit(background, cloud.rect, cloud.rect)
			for boss in bosssprite.sprites():
				screen.blit(background, boss.rect, boss.rect)
			for expl in explosionsprites.sprites():
				screen.blit(background, expl.rect, expl.rect)
				if expl.state == 5:
					explosionsprites.remove(expl)
			screen.blit(background, stext1.get_rect().move(100, 300), stext1.get_rect().move(100, 300))
			screen.blit(background, stext2.get_rect().move(100, 340), stext2.get_rect().move(100, 340))
			
			screen.blit(cannonbase, cbrect)
			screen.blit(cannonbase2, cbrect2)

			cannonsprite.update()
			bulletsprites.update()
			helisprites.update()
			planesprites.update()
			bosssprite.update()
			bombsprites.update()
			parasprites.update()
			troopersprites.update()
			cloudsprites.update()
			explosionsprites.update()
		
			cloudsprites.draw(screen)
			cannonsprite.draw(screen)
			bulletsprites.draw(screen)
			helisprites.draw(screen)
			planesprites.draw(screen)
			bosssprite.draw(screen)
			bombsprites.draw(screen)
			parasprites.draw(screen)
			troopersprites.draw(screen)
			explosionsprites.draw(screen)
			
			screen.blit(stext1, stext1.get_rect().move(100, 300))
			screen.blit(stext2, stext2.get_rect().move(100, 340))

		# MAIN MENU
		elif game.state == "mainmenu":
			
			for event in pygame.event.get():
				if event.type == QUIT:
					sys.exit()
				elif event.type == KEYDOWN:
					if event.key == K_UP:
						game.menu_up()
					elif event.key == K_DOWN:
						game.menu_down()
					elif event.key == K_q:
						sys.exit()
					elif event.key == K_RETURN:
						game.menu_select()
			
			screen.blit(background, (0, 100), (0, 100, 800, 400))
				
			# CLOUDS
			# Should we remove any clouds
			# or should we create some?
			for cloud in cloudsprites.sprites():
				if (cloud.rect.right < area.left and cloud.direction == -1) or (cloud.rect.left > area.right and cloud.direction == 1):
					cloudsprites.remove(cloud)
			
			if random.randrange(0, 50) == 1:
				cloud = Cloud()
				
				f = random.randrange(4, 8) / 6.0
				cloud.image = pygame.transform.scale(cloud.image, (int(cloud.rect.width * f) , int(cloud.rect.height * f)))
				cloud.rect = cloud.image.get_rect()
				
				if random.randrange(0,2) == 1:
					cloud.direction = -1
					cloud.rect.topleft = area.topright
				else:	
					cloud.direction = 1
					cloud.rect.topright = area.topleft
			
				cloud.image = pygame.transform.flip(cloud.image, random.randrange(0, 2) -1, random.randrange(0, 2) -1)
				cloud.speed = random.randrange(1, 4)
				cloud.rect = cloud.rect.move((0, random.randrange(-50, 150)))
			
				cloudsprites.add(cloud)
			
			
			for cloud in cloudsprites.sprites():
				screen.blit(background, cloud.rect, cloud.rect)
			
			#blit everything
			cloudsprites.update()
			cloudsprites.draw(screen)
			
			#blit menu
			menuitems = game.get_current_menu()
			selected = game.menu.selected
			for i in range(0, len(menuitems)):
				cur = menuitems[i]
				if i != selected:
					color = (0,0,0)
				else:
					color = (200, 0, 0)

				if cur.align == "center":
					text = menufont_h1.render(cur.caption, 1, color)
				elif cur.align == "left":
					text = menufont_h2.render(cur.caption, 1, color)
				else:
					text = menufont_h3.render(cur.caption, 1, color)

					
				trect = text.get_rect()
				trect = trect.move((0, (300 / len(menuitems)) * i + 100))
				
				#alignment
				if menuitems[i].align == "center":
					trect.centerx = area.centerx
				elif menuitems[i].align == "left":
					trect.left = area.left + 80
				else:
					trect.right = area.right - 80
				screen.blit(text, trect)
			
		
		elif game.state == "fadeout_y":
	
			dy = area.height / game.max + 1
			if game.t < game.max:
				surf = pygame.Surface((area.width, dy))
				surf.fill(game.fadecolor)
				screen.blit(surf, (0, dy * game.t ))
				game.t += 1
			else:
				game.state = "fadein_y"
				game.t = 0
	
		elif game.state == "fadein_y":
			dy = area.height / game.max + 1
			if game.t < game.max:
				rect = pygame.Rect((0, 0, area.width, dy))
				rect = rect.move((0, game.t*dy))
				screen.blit(stillbackground, rect, rect)
				game.t += 1
				explosionsprites.update()
				explosionsprites.draw(screen)
			else:
				screen.blit(background, (0,0))
				game.state = game.nextstate
				game.nextstate = ""
				game.t = 0

		elif game.state == "gameover":
			game.highscores.add(HighScoreEntry(game.player_name, str(game.score)));
			game.menu.highscoresmenu(game.highscores);
			game.highscores.save();

			print game.player_name + " died with a score of " + str(game.score)
			
			game.nextstate = "mainmenu";
			game.state="fadein_y";
		
		elif game.state == "restartlevel":
			bulletsprites.empty()
			parasprites.empty()
			planesprites.empty()
			bombsprites.empty()
			troopersprites.empty()
			droppingsprites.empty()
			helisprites.empty()
			bosssprite.empty()
			game.state = "fadein_y"
			game.nextstate="ingame"

		elif game.state == "reset":
			
			bulletsprites.empty()
			parasprites.empty()
			planesprites.empty()
			bombsprites.empty()
			troopersprites.empty()
			droppingsprites.empty()
			helisprites.empty()
			bosssprite.empty()
			game.reset()
			game.state = "ingame"

	
		elif game.state == "quit":
			sys.exit(0)
		
		elif game.state == "options":
			print "Options menu not yet implemented";
			game.state = "mainmenu";

		else:
			print "Error: unknown game state: ", game.state
			sys.exit(2)

		pygame.display.flip()

if __name__ == '__main__': main()
