"""All the sprite classes used in Paratrooper"""
import pygame
import os
import random
import math

# GLOBAL FUNCTIONS
def load_img(name):
	"""Load image and return an image object"""

	fullname = os.path.join("data", name)
	try:
		image = pygame.image.load(fullname)
		if image.get_alpha() is None:
			image= image.convert()
		else:
			image = image.convert_alpha()
	except pygame.error, message:
		print "Error: couldn't load image: ", fullname
		raise SystemExit, message
	return image, image.get_rect()


class Cannon(pygame.sprite.Sprite):
	"""The cannon best known for shooting
	Returns: Cannon object
	Functions: update, moveClockwise, moveAntiClockwise"""

	def __init__(self):

		#init sprite
		pygame.sprite.Sprite.__init__(self)
		self.base, self.rect = load_img('cannon.png')
	
		self.image = self.base
		screen = pygame.display.get_surface()
		self.area = screen.get_rect()
		self.reinit()
		
	def reinit(self):
		self.state = "still"
		self.angle = 180
		self.speed = 3 
		self.rect.midbottom = self.area.midbottom
		self.rect = self.rect.move((0, -16))
		
	def update(self):
		rotated = pygame.transform.rotate(self.base, self.angle)
		self.rect = rotated.get_rect()
		self.rect.midbottom = self.area.midbottom
		self.rect = self.rect.move((0, -16))
		self.image = rotated
		if self.state == "clockwise":
			self.moveClockwise()
		elif self.state == "anticlockwise":
			self.moveAntiClockwise()
	
	def moveClockwise(self):
		if self.angle - self.speed > 125:
			self.angle -= self.speed
			self.state = "clockwise"
		else:
			self.angle = 125
			self.state = "still"

	def moveAntiClockwise(self):
		if self.angle + self.speed < 235:
			self.angle += self.speed
			self.state = "anticlockwise"
		else:
			self.angle = 235
			self.state = "still"

	def halt(self):
		self.state = "still"

class Bullet(pygame.sprite.Sprite):
	"""The bullets being shot from the canon"""

	def __init__(self):
		
		#init sprite
		pygame.sprite.Sprite.__init__(self)

		self.image, self.rect = load_img('bullet.png')
		self.speed = 15
		self.movepos = (0,0)
			
	def update(self):
		rad = self.direction * (math.pi / 180)
		dx, dy = self.speed * math.sin(rad), self.speed * math.cos(rad)
		self.rect = self.rect.move((dx, dy))

class Boss(pygame.sprite.Sprite):

	def __init__(self, area):

		pygame.sprite.Sprite.__init__(self);
		self.image, self.rect = load_img("boss.png");
		self.direction = 1;
		self.dy = random.randrange(1,2)
		self.speed = 10
		self.hits =25
		self.area = area;
		self.t = 0
		self.shoot_speed = 15;
	
	def update(self):
		if self.direction == 1:
			if self.rect.left > self.area.width:
				self.direction = -1;
		else:
			if self.rect.right < 0:
				self.direction = 1;
		if self.dy < 0 and self.rect.bottom < 0:
			self.dy *= -1
		if self.dy > 0 and self.rect.bottom > 200:
			self.dy *= -1

		self.rect = self.rect.move((self.speed * self.direction, self.dy))

class Airplane(pygame.sprite.Sprite):
	"""Airplane class"""

	def __init__(self):

		#init sprite
		pygame.sprite.Sprite.__init__(self)
		self.image, self.rect = load_img("plane.png");
		self.direction = 1;
		self.flip()
		self.direction = 1;
		self.dy = random.randrange(1,2)
		self.speed = random.randrange(6, 12)
		self.droppedbomb = False
		if random.randrange(0,3) == 1:
			self.drop_troopers = True
		else:
			self.drop_troopers = False
		self.troopers = random.randrange(4,8)
		self.trooperlock = 25	
		
	
	def update(self):
		self.rect = self.rect.move((self.speed * self.direction, self.dy))
	
	def flip(self):
		self.image = pygame.transform.flip(self.image, 1, 0)
		self.direction *= -1;

class PlaneBomb(pygame.sprite.Sprite):

	def __init__(self):

		pygame.sprite.Sprite.__init__(self)
		self.image, self.rect = load_img("bomb.gif")
		self.speed = 9
		self.dy = 0
	
	def update(self):
		self.rect = self.rect.move((self.dy, self.speed))

class Helicopter(pygame.sprite.Sprite):
	"""Helicopter class"""
	
	def __init__(self):
		
		#init sprite
		pygame.sprite.Sprite.__init__(self)
		
		images = []
		im, rect = load_img('heli1.png')
		im2, rect = load_img('heli2.png')
		images.append(im)
		images.append(im2)
		
		self.images = images
		self.rect = rect
		self.state = 0
		self.speed = random.randrange(2,10)
		self.direction = 1
		self.setimage()
	
	def setimage(self):
		self.image = self.images[self.state]
		if self.state < len(self.images) - 1:
			self.state += 1
		else:
			self.state = 0
	
	def update(self):
		dx = self.speed * self.direction
		self.rect = self.rect.move((dx, 0))
		self.setimage()
	
	def flipimages(self):
		newim = []
		for im in self.images:
			newim.append(pygame.transform.flip(im, 1,0))
		self.images = newim
		self.setimage()
	
class Parachute(pygame.sprite.Sprite):
	"""Parachute class"""
	
	def __init__(self):
		
		#init Sprite class
		pygame.sprite.Sprite.__init__(self)
		
		self.image, self.rect = load_img('para.png')
		self.speed = 2
		self.removePlease = 0
		screen = pygame.display.get_surface()
		self.area = screen.get_rect()
		
	def update(self):
		if self.rect.bottom + self.speed + 35 < self.area.bottom:
			self.rect = self.rect.move((0, self.speed))
		else:
			self.removePlease = 1
		
class Trooper(pygame.sprite.Sprite):
	"""The paratrooper class"""
	
	def __init__(self):
		
		#init Sprite class
		pygame.sprite.Sprite.__init__(self)
		self.image, self.rect= load_img('manfalling.png')
		self.speed = 2
		screen = pygame.display.get_surface()
		self.area = screen.get_rect()
		
		#Trooper states
		self.stopped = 0
		self.falling = 1
		self.climb = 0
		self.climb2 = 0
		self.walk1 =0 
		self.walk2 = 0
		self.walk3 = 0
		self.explode = 0
		
		
	def stand(self, bottom = None):
		
		self.image, rect = load_img('manground.png')
		if bottom == None:
			bottom = self.area.bottom
		self.rect.bottom = bottom
		self.falling = 0 
		self.speed = 1
		
	def update(self):
		
		#Falling trooper
		if self.falling:
			if self.rect.bottom + self.speed < self.area.bottom:
				if self.rect.right > self.area.centerx - 28 and self.rect.left < self.area.centerx + 28:
					if self.rect.right < self.area.centerx - self.rect.height + 1:
						if self.rect.bottom + self.speed < self.area.bottom - 16:
							self.rect = self.rect.move((0, self.speed))
						else:
							self.stand(self.area.bottom- self.rect.height + 1)
					elif self.rect.left > self.area.centerx + 16:
						if self.rect.bottom + self.speed < self.area.bottom - 16:
							self.rect = self.rect.move((0, self.speed))
						else:
							self.stand(self.area.bottom - self.rect.height + 1)
							self.walk2 = 1
							self.stopped = 0
					else:
						if self.rect.bottom + self.speed < self.area.bottom - 31:
							self.rect = self.rect.move((0, self.speed))	
						else:
							self.stand(self.area.bottom - 31)
							self.walk3 = 1
							self.stopped = 0
				else:
					self.rect = self.rect.move((0, self.speed))
			else:
				self.stand()
		#Walking / standing trooper
		else:
			if not self.stopped: 
				if self.rect.bottom == self.area.bottom:
				
					if not self.walk1:
						if self.rect.right < self.area.centerx - 32:
							if self.rect.right + self.speed < self.area.centerx - 32:
								self.rect = self.rect.move((self.speed, 0))
							else:
								self.rect.right = self.area.centerx - 32
								self.stopped = 1
						elif self.rect.left > self.area.centerx + 32:
							if self.rect.left - self.speed > self.area.centerx + 32:
								self.rect = self.rect.move((-1 * self.speed, 0))
							else:
								self.rect.left = self.area.centerx + 32
								self.stopped = 1
						else:
							pass
					else:
						#WALK 1
						if self.rect.right < self.area.centerx:
							if self.rect.right + self.speed < self.area.centerx - 24:
								self.rect = self.rect.move((self.speed, 0))
							else:
								self.rect.right = self.area.centerx - 24
								self.walk1 = 0
								self.stopped = 1
						else:
							if self.rect.left - self.speed > self.area.centerx + 24:
								self.rect = self.rect.move((-1 * self.speed, 0))
							else:
								self.rect.left = self.area.centerx + 24
								self.walk1 = 0
								self.stopped = 1
							
				elif self.rect.bottom == self.area.bottom - self.rect.height + 1:
					#WALK2
					if self.walk2:
						if self.rect.right < self.area.centerx - (self.rect.width * 2):
							if self.rect.right + self.speed < self.area.centerx - (self.rect.width * 2):
								self.rect = self.rect.move((self.speed, 0))
							else:
								self.rect.right = self.area.centerx - (self.rect.width * 2)
								self.walk2 = 0
								self.stopped = 1
						elif self.rect.left > self.area.centerx + (self.rect.width * 2):
							if self.rect.left - self.speed > self.area.centerx + (self.rect.width * 2):
								self.rect = self.rect.move((-1 * self.speed, 0))
							else:
								self.rect.left = self.area.centerx+(self.rect.width * 2)
								self.walk2 = 0
								self.stopped = 1
				elif self.rect.bottom == self.area.bottom - (self.rect.height * 2) + 1:
					if self.walk3:
						if self.rect.right + self.speed < self.area.centerx:
							self.rect = self.rect.move((self.speed, 0))
						elif self.rect.left - self.speed > self.area.centerx:
							self.rect = self.rect.move((-1 * self.speed, 0))
						else:
							self.explode = 1
							self.walk3 =0
							self.stopped = 1
							
			else:
				#CLIMB
				if self.climb:
					if self.rect.top - self.speed > self.area.bottom - 32:
						self.rect = self.rect.move((0, (-1 * self.speed)))
					else:
						self.climb = 0
						self.stopped = 1
				#CLIMB2
				elif self.climb2:
					if self.rect.top - self.speed > self.area.bottom - 48:
						self.rect = self.rect.move((0, (-1 * self.speed)))
					else:
						self.climb2 = 0
						self.walk3 = 1
						self.stopped = 0
						
class Cloud(pygame.sprite.Sprite):
	"""Simple Cloud class"""
	
	def __init__(self):
		
		#init sprite class
		pygame.sprite.Sprite.__init__(self)
		
		self.image, self.rect = load_img("cloud.png")
		self.speed = 1
		self.direction = 1
		
	def update(self):
		self.rect = self.rect.move((self.speed * self.direction, 0))


class Explosion(pygame.sprite.Sprite):
	
	def __init__(self, moveto):
		
		#init Sprite class
		pygame.sprite.Sprite.__init__(self)
		
		im = []
		im0, rect = load_img("fireball0.gif")
		im1, rect = load_img("fireball1.gif")
		im2, rect = load_img("fireball2.gif")
		im.append(im0)
		im.append(im1)
		im.append(im2)
		im.append(im2)
		im.append(im1)
		im.append(im0)
		
		self.state = 0
		self.images = im
		self.rect = rect.move((moveto.left, moveto.top))
		self.set_image()
		
	def set_image(self):
		self.image = self.images[self.state]
		if self.state < len(self.images) - 1:
			self.state += 1
			
	def update(self):
		self.set_image()
			
