#! /usr/bin/env python

# camera.py - part of PyMGL
# Started February 05, 2008
# Contributors:
# -- PyMike (pymike93@gmail.com)
# -- Andy Sommerville (aksommerville@gmail.com)

import pygame
from pygame.locals import *

def Rect(actor, camera):
    r = pygame.Rect(actor.rect.x - camera.rect.x, actor.rect.y - camera.rect.y,
            actor.rect.width, actor.rect.height)
    return r


class Camera(object):

    def __init__(self, surface, world_size, sprite=None, clamp=True):
	self.rect=surface.get_rect()
	self._world_size=world_size
	self._sprite=sprite
	self._destsurface=surface
	self._bgimgs=[]
	self._fgscroll=[0,0]
	self._destpos = [0,0]
	self._clamp = clamp
	self._moving = False
	self._speed = 10

    def MoveTo(self, pos, speed=10):
        self._destpos = pos
        self._speed = speed

    def Moving(self):
        return self._moving

    def update(self):
	if self._sprite:
            if self._sprite.rect.centerx > self.rect.centerx + 50:
                self.rect.centerx = self._sprite.rect.centerx - 50
            if self._sprite.rect.centerx < self.rect.centerx - 50:
                self.rect.centerx = self._sprite.rect.centerx + 50
            if self._sprite.rect.centery > self.rect.centery + 50:
                self.rect.centery = self._sprite.rect.centery - 50
            if self._sprite.rect.centery < self.rect.centery - 50:
                self.rect.centery = self._sprite.rect.centery + 50
        else:
            self.rect.topleft=self._fgscroll
            if self._destpos[0] > self._fgscroll[0]: self._fgscroll[0]+=self._speed; self._moving=True
            elif self._destpos[0] < self._fgscroll[0]: self._fgscroll[0]-=self._speed; self._moving=True
            elif self._destpos[1] > self._fgscroll[1]: self._fgscroll[1]+=self._speed; self._moving=True
            elif self._destpos[1] < self._fgscroll[1]: self._fgscroll[1]-=self._speed; self._moving=True
            else: self._moving=False
        if self._clamp:
            if self.rect.top < 0:
                self.rect.top = 0
            elif self.rect.bottom > self._world_size[1]:
                self.rect.bottom = self._world_size[1]
            if self.rect.left < 0:
                self.rect.left = 0
            elif self.rect.right > self._world_size[0]:
                self.rect.right = self._world_size[0]


