#! /usr/bin/env python

import pygame
from pygame.locals import *
import camera as cam

class DrawGroup(pygame.sprite.Group):
    def __init__(self):
        pygame.sprite.Group.__init__(self)
        self.screen = pygame.display.get_surface()
        self.rect = self.screen.get_rect()
    def draw(self, surface, camera=None):
        spritedict = self.spritedict
        surface_blit = surface.blit
        dirty = self.lostsprites
        self.lostsprites = []
        dirty_append = dirty.append
        for s in self.sprites():
            if camera is not None:
                xo = 0
                yo = 0
                if hasattr(s, "xoffset"):
                    xo = s.xoffset
                if hasattr(s, "yoffset"):
                    yo = s.yoffset
                r = cam.Rect(s, camera)
                r[0] += xo
                r[1] += yo
                if r.colliderect(self.rect):
                    surface_blit(s.image, r)
            else:
                xo = 0
                yo = 0
                if hasattr(s, "xoffset"):
                    xo = s.xoffset
                elif hasattr(s, "yoffset"):
                    yo = s.yoffset
                else:
                    if r.colliderect(self.rect):
                        surface_blit(s.image, (s.rect[0]+xo, s.rect[1]+yo))
    def update(self, camera=None):
        if camera:
            for s in self.sprites():
                r = cam.Rect(s, camera)
                if r.colliderect(self.rect):
                    s.update()
        else:
            for s in self.sprites():
                s.update()            
