# -*- coding: utf-8 -*-

import pygame, os, random
from pygame.locals import *
from util import *
from objects import *
import math

class WalkingEnemy(pygame.sprite.Sprite):
	
	def __init__(self, type, pos, direction):

                pygame.sprite.Sprite.__init__(self, self.containers)

		# Loading enemy frames
		self.left_n_images = []
		for i in range(1,5): 
			self.left_n_images.append(loadpng(type+"-r"+str(i)+".png"))
		
		self.right_n_images = []
		for img in self.left_n_images:
			self.right_n_images.append(pygame.transform.flip(img, 1, 0))
		
		self.left_d_images = []
		for i in range(1,5):
			self.left_d_images.append(loadpng(type+"-d"+str(i)+".png"))
		
		self.right_d_images = []
		for img in self.left_d_images:
			self.right_d_images.append(pygame.transform.flip(img, 1, 0))

		self.hit_images = [loadpng(type+"-h1.png"), pygame.transform.flip(loadpng(type+"-h1.png"), 1, 0)]

		if (direction > 0): self.image = self.right_n_images[0]
		else: self.image = self.left_n_images[0]
			
		self.rect = Rect(0, 0, 24, 32)
		self.rect.topleft = pos
		self.rect.move_ip(0, -8)
		self._rect = Rect(self.rect)
		self.cr = Rect(self.rect[0], self.rect[1]+8, 24, 24)
		self.yoffset = -2
		self.xoffset = -4
		
		self.hp = 2
		self.direction = direction
		self.jump_speed = 0
		self.fall_speed = 0.5
		self.max_speed  = 10
		self.jumping = False
		self.accel = 0.5
		self.speed = random.choice([2, -2])
		self.max_mspeed = 5
		self.frame = 0
		self.animdelay  = 4
		self.facing = 1
		self.death_frame=0
		self.hurt=False
		self.hurt_delay = 0
		self.s = self.speed
		self.screenrect = Rect(0, 0, 500, 400)
		
	def hit(self, damage):
		if (self.hp > 0) and (not self.hurt):
			self.hp -= damage
			self.hurt=True
			self.hurt_delay = 5

	def inbounds(self, camera):
                if self.screenrect.colliderect(Rel_Rect(self, camera)):
                        return True

	def move(self):
		if (self.hp > 0):
                        self.rect.move_ip(self.speed, 0)
	
	def update(self):
		self._rect = Rect(self.rect)
		self.frame += 1

		if (self.hp > 0):
			if self.speed > 0:
				self.image = self.right_n_images[self.frame/self.animdelay%len(self.right_n_images)]
			elif self.speed < 0:
				self.image = self.left_n_images[self.frame/self.animdelay%len(self.left_n_images)]
		
		if self.hurt:
			if self.speed > 0: self.image = self.hit_images[1]
			else: self.image = self.hit_images[0]
			self.hurt_delay -= 1
			if (self.hurt_delay <= 0): self.hurt=False
				
		if (self.hp <= 0):
			if (0 < self.death_frame <= 3):
				if self.speed > 0: self.image = self.right_d_images[0]
				else: self.image = self.left_d_images[0]
			elif (3 < self.death_frame <= 6):
				if self.speed > 0: self.image = self.right_d_images[1]
				else: self.image = self.left_d_images[1]
			elif (6 < self.death_frame <= 9):
				if self.speed > 0: self.image = self.right_d_images[2]
				else: self.image = self.left_d_images[2]
			elif (9 < self.death_frame <= 12):
				if self.speed > 0: self.image = self.right_d_images[3]
				else: self.image = self.left_d_images[3]
			elif (self.death_frame>=12):
				self.kill()
			self.death_frame += 1
			
		if self.rect.left <= 0:
			self.rect.left = 0
		self.cr = Rect(self.rect[0], self.rect[1]+8, 24, 24)

        def collide(self, platforms):
                for p in platforms:
                        if self.cr.colliderect(p.rect):
                                if p.isOnRight():
                                        if p.isOnTop():
                                                if self.cr.bottom == p.rect.bottom+1 and self.cr.top == p.rect.top+1:
                                                        self.rect.left = p.rect.right
                                                        self.rect.move_ip(2, 0)
                                                        self.speed = 2
                                                if self.cr.bottom == p.rect.top+1:
                                                        if self.rect.right >= p.rect.right:
                                                                self.speed = -2
                                        else:
                                                self.rect.left = p.rect.right
                                                self.rect.move_ip(2, 0)
                                                self.speed = 2
                                if p.isOnLeft():
                                        if p.isOnTop():
                                                if self.cr.bottom == p.rect.bottom+1 and self.cr.top == p.rect.top+1:
                                                        self.rect.right = p.rect.left
                                                        self.rect.move_ip(-2, 0)
                                                        self.speed = -2   
                                                if self.cr.bottom == p.rect.top+1:
                                                        if self.rect.left <= p.rect.left:
                                                                self.speed = 2
                                        else:
                                                self.rect.right = p.rect.left
                                                self.rect.move_ip(-2, 0)
                                                self.speed = -2        

class FixedEnemy(pygame.sprite.Sprite):
	
	def __init__(self, type, pos, direction, player_rect):
		pygame.sprite.Sprite.__init__(self, self.containers)

		# Loading enemy frames
		self.left_n_image = loadpng(type+"-n1.png")
		self.right_n_image = pygame.transform.flip(self.left_n_image, 1, 0)
		
		self.left_s_image = loadpng(type+"-s1.png")
		self.right_s_image = pygame.transform.flip(self.left_s_image, 1, 0)
		
		self.hit_images = [loadpng(type+"-h1.png"), pygame.transform.flip(loadpng(type+"-h1.png"), 1, 0)]

		if (direction > 0): self.image = self.right_n_image
		else: self.image = self.left_n_image
		
		self.rect = Rect(0, 0, 32, 32)
		self.rect.topleft = pos
		self.player_rect = player_rect
		self.proxrect = Rect(0,0, 1200, 600)
		self.proxrect.center = self.rect.center
		
		self.hp = 2
		self.direction = direction
		self.animdelay  = 5
		self.shot_delay=50
		self.hurt=False
		self.hurt_delay = 0
		self.shooting=False

	def target(self, player_rect):
		sefl.player_rect = player_rect
		
	def hit(self, damage):
		if (self.hp > 0) and (not self.hurt):
			self.hp -= damage
			self.hurt=True
			self.hurt_delay = 5
			
	def collide(self, platform):
		return

	def fire(self, player_rect, camera):
		""" This method should be overloaded in child class. You can control how much 
		shots it should do and shots directions"""
		return

	def inbounds(self, camera):
                return False

        def move(self):
                pass


	def update(self):		
		if (self.hp > 0): 
			if (self.proxrect.contains(self.player_rect) and self.shot_delay > 0): self.shot_delay -= 1
			
			if self.shooting:
				self.animdelay -= 1
				if (self.animdelay <= 0):
					self.animdelay  = 5
					self.shooting=False
					self.shot_delay=50
					if self.direction > 0: self.image = self.right_n_image
					elif self.direction < 0: self.image = self.left_n_image
				
			if (self.player_rect.center[0] <= self.rect.center[0]): self.direction=-1
			else: self.direction=1
		
		if self.hurt:
			if self.direction > 0: self.image = self.hit_images[1]
			else: self.image = self.hit_images[0]
			self.hurt_delay -= 1
			if (self.hurt_delay <= 0): 
				self.hurt=False
				if self.direction > 0: self.image = self.right_n_image
				elif self.direction < 0: self.image = self.left_n_image
		
		if (self.hp <= 0): 
			Explosion(self.rect.center)
			self.kill()
		
		if self.rect.left <= 0:
			self.rect.left = 0
			
class LiquidEnemy(pygame.sprite.Sprite):
	
	def __init__(self, type, pos):
		pygame.sprite.Sprite.__init__(self, self.containers)
		
		# Loading enemy frames
		self.images = []
		for i in range(1,5):
			self.images.append(loadpng(type+str(i)+".png"))
		self.image = self.images[0]
		self.rect = Rect(0, 0, 24, 24)
		self.screenrect = Rect(0, 0, 500, 400)
		self.rect.topleft = pos
		self.animdelay=8
		self.frame=0
		
	def collide(self, platform):
		return
	
	def move(self):
		return
		
	def hit(self, damage):
		return
		
	def inbounds(self, camera):
                if self.screenrect.colliderect(Rel_Rect(self, camera)):
                        return True
		
	def update(self):
		self.frame += 1
		self.image = self.images[self.frame/self.animdelay%len(self.images)]


class FlyingEnemy(pygame.sprite.Sprite):
	
	def __init__(self, type, pos):

                pygame.sprite.Sprite.__init__(self, self.containers)

		# Loading enemy frames
		self.left_n_images = []
		for i in range(1,5): 
			self.left_n_images.append(loadpng(type+"-r"+str(i)+".png"))
		
		self.right_n_images = []
		for img in self.left_n_images:
			self.right_n_images.append(pygame.transform.flip(img, 1, 0))
		'''
		self.left_d_images = []
		for i in range(1,5):
			self.left_d_images.append(loadpng(type+"-d"+str(i)+".png"))
		
		self.right_d_images = []
		for img in self.left_d_images:
			self.right_d_images.append(pygame.transform.flip(img, 1, 0))
		'''
		self.hit_images = [loadpng(type+"-h1.png"), pygame.transform.flip(loadpng(type+"-h1.png"), 1, 0)]
		
		self.image = self.right_n_images[0]
		
		self.rect = Rect(0, 0, 24, 32)
		self.rect.topleft = pos
		self.rect.move_ip(0, -8)
		self._rect = Rect(self.rect)
		self.cr = Rect(self.rect[0], self.rect[1]+8, 24, 24)
		self.yoffset = -2
		self.xoffset = -4
		
		self.hp = 3
		#self.jump_speed = 0
		#self.fall_speed = 0.5
		#self.max_speed  = 10
		#self.jumping = False
		self.accel = 0.5
		self.xspeed = random.choice([2, -2])
		self.yspeed = random.choice([2, -2])
		#self.max_mspeed = 5
		self.frame = 0
		self.animdelay  = 10
		self.facing = 1
		self.death_frame=0
		self.hurt=False
		self.hurt_delay = 0
		self.s = self.xspeed
		self.screenrect = Rect(0, 0, 500, 400)
		self.flyingrect = Rect(0, 0, 250,120)
		self.flyingrect.center=self.rect.center
		
	def hit(self, damage):
		if (self.hp > 0) and (not self.hurt):
			self.hp -= damage
			self.hurt=True
			self.hurt_delay = 5

	def inbounds(self, camera):
                if self.screenrect.colliderect(Rel_Rect(self, camera)):
                        return True
			
	def collide(self, platform):
		return

	def move(self):
		if (self.hp > 0):
			if (self.rect.left < self.flyingrect.left): self.xspeed = -self.xspeed
			if (self.rect.right > self.flyingrect.right): self.xspeed = -self.xspeed
			if (self.rect.top < self.flyingrect.top): self.yspeed = -self.yspeed
			if (self.rect.bottom > self.flyingrect.bottom): self.yspeed = -self.yspeed
                        self.rect.move_ip(self.xspeed, self.yspeed)
	
	def update(self):
		self._rect = Rect(self.rect)
		self.frame += 1

		if (self.hp > 0):
			if self.xspeed > 0:
				self.image = self.right_n_images[self.frame/self.animdelay%len(self.right_n_images)]
			elif self.xspeed < 0:
				self.image = self.left_n_images[self.frame/self.animdelay%len(self.left_n_images)]
		
		if self.hurt:
			if self.xspeed > 0: self.image = self.hit_images[1]
			else: self.image = self.hit_images[0]
			self.hurt_delay -= 1
			if (self.hurt_delay <= 0): self.hurt=False
		'''
		if (self.hp <= 0):
			if (0 < self.death_frame <= 3):
				if self.xspeed > 0: self.image = self.right_d_images[0]
				else: self.image = self.left_d_images[0]
			elif (3 < self.death_frame <= 6):
				if self.xspeed > 0: self.image = self.right_d_images[1]
				else: self.image = self.left_d_images[1]
			elif (6 < self.death_frame <= 9):
				if self.xspeed > 0: self.image = self.right_d_images[2]
				else: self.image = self.left_d_images[2]
			elif (9 < self.death_frame <= 12):
				if self.xspeed > 0: self.image = self.right_d_images[3]
				else: self.image = self.left_d_images[3]
			elif (self.death_frame>=12):
				self.kill()
			self.death_frame += 1
		'''
		if (self.hp <= 0): 
			Explosion(self.rect.center)
			self.kill()
		
		if self.rect.left <= 0:
			self.rect.left = 0
		self.cr = Rect(self.rect[0], self.rect[1]+8, 24, 24)
		

class Boss (pygame.sprite.Sprite):
	
	def __init__(self, pos):

                pygame.sprite.Sprite.__init__(self, self.containers)
		type='boss'
		# Loading enemy frames
		self.left_n_images = []
		for i in range(1,5): 
			self.left_n_images.append(loadpng(type+"-r"+str(i)+".png"))
		
		self.right_n_images = []
		for img in self.left_n_images:
			self.right_n_images.append(pygame.transform.flip(img, 1, 0))
		'''
		self.left_d_images = []
		for i in range(1,5):
			self.left_d_images.append(loadpng(type+"-d"+str(i)+".png"))
		
		self.right_d_images = []
		for img in self.left_d_images:
			self.right_d_images.append(pygame.transform.flip(img, 1, 0))
		'''
		self.hit_images = [loadpng(type+"-h1.png"), pygame.transform.flip(loadpng(type+"-h1.png"), 1, 0)]
		
		self.image = self.right_n_images[0]
		
		self.sound = loadsound("gun.ogg")
		
		self.rect = Rect(0, 0, 44, 67)
		self.rect.topleft = pos
		self.rect.move_ip(0, -8)
		self._rect = Rect(self.rect)
		self.cr = Rect(self.rect[0], self.rect[1]+8, 44, 67)
		self.yoffset = -2
		self.xoffset = -4
		
		self.hp = 1
		self.damage = 30
		self.accel = 0.5
		self.xspeed = random.choice([1, -1])
		self.yspeed = random.choice([2, -2])
		self.frame = 0
		self.animdelay  = 10
		self.facing = 1
		self.death_frame=0
		self.hurt=False
		self.hurt_delay = 0
		self.s = self.xspeed
		self.screenrect = Rect(0, 0, 500, 400)
		self.flyingrect = Rect(0, 0, 200,80)
		self.flyingrect.center=self.rect.center
		
		self.proxrect = Rect(0,0, 1200, 600)
		self.proxrect.center = self.rect.center
		self.shooting=False
		self.shot_delay=50
		
	def hit(self, damage):
		if (self.hp > 0) and (not self.hurt):
			self.hp -= damage
			self.hurt=True
			self.hurt_delay = 5
	
	def fire(self, player_rect, camera):
		self.player_rect = player_rect
		self.camera = camera
		if self.screenrect.contains(Rel_Rect(self, self.camera)):
                        if (self.hp > 0): 
                                if (self.shot_delay == 0) and (not self.shooting): 
                                        self.shooting=True
                                        self.sound.play()
					EnemyShot('', self.rect.center, 'up', self.camera)
					EnemyShot('', self.rect.center, 'down', self.camera)
					EnemyShot('', self.rect.center, 'right', self.camera)
					EnemyShot('', self.rect.center, 'left', self.camera)
					EnemyShot('', self.rect.center, 'left-up', self.camera)
					EnemyShot('', self.rect.center, 'left-down', self.camera)
					EnemyShot('', self.rect.center, 'right-up', self.camera)
					EnemyShot('', self.rect.center, 'right-down', self.camera)

	def inbounds(self, camera):
                if self.screenrect.colliderect(Rel_Rect(self, camera)):
                        return True
			
	def collide(self, platform):
		return

	def move(self):
		if (self.hp > 0):
			if (self.rect.left < self.flyingrect.left): self.xspeed = -self.xspeed
			if (self.rect.right > self.flyingrect.right): self.xspeed = -self.xspeed
			if (self.rect.top < self.flyingrect.top): self.yspeed = -self.yspeed
			if (self.rect.bottom > self.flyingrect.bottom): self.yspeed = -self.yspeed
                        self.rect.move_ip(self.xspeed, self.yspeed)
	
	def update(self):
		self.frame += 1

		if (self.hp > 0):
			if (self.shot_delay > 0): self.shot_delay -= 1
			
			if self.shooting:
				self.animdelay -= 1
				if (self.animdelay <= 0):
					self.animdelay  = 5
					self.shooting=False
					self.shot_delay=50
					
			if self.xspeed > 0:
				self.image = self.right_n_images[self.frame/self.animdelay%len(self.right_n_images)]
			elif self.xspeed < 0:
				self.image = self.left_n_images[self.frame/self.animdelay%len(self.left_n_images)]
		
		if self.hurt:
			if self.xspeed > 0: self.image = self.hit_images[1]
			else: self.image = self.hit_images[0]
			self.hurt_delay -= 1
			if (self.hurt_delay <= 0): self.hurt=False
		'''
		if (self.hp <= 0):
			if (0 < self.death_frame <= 3):
				if self.xspeed > 0: self.image = self.right_d_images[0]
				else: self.image = self.left_d_images[0]
			elif (3 < self.death_frame <= 6):
				if self.xspeed > 0: self.image = self.right_d_images[1]
				else: self.image = self.left_d_images[1]
			elif (6 < self.death_frame <= 9):
				if self.xspeed > 0: self.image = self.right_d_images[2]
				else: self.image = self.left_d_images[2]
			elif (9 < self.death_frame <= 12):
				if self.xspeed > 0: self.image = self.right_d_images[3]
				else: self.image = self.left_d_images[3]
			elif (self.death_frame>=12):
				self.kill()
			self.death_frame += 1
		'''
		if (self.hp <= 0): 
			Explosion2(self.rect.center)
			self.kill()
		
		if self.rect.left <= 0:
			self.rect.left = 0
		self.cr = Rect(self.rect[0], self.rect[1]+8, 24, 24)
		
		
class Unoculus(WalkingEnemy):
	
	def __init__(self, pos, direction):

		WalkingEnemy.__init__(self, 'unoculus', pos, direction)
		
		self.hp = 2
		self.damage = 1
		self.speed = 2

class Turret(FixedEnemy):
	
	def __init__(self, pos, direction, player_rect):

		FixedEnemy.__init__(self, 'turret', pos, direction, player_rect)
		
		self.hp = 5
		self.damage = 2
		self.shot_delay=50
		self.sound = loadsound("gun.ogg")
		self.screenrect = Rect(0, 0, 500, 400)
	
	def fire(self, player_rect, camera):
		self.player_rect = player_rect
		self.camera = camera
		if self.screenrect.contains(Rel_Rect(self, self.camera)):
                        if (self.hp > 0): 
                                if (self.shot_delay == 0) and (not self.shooting): 
                                        self.shooting=True
                                        self.sound.play()
                                        if self.direction > 0: 
                                                self.image = self.right_s_image
                                                EnemyShot('', self.rect.center, 'right', self.camera)
                                        elif self.direction < 0: 
                                                self.image = self.left_s_image
                                                EnemyShot('', self.rect.center, 'left', self.camera)

class Acid(LiquidEnemy):
	
	def __init__(self, pos):

		LiquidEnemy.__init__(self, 'acid', pos)
		
		self.damage = 5
		self.rect = Rect(self.rect[0], self.rect[1]+16, self.rect[2], self.rect[3]-16)
		self.yoffset = -16

		
class Mine(FlyingEnemy):
	
	def __init__(self, pos):

		FlyingEnemy.__init__(self, 'mine', pos)
		
		self.damage = 20
