#! /usr/bin/env python

import pygame, os, sys
import input, util, screens #, ui
from pygame.locals import *

from player import *
from objects import *
from level import *
from camera import *
from draw import *
from data import *
from enemies import *
from camera import Rect as Rel_Rect

# KEY BINDINGS (Defined by user)
LEFT 	= 0x13
RIGHT 	= 0x14
PAUSE 	= 0x15
ACTION1	= 0x16
ACTION2 	= 0x17
ACTION3 	= 0x18
EXIT 	= 0xFF

FPS		= 60

def save_prog(level):
        f = os.path.join("data", "prog.sav")
        open(f, "wr").write(str(level))

def open_prog():
        f = os.path.join("data", "prog.sav")
        if not os.path.exists(f):
                open(f, "wr").write(str(1))
        return open(f, "rb").read()        

class Game:
	
	def __init__(self, screen, maxenergy, energy, _continue=False):
		self.screen = screen
		
		self.score = 0
		if _continue:
                        self.lvl = int(open_prog())
                else:
                        self.lvl = 1
		self.energy=maxenergy
		self.maxenergy=maxenergy
		self.downratio=0.03

                self.inner = DrawGroup()
		self.all = DrawGroup()
		self.msgs = pygame.sprite.RenderUpdates()
		self.gshots = pygame.sprite.Group()
		self.gplatforms = pygame.sprite.Group()
		self.genemies = pygame.sprite.Group()
		self.ghostages = pygame.sprite.Group()
		self.genemshots = pygame.sprite.Group()
		self.grechargers = pygame.sprite.Group()
		self.gportals = pygame.sprite.Group()
		self.gexplosions = pygame.sprite.Group()
		
		self.titlefont= util.loadfont(16, 'featured')
		self.bigfont= util.loadfont(16, 'bronic')
		self.smallfont= util.loadfont(14, 'featured')
		self.gauge = util.loadpng('gauge.png')

		self.shoot = util.loadsound("shoot.wav")
		self.exp1  = util.loadsound("exp1.wav")
		self.exp2  = util.loadsound("exp2.ogg")
		self.exp3  = util.loadsound("exp3.wav")

		Shackle.image = util.loadpng('shackle.png')
                Hostage.image = util.loadpng('hostage.png')
                Hostage.helpsound = util.loadsound("help.ogg")
		EnemyShot.image = util.loadpng('enemyshot.png')
		Shot.image = util.loadpng('shot.png')
		Help.image = loadpng('help.png')
		Portal.game=self
		Explosion.expimg=[]
		for i in range(1,7):
			Explosion.expimg.append(loadpng('exp'+str(i)+'.png'))
		Explosion2.expimg=[]
		for i in range(1,7):
			Explosion2.expimg.append(loadpng2('exp'+str(i)+'.png'))
		Explosion2.expimg.append(loadpng2('exp6.png'))
		Explosion2.expimg.append(loadpng2('exp6.png'))
		Explosion2.expimg.append(loadpng2('exp6.png'))

		
		Player.containers = self.all
		Platform.containers = self.all, self.gplatforms
		MovingPlatform.containers = self.all, self.gplatforms
		Shot.containers = self.all, self.gshots
		ParticleBlast.containers = self.all
		Shackle.containers = self.all
		Help.containers = self.all
		Hostage.containers = self.all, self.ghostages
		Unoculus.containers = self.all, self.genemies
		Explosion.containers = self.all, self.gexplosions
		EnemyShot.containers = self.all, self.genemshots
		Turret.containers = self.all, self.genemies
		Recharger.containers = self.all, self.grechargers, self.gplatforms
		Portal.containers = self.all, self.gportals, self.gplatforms
                Message.containers = self.msgs
                Warning.containers = self.all, self.msgs
                Acid.containers = self.all, self.genemies
                Mine.containers = self.all, self.genemies
                Boss.containers = self.all, self.genemies
                BossRoom.containers = self.inner
                Explosion2.containers = self.all, self.gexplosions
		
		# User input bindings (with joystick support)
		self.input=input.Input()
		self.input.bindKey(LEFT, pygame.K_LEFT)
		self.input.bindKey(RIGHT, pygame.K_RIGHT)
		self.input.bindKey(ACTION1, pygame.K_z, False)
		self.input.bindKey(ACTION2, pygame.K_x)
		self.input.bindKey(ACTION3, pygame.K_LSHIFT)
		self.input.bindKey(EXIT, pygame.K_ESCAPE)

		self.input.bindJoyButton(ACTION1, input.JOY_BUTTON2, False)
		self.input.bindJoyButton(ACTION2, input.JOY_BUTTON3)
		self.input.bindJoyButton(ACTION3, input.JOY_BUTTON1)

		self.input.bindJoyAxis(LEFT, input.JOY_AXIS_0_LEFT)
		self.input.bindJoyAxis(RIGHT, input.JOY_AXIS_0_RIGHT)

		self.clock = pygame.time.Clock()
		self.do_level()
		self.quit=False
		self.screenrect = pygame.Rect(0, 0, 500, 400)
		
		loadmusic("loop.ogg")

	def clear_sprites(self):
                for s in self.inner.sprites():
                        pygame.sprite.Sprite.kill(s)
                for s in self.all.sprites():
                        pygame.sprite.Sprite.kill(s)
		for s in self.msgs.sprites():
                        pygame.sprite.Sprite.kill(s)
	
	def next_level(self):
		"""This method is called from the player class"""
		if self.hostages <= 0:
			self.lvl += 1
			if (self.lvl > 7): 
				EndScreen(self.screen)
				self.quit = True
			else:
                                save_prog(self.lvl)
				self.do_level()
			
		else:
			Warning('%d hostages left' % self.hostages, (250, 130), 1)

	def gameInput(self):
		events = self.input.handleInput()

		if self.player.dietimer <= 0:
                        if self.input.lookup(LEFT):
                                self.player.walk(-1)
                        if self.input.lookup(RIGHT): 
                                self.player.walk(1)
                        if self.input.lookup(ACTION1):
                                self.player.jump()
                        if self.input.lookup(ACTION2):
                                self.player.shooting = True
                                if (self.player.shot_delay == 0): 
                                        Shot(self.player.rect.center, self.player.facing, self.camera)
                                        self.player.shot()
                                        self.shoot.play()
                        else:
                                self.player.shooting = False
		if self.input.lookup(EXIT):
			self.quit = True

	def updateUI(self):
		normal_color=(0xff,0xff,0xff)
		shadow_color=(164,0,0)
		
		energyTitle, energyTitleSha = util.rendertextsha('ENERGY', normal_color, shadow_color, self.titlefont)
		stageTitle, stageTitleSha = util.rendertextsha('LEVEL', normal_color, shadow_color, self.titlefont)
		hostagesTitle, hostagesTitleSha = util.rendertextsha('HOSTAGES', normal_color, shadow_color, self.titlefont)
		scoreTitle, scoreTitleSha = util.rendertextsha('SCORE', normal_color, shadow_color, self.titlefont)
		mid=(self.screen.get_width()-stageTitle.get_size()[0])/2
		
		score=util.rendertext(util.fillnum(self.score, 7), normal_color, self.bigfont)
		hostages=util.rendertext(str(self.hostages), normal_color, self.bigfont)
		stage=util.rendertext('%d' % self.lvl, normal_color, self.bigfont)
		e=(150*self.energy)/self.maxenergy
		fps=util.rendertext('FPS: %02d/60' % self.clock.get_fps(), normal_color, self.smallfont)

		self.screen.blit(energyTitleSha, (6,6))
		self.screen.blit(energyTitle, (5,5))
		self.screen.blit(hostagesTitleSha, (281,6))
		self.screen.blit(hostagesTitle, (280,5))
		self.screen.blit(stageTitleSha, (381,6))
		self.screen.blit(stageTitle, (380,5))
		self.screen.blit(scoreTitleSha, (self.screen.get_width()-79,6))
		self.screen.blit(scoreTitle, (self.screen.get_width()-80,5))
		
		self.screen.blit(score, (self.screen.get_width()-80,20))
		self.screen.blit(hostages, (280,20))
		self.screen.blit(stage, (380,20))
		self.screen.blit(fps, (10,380))
		
		self.screen.blit(self.gauge, (5,25), (0, 0, 150, 8))
		self.screen.blit(self.gauge, (5,25), (0, 8, e, 8))

	def done(self):
                self.quit = True

	def do_level(self):
		self.clear_sprites()
		self.energy = 100
		screens.IntroLevel(self.screen, self.lvl)
		self.level = Level(self, self.lvl)
		self.bg = self.level.bg
		self.fg = self.level.fg
		self.camera = Camera(self.screen, self.level.get_size(), self.player, True)
		self.hostages = len(self.ghostages)

	def update(self):
		self.clock.tick(FPS)
		self.inner.update()
		self.all.update()
		self.msgs.update()
		self.camera.update()
		self.energy -= self.downratio
		if self.energy <= 0:
                        if self.player.alive():
                                Explosion(self.player.rect.center)
                                self.exp3.play()
                        self.energy = 0
                        self.player.kill()
                if self.lvl == 6 and not self.genemies and not self.gexplosions:
                        self.done()

	def collision_detect(self):
		for platform in self.gplatforms:
                        if self.screenrect.colliderect(Rel_Rect(platform, self.camera)):
                                for s in pygame.sprite.spritecollide(platform, self.gshots, 1):
                                        for i in range(5):
                                                ParticleBlast(s.rect.center, s.speed, s.color)
                                for s in pygame.sprite.spritecollide(platform, self.genemshots, 1):
                                        for i in range(5):
                                                ParticleBlast(s.rect.center, s.speed)

			self.player.collide(platform)
		for enemy in self.genemies:
                        if enemy.inbounds(self.camera):
                                enemy.collide(self.gplatforms)
                                enemy.move()
                        if isinstance(enemy, Turret):
                                enemy.fire(self.player.rect, self.camera)
			if isinstance(enemy, Boss):
                                enemy.fire(self.player.rect, self.camera)
		
		for enemy in pygame.sprite.groupcollide(self.genemies, self.gshots, 0, 1):
			enemy.hit(1)
			if isinstance(enemy, WalkingEnemy):
                                if enemy.hp <= 0 and enemy.death_frame == 0:
                                        self.exp1.play()
                                        self.score += 25
			if isinstance(enemy, FixedEnemy):
                                if enemy.hp <= 0 and enemy.alive():
                                        self.exp2.play()
                                        self.score += 25
			if isinstance(enemy, FlyingEnemy):
                                if enemy.hp <= 0 and enemy.alive():
                                        self.exp2.play()
                                        self.score += 25
			if isinstance(enemy, Boss):
                                if enemy.hp <= 0 and enemy.alive():
					screens.EndScreen(self.screen)
					self.quit=True
					#self.next_level()

		for hostage in pygame.sprite.spritecollide(self.player, self.ghostages, False):
			if not hostage.released:
				self.score += 1000
                                self.hostages -= 1
                                if (self.hostages > 1): Message("%s hostages left!" % self.hostages, (250, 100))
				elif (self.hostages == 1): Message("1 hostage left!", (250, 100))
				else: Message("All hostages rescued!", (250, 100))
			hostage.release()
		
		for enemy in pygame.sprite.spritecollide(self.player, self.genemies, False):
			self.player.hit(self, enemy.damage)
                        if isinstance(enemy, Acid) and self.player.alive():
                                self.player.kill()
                                Explosion(self.player.rect.center)
                                self.exp2.play()
			if isinstance(enemy, Mine) and self.player.alive():
                                Explosion(self.player.rect.center)
				#enemy.hit(5)
				enemy.kill()
                                self.exp2.play()
		
		for shot in pygame.sprite.spritecollide(self.player, self.genemshots, False):
			self.player.hit(self)
			if self.player.alive():
                                shot.kill()

                if self.player.rect.top >= self.level.get_size()[1]:
                        self.player.kill()

                if self.player.rect.right >= self.level.get_size()[0]:
                        self.player.rect.right = self.level.get_size()[0]
		
                if self.energy > self.maxenergy:
                        self.energy = self.maxenergy

                if not self.player.alive() and not self.gexplosions:
                        self.do_level()

	def draw(self):
		self.screen.fill((0, 0, 0))

		x = -(self.camera.rect.left % 1000) / 2
		y = -(self.camera.rect.top % 800) / 2
		self.screen.blit(self.bg, (x, y))
		self.screen.blit(self.bg, (x-500, y))
		self.screen.blit(self.bg, (x+500, y))
		self.screen.blit(self.bg, (x, y+400))
		self.screen.blit(self.bg, (x-500, y+400))
		self.screen.blit(self.bg, (x+500, y+400))
		self.screen.blit(self.bg, (x, y-400))
		self.screen.blit(self.bg, (x-500, y-400))
		self.screen.blit(self.bg, (x+500, y-400))

		'''x = -(self.camera.rect.left % 1000) / 2
		y = -(self.camera.rect.top % 800) / 2
		self.screen.blit(self.fg, (x, y))
		self.screen.blit(self.fg, (x-500, y))
		self.screen.blit(self.fg, (x+500, y))
		self.screen.blit(self.fg, (x, y+400))
		self.screen.blit(self.fg, (x-500, y+400))
		self.screen.blit(self.fg, (x+500, y+400))
		self.screen.blit(self.fg, (x, y-400))
		self.screen.blit(self.fg, (x-500, y-400))
		self.screen.blit(self.fg, (x+500, y-400))'''

                self.inner.draw(self.screen, self.camera)
		self.all.draw(self.screen, self.camera)
		self.updateUI()
		self.msgs.draw(self.screen)
		pygame.display.flip()

	def main_loop(self):
		while not self.quit:
			self.update()
			self.collision_detect()
			self.gameInput()
			self.draw()

