#! /usr/bin/env python

import pygame, os, random
from pygame.locals import *
from objects import *
from util import *
from enemies import *
from player import *

class Level:

    def __init__(self, game, lvl):
        self.player_rect=Rect(0, 0, 1, 1)
        self.level = loadlevel("level%d.bmp" % lvl)
        try:
            self.bg = loadpng("bg%d.png" % lvl)
            self.fg = loadpng("fg%d.png" % lvl)
        except:
            self.bg = loadpng("bg1.png")
            self.fg = loadpng("fg1.png")
            
        platform_color  = (0, 0, 255, 255)
        platform2_color = (255, 0, 0, 255)
        shackle_color   = (124, 0, 88, 255)
        unoculus_color  = (0, 255, 255, 255)
        turret_color    = (184, 184, 184, 255)
        recharger_color = (18, 195, 0, 255)
        acid_color      = (16, 230, 0, 255)
        player_color    = (255, 200, 0, 255)
        portal_color    = (255, 234, 0, 255)
        mine_color    = (235, 65, 255, 255)
        boss_color    = (255, 150, 0, 255)
        bossroom_color    = (54, 54, 54, 255)
        collidables     = [platform_color]
        platforms       = [platform_color]
        self.x = self.y = 0
        
        self.hostages=0
        shackle = loadpng("shackle.png")
        
        try:
            blocks = loadpng("ground%d.png" %lvl)
        except:
            blocks = loadpng("ground1.png")
        block_topleft     = image_at(blocks, (0, 0),   (24, 24))
        block_topright    = image_at(blocks, (72, 0),  (24, 24))
        block_bottomleft  = image_at(blocks, (0, 72),  (24, 24))
        block_bottomright = image_at(blocks, (72, 72), (24, 24))
        block_left        = image_at(blocks, (0, 24),  (24, 24))
        block_right       = image_at(blocks, (72, 24), (24, 24))
        block_top         = image_at(blocks, (24, 0),  (24, 24))
        block_bottom      = image_at(blocks, (24, 72), (24, 24))
        block_middle2     = image_at(blocks, (96, 24), (24, 24))
        block_middle3     = image_at(blocks, (96, 48), (24, 24))
        block_middle4     = image_at(blocks, (96, 72), (24, 24))
        block_ctl         = image_at(blocks, (24, 24), (24, 24))
        block_ctr         = image_at(blocks, (48, 24), (24, 24))
        block_cbl         = image_at(blocks, (24, 48), (24, 24))
        block_cbr         = image_at(blocks, (48, 48), (24, 24))
        block_alone       = image_at(blocks, (96, 0),  (24, 24))

        while self.y < self.level.get_height():
            color = self.level.get_at((self.x, self.y))
            if color == shackle_color:
                self.hostages+=1
                x=self.x*24
                y=self.y*24
                Shackle((x, y))
                Hostage((x-4, y-8))
            elif color == platform2_color:
                left = right = False
                if self.get_tile_left() not in [platform2_color]:
                    left = True
                if self.get_tile_right() not in [platform2_color]:
                    right = True
                MovingPlatform((self.x*24, self.y*24), True, True, left, right)
            elif color == unoculus_color:
                Unoculus((self.x*24, self.y*24 + 1), -1)
            elif color == turret_color:
                Turret((self.x*24, self.y*24 -8), -1, self.player_rect)
            elif color == recharger_color:
                Recharger((self.x*24 + 12, self.y*24 + 10))
            elif color == acid_color:
                Acid((self.x*24, self.y*24))
            elif color == portal_color:
                Portal((self.x*24, self.y*24))
            elif color == mine_color:
                Mine((self.x*24, self.y*24))
	    elif color == boss_color:
                Boss((self.x*24, self.y*24))
	    elif color == bossroom_color:
                BossRoom((self.x*24, self.y*24))
            elif color == player_color:
                game.player = Player(game, (self.x*24, self.y*24 - 8))

            elif color in collidables:
                top = bottom = left = right = False
                if self.get_tile_above() not in collidables:
                    top = True
                if self.get_tile_under() not in collidables:
                    bottom = True
                if self.get_tile_left() not in collidables:
                    left = True
                if self.get_tile_right() not in collidables:
                    right = True
                if color == platform_color:
                    img = random.choice([block_middle2, block_middle3, block_middle4])
                    if self.get_tile_left() not in collidables:
                        img=block_left
                    if self.get_tile_right() not in collidables:
                        img=block_right
                    if self.get_tile_under() not in collidables:
                        img=block_bottom
                        if self.get_tile_right() not in collidables:
                            img=block_bottomright
                        elif self.get_tile_left() not in collidables:
                            img=block_bottomleft
                    if self.get_tile_above() not in collidables:
                        img=block_top
                        if self.get_tile_right() not in collidables:
                            img=block_topright
                        if self.get_tile_left() not in collidables:
                            img=block_topleft
                    if self.get_tile_above() in platforms:
                        if self.get_tile_at(-1, -1) not in platforms:
                            if self.get_tile_left() in platforms:
                                img=block_ctl
                        if self.get_tile_at(1, -1) not in platforms:
                            if self.get_tile_right() in platforms:
                                img=block_ctr
                    if self.get_tile_under() in platforms:
                        if self.get_tile_at(-1, 1) not in platforms:
                            if self.get_tile_left() in platforms:
                                img=block_cbl
                        if self.get_tile_at(1, 1) not in platforms:
                            if self.get_tile_right() in platforms:
                                img=block_cbr
                    if self.get_tile_left() not in platforms:
                        if self.get_tile_right() not in platforms:
                            if self.get_tile_above() not in platforms:
                                if self.get_tile_under() not in platforms:
                                    img = block_alone
                    Platform((self.x*24, self.y*24), img, top, bottom, left, right)

            self.x += 1
            if self.x >= self.level.get_width():
                self.x = 0
                self.y += 1

    def get_size(self):
        return [self.level.get_size()[0]*24, self.level.get_size()[1]*24]

    def get_tile_above(self):
        try:
            return self.level.get_at((self.x, self.y-1))
        except:
            pass
    def get_tile_under(self):
        try:
            return self.level.get_at((self.x, self.y+1))
        except:
            pass
    def get_tile_left(self):
        try:
            return self.level.get_at((self.x-1, self.y))
        except:
            pass
    def get_tile_right(self):
        try:
            return self.level.get_at((self.x+1, self.y))
        except:
            pass

    def get_tile_at(self, dx, dy):
        try:
            return self.level.get_at((self.x+dx, self.y+dy))
        except:
            pass
