# -*- coding: utf-8 -*-

import pygame, os, random
from pygame.locals import *
from util import *
from math import *
from camera import Rect as Rel_Rect

class Platform(pygame.sprite.Sprite):

	def __init__(self, pos, image, can_collide_top, can_collide_bottom, can_collide_left, can_collide_right):
		pygame.sprite.Sprite.__init__(self, self.containers)
		
		self.image = image
		self.rect = self.image.get_rect(topleft = pos)
		self._rect = Rect(self.rect)
		
		self.can_collide_top = can_collide_top
		self.can_collide_bottom = can_collide_bottom
		self.can_collide_left = can_collide_left
		self.can_collide_right = can_collide_right

	def isOnTop(self):
		return self.can_collide_top
		
	def isOnBottom(self):
		return self.can_collide_bottom
		
	def isOnLeft(self):
		return self.can_collide_left
		
	def isOnRight(self):
		return self.can_collide_right
		
class MovingPlatform(pygame.sprite.Sprite):

	def __init__(self, pos, can_collide_top, can_collide_bottom, can_collide_left, can_collide_right):
		pygame.sprite.Sprite.__init__(self, self.containers)

		ss = loadpng("groundx.png")
		self.image = image_at(ss, (24, 2), (24, 20))
		self.rect = self.image.get_rect(topleft = pos)
		self._rect = Rect(self.rect)
		
		self.can_collide_top = True
		self.can_collide_bottom = True
		self.can_collide_left = can_collide_left
		self.can_collide_right = can_collide_right

		self.oldy = self.rect.centery
		self.speed = 2

	def update(self):
                self._rect = Rect(self.rect)
                self.rect.move_ip(0, self.speed)
                if self.rect.centery <= self.oldy - 48:
                        self.speed = -self.speed
                if self.rect.centery >= self.oldy + 48:
                        self.speed = -self.speed

	def isOnTop(self):
		return self.can_collide_top
		
	def isOnBottom(self):
		return self.can_collide_bottom
		
	def isOnLeft(self):
		return self.can_collide_left
		
	def isOnRight(self):
		return self.can_collide_right
		
class Shot(pygame.sprite.Sprite):

	def __init__(self, pos, direction, camera):
		pygame.sprite.Sprite.__init__(self, self.containers)
		
		y=pos[1]-10
		x=pos[0] + 22*direction
		
		self.color=(0,255,255)
		self.camera = camera
		self.rect = self.image.get_rect(center = (x, y))
		self._rect = Rect(self.rect)
		self.speed=10*direction
		self.screenrect = Rect(0, 0, 500, 400)
		
	def update(self):
		self.rect.move_ip(self.speed, 0)
		if not self.screenrect.contains(Rel_Rect(self, self.camera)):
                        self.kill()

class ParticleBlast(pygame.sprite.Sprite):

    def __init__(self, pos, dir, color=(255, 255, 0)):

        pygame.sprite.Sprite.__init__(self, self.containers)
        self.image = pygame.Surface((2, 2))
        self.image.fill(color)
        self.rect = self.image.get_rect(center = pos)
        self.x, self.y = self.rect.center

        self.v = random.choice([0.2, 0.5, 1.0])*2
        if dir < 0:
                self.angle = 90
        if dir > 0:
                self.angle = 270
        self.angle += random.randrange(-25, 25)
        self.life = 255
        self.rect.center = self.x, self.y

    def update(self):
        self.rect.center = self.x, self.y
        self.x += sin(radians(self.angle))*self.v
        self.y += cos(radians(self.angle))*self.v
        self.life -= 10
        if self.life <= 0:
            self.kill()
            self.life = 0
        self.image.set_alpha(self.life)

class Shackle(pygame.sprite.Sprite):

	def __init__(self, pos):
		pygame.sprite.Sprite.__init__(self, self.containers)
		self.rect = self.image.get_rect(topleft = pos)
		
class Hostage(pygame.sprite.Sprite):

	def __init__(self, pos):
		pygame.sprite.Sprite.__init__(self, self.containers)
		
		self.sound = loadsound("release.ogg")
		self.rect = self.image.get_rect(topleft = pos)
		self.released=False
		self.delay=120
		self.help_delay=0
		self.count=0
		self.frame=0
		
	def release (self):
		if self.released: return
		
		self.sound.play()
		self.image = loadpng('hostage-released.png')
		self.released=True
		
	def update(self):
		self.help_delay -= 1
		if self.help_delay <= 0: 
			if not self.released: 
				Help((self.rect.x+32, self.rect.y-20))
				#self.helpsound.play()
			self.help_delay=200
		
		if (self.released and self.delay > 0): self.delay -= 1
		
		if self.delay==0:
			self.count += 1
			if self.count % 10: 
				if self.frame == 0: self.frame=1
				else: self.frame=0
					
			if self.frame==0: 
				self.image = loadpng('hostage-released.png')
			else:
				self.image = loadpng('hostage-released-2.png')
				
			if self.count == 100: self.kill()
				
class Help(pygame.sprite.Sprite):

	def __init__(self, pos):
		pygame.sprite.Sprite.__init__(self, self.containers)
		
		self.rect = self.image.get_rect(topleft = pos)
		self.delay=100
		
	def update(self):
		self.delay -= 1
		
		if self.delay <= 0: self.kill()

class Explosion(pygame.sprite.Sprite):
	def __init__(self, pos):
		pygame.sprite.Sprite.__init__(self, self.containers)
		
		self.frame=0
		self.delay=3
		self.image=self.expimg[0]
		self.rect = self.image.get_rect(center=pos)
		
	def update(self):
		self.image = self.expimg[self.frame]
		
		self.delay -= 1
		if(self.delay <= 0): 
			self.frame += 1
			self.delay=3
		if self.frame == 6: self.kill()
			
class Explosion2(pygame.sprite.Sprite):
	def __init__(self, pos):
		pygame.sprite.Sprite.__init__(self, self.containers)
		
		self.frame=0
		self.delay=3
		self.image=self.expimg[0]
		self.rect = self.image.get_rect(center=pos)
		
	def update(self):
		self.image = self.expimg[self.frame]
		
		self.delay -= 1
		if(self.delay <= 0): 
			self.frame += 1
			self.delay=3
		if self.frame == 6: self.kill()

class EnemyShot(pygame.sprite.Sprite):

	def __init__(self, type, pos, direction, camera):
		pygame.sprite.Sprite.__init__(self, self.containers)
		
		self.dir = 0
		if direction=='left':
                        self.dir = -1
			self.angle=180
		elif direction=='right':
                        self.dir = 1
			self.angle=0
		elif direction=='up': 
			self.image = pygame.transform.rotate(self.image, 90)
			self.angle=-90
		elif direction=='down': 
			self.image = pygame.transform.rotate(self.image, 90)
			self.angle=90
		elif direction=='right-up': 
			self.image = pygame.transform.rotate(self.image, -45)
			self.angle=-45
		elif direction=='left-up': 
			self.image = pygame.transform.rotate(self.image, -135)
			self.angle=-135
		elif direction=='right-down': 
			self.image = pygame.transform.rotate(self.image, 45)
			self.angle=45
		elif direction=='left-down': 
			self.image = pygame.transform.rotate(self.image, 135)
			self.angle=135
		else: 
			self.angle=0
		#self.shots=[360, 330, 300, 270, 240, 210, 180, 150, 120, 90, 60, 30, 0]
		self.color=(222,0,0)
		self.camera = camera
		self.rect = self.image.get_rect(center = pos)
		self._rect = Rect(self.rect)
		self.speed=10
		self.screenrect = Rect(0, 0, 500, 400)
		
	def update(self):
		a=radians(self.angle)
		x=round(self.speed*cos(a),2)
		y=round(self.speed*sin(a),2)
		
		self.rect.move_ip(x, y)
		if not self.screenrect.contains(Rel_Rect(self, self.camera)):
                        self.kill()

class Recharger(pygame.sprite.Sprite):

	def __init__(self, pos):
		pygame.sprite.Sprite.__init__(self, self.containers)
		
		self.n_images = []
		for i in range(1,5):
			self.n_images.append(loadpng('recharger-n'+str(i)+'.png'))
		
		self.r_image=loadpng('recharger-r1.png')
		
		self.image=self.n_images[0]
		self.rect = self.image.get_rect(center = pos)
		self._rect = Rect(self.rect)
		
		self.frame=0
		self.animdelay=8
		self.charging=False

	def isOnTop(self):
		return True
		
	def isOnBottom(self):
		return True
		
	def isOnLeft(self):
		return True
		
	def isOnRight(self):
		return True
		
	def charge(self):
		self.charging=True
			
	def stopcharge(self):
		self.charging=False
	
	def update(self):
		self.frame += 1
		if self.charging:
			self.image = self.r_image
		else:
			self.image = self.n_images[self.frame/self.animdelay%len(self.n_images)]
		
class Message(pygame.sprite.Sprite):

        def __init__(self, msg, pos, life=150):
                pygame.sprite.Sprite.__init__(self, self.containers)
                self.font = loadfont(20, 'featured')
		mesg, mesgsha=rendertextsha(msg, (255, 234, 0), (255, 255, 255), self.font)
		self.image=pygame.Surface((mesg.get_size()[0]+1, mesg.get_size()[1]+1))
		self.image.set_colorkey((0,0,0))
		self.image.blit(mesgsha, (1,1))
		self.image.blit(mesg, (0,0))
                self.rect = self.image.get_rect(center = pos)
                self.life = life

        def update(self):
                self.life -= 1
                if self.life <= 0:
                        self.kill()

class Warning(pygame.sprite.Sprite):

        def __init__(self, msg, pos, life=150):
                pygame.sprite.Sprite.__init__(self, self.containers)
                self.font = loadfont(22, 'featured')
		mesg, mesgsha=rendertextsha(msg, (255, 0, 0), (255, 255, 255), self.font)
		self.image=pygame.Surface((mesg.get_size()[0]+1, mesg.get_size()[1]+1))
		self.image.set_colorkey((0,0,0))
		self.image.blit(mesgsha, (1,1))
		self.image.blit(mesg, (0,0))
                self.rect = self.image.get_rect(center = pos)
                self.life = life

        def update(self):
                self.life -= 1
                if self.life <= 0:
                        self.kill()


class Portal(pygame.sprite.Sprite):

	def __init__(self, pos):
		pygame.sprite.Sprite.__init__(self, self.containers)
		
		self.n_images = []
		for i in range(1,6):
			self.n_images.append(loadpng('portal'+str(i)+'.png'))
		
		self.image=self.n_images[0]
		self.rect = self.image.get_rect(topleft = pos)
		self._rect = Rect(self.rect)
		
		self.frame=0
		self.animdelay=8

	def isOnTop(self):
		return True
		
	def isOnBottom(self):
		return True
		
	def isOnLeft(self):
		return True
		
	def isOnRight(self):
		return True
	
	def update(self):
		self.frame += 1
		self.image = self.n_images[self.frame/self.animdelay%len(self.n_images)]
		
	def next_level(self):
		self.game.next_level()

class BossRoom(pygame.sprite.Sprite):

	def __init__(self, pos):
		pygame.sprite.Sprite.__init__(self, self.containers)
		print 'created'
		self.image = loadpng('bossroom.png')
		self.rect = self.image.get_rect(topleft = pos)
