# -*- coding: utf-8 -*-

import pygame, os
import util
from pygame.locals import *
from objects import *

MAX_SHOT_DELAY = 12

class Player(pygame.sprite.Sprite):

    def __init__(self, game, pos):

        pygame.sprite.Sprite.__init__(self, self.containers)
        self.game = game

        # Loading robot frames
        self.norm_images = []
        for i in range(1,12): 
            self.norm_images.append(util.loadpng("robo-n-r"+str(i)+".png"))

        self.hit_images = []
        self.hit_images.append(util.loadpng("robo-hit-1.png"))
        self.hit_images.append(util.loadpng("robo-hit-2.png"))

        self.shoot_images = []
        for i in range(1,12): 
            self.shoot_images.append(util.loadpng("robo-w-r"+str(i)+".png"))

        self.jump_n_images = [util.loadpng("robo-n-j1.png"), pygame.transform.flip(util.loadpng("robo-n-j1.png"), 1, 0)]
        self.stand_n_images = [util.loadpng("robo-n-s1.png"), pygame.transform.flip(util.loadpng("robo-n-s1.png"), 1, 0)]

        self.jump_g_images = [util.loadpng("robo-w-j1.png"), pygame.transform.flip(util.loadpng("robo-w-j1.png"), 1, 0)]
        self.stand_g_images = [util.loadpng("robo-w-s1.png"), pygame.transform.flip(util.loadpng("robo-w-s1.png"), 1, 0)]

        self.right_n_images = self.norm_images
        self.left_n_images = []
        for img in self.norm_images:
            self.left_n_images.append(pygame.transform.flip(img, 1, 0))

        self.right_g_images = self.shoot_images
        self.left_g_images = []
        for img in self.shoot_images:
            self.left_g_images.append(pygame.transform.flip(img, 1, 0))

        self.right_h_images = self.hit_images
        self.left_h_images = []
        for img in self.hit_images:
            self.left_h_images.append(pygame.transform.flip(img, 1, 0))

        self.flickerimg = util.loadpng("hostage-released-2.png")
        self.hitsound = util.loadsound("hit.ogg")

        self.left_images = self.left_n_images
        self.right_images = self.right_n_images
        self.jump_images = self.jump_n_images
        self.stand_images = self.stand_n_images

        self.image = self.right_images[0]
        self.rect = Rect(pos[0], pos[1], 20, 28)
        self._rect = Rect(self.rect)
        self.xoffset = -6
        self.yoffset = -4
        
        self.shot_delay = 0
        self.jump_speed = 0
        self.fall_speed = 0.5
        self.max_speed  = 10
        self.jumping    = False
        self.accel      = 0.5
        self.speed      = 4
        self.max_mspeed = 5
        self.frame      = 0
        self.animdelay  = 2
        self.facing     = 1
        self.moving     = 0
        self.shooting   = False
        self.dietimer   = 0
        self.dietime    = 30
        self.hitdir     = 1
        self.invinctime = 0
        self.msg        = Message("", (250, 70))
        self.msg.kill()

    
    def shot(self):
        self.shot_delay = MAX_SHOT_DELAY
        
    def walk(self, direction):
        self.moving = direction	
        self.facing = direction	

    def jump(self):
        if not self.jumping:
            self.jump_speed = -9
            self.jumping = True

    def hit(self, game, damage=1):
        if self.alive() and self.dietimer <= 0 and self.invinctime <= 0:
            self.hitsound.play()
            self.hitdir = self.facing*5
            self.dietimer = self.dietime
            game.energy -= damage
            self.invinctime = 80
	    #self.jump_speed = -5
	    #if self.facing > 0: self.rect.left += 15
            #elif self.facing < 0: self.rect.left -= 15
	
            if game.energy <= 0:
                game.exp3.play()
                Explosion(self.rect.center)
                self.kill()

    def update(self):
        self.dietimer -= 1
        self.invinctime -= 1
        if self.shooting:
            self.left_images = self.left_g_images
            self.right_images = self.right_g_images
            self.jump_images = self.jump_g_images
            self.stand_images = self.stand_g_images
        else:
            self.left_images = self.left_n_images
            self.right_images = self.right_n_images
            self.jump_images = self.jump_n_images
            self.stand_images = self.stand_n_images

        self._rect = Rect(self.rect)
        if self.dietimer <= 0:
            self.frame += 1
            if self.shot_delay > 0: self.shot_delay -= 1

            self.rect.move_ip(0, self.jump_speed)
            if self.jump_speed < self.max_speed:
                self.jump_speed += self.fall_speed
            if self.jump_speed >= 4.5:
                self.jumping = True

            if self.moving < 0:
                self.rect.move_ip(-self.speed, 0)
            if self.moving > 0:
                self.rect.move_ip(self.speed, 0)
            if self.rect.left <= 0:
                self.rect.left = 0

            if self.facing > 0:
                self.image = self.stand_images[0]
            if self.facing < 0:
                self.image = self.stand_images[1]

            if self.moving > 0:
                self.image = self.right_images[self.frame/self.animdelay%len(self.right_images)]
            if self.moving < 0:
                self.image = self.left_images[self.frame/self.animdelay%len(self.left_images)]

            if self.jumping:
                if self.facing > 0:
                    self.image = self.jump_images[0]
                if self.facing < 0:
                    self.image = self.jump_images[1]

            if self.invinctime > 0:
                if self.dietimer % 3:
                    self.image = self.flickerimg
        else:
            if self.hitdir > 0:
                self.hitdir -= 0.5
            if self.hitdir < 0:
                self.hitdir += 0.5
            self.rect.move_ip(-self.hitdir, 0)
            if self.dietimer % 3:
                if self.facing > 0:
                    self.image = self.right_h_images[1]
                else:
                    self.image = self.left_h_images[1]
            else:
                if self.facing > 0:
                    self.image = self.right_h_images[0]
                else:
                    self.image = self.left_h_images[0]

        self.moving = 0

    def collide(self, platform):
        if self.rect.colliderect(platform.rect):
            if self._rect.right <= platform._rect.left and self.rect.right > platform.rect.left:
                if platform.isOnLeft():
                    self.rect.right = platform.rect.left
            if self._rect.left >= platform._rect.right and self.rect.left < platform.rect.right:
                if platform.isOnRight():
                    self.rect.left = platform.rect.right
            if self._rect.bottom <= platform._rect.top and self.rect.bottom > platform.rect.top:
                if platform.isOnTop():
                    self.rect.bottom = platform.rect.top
                    self.jumping = False
                    self.jump_speed = 2
                    if isinstance(platform, Recharger):
                        platform.charge()
                        self.game.energy += 0.5
                        if not self.msg.alive():
                            self.msg = Message("Replenishing Energy...", (250, 70), 1)
                    elif isinstance(platform, Portal):
			platform.next_level()
            if self._rect.top >= platform._rect.bottom and self.rect.top < platform.rect.bottom:
                if platform.isOnBottom():
                    self.rect.top = platform.rect.bottom
                    self.jump_speed = 2
        else:
            if isinstance(platform, Recharger):
                platform.stopcharge()
                #self.msg.kill()
