# -*- coding: utf-8 -*-
import pygame
import input
from util import *
from game import *

# KEY BINDINGS (Defined by user)
ENTER 	= 0x10
UP 		= 0x11
DOWN	= 0x12
EXIT 	= 0xFF
BGMUSIC 	= 0xF4

class MainMenu:
	def __init__(self, screen):
		self.screen=screen
		self.clock = pygame.time.Clock()
		self.fps=60
		self.menu=0
		self.quit=False
		
		self.font=loadfont(50, 'featured')
		self.smallfont=loadfont(12, 'featured')
		self.bigfont=loadfont(60, 'ethno')
		self.bg = loadpng("menu.png")
		
		self.input=input.Input()
		self.input.bindKey(EXIT, pygame.K_ESCAPE)
		self.input.bindKey(UP, pygame.K_UP, False)
		self.input.bindKey(DOWN, pygame.K_DOWN, False)
		self.input.bindKey(ENTER, pygame.K_RETURN, False)
		self.input.bindKey(BGMUSIC, pygame.K_F11, False)
		
		self.input.bindJoyAxis(UP, input.JOY_AXIS_1_UP, False)
		self.input.bindJoyAxis(DOWN, input.JOY_AXIS_1_DOWN, False)
		
		self.input.bindJoyButton(ENTER, input.JOY_BUTTON9, False)
		self.input.bindJoyButton(EXIT, input.JOY_BUTTON8, False)
		self.input.bindJoyButton(BGMUSIC, input.JOY_BUTTON4, False)
		
		self.menucolor=(0xff,0xff, 0xff)
		self.hgcolor=(0xff,0xf6,0x0)
		self.start=rendertext('New Game', self.menucolor, self.font)
		self.hlstart=rendertext('New Game', self.hgcolor, self.font)
		self.cont=rendertext('Continue', self.menucolor, self.font)
		self.hlcont=rendertext('Continue', self.hgcolor, self.font)
		self.quit=rendertext('Quit', self.menucolor, self.font)
		self.hlquit=rendertext('Quit', self.hgcolor , self.font)
		copyright=rendertext('Entry for PyWeek 6 - Magma Team (C) 2008', (255,255,255), self.smallfont)
		sx, sy = self.screen.get_size()
		cx, cy = copyright.get_size()
		loadmusic("menu.ogg")
		
		while 1:
			self.clock.tick(self.fps)
			
			self.screen.blit(self.bg, (0, 0))
			self.__updateMenu()
			self.__gameInput()
			
			self.screen.blit(copyright, ((sx-cx)/2, sy-20))
			
			pygame.display.flip()
	
	def __updateMenu(self):
		xicon=30
		xtxt=240
		ytxt=170
		self.screen.blit(self.start, (xtxt, ytxt))
		self.screen.blit(self.cont, (xtxt, ytxt+50))
		self.screen.blit(self.quit, (xtxt, ytxt+100))
		ren = self.bigfont.render("robolts", 1, (200, 200, 0))
		self.screen.blit(ren, (254-ren.get_width()/2, 34))
		ren = self.bigfont.render("robolts", 1, (255, 255, 0))
		self.screen.blit(ren, (250-ren.get_width()/2, 30))
		
		
		if (self.menu==0): 
			#self.screen.blit(self.menuicon, (xicon, 226))
			self.screen.blit(self.hlstart, (xtxt, ytxt))
		elif (self.menu==1): 
			#self.screen.blit(self.menuicon, (xicon, 256))
			self.screen.blit(self.hlcont, (xtxt, ytxt+50))
		elif (self.menu==2): 
			#self.screen.blit(self.menuicon, (xicon, 346))
			self.screen.blit(self.hlquit, (xtxt, ytxt+100))
	
	def __gameInput(self):
		self.input.handleInput()
		
		if self.input.lookup(UP):
			self.menu -= 1
			if self.menu < 0: self.menu=2
		if self.input.lookup(DOWN):
			self.menu += 1
			if self.menu > 2: self.menu=0
		if self.input.lookup(ENTER):
			if(self.menu == 0): 
				self.__run()
			elif(self.menu == 1):  
				self.__continue()
			elif(self.menu == 2):  
				exit(0)
		if self.input.lookup(EXIT): 
			exit(0)
		if self.input.lookup(BGMUSIC): 
			if pygame.mixer.music.get_volume() == 0:
				pygame.mixer.music.set_volume(1.0)
			else:
				pygame.mixer.music.set_volume(0.0)
				
	def __run(self):
		game = Game(self.screen, 100, 80, False)
		game.main_loop()
		pygame.mixer.music.stop()
		loadmusic("menu.ogg")
					
	def __continue(self):
		game = Game(self.screen, 100, 80, True)
		game.main_loop()
		pygame.mixer.music.stop()
		loadmusic("menu.ogg")

class GameOver:
	def __init__(self, screen):
		self.screen=screen
		self.clock = pygame.time.Clock()
		self.fps=60
		self.delay=150
		self.quit=False
		
		self.input=input.Input()
		
		self.font=loadfont(34, 'featured')
		self.fontsub=loadfont(12, 'vera')
		gameover=rendertext("Game Over", (255,255,255), self.font)
		sx, sy = self.screen.get_size()
		
		while 1:
			self.delay -= 1
			if (self.delay <= 0): return
			self.clock.tick(self.fps)
			#self.__gameInput()
			
			self.screen.fill((0,0,0))
			cx, cy = gameover.get_size()
			self.screen.blit(gameover, ((sx-cx)/2, (sy-cy)/2-20))
			
			pygame.display.flip()
			
	def __gameInput(self):
		self.input.handleInput()
		if self.input.lookupAny():	self.quit=True

class IntroLevel:
	def __init__(self, screen, level):
		self.screen=screen
		self.clock = pygame.time.Clock()
		self.fps=60
		self.delay=100
		self.quit=False
		
		self.font=loadfont(34, 'featured')
		self.fontsub=loadfont(12, 'vera')
		title=rendertext("Level %d" % level, (255,255,255), self.font)
		try:
			img = loadlevel("level%dintro.png" % level)
		except:
			img = loadlevel("level1intro.png")
		
		while 1:
			self.delay -= 1
			if (self.delay <= 0): return
			self.clock.tick(self.fps)
			
			self.screen.fill((0,0,0))
			sx, sy = self.screen.get_size()
			ix, iy = img.get_size()
			self.screen.blit(img, ((sx-ix)/2, 40))
			cx, cy = title.get_size()
			self.screen.blit(title, ((sx-cx)/2, iy+60))

			pygame.display.flip()
			
class OutroLevel:
	def __init__(self, screen, hostages, lives):
		self.screen=screen
		self.clock = pygame.time.Clock()
		self.fps=60
		self.delay=100
		self.quit=False
		
		self.font=loadfont(34, 'featured')
		self.fontsub=loadfont(12, 'vera')
		title=rendertext("Level %d" % level, (255,255,255), self.font)
		lives=rendertext("Lives x %d" % lives, (255,255,255), self.fontsub)
		#img = loadlevel("level%dintro.png" % level)
		img = loadlevel("level1intro.png")
		
		while 1:
			self.delay -= 1
			if (self.delay <= 0): return
			self.clock.tick(self.fps)
			
			self.screen.fill((0,0,0))
			sx, sy = self.screen.get_size()
			ix, iy = img.get_size()
			self.screen.blit(img, ((sx-ix)/2, 40))
			cx, cy = title.get_size()
			self.screen.blit(title, ((sx-cx)/2, iy+60))
			cx, cy = lives.get_size()
			self.screen.blit(lives, ((sx-cx)/2, iy+105))
			
			pygame.display.flip()
			
class EndScreen:
	def __init__(self, screen):
		self.screen=screen
		self.clock = pygame.time.Clock()
		self.fps=60
		self.quit=False
		
		img = loadpng("end.png")
		loadmusic('end.ogg')
		self.input=input.Input()
		self.input.bindKey(EXIT, pygame.K_ESCAPE)
		self.input.bindKey(ENTER, pygame.K_RETURN, False)
		
		self.input.bindJoyButton(ENTER, input.JOY_BUTTON9, False)
		self.input.bindJoyButton(EXIT, input.JOY_BUTTON8, False)
		
		while not self.quit:
			self.clock.tick(self.fps)
			self.__gameInput()
			self.screen.fill((0,0,0))
			self.screen.blit(img, (0,0))

			pygame.display.flip()
			
	def __gameInput(self):
		self.input.handleInput()
		
		if self.input.lookup(ENTER):
			self.quit=True
		if self.input.lookup(EXIT): 
			self.quit=True
		
	
	
		
