# -*- coding: utf-8 -*-
import os, sys, pygame
from pygame.locals import *


def loadpng(name):
	""" Load image and return image object"""
	fullname = os.path.join('data', 'images', name)
	#fullname = name
	try:
		image = pygame.image.load(fullname)
		if image.get_alpha() is None:
			image = image.convert()
		else:
			image = image.convert_alpha()
	except pygame.error, message:
		print 'Cannot load image:', fullname
		raise SystemExit, message
	return image

def loadpng2(name):
	""" Load image and return image object"""
	fullname = os.path.join('data', 'images', name)
	#fullname = name
	try:
		image = pygame.image.load(fullname)
		if image.get_alpha() is None:
			image = image.convert()
		else:
			image = image.convert_alpha()
	except pygame.error, message:
		print 'Cannot load image:', fullname
		raise SystemExit, message
	image = pygame.transform.scale2x(image)
	return image

def loadfont(size, fontdesc=None):
	'''
	This can be used to define ours own text fonts
	'''

	if fontdesc=='vera': font=os.path.join('data','fonts','Vera.ttf')
	elif fontdesc=='dgoutline': font=os.path.join('data','fonts','SF Distant Galaxy Outline.ttf')
	elif fontdesc=='featured': font=os.path.join('data','fonts','featuredItem.ttf')
	elif fontdesc=='bronic': font=os.path.join('data','fonts','bronic.ttf')
	elif fontdesc=='intel': font=os.path.join('data','fonts','intel.ttf')
	elif fontdesc == None: font=os.path.join('data','fonts','Vera.ttf')
	else: font=os.path.join('data','fonts', fontdesc + '.ttf')
	
	return pygame.font.Font(font, size)
	
	
def rendertext(text, color, font, bold=False, aa=1):
	'''
	Returns a rendered font
	'''

	if bold: font.set_bold(1)
	
	return font.render(text, 1, color)
	
def rendertextsha(text, color, shadow_color, font, bold=False, aa=1):
	'''
	Returns a rendered font
	'''

	if bold: font.set_bold(1)
	
	return font.render(text, 1, color), font.render(text, 1, shadow_color)
	
def loadsound(name):
	class NoneSound:
		def play(self): pass
	
	if not pygame.mixer:
		return NoneSound()
		
	fullname = os.path.join('data', 'sounds', name)
	try:
		sound = pygame.mixer.Sound(fullname)
	except pygame.error, message:
		print 'Cannot load sound:', fullname
		raise SystemExit, message
	sound.set_volume(0.5)
	return sound

def loadmusic(name):
        fullname = os.path.join('data', 'music', name)
        pygame.mixer.music.load(fullname)
        pygame.mixer.music.play(-1)

def fillnum(num, digits=6):
	snum=str(num)
	for i in range(len(snum), digits):
		snum = '0'+snum

	return snum

def image_at(image, pos, size):
        surf = pygame.Surface(size)
        #surf.set_colorkey((0, 0, 0), RLEACCEL)
        surf.blit(image, (0, 0, size[0], size[1]), (pos[0], pos[1], size[0], size[1]))
        return surf.convert_alpha()

def loadbg(image):
        image = pygame.image.load(os.path.join("data", 'images', image))
        image.set_colorkey((0, 0, 0), RLEACCEL)
        return image.convert_alpha()

def loadlevel(file):
    img = pygame.image.load(os.path.join("data", "levels", file))
    return img.convert()
