/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.ogg;

import de.jarnbjo.ogg.EndOfOggStreamException;
import de.jarnbjo.ogg.LogicalOggStream;
import de.jarnbjo.ogg.LogicalOggStreamImpl;
import de.jarnbjo.ogg.OggFormatException;
import de.jarnbjo.ogg.OggPage;
import de.jarnbjo.ogg.PhysicalOggStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class FileStream
implements PhysicalOggStream {
    private boolean closed = false;
    private RandomAccessFile source;
    private long[] pageOffsets;
    private long numberOfSamples = -1L;
    private HashMap logicalStreams = new HashMap();

    public FileStream(RandomAccessFile source) throws OggFormatException, IOException {
        this.source = source;
        ArrayList<Long> po = new ArrayList<Long>();
        int pageNumber = 0;
        try {
            while (true) {
                po.add(new Long(this.source.getFilePointer()));
                OggPage op = this.getNextPage(pageNumber > 0);
                if (op != null) {
                    LogicalOggStreamImpl los = (LogicalOggStreamImpl)this.getLogicalStream(op.getStreamSerialNumber());
                    if (los == null) {
                        los = new LogicalOggStreamImpl(this, op.getStreamSerialNumber());
                        this.logicalStreams.put(new Integer(op.getStreamSerialNumber()), los);
                    }
                    if (pageNumber == 0) {
                        los.checkFormat(op);
                    }
                    los.addPageNumberMapping(pageNumber);
                    los.addGranulePosition(op.getAbsoluteGranulePosition());
                    if (pageNumber > 0) {
                        this.source.seek(this.source.getFilePointer() + (long)op.getTotalLength());
                    }
                    ++pageNumber;
                    continue;
                }
                break;
            }
        }
        catch (EndOfOggStreamException e) {
        }
        catch (IOException e) {
            throw e;
        }
        this.source.seek(0L);
        this.pageOffsets = new long[po.size()];
        int i = 0;
        Iterator iter = po.iterator();
        while (iter.hasNext()) {
            this.pageOffsets[i++] = (Long)iter.next();
        }
    }

    public Collection getLogicalStreams() {
        return this.logicalStreams.values();
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public void close() throws IOException {
        this.closed = true;
        this.source.close();
    }

    private OggPage getNextPage() throws EndOfOggStreamException, IOException, OggFormatException {
        return this.getNextPage(false);
    }

    private OggPage getNextPage(boolean skipData) throws EndOfOggStreamException, IOException, OggFormatException {
        return OggPage.create(this.source, skipData);
    }

    public OggPage getOggPage(int index) throws IOException {
        this.source.seek(this.pageOffsets[index]);
        return OggPage.create(this.source);
    }

    private LogicalOggStream getLogicalStream(int serialNumber) {
        return (LogicalOggStream)this.logicalStreams.get(new Integer(serialNumber));
    }

    public void setTime(long granulePosition) throws IOException {
        for (LogicalOggStream los : this.logicalStreams.values()) {
            los.setTime(granulePosition);
        }
    }

    public boolean isSeekable() {
        return true;
    }
}

