/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.util.io;

import de.jarnbjo.util.io.BitInputStream;
import java.io.IOException;

public final class HuffmanNode {
    private HuffmanNode parent;
    private int depth = 0;
    protected HuffmanNode o0;
    protected HuffmanNode o1;
    protected Integer value;
    private boolean full = false;

    public HuffmanNode() {
        this(null);
    }

    protected HuffmanNode(HuffmanNode parent) {
        this.parent = parent;
        if (parent != null) {
            this.depth = parent.getDepth() + 1;
        }
    }

    protected HuffmanNode(HuffmanNode parent, int value) {
        this(parent);
        this.value = new Integer(value);
        this.full = true;
    }

    protected int read(BitInputStream bis) throws IOException {
        HuffmanNode iter = this;
        while (iter.value == null) {
            iter = bis.getBit() ? iter.o1 : iter.o0;
        }
        return iter.value;
    }

    protected HuffmanNode get0() {
        return this.o0 == null ? this.set0(new HuffmanNode(this)) : this.o0;
    }

    protected HuffmanNode get1() {
        return this.o1 == null ? this.set1(new HuffmanNode(this)) : this.o1;
    }

    protected Integer getValue() {
        return this.value;
    }

    private HuffmanNode getParent() {
        return this.parent;
    }

    protected int getDepth() {
        return this.depth;
    }

    private boolean isFull() {
        return this.full ? true : (this.full = this.o0 != null && this.o0.isFull() && this.o1 != null && this.o1.isFull());
    }

    private HuffmanNode set0(HuffmanNode value) {
        this.o0 = value;
        return this.o0;
    }

    private HuffmanNode set1(HuffmanNode value) {
        this.o1 = value;
        return this.o1;
    }

    private void setValue(Integer value) {
        this.full = true;
        this.value = value;
    }

    public boolean setNewValue(int depth, int value) {
        if (this.isFull()) {
            return false;
        }
        if (depth == 1) {
            if (this.o0 == null) {
                this.set0(new HuffmanNode(this, value));
                return true;
            }
            if (this.o1 == null) {
                this.set1(new HuffmanNode(this, value));
                return true;
            }
            return false;
        }
        return this.get0().setNewValue(depth - 1, value) ? true : this.get1().setNewValue(depth - 1, value);
    }
}

