/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame;

import com.dmgame.SMWException;
import com.dmgame.Updatable;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public class Animation
implements Cloneable,
Updatable {
    private List<Frame> frames;
    private int index;
    private long animTime;
    private long totalTime;
    private long duration;
    private boolean firstRun;
    private int height;
    private int width;

    public Animation(long duration, BufferedImage ... images) throws SMWException {
        if (images.length < 2) {
            throw new SMWException("Not enough images to warrant an animation.");
        }
        for (int i = 1; i < images.length; ++i) {
            if (images[i].getWidth() == images[i - 1].getWidth() || images[i].getHeight() == images[i - 1].getHeight()) continue;
            throw new SMWException("All images must have the same dimensions.");
        }
        this.width = images[0].getWidth();
        this.height = images[0].getHeight();
        this.frames = new ArrayList<Frame>(images.length);
        this.totalTime = 0L;
        this.animTime = 0L;
        this.index = 0;
        for (BufferedImage i : images) {
            this.totalTime += duration;
            this.frames.add(new Frame(i, this.totalTime));
        }
        this.duration = duration;
        this.firstRun = true;
    }

    private Animation(List<Frame> oldFrames, int oldIndex, long oldAnimTime, long oldTotalTime, long oldDuration) {
        this.frames = new ArrayList<Frame>(oldFrames.size());
        for (Frame f : oldFrames) {
            this.frames.add(new Frame(f.image, f.endTime));
        }
        this.index = oldIndex;
        this.totalTime = oldTotalTime;
        this.animTime = oldAnimTime;
        this.duration = oldDuration;
        this.width = this.frames.get(0).image.getWidth();
        this.height = this.frames.get(0).image.getHeight();
    }

    @Override
    public synchronized void update(long timePassed) {
        this.animTime += timePassed;
        if (this.animTime >= this.totalTime) {
            this.animTime = 0L;
            this.index = 0;
            this.firstRun = false;
        }
        while (this.animTime > this.getFrame(this.index).endTime) {
            ++this.index;
        }
    }

    public synchronized BufferedImage getImage() {
        return this.getFrame(this.index).image;
    }

    public synchronized BufferedImage getImageAt(int index) {
        return this.getFrame(index).image;
    }

    public synchronized int size() {
        return this.frames.size();
    }

    private Frame getFrame(int index) {
        return this.frames.get(index);
    }

    public synchronized void addFrame(BufferedImage image) {
        this.addFrame(image, this.frames.size());
    }

    public synchronized void addFrame(BufferedImage image, int index) {
        this.totalTime += this.duration;
        this.frames.add(index, new Frame(image, this.totalTime));
    }

    public synchronized void reset() {
        this.index = 0;
        this.firstRun = true;
    }

    public synchronized boolean firstCycleCompleted() {
        return !this.firstRun;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getCurrentIndex() {
        return this.index;
    }

    public Object clone() {
        return new Animation(this.frames, this.index, this.animTime, this.totalTime, this.duration);
    }

    public long getFrameDuration() {
        return this.duration;
    }

    public static class Frame
    implements Cloneable {
        private BufferedImage image;
        private long endTime;

        private Frame(BufferedImage image, long endTime) {
            this.image = image;
            this.endTime = endTime;
        }

        public Object clone() {
            return new Frame(this.image, this.endTime);
        }
    }
}

