/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public final class BitmapFont {
    private BufferedImage defaultImage;
    private Hashtable<Character, BufferedImage> fontTable;
    private int spaceWidth;
    private int kerning;
    public static final String DEFAULT_ORDER = "!\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_'abcdefghijklmnopqrstuvwxyz{|}~";

    public BitmapFont(BufferedImage fontSheet, String order) {
        this(fontSheet, order, 0, 8);
    }

    public BitmapFont(BufferedImage fontSheet, String order, int kerning) {
        this(fontSheet, order, kerning, 8);
    }

    public BitmapFont(BufferedImage fontSheet, String order, int kerning, int spaceWidth) {
        if (fontSheet == null) {
            if (this.defaultImage == null) {
                try {
                    this.defaultImage = ImageIO.read(new File("res/gfx/fonts/font.png"));
                }
                catch (IOException ex) {
                    Logger.getLogger(BitmapFont.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            fontSheet = this.defaultImage;
        }
        this.spaceWidth = spaceWidth;
        this.fontTable = new Hashtable();
        Color delimiter = new Color(255, 0, 255);
        int startPos = 0;
        int endPos = 0;
        for (int i = 0; i < order.length(); ++i) {
            if (i != order.length() - 1) {
                endPos = startPos;
                while (fontSheet.getRGB(endPos, 0) != delimiter.getRGB()) {
                    ++endPos;
                }
            } else {
                endPos = fontSheet.getWidth();
            }
            this.fontTable.put(Character.valueOf(order.charAt(i)), fontSheet.getSubimage(startPos, 0, endPos - startPos, fontSheet.getHeight()));
            if (i == order.length() - 1) continue;
            startPos = endPos;
            while (fontSheet.getRGB(startPos, 0) == delimiter.getRGB()) {
                ++startPos;
            }
        }
    }

    public BufferedImage getImageFrom(char c) {
        return this.fontTable.get(Character.valueOf(c));
    }

    public BufferedImage[] getImagesFrom(String str) {
        BufferedImage[] toReturn = new BufferedImage[str.length()];
        for (int i = 0; i < str.length(); ++i) {
            toReturn[i] = this.getImageFrom(str.charAt(i));
        }
        return toReturn;
    }

    public void drawString(Graphics2D g2D, String str, float xPos, float yPos) {
        BufferedImage[] array = this.getImagesFrom(str);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != null) {
                g2D.drawImage((Image)array[i], Math.round(xPos), Math.round(yPos), null);
                xPos += (float)(array[i].getWidth() + this.kerning);
                continue;
            }
            xPos += (float)(this.spaceWidth + this.kerning);
        }
    }

    public Dimension getStringDimensions(String str) {
        int xPos = 0;
        int y = 0;
        BufferedImage[] array = this.getImagesFrom(str);
        for (int i = 0; i < array.length; ++i) {
            xPos += array[i] != null ? array[i].getWidth() : this.spaceWidth;
            if (array[i] == null || array[i].getHeight() <= y) continue;
            y = array[i].getHeight();
        }
        return new Dimension(xPos, y);
    }
}

