/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DevConsole {
    private JFrame frame;
    private JTextArea textArea;
    private int errCount = 0;
    private List<ChangeListener> listeners = new Vector<ChangeListener>();

    public DevConsole() {
        this.textArea = new JTextArea(16, 32);
        this.textArea.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(this.textArea);
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollPane.setHorizontalScrollBarPolicy(32);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)scrollPane, "First");
        panel.validate();
        this.frame = new JFrame("Debug Console");
        this.frame.setLocation(4, 4);
        this.frame.add(panel);
        this.frame.validate();
        this.frame.pack();
        this.frame.setResizable(false);
        this.frame.setDefaultCloseOperation(0);
        this.frame.setVisible(true);
    }

    public void start() {
        EditorOutputStream output = new EditorOutputStream(this.textArea);
        System.setErr(new PrintStream(output));
    }

    public void setIconImage(Image icon) {
        this.frame.setIconImage(icon);
    }

    public int getErrCount() {
        return this.errCount;
    }

    public boolean hasErrors() {
        return this.errCount > 0;
    }

    public void addChangeListener(ChangeListener cl) {
        this.listeners.add(cl);
    }

    private class EditorOutputStream
    extends OutputStream {
        private JTextArea console;
        private StringBuilder builder;

        private EditorOutputStream(JTextArea console) {
            this.console = console;
            this.builder = new StringBuilder();
        }

        @Override
        public void write(int b) throws IOException {
            this.sendErrorAlert();
            if (b == 13) {
                return;
            }
            if (b == 10) {
                final String text = this.builder.toString() + "\n";
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        EditorOutputStream.this.console.append(text);
                    }
                });
                this.builder.setLength(0);
            } else {
                this.builder.append((char)b);
            }
        }

        private void sendErrorAlert() {
            DevConsole.this.errCount++;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (ChangeListener cl : DevConsole.this.listeners) {
                        cl.stateChanged(new ChangeEvent(DevConsole.this));
                    }
                }
            });
        }
    }
}

