/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame;

import com.dmgame.Animation;
import com.dmgame.GameLogic;
import com.dmgame.MapScene;
import com.dmgame.SMWException;
import com.dmgame.Updatable;
import com.dmgame.Utility;
import com.dmgame.map.Map;
import com.dmgame.particle.AnimatedParticle;
import com.dmgame.particle.OscillationParticleLogic;
import com.dmgame.particle.Particle;
import com.dmgame.particle.ParticleLogic;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Vector;
import javax.imageio.ImageIO;

public class EyeCandy
implements Updatable {
    private static final File particleFolder = new File("res/gfx/packs/" + MapScene.texturePackName + "/particles");
    public static final int MAX_CLOUD_HEIGHT = 192;
    public static final int MAX_FISH_HEIGHT = GameLogic.currentMap.MAP_HEIGHT - 192;
    private List<Particle> eyeCandy = new Vector<Particle>();
    private boolean rainMovingRight = Math.random() > 0.5;
    private BufferedImage largeCloud;
    private BufferedImage smallCloud;
    private BufferedImage lightFishRight;
    private BufferedImage darkFishRight;
    private BufferedImage lightFishLeft;
    private BufferedImage darkFishLeft;
    private Animation brownLeaf;
    private Animation redLeaf;
    private Animation yellowLeaf;
    private Animation greenLeaf;
    private Animation ghostOneRight;
    private Animation ghostTwoRight;
    private Animation ghostThreeRight;
    private Animation ghostOneLeft;
    private Animation ghostTwoLeft;
    private Animation ghostThreeLeft;
    private BufferedImage bubble;
    private BufferedImage blueRainSheet;
    private BufferedImage grayRainSheet;
    private BufferedImage largeSnow;
    private BufferedImage smallSnow;

    public EyeCandy() throws IOException, SMWException {
        File largeCloudFile = this.getParticleFile("largecloud");
        File smallCloudFile = this.getParticleFile("smallcloud");
        File lightFishFile = this.getParticleFile("lightfish");
        File darkFishFile = this.getParticleFile("darkfish");
        File brownLeafFile = this.getParticleFile("brownleaf");
        File redLeafFile = this.getParticleFile("redleaf");
        File yellowLeafFile = this.getParticleFile("yellowleaf");
        File greenLeafFile = this.getParticleFile("greenleaf");
        File ghostOneFile = this.getParticleFile("ghostone");
        File ghostTwoFile = this.getParticleFile("ghosttwo");
        File ghostThreeFile = this.getParticleFile("ghostthree");
        File bubbleFile = this.getParticleFile("bubble");
        File blueRainFile = this.getParticleFile("bluerain");
        File grayRainFile = this.getParticleFile("grayrain");
        File largeSnowFile = this.getParticleFile("largesnow");
        File smallSnowFile = this.getParticleFile("smallsnow");
        this.largeCloud = ImageIO.read(largeCloudFile);
        this.smallCloud = ImageIO.read(smallCloudFile);
        this.lightFishRight = ImageIO.read(lightFishFile);
        this.darkFishRight = ImageIO.read(darkFishFile);
        this.lightFishLeft = Utility.getHorizontalFlippedCopy(this.lightFishRight);
        this.darkFishLeft = Utility.getHorizontalFlippedCopy(this.darkFishRight);
        BufferedImage[] leafSprites = new BufferedImage[6];
        BufferedImage leafSheet = ImageIO.read(brownLeafFile);
        leafSprites[0] = leafSheet.getSubimage(0, 0, 16, 16);
        leafSprites[1] = leafSheet.getSubimage(16, 0, 16, 16);
        leafSprites[2] = leafSheet.getSubimage(32, 0, 16, 16);
        leafSprites[3] = leafSheet.getSubimage(48, 0, 16, 16);
        leafSprites[4] = leafSheet.getSubimage(32, 0, 16, 16);
        leafSprites[5] = leafSheet.getSubimage(16, 0, 16, 16);
        this.brownLeaf = new Animation(120L, leafSprites);
        leafSprites = new BufferedImage[6];
        leafSheet = ImageIO.read(redLeafFile);
        leafSprites[0] = leafSheet.getSubimage(0, 0, 16, 16);
        leafSprites[1] = leafSheet.getSubimage(16, 0, 16, 16);
        leafSprites[2] = leafSheet.getSubimage(32, 0, 16, 16);
        leafSprites[3] = leafSheet.getSubimage(48, 0, 16, 16);
        leafSprites[4] = leafSheet.getSubimage(32, 0, 16, 16);
        leafSprites[5] = leafSheet.getSubimage(16, 0, 16, 16);
        this.redLeaf = new Animation(120L, leafSprites);
        leafSprites = new BufferedImage[6];
        leafSheet = ImageIO.read(yellowLeafFile);
        leafSprites[0] = leafSheet.getSubimage(0, 0, 16, 16);
        leafSprites[1] = leafSheet.getSubimage(16, 0, 16, 16);
        leafSprites[2] = leafSheet.getSubimage(32, 0, 16, 16);
        leafSprites[3] = leafSheet.getSubimage(48, 0, 16, 16);
        leafSprites[4] = leafSheet.getSubimage(32, 0, 16, 16);
        leafSprites[5] = leafSheet.getSubimage(16, 0, 16, 16);
        this.yellowLeaf = new Animation(120L, leafSprites);
        leafSprites = new BufferedImage[6];
        leafSheet = ImageIO.read(greenLeafFile);
        leafSprites[0] = leafSheet.getSubimage(0, 0, 16, 16);
        leafSprites[1] = leafSheet.getSubimage(16, 0, 16, 16);
        leafSprites[2] = leafSheet.getSubimage(32, 0, 16, 16);
        leafSprites[3] = leafSheet.getSubimage(48, 0, 16, 16);
        leafSprites[4] = leafSheet.getSubimage(32, 0, 16, 16);
        leafSprites[5] = leafSheet.getSubimage(16, 0, 16, 16);
        this.greenLeaf = new Animation(120L, leafSprites);
        BufferedImage[] ghostSprites = new BufferedImage[2];
        BufferedImage ghostSheet = ImageIO.read(ghostOneFile);
        ghostSprites[0] = ghostSheet.getSubimage(0, 0, 32, 32);
        ghostSprites[1] = ghostSheet.getSubimage(32, 0, 32, 32);
        this.ghostOneRight = new Animation(120L, ghostSprites);
        ghostSprites = new BufferedImage[2];
        ghostSheet = ImageIO.read(ghostTwoFile);
        ghostSprites[0] = ghostSheet.getSubimage(0, 0, 32, 32);
        ghostSprites[1] = ghostSheet.getSubimage(32, 0, 32, 32);
        this.ghostTwoRight = new Animation(120L, ghostSprites);
        ghostSprites = new BufferedImage[2];
        ghostSheet = ImageIO.read(ghostThreeFile);
        ghostSprites[0] = ghostSheet.getSubimage(0, 0, 32, 32);
        ghostSprites[1] = ghostSheet.getSubimage(32, 0, 32, 32);
        this.ghostThreeRight = new Animation(120L, ghostSprites);
        this.ghostOneLeft = Utility.getHorizontalFlippedCopy(this.ghostOneRight);
        this.ghostTwoLeft = Utility.getHorizontalFlippedCopy(this.ghostTwoRight);
        this.ghostThreeLeft = Utility.getHorizontalFlippedCopy(this.ghostThreeRight);
        this.bubble = ImageIO.read(bubbleFile);
        this.blueRainSheet = ImageIO.read(blueRainFile);
        this.grayRainSheet = ImageIO.read(grayRainFile);
        if (this.rainMovingRight) {
            this.blueRainSheet = Utility.getHorizontalFlippedCopy(this.blueRainSheet);
            this.grayRainSheet = Utility.getHorizontalFlippedCopy(this.grayRainSheet);
        }
        this.largeSnow = ImageIO.read(largeSnowFile);
        this.smallSnow = ImageIO.read(smallSnowFile);
    }

    private File getParticleFile(String key) {
        return new File(particleFolder.getAbsolutePath() + "/" + key + ".png");
    }

    @Override
    public void update(long timePassed) {
        Animation a;
        int xLoc;
        double speed;
        BufferedImage b;
        Particle p2;
        for (Particle p2 : this.eyeCandy) {
            p2.update(timePassed);
        }
        if (Math.random() > 0.05) {
            return;
        }
        Map map = GameLogic.currentMap;
        if (map == null) {
            return;
        }
        if ((double)map.eyeCandyValues.get("cloud").floatValue() > Math.random()) {
            b = Math.random() > 0.5 ? this.largeCloud : this.smallCloud;
            speed = 1.0 + Math.random() * 3.0;
            if (Math.random() > 0.5) {
                xLoc = 2 - b.getWidth();
            } else {
                speed *= -1.0;
                xLoc = GameLogic.currentMap.MAP_WIDTH + b.getWidth() - 2;
            }
            p2 = new Particle(b, new ParticleLogic((int)speed, 0.0f), xLoc, (float)(Math.random() * 192.0));
            this.eyeCandy.add(p2);
        }
        if ((double)map.eyeCandyValues.get("fish").floatValue() > Math.random()) {
            speed = 1.0 + Math.random() * 3.0;
            if (Math.random() > 0.5) {
                b = Math.random() > 0.5 ? this.lightFishRight : this.darkFishRight;
                xLoc = 2 - b.getWidth();
            } else {
                b = Math.random() > 0.5 ? this.lightFishLeft : this.darkFishLeft;
                speed *= -1.0;
                xLoc = GameLogic.currentMap.MAP_WIDTH + b.getWidth() - 2;
            }
            p2 = new Particle(b, new ParticleLogic((int)speed, 0.0f), xLoc, (float)(Math.random() * (double)MAX_FISH_HEIGHT));
            this.eyeCandy.add(p2);
        }
        if ((double)map.eyeCandyValues.get("leaf").floatValue() > Math.random()) {
            a = Math.random() > 0.75 ? this.brownLeaf : (Math.random() > 0.5 ? this.redLeaf : (Math.random() > 0.25 ? this.yellowLeaf : this.greenLeaf));
            p2 = new AnimatedParticle((Animation)a.clone(), (ParticleLogic)new OscillationParticleLogic((float)(1.0 + Math.random() * 3.0), 0.4f, (long)(1000.0 + Math.random() * 3000.0), false), (float)(Math.random() * (double)GameLogic.currentMap.MAP_WIDTH), -16.0f);
            this.eyeCandy.add(p2);
        }
        if ((double)map.eyeCandyValues.get("ghost").floatValue() > Math.random()) {
            speed = 1.0 + Math.random() * 3.0;
            if (Math.random() > 0.5) {
                a = Math.random() > 0.66 ? this.ghostOneRight : (Math.random() > 0.33 ? this.ghostTwoRight : this.ghostThreeRight);
                xLoc = 2 - a.getWidth();
            } else {
                a = Math.random() > 0.66 ? this.ghostOneLeft : (Math.random() > 0.33 ? this.ghostTwoLeft : this.ghostThreeLeft);
                speed *= -1.0;
                xLoc = GameLogic.currentMap.MAP_WIDTH + a.getWidth() - 2;
            }
            p2 = new AnimatedParticle((Animation)a.clone(), new ParticleLogic((int)speed, 0.0f), (float)xLoc, (float)(Math.random() * 192.0));
            this.eyeCandy.add(p2);
        }
        if (map.eyeCandyValues.get("rain").floatValue() > 0.0f) {
            for (int i = 0; i < 10; ++i) {
                float yLoc;
                float xLoc2;
                BufferedImage bufferedImage = b = Math.random() > 0.5 ? this.blueRainSheet : this.grayRainSheet;
                if (i % 2 == 0) {
                    xLoc2 = (float)(Math.random() * (double)GameLogic.currentMap.MAP_WIDTH);
                    yLoc = -10.0f;
                } else {
                    xLoc2 = this.rainMovingRight ? -10.0f : (float)(GameLogic.currentMap.MAP_WIDTH + 10);
                    yLoc = (float)(Math.random() * (double)GameLogic.currentMap.MAP_HEIGHT);
                }
                p2 = new Particle(b.getSubimage(GameLogic.random.nextInt(3) * 10, 0, 10, 10), new ParticleLogic(6.0f * (float)(this.rainMovingRight ? 1 : -1), 6.0f), xLoc2, yLoc);
                this.eyeCandy.add(p2);
            }
        }
        if ((double)map.eyeCandyValues.get("bubble").floatValue() > Math.random()) {
            p2 = new Particle(this.bubble, new OscillationParticleLogic((float)(1.0 + Math.random() * 3.0), -10.0f, 100L, false), (float)(Math.random() * (double)GameLogic.currentMap.MAP_WIDTH), (float)GameLogic.currentMap.MAP_HEIGHT + 16.0f);
            this.eyeCandy.add(p2);
        }
        if ((double)map.eyeCandyValues.get("snow").floatValue() > Math.random()) {
            p2 = new Particle(Math.random() > 0.5 ? this.largeSnow : this.smallSnow, new OscillationParticleLogic((float)(0.1 + Math.random() * 2.0), 0.4f, (long)(1000.0 + Math.random() * 3000.0), false), (float)(Math.random() * (double)GameLogic.currentMap.MAP_WIDTH), -16.0f);
            this.eyeCandy.add(p2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawEyeCandy(Graphics2D g2D) {
        Composite defaultComposite = g2D.getComposite();
        g2D.setComposite(AlphaComposite.getInstance(10, 0.75f));
        try {
            for (Particle p : this.eyeCandy) {
                g2D.drawImage((Image)p.getImage(), (int)p.x, (int)p.y, null);
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
        }
        finally {
            g2D.setComposite(defaultComposite);
        }
    }
}

