/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame;

import com.dmgame.Direction;
import com.dmgame.SMWException;
import com.dmgame.Updatable;
import com.dmgame.Utility;
import com.dmgame.entity.AI;
import com.dmgame.entity.EditableEntity;
import com.dmgame.entity.Entity;
import com.dmgame.entity.FireballBar;
import com.dmgame.entity.Player;
import com.dmgame.entity.Rotodisc;
import com.dmgame.entity.Team;
import com.dmgame.gui.PlayerOptions;
import com.dmgame.io.MapIO;
import com.dmgame.map.AnimatedTile;
import com.dmgame.map.Map;
import com.dmgame.map.PhysicalTile;
import com.dmgame.map.Platform;
import com.dmgame.map.TileType;
import com.dmgame.map.Warp;
import com.dmgame.map.interactivetiles.AbstractOnOffBlock;
import com.dmgame.modes.GameMode;
import com.dmgame.net.server.NetplayServer;
import com.dmgame.options.OptionsHandlerBean;
import com.dmgame.particle.Particle;
import com.dmgame.sound.SoundPlayer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GameLogic {
    private static OptionsHandlerBean options;
    public static volatile boolean running;
    private static long frameDelay;
    public static boolean gameWon;
    private static AtomicInteger entityCounter;
    public static HashMap<Integer, Entity> entities;
    public static Set<Updatable> updatables;
    public static List<Entity> mapEntities;
    public static List<Updatable> mapUpdatables;
    public static List<Particle> particles;
    public static Map currentMap;
    private static volatile Thread updateThread;
    private static volatile Thread collisionThread;
    public static PlayerOptions[] playerOptions;
    public static Player playerOne;
    public static Player playerTwo;
    public static Player playerThree;
    public static Player playerFour;
    public static int[] playerOneControls;
    public static int[] playerTwoControls;
    public static int[] playerThreeControls;
    public static int[] playerFourControls;
    public static double speedMultiplier;
    public static Random random;
    public static PhysicalTile[][] usePTiles;
    public static GameMode gamemode;
    protected static ScheduledThreadPoolExecutor timer;
    protected static Hashtable<Runnable, ScheduledFuture<?>> timerFutureActions;
    protected static boolean paused;

    public static void start(String mapName, boolean networkMode, String texturePackName, GameMode mode, PlayerOptions[] playerOptions) {
        try {
            GameLogic.start(MapIO.loadMap(new File("res/maps/" + mapName + ".map"), false), networkMode, texturePackName, mode, playerOptions);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(GameLogic.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(GameLogic.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(GameLogic.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SMWException ex) {
            Logger.getLogger(GameLogic.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void start(Map map, boolean networkMode, String texturePackName, GameMode mode, PlayerOptions[] playerOptions) {
        int l;
        gamemode = mode;
        gameWon = false;
        try {
            options = Utility.loadConfig();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(GameLogic.class.getName()).log(Level.SEVERE, null, ex);
        }
        GameLogic.playerOptions = playerOptions;
        try {
            AnimatedTile a;
            int y;
            int x;
            int l2;
            currentMap = map;
            usePTiles = new PhysicalTile[GameLogic.currentMap.REL_WIDTH][GameLogic.currentMap.REL_HEIGHT];
            for (int x2 = 0; x2 < GameLogic.currentMap.iTiles.length; ++x2) {
                for (int y2 = 0; y2 < GameLogic.currentMap.iTiles[0].length; ++y2) {
                    if (GameLogic.currentMap.iTiles[x2][y2] == null) continue;
                    updatables.add(GameLogic.currentMap.iTiles[x2][y2]);
                }
            }
            for (l2 = 0; l2 < GameLogic.currentMap.tilesBackground.size(); ++l2) {
                for (x = 0; x < GameLogic.currentMap.tilesBackground.get(l2).length; ++x) {
                    for (y = 0; y < GameLogic.currentMap.tilesBackground.get(l2)[x].length; ++y) {
                        if (GameLogic.currentMap.tilesBackground.get(l2)[x][y] == null || !(GameLogic.currentMap.tilesBackground.get(l2)[x][y].getUnclonedGraphicTile() instanceof AnimatedTile)) continue;
                        a = (AnimatedTile)GameLogic.currentMap.tilesBackground.get(l2)[x][y].getUnclonedGraphicTile();
                        updatables.add(a);
                    }
                }
            }
            for (l2 = 0; l2 < GameLogic.currentMap.tilesForeground.size(); ++l2) {
                for (x = 0; x < GameLogic.currentMap.tilesForeground.get(l2).length; ++x) {
                    for (y = 0; y < GameLogic.currentMap.tilesForeground.get(l2)[x].length; ++y) {
                        if (GameLogic.currentMap.tilesForeground.get(l2)[x][y] == null || !(GameLogic.currentMap.tilesForeground.get(l2)[x][y].getUnclonedGraphicTile() instanceof AnimatedTile)) continue;
                        a = (AnimatedTile)GameLogic.currentMap.tilesForeground.get(l2)[x][y].getUnclonedGraphicTile();
                        updatables.add(a);
                    }
                }
            }
            for (EditableEntity e : GameLogic.currentMap.mapEntities) {
                if (e instanceof Rotodisc) {
                    ((Rotodisc)e).setDiscsPosition();
                    for (Rotodisc.Disc d : ((Rotodisc)e).discs) {
                        GameLogic.addMapEntity((Entity)d.clone());
                    }
                } else if (e instanceof FireballBar) {
                    for (FireballBar.BarFireball b : ((FireballBar)e).fireballs) {
                        GameLogic.addMapEntity((Entity)b.clone());
                    }
                }
                GameLogic.addMapEntity((Entity)e.clone());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int i = 0; i < GameLogic.currentMap.warps.length; ++i) {
            Warp[][] arr$ = GameLogic.currentMap.warps[i];
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Warp[] array;
                for (Warp w : array = arr$[i$]) {
                    if (w == null) continue;
                    w.useX = w.mapRelX * 32;
                    w.useY = w.mapRelY * 32;
                }
            }
        }
        boolean[][] drewSpots = new boolean[GameLogic.currentMap.REL_WIDTH][GameLogic.currentMap.REL_HEIGHT];
        for (l = GameLogic.currentMap.tilesForeground.size() - 1; l >= 0; --l) {
            for (int x = 0; x < GameLogic.currentMap.tilesForeground.get(l).length; ++x) {
                for (int y = 0; y < GameLogic.currentMap.tilesForeground.get(l)[x].length; ++y) {
                    if (drewSpots[x][y] || GameLogic.currentMap.tilesForeground.get(l)[x][y] == null || GameLogic.currentMap.tilesForeground.get(l)[x][y].getPhysicalTile() == null || GameLogic.currentMap.tilesForeground.get((int)l)[x][y].getPhysicalTile().type == TileType.NONE) continue;
                    GameLogic.usePTiles[x][y] = GameLogic.currentMap.tilesForeground.get(l)[x][y].getPhysicalTile();
                    drewSpots[x][y] = true;
                }
            }
        }
        for (l = GameLogic.currentMap.tilesBackground.size() - 1; l >= 0; --l) {
            for (int x = 0; x < GameLogic.currentMap.tilesBackground.get(l).length; ++x) {
                for (int y = 0; y < GameLogic.currentMap.tilesBackground.get(l)[x].length; ++y) {
                    if (drewSpots[x][y] || GameLogic.currentMap.tilesBackground.get(l)[x][y] == null || GameLogic.currentMap.tilesBackground.get(l)[x][y].getPhysicalTile() == null || GameLogic.currentMap.tilesBackground.get((int)l)[x][y].getPhysicalTile().type == TileType.NONE) continue;
                    GameLogic.usePTiles[x][y] = GameLogic.currentMap.tilesBackground.get(l)[x][y].getPhysicalTile();
                    drewSpots[x][y] = true;
                }
            }
        }
        for (int x = 0; x < GameLogic.currentMap.iTiles.length; ++x) {
            for (int y = 0; y < GameLogic.currentMap.iTiles[x].length; ++y) {
                if (GameLogic.currentMap.iTiles[x][y] == null) continue;
                GameLogic.currentMap.iTiles[x][y].setHiddenPTile(usePTiles[x][y]);
                GameLogic.usePTiles[x][y] = new PhysicalTile(TileType.INTERACTIVE, PhysicalTile.DEFAULT);
                usePTiles[x][y].translate(x * 32, y * 32);
                if (!(GameLogic.currentMap.iTiles[x][y] instanceof AbstractOnOffBlock)) continue;
                ((AbstractOnOffBlock)GameLogic.currentMap.iTiles[x][y]).setOn(((AbstractOnOffBlock)GameLogic.currentMap.iTiles[x][y]).on);
            }
        }
        for (int c = 0; c < GameLogic.currentMap.warps.length; ++c) {
            for (int x = 0; x < GameLogic.currentMap.warps[c].length; ++x) {
                for (int y = 0; y < GameLogic.currentMap.warps[c][x].length; ++y) {
                    if (GameLogic.currentMap.warps[c][x][y] == null) continue;
                    if (usePTiles[x][y] == null) {
                        GameLogic.usePTiles[x][y] = new PhysicalTile(TileType.SOLID, PhysicalTile.DEFAULT);
                        usePTiles[x][y].translate(x * 32, y * 32);
                    }
                    GameLogic.usePTiles[x][y].type = TileType.SOLID;
                }
            }
        }
        for (int i = 0; i < GameLogic.currentMap.platforms.size(); ++i) {
            Platform p = GameLogic.currentMap.platforms.get(i);
            updatables.add(p);
            p.resetToZero();
            p.setPathIterator();
            for (int x = 0; x < p.iTiles.length; ++x) {
                for (int y = 0; y < p.iTiles[0].length; ++y) {
                    if (p.iTiles[x][y] != null) {
                        updatables.add(p.iTiles[x][y]);
                    }
                    if (!(p.gTiles[x][y] instanceof AnimatedTile)) continue;
                    AnimatedTile a = (AnimatedTile)p.gTiles[x][y];
                    updatables.add(a);
                }
            }
        }
        GameLogic.init();
    }

    public static int getUniqueEntityID() {
        return entityCounter.getAndIncrement();
    }

    public static void init() {
        int numPlayers = 0;
        if (playerOptions != null) {
            if (playerOptions[0] != null && !GameLogic.playerOptions[0].TYPE.equalsIgnoreCase("NONE")) {
                GameLogic.setupPlayerOne(GameLogic.playerOptions[0].SKIN, GameLogic.playerOptions[0].TEAM, GameLogic.playerOptions[0].TYPE);
                ++numPlayers;
            }
            if (playerOptions[1] != null && !GameLogic.playerOptions[1].TYPE.equalsIgnoreCase("NONE")) {
                GameLogic.setupPlayerTwo(GameLogic.playerOptions[1].SKIN, GameLogic.playerOptions[1].TEAM, GameLogic.playerOptions[1].TYPE);
                ++numPlayers;
            }
            if (playerOptions[2] != null && !GameLogic.playerOptions[2].TYPE.equalsIgnoreCase("NONE")) {
                GameLogic.setupPlayerThree(GameLogic.playerOptions[2].SKIN, GameLogic.playerOptions[2].TEAM, GameLogic.playerOptions[2].TYPE);
                ++numPlayers;
            }
            if (playerOptions[3] != null && !GameLogic.playerOptions[3].TYPE.equalsIgnoreCase("NONE")) {
                GameLogic.setupPlayerFour(GameLogic.playerOptions[3].SKIN, GameLogic.playerOptions[3].TEAM, GameLogic.playerOptions[3].TYPE);
                ++numPlayers;
            }
        } else {
            GameLogic.setupPlayerOne("0smw.png", Team.RED, "human");
            ++numPlayers;
            GameLogic.setupPlayerTwo("0smw.png", Team.GREEN, "human");
            ++numPlayers;
        }
        gamemode.numberOfPlayers(numPlayers);
        running = true;
        GameLogic.startGameLoop();
    }

    private static int[] mapControls(PlayerOptions op) {
        if (op.TYPE.equalsIgnoreCase("net")) {
            return null;
        }
        switch (op.PLAYER_NUMBER) {
            case 0: {
                return options.getPlayerOneControls().getAllAsArray();
            }
            case 1: {
                return options.getPlayerTwoControls().getAllAsArray();
            }
            case 2: {
                return options.getPlayerThreeControls().getAllAsArray();
            }
            case 3: {
                return options.getPlayerFourControls().getAllAsArray();
            }
        }
        return null;
    }

    private static synchronized void setupPlayerOne(String skinName, Team team, String type) {
        int relX = 0;
        int relY = 0;
        PhysicalTile p = null;
        boolean notFoundSpawn = true;
        while (notFoundSpawn) {
            relX = (int)(random.nextDouble() * (double)GameLogic.currentMap.REL_WIDTH);
            relY = (int)(random.nextDouble() * (double)GameLogic.currentMap.REL_HEIGHT);
            p = usePTiles[relX][relY];
            if (GameLogic.currentMap.spawnLocs[relX][relY] || p != null && p.type.isSolid(Direction.DOWN)) continue;
            notFoundSpawn = false;
        }
        if (type.equalsIgnoreCase("bot")) {
            playerOne = new AI(skinName, relX * 32, relY * 32, Team.RED, gamemode.getStartScore());
        } else {
            int[] controls = GameLogic.mapControls(playerOptions[0]);
            playerOne = new Player(skinName, relX * 32, relY * 32, controls, team, gamemode.getStartScore());
        }
        GameLogic.addEntity(playerOne);
    }

    private static synchronized void setupPlayerTwo(String skinName, Team team, String type) {
        int relX = 0;
        int relY = 0;
        PhysicalTile p = null;
        do {
            relX = (int)(random.nextDouble() * (double)GameLogic.currentMap.REL_WIDTH);
            relY = (int)(random.nextDouble() * (double)GameLogic.currentMap.REL_HEIGHT);
            p = usePTiles[relX][relY];
        } while (GameLogic.currentMap.spawnLocs[relX][relY] || p != null && p.type.isSolid(Direction.DOWN));
        if (type.equalsIgnoreCase("bot")) {
            playerTwo = new AI(skinName, relX * 32, relY * 32, Team.GREEN, gamemode.getStartScore());
        } else {
            int[] controls = GameLogic.mapControls(playerOptions[1]);
            playerTwo = new Player(skinName, relX * 32, relY * 32, controls, team, gamemode.getStartScore());
        }
        GameLogic.addEntity(playerTwo);
    }

    private static synchronized void setupPlayerThree(String skinName, Team team, String type) {
        int relX = 0;
        int relY = 0;
        PhysicalTile p = null;
        do {
            relX = (int)(random.nextDouble() * (double)GameLogic.currentMap.REL_WIDTH);
            relY = (int)(random.nextDouble() * (double)GameLogic.currentMap.REL_HEIGHT);
            p = usePTiles[relX][relY];
        } while (GameLogic.currentMap.spawnLocs[relX][relY] || p != null && p.type.isSolid(Direction.DOWN));
        if (type.equalsIgnoreCase("bot")) {
            playerThree = new AI(skinName, relX * 32, relY * 32, Team.YELLOW, gamemode.getStartScore());
        } else {
            int[] controls = GameLogic.mapControls(playerOptions[2]);
            playerThree = new Player(skinName, relX * 32, relY * 32, controls, team, gamemode.getStartScore());
        }
        GameLogic.addEntity(playerThree);
    }

    private static synchronized void setupPlayerFour(String skinName, Team team, String type) {
        int relX = 0;
        int relY = 0;
        PhysicalTile p = null;
        do {
            relX = (int)(random.nextDouble() * (double)GameLogic.currentMap.REL_WIDTH);
            relY = (int)(random.nextDouble() * (double)GameLogic.currentMap.REL_HEIGHT);
            p = usePTiles[relX][relY];
        } while (GameLogic.currentMap.spawnLocs[relX][relY] || p != null && p.type.isSolid(Direction.DOWN));
        if (type.equalsIgnoreCase("bot")) {
            playerFour = new AI(skinName, relX * 32, relY * 32, Team.BLUE, gamemode.getStartScore());
        } else {
            int[] controls = GameLogic.mapControls(playerOptions[3]);
            playerFour = new Player(skinName, relX * 32, relY * 32, controls, team, gamemode.getStartScore());
        }
        GameLogic.addEntity(playerFour);
    }

    public static int addEntity(Entity e) {
        entities.put(e.entityID, e);
        updatables.add(e);
        return e.entityID;
    }

    public static synchronized int removeEntity(Entity e) {
        if (e == null) {
            return -1;
        }
        entities.remove(e.entityID);
        updatables.remove(e);
        return e.entityID;
    }

    public static synchronized void addMapEntity(Entity e) {
        mapEntities.add(e);
        mapUpdatables.add(e);
    }

    public static synchronized void removeMapEntity(Entity e) {
        mapEntities.remove(e);
        mapUpdatables.remove(e);
    }

    public static synchronized boolean contains(Entity e) {
        return entities.containsKey(e.entityID) && updatables.contains(e);
    }

    public static synchronized Set<Player> getActivePlayers() {
        HashSet<Player> players = new HashSet<Player>();
        if (playerOne != null && playerOne.isAlive()) {
            players.add(playerOne);
        }
        if (playerTwo != null && playerTwo.isAlive()) {
            players.add(playerTwo);
        }
        if (playerThree != null && playerThree.isAlive()) {
            players.add(playerThree);
        }
        if (playerFour != null && playerFour.isAlive()) {
            players.add(playerFour);
        }
        return players;
    }

    public static void reportVictory() {
        if (!NetplayServer.running) {
            SoundPlayer.stopMusic();
            File musicFile = new File("res/music/game/default/stageclear.wav");
            SoundPlayer.playVictoryMusic(musicFile);
        }
        gameWon = true;
    }

    public static void startGameLoop() {
        collisionThread = new Thread(null, new Runnable(){

            @Override
            public void run() {
                long startTime;
                long totalTime = startTime = System.currentTimeMillis();
                while (running) {
                    long timePassed = System.currentTimeMillis() - totalTime;
                    totalTime += timePassed;
                    if (paused) continue;
                    try {
                        for (Entity e : entities.values()) {
                            if (e instanceof Player && !((Player)e).isAlive()) continue;
                            e.collisionLogic();
                            e.reactionLogic(entities.values());
                            e.reactionLogic(mapEntities);
                        }
                        for (Entity e : mapEntities) {
                            e.collisionLogic();
                            e.reactionLogic(entities.values());
                            e.reactionLogic(mapEntities);
                        }
                    }
                    catch (ConcurrentModificationException e) {
                        continue;
                    }
                    try {
                        Thread.sleep(frameDelay);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }, "collision thread");
        updateThread = new Thread(null, new Runnable(){

            @Override
            public void run() {
                long startTime;
                long totalTime = startTime = System.currentTimeMillis();
                while (running) {
                    long timePassed = System.currentTimeMillis() - totalTime;
                    totalTime += timePassed;
                    if (paused) {
                        try {
                            Thread.sleep(frameDelay);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    try {
                        GameLogic.update(timePassed);
                    }
                    catch (ConcurrentModificationException e) {
                        // empty catch block
                    }
                    try {
                        Thread.sleep(frameDelay);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }, "update thread");
        collisionThread.start();
        updateThread.start();
    }

    public static synchronized void update(long timePassed) {
        try {
            for (Updatable u : updatables) {
                u.update(timePassed);
            }
            for (Updatable u : mapUpdatables) {
                u.update(timePassed);
            }
        }
        catch (ConcurrentModificationException e) {
            return;
        }
        if (NetplayServer.running) {
            NetplayServer.update();
        }
    }

    public static void startSpeedTimer(long duration, double newSpeed) {
        speedMultiplier = newSpeed;
        GameLogic.startDelayedAction(duration, new Runnable(){

            @Override
            public void run() {
                speedMultiplier = 1.0;
            }
        });
    }

    public static void startDelayedAction(long delay, Runnable action) {
        timerFutureActions.put(action, timer.schedule(action, delay, TimeUnit.MILLISECONDS));
    }

    public static void startDelayedRepeatingAction(long delay, Runnable action) {
        timerFutureActions.put(action, timer.scheduleAtFixedRate(action, delay, delay, TimeUnit.MILLISECONDS));
    }

    public static boolean containsDelayedAction(Runnable action) {
        return timerFutureActions.get(action) != null;
    }

    public static void removeDelayedAction(Runnable action) {
        ScheduledFuture<?> toRemove = timerFutureActions.get(action);
        if (toRemove != null) {
            System.out.println("Removed action: " + toRemove.cancel(false));
        }
        timerFutureActions.remove(action);
    }

    public static void cleanup() {
        running = false;
        options = null;
        running = false;
        gameWon = false;
        paused = false;
        entityCounter = new AtomicInteger();
        entities = new HashMap();
        updatables = new CopyOnWriteArraySet<Updatable>();
        mapEntities = new Vector<Entity>();
        mapUpdatables = new Vector<Updatable>();
        particles = new Vector<Particle>();
        currentMap = null;
        updateThread = null;
        collisionThread = null;
        playerOptions = null;
        playerOne = null;
        playerTwo = null;
        playerThree = null;
        playerFour = null;
        playerOneControls = null;
        playerTwoControls = null;
        playerThreeControls = null;
        playerFourControls = null;
        speedMultiplier = 1.0;
        random = new Random();
        usePTiles = new PhysicalTile[Map.DEF_REL_WIDTH][Map.DEF_REL_HEIGHT];
        gamemode = null;
        timer = new ScheduledThreadPoolExecutor(32);
        timerFutureActions = new Hashtable();
    }

    static {
        frameDelay = 16L;
        entityCounter = new AtomicInteger();
        entities = new HashMap();
        updatables = new CopyOnWriteArraySet<Updatable>();
        mapEntities = new Vector<Entity>();
        mapUpdatables = new Vector<Updatable>();
        particles = new Vector<Particle>();
        currentMap = null;
        playerOne = null;
        playerTwo = null;
        playerThree = null;
        playerFour = null;
        playerOneControls = null;
        playerTwoControls = null;
        playerThreeControls = null;
        playerFourControls = null;
        speedMultiplier = 1.0;
        random = new Random();
        usePTiles = new PhysicalTile[Map.DEF_REL_WIDTH][Map.DEF_REL_HEIGHT];
        timer = new ScheduledThreadPoolExecutor(32);
        timerFutureActions = new Hashtable();
        paused = false;
    }
}

