/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame;

import com.dmgame.SMWException;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;

public strictfp final class Geometry {
    private Geometry() throws SMWException {
        throw new SMWException("Illegal instantiation of the Geometry clss.");
    }

    public static int calculateVerticalCollision(Shape tile, Rectangle player, boolean fromBottom) {
        if (tile instanceof Rectangle) {
            Rectangle r = tile.getBounds();
            if (fromBottom) {
                return r.y + r.height;
            }
            return r.y - player.height;
        }
        if (tile instanceof Ellipse2D) {
            return Geometry.calculateVerticalEllipseCollision((Ellipse2D)tile, player, fromBottom);
        }
        if (tile instanceof Polygon) {
            Rectangle bbox = new Rectangle(player);
            Area tileArea = new Area(tile);
            int move = 0;
            if (fromBottom) {
                do {
                    ++bbox.y;
                    ++move;
                } while (tileArea.intersects(bbox));
                --move;
            } else {
                do {
                    --bbox.y;
                    --move;
                } while (tileArea.intersects(bbox));
                ++move;
            }
            if (move == -2) {
                move = -1;
            }
            return player.y + move;
        }
        return 0;
    }

    public static int calculateSideCollision(Shape tile, Rectangle player, boolean fromRight) {
        if (tile instanceof Rectangle) {
            Rectangle r = tile.getBounds();
            if (fromRight) {
                return r.x + r.width;
            }
            return r.x - player.width;
        }
        if (tile instanceof Ellipse2D) {
            return Geometry.calculateHorizontalEllipseCollision((Ellipse2D)tile, player, fromRight);
        }
        return 0;
    }

    private static int calculateVerticalEllipseCollision(Ellipse2D tile, Rectangle player, boolean fromBottom) {
        double y;
        double a = tile.getWidth() / 2.0;
        double b = tile.getHeight() / 2.0;
        if ((double)player.x >= tile.getCenterX() - (double)player.width && (double)player.x <= tile.getCenterX()) {
            if (fromBottom) {
                return (int)(tile.getY() + tile.getHeight());
            }
            return (int)(tile.getY() - (double)player.height);
        }
        int x = (int)((double)player.x - tile.getCenterX());
        if ((double)player.x <= tile.getCenterX()) {
            x += player.width;
        }
        if (Double.isNaN(y = b * Math.sqrt(1.0 - Math.pow((double)x / a, 2.0)))) {
            y = 0.0;
        }
        if (fromBottom) {
            return (int)(tile.getY() + tile.getHeight());
        }
        return (int)(tile.getCenterY() - (double)player.height - y);
    }

    private static int calculateHorizontalEllipseCollision(Ellipse2D tile, Rectangle player, boolean fromRight) {
        double a = tile.getWidth() / 2.0;
        double b = tile.getHeight() / 2.0;
        if ((double)player.y >= tile.getCenterY() - (double)player.height && (double)player.y <= tile.getCenterY()) {
            return fromRight ? (int)(tile.getX() + tile.getWidth()) : (int)(tile.getX() - (double)player.width);
        }
        int y = (int)((double)player.y - tile.getCenterY());
        double x = Math.abs(a * Math.sqrt(1.0 - Math.pow((double)y / b, 2.0)));
        return fromRight ? (int)(tile.getX() + tile.getWidth() - x) : (int)(tile.getCenterX() - x - (double)player.width);
    }
}

