/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame;

import com.dmgame.BitmapFont;
import com.dmgame.DevConsole;
import com.dmgame.EyeCandy;
import com.dmgame.GameLogic;
import com.dmgame.Scene;
import com.dmgame.Utility;
import com.dmgame.Version;
import com.dmgame.entity.AI;
import com.dmgame.entity.Entity;
import com.dmgame.entity.Player;
import com.dmgame.entity.logic.Logic;
import com.dmgame.entity.powerups.Starman;
import com.dmgame.gui.PlayerOptions;
import com.dmgame.gui.SMWButton;
import com.dmgame.gui.SMWInternalFrame;
import com.dmgame.gui.SMWLabel;
import com.dmgame.map.GraphicTile;
import com.dmgame.map.InteractiveTile;
import com.dmgame.map.Map;
import com.dmgame.map.OrderedTile;
import com.dmgame.map.PhysicalTile;
import com.dmgame.map.Platform;
import com.dmgame.map.Warp;
import com.dmgame.map.interactivetiles.DonutBlock;
import com.dmgame.menu.MenuScene;
import com.dmgame.menu.NetplayGamePanel;
import com.dmgame.modes.GameMode;
import com.dmgame.net.client.NetplayClient;
import com.dmgame.particle.Particle;
import com.dmgame.sound.Sound;
import com.dmgame.sound.SoundPlayer;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class MapScene
extends Scene
implements KeyListener {
    private static final long serialVersionUID = 1L;
    public static MapScene currentInstance = null;
    private volatile Thread renderThread;
    private volatile Thread eyeCandyThread;
    private TexturePaint background;
    private TexturePaint border;
    private TexturePaint menuBackground;
    private NetplayGamePanel prevPanel;
    private boolean drawDebug;
    public static Window w = null;
    public static Window fs = null;
    private DevConsole d;
    private BufferedImage shadeImage;
    private BufferedImage warpLock;
    private BitmapFont font;
    private BitmapFont score;
    private EyeCandy eyeCandyGenerator;
    private JPanel centeringPanel;
    private final SMWInternalFrame PAUSE_FRAME;
    private boolean started = false;

    public MapScene(String mapName, boolean drawDebug, boolean networkMode, String texturePackName, GameMode mode, PlayerOptions[] playerOptions, TexturePaint menuPaint) {
        GameLogic.start(mapName, networkMode, texturePackName, mode, playerOptions);
        this.startObject(drawDebug);
        this.menuBackground = menuPaint;
        this.PAUSE_FRAME = new SMWInternalFrame(640, 480);
        this.PAUSE_FRAME.setCenteredBounds(this);
    }

    public MapScene(Map map, boolean drawDebug, boolean networkMode, String texturePackName, GameMode mode, PlayerOptions[] playerOptions, TexturePaint menuPaint) {
        GameLogic.start(map, networkMode, texturePackName, mode, playerOptions);
        this.startObject(drawDebug);
        this.menuBackground = menuPaint;
        this.PAUSE_FRAME = new SMWInternalFrame(640, 480);
        this.PAUSE_FRAME.setCenteredBounds(this);
    }

    public MapScene(NetplayGamePanel prevPanel, Map map, boolean drawDebug, boolean networkMode, String texturePackName, GameMode mode, PlayerOptions[] playerOptions) {
        GameLogic.start(map, networkMode, texturePackName, mode, playerOptions);
        this.startObject(drawDebug);
        this.prevPanel = prevPanel;
        this.PAUSE_FRAME = new SMWInternalFrame(640, 480);
        this.PAUSE_FRAME.setCenteredBounds(this);
    }

    private void startObject(boolean drawDebug) {
        this.drawDebug = drawDebug;
        this.eyeCandyGenerator = null;
        try {
            this.font = new BitmapFont(ImageIO.read(new File("res/gfx/fonts/font.png")), "!\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_'abcdefghijklmnopqrstuvwxyz{|}~");
            this.score = new BitmapFont(ImageIO.read(new File("res/gfx/fonts/score.png")), "0123456789");
            BufferedImage borderImage = ImageIO.read(new File("res/gfx/packs/" + texturePackName + "/hud/border.png"));
            this.border = new TexturePaint(borderImage, new Rectangle(0, 0, borderImage.getWidth(), borderImage.getHeight()));
            this.eyeCandyGenerator = new EyeCandy();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BufferedImage compositeBackground = new BufferedImage(GameLogic.currentMap.background.getWidth(), GameLogic.currentMap.background.getHeight(), 2);
        Graphics2D g2D = compositeBackground.createGraphics();
        Rectangle r = new Rectangle(GameLogic.currentMap.background.getWidth(), GameLogic.currentMap.background.getHeight());
        g2D.setColor(GameLogic.currentMap.bgColor);
        g2D.fill(r);
        g2D.drawImage(GameLogic.currentMap.background, null, this);
        this.background = new TexturePaint(compositeBackground, r);
        g2D.dispose();
        try {
            this.shadeImage = ImageIO.read(new File("res/gfx/packs/" + texturePackName + "/hud/shade1.png"));
            this.warpLock = ImageIO.read(new File("res/gfx/packs/" + texturePackName + "/eyecandy/warplock.png"));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        currentInstance = this;
    }

    @Override
    public void init() {
        super.init();
        this.setLayout(null);
        this.PAUSE_FRAME.setLayout(new GridBagLayout());
        this.PAUSE_FRAME.setPreferredSize(new Dimension(320, 240));
        SMWButton back = new SMWButton(Utility.lang.getProperty("back"), 248, -1);
        back.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapScene.this.running = false;
                MapScene.this.cleanup();
                GameLogic.cleanup();
                GameLogic.paused = false;
            }
        });
        SMWButton resume = new SMWButton(Utility.lang.getProperty("continue"), 248, -1);
        resume.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapScene.this.remove(MapScene.this.PAUSE_FRAME);
                GameLogic.paused = false;
                SoundPlayer.playSound(Sound.PAUSE);
            }
        });
        SMWButton exit = new SMWButton(Utility.lang.getProperty("quit"), 248, -1);
        exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapScene.this.stop();
                System.exit(0);
            }
        });
        SMWLabel pauseLabel = new SMWLabel(Utility.lang.getProperty("pause"));
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.insets = new Insets(8, 0, 48, 0);
        c.anchor = 10;
        this.PAUSE_FRAME.add((Component)pauseLabel, c);
        c = new GridBagConstraints();
        c.gridy = 1;
        this.PAUSE_FRAME.add((Component)back, c);
        c = new GridBagConstraints();
        c.gridy = 2;
        this.PAUSE_FRAME.add((Component)resume, c);
        c = new GridBagConstraints();
        c.gridy = 3;
        this.PAUSE_FRAME.add((Component)exit, c);
        this.PAUSE_FRAME.validate();
        if (Version.isInReleaseMode()) {
            this.d = new DevConsole();
            this.d.setIconImage(this.windowIcon);
            this.d.start();
        }
        w = MapScene.s.windowFrame;
        fs = MapScene.s.fullScreenFrame;
        if (GameLogic.playerOne != null && !(GameLogic.playerOne instanceof AI)) {
            w.addKeyListener(GameLogic.playerOne);
            fs.addKeyListener(GameLogic.playerOne);
        }
        if (GameLogic.playerTwo != null && !(GameLogic.playerTwo instanceof AI)) {
            w.addKeyListener(GameLogic.playerTwo);
            fs.addKeyListener(GameLogic.playerTwo);
        }
        if (GameLogic.playerThree != null && !(GameLogic.playerThree instanceof AI)) {
            w.addKeyListener(GameLogic.playerThree);
            fs.addKeyListener(GameLogic.playerThree);
        }
        if (GameLogic.playerFour != null && !(GameLogic.playerFour instanceof AI)) {
            w.addKeyListener(GameLogic.playerFour);
            fs.addKeyListener(GameLogic.playerFour);
        }
        this.centeringPanel = new MapRenderer(new GridBagLayout());
        this.centeringPanel.setPreferredSize(new Dimension(GameLogic.currentMap.MAP_WIDTH, GameLogic.currentMap.MAP_HEIGHT));
        this.setPreferredSize(new Dimension(1024, 768));
        int width = this.centeringPanel.getPreferredSize().width;
        int height = this.centeringPanel.getPreferredSize().height;
        int x = this.getPreferredSize().width / 2 - width / 2;
        int y = this.getPreferredSize().height / 2 - height / 2;
        this.centeringPanel.setBounds(x, y, width, height);
        this.add(this.centeringPanel);
        this.containerPanel = this;
        this.add(this.centeringPanel);
        this.validate();
        w.setFocusTraversalKeysEnabled(false);
        w.addKeyListener(this);
        fs.setFocusTraversalKeysEnabled(false);
        fs.addKeyListener(this);
        w.setFont(new Font("Arial", 0, 20));
        w.setBackground(Color.BLACK);
        w.setForeground(Color.WHITE);
        fs.setFont(new Font("Arial", 0, 20));
        fs.setBackground(Color.BLACK);
        fs.setForeground(Color.WHITE);
        w.setFocusable(true);
        w.requestFocus();
        this.started = true;
        this.startMusic();
    }

    private void startMusic() {
        File musicFile = new File("res/music/game" + GameLogic.currentMap.specificSong);
        if (!musicFile.exists() || !musicFile.isFile()) {
            List<File> musicFiles = Utility.getMusicFilesInCategory(musicPackName, GameLogic.currentMap.musicCategory);
            int num = (int)(Math.random() * (double)musicFiles.size());
            musicFile = musicFiles.get(num);
        }
        SoundPlayer.playMusic(musicFile, true);
    }

    public static void reportVictory() {
        File musicFile = new File("res/music/game/" + musicPackName + "/stageclear.wav");
        SoundPlayer.playVictoryMusic(musicFile);
    }

    @Override
    public void gameLoop() {
        this.eyeCandyThread = new Thread(null, new Runnable(){

            @Override
            public void run() {
                long startTime;
                long totalTime = startTime = System.currentTimeMillis();
                while (MapScene.this.running) {
                    long timePassed = System.currentTimeMillis() - totalTime;
                    totalTime += timePassed;
                    if (GameLogic.paused) {
                        try {
                            Thread.sleep(16L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    MapScene.this.eyeCandyGenerator.update(timePassed);
                    try {
                        Thread.sleep(16L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }, "Eyecandy Thread");
        this.renderThread = new Thread(null, new Runnable(){

            @Override
            public void run() {
                long startTime;
                long totalTime = startTime = System.currentTimeMillis();
                while (MapScene.this.running) {
                    long timePassed = System.currentTimeMillis() - totalTime;
                    totalTime += timePassed;
                    MapScene.this.repaint();
                    try {
                        Thread.sleep(16L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }, "Render Thread");
        this.eyeCandyThread.start();
        this.renderThread.start();
    }

    @Override
    public synchronized void update(long timePassed) {
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.started) {
            Graphics2D g2D = (Graphics2D)g;
            g2D.setPaint(this.border);
            g2D.fill(new Rectangle(0, 0, this.getWidth(), this.getHeight()));
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        switch (keyCode) {
            case 27: {
                if (NetplayClient.running) break;
                GameLogic.paused = !GameLogic.paused;
                SoundPlayer.playSound(Sound.PAUSE);
                if (GameLogic.paused) {
                    this.PAUSE_FRAME.setCenteredBounds(this);
                    this.add((Component)this.PAUSE_FRAME, 0);
                    System.out.println(this.PAUSE_FRAME.getBounds());
                    this.validate();
                    break;
                }
                this.remove(this.PAUSE_FRAME);
                break;
            }
            case 112: {
                this.drawDebug = !this.drawDebug;
                break;
            }
            case 113: {
                this.takeScreenshot();
                break;
            }
            case 114: {
                new Starman(0.0f, 0.0f).spawn();
            }
            case 115: {
                if (!s.isFullscreen()) break;
                MapScene.s.fullScreenFrame.remove(this);
                MapScene.s.windowFrame.add(this);
                MapScene.s.windowFrame.validate();
                s.setWindowed();
                break;
            }
            case 116: {
                if (s.isFullscreen()) break;
                MapScene.s.windowFrame.remove(this);
                MapScene.s.fullScreenFrame.add(this);
                MapScene.s.fullScreenFrame.validate();
                s.setFullscreen(this.mode);
                break;
            }
            case 120: {
                this.setGameScale(0.625);
                break;
            }
            case 121: {
                this.setGameScale(0.78125);
                break;
            }
            case 122: {
                this.setGameScale(1.0);
                break;
            }
            case 10: {
                if (!GameLogic.gameWon) break;
                if (NetplayClient.running) {
                    NetplayClient.sendGameComplete();
                }
                this.running = false;
                this.cleanup();
                GameLogic.cleanup();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        e.consume();
    }

    @Override
    public void keyTyped(KeyEvent e) {
        e.consume();
    }

    private void takeScreenshot() {
        try {
            BufferedImage screenshot = new BufferedImage(GameLogic.currentMap.MAP_WIDTH, GameLogic.currentMap.MAP_HEIGHT, 2);
            this.paintComponent(screenshot.createGraphics());
            ImageIO.write((RenderedImage)screenshot, "png", new File("res/screenshots/" + GameLogic.currentMap.mapName + "_" + screenshotName + ".png"));
            ++screenshotName;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void cleanup() {
        if (GameLogic.gameWon) {
            SoundPlayer.stopVictoryMusic();
        } else {
            SoundPlayer.stopMusic();
        }
        w.removeKeyListener(this);
        fs.removeKeyListener(this);
        currentInstance = null;
        this.running = false;
        this.eyeCandyGenerator = null;
        s.switchScene(this.prevPanel != null ? new MenuScene(this.prevPanel) : new MenuScene(this.menuBackground, GameLogic.playerOptions));
    }

    public void setGameScale(double windowScale) {
        this.windowScale = windowScale;
        this.setPreferredSize(new Dimension((int)(1024.0 * windowScale), (int)(768.0 * windowScale)));
        MapScene.s.windowFrame.pack();
    }

    class MapRenderer
    extends JPanel {
        private static final long serialVersionUID = -846911250417816613L;

        public MapRenderer(LayoutManager m) {
            super(m);
        }

        @Override
        public synchronized void paintComponent(Graphics g) {
            int len$;
            int i$;
            int drawY;
            if (!GameLogic.running) {
                return;
            }
            Graphics2D g2D = (Graphics2D)g;
            if (!Scene.s.isFullscreen()) {
                g2D.scale(MapScene.this.windowScale, MapScene.this.windowScale);
            }
            if (MapScene.this.background != null) {
                Paint p = g2D.getPaint();
                g2D.setPaint(MapScene.this.background);
                g2D.fill(new Rectangle(0, 0, GameLogic.currentMap.MAP_WIDTH, GameLogic.currentMap.MAP_HEIGHT));
                g2D.setPaint(p);
            } else {
                g2D.setColor(GameLogic.currentMap.bgColor);
                g2D.fill(new Rectangle(0, 0, GameLogic.currentMap.MAP_WIDTH, GameLogic.currentMap.MAP_HEIGHT));
            }
            if (GameLogic.playerOne != null && GameLogic.playerOne.isInWarp()) {
                GameLogic.playerOne.drawToScreen(g2D, GameLogic.playerOne.entityX, GameLogic.playerOne.entityY);
                if (MapScene.this.drawDebug) {
                    g2D.setColor(Color.BLUE);
                    int drawX = GameLogic.playerOne.x / 32;
                    drawY = (int)Math.floor(GameLogic.playerOne.y / 32);
                    if (GameLogic.playerOne.facingRight) {
                        ++drawX;
                    }
                    g2D.draw(new Rectangle(drawX * 32, drawY * 32, 32, 32));
                    g2D.setColor(Color.GREEN);
                    g2D.draw(GameLogic.playerOne);
                    if (GameLogic.playerOne.debugWarps != null) {
                        System.out.println("drawing debug warps");
                        Warp[][][] arr$ = GameLogic.playerOne.debugWarps;
                        int len$2 = arr$.length;
                        for (int i$2 = 0; i$2 < len$2; ++i$2) {
                            Warp[][] warp2d;
                            Warp[][] arr$2 = warp2d = arr$[i$2];
                            int len$3 = arr$2.length;
                            for (int i$3 = 0; i$3 < len$3; ++i$3) {
                                Warp[] warp1d;
                                for (Warp warp : warp1d = arr$2[i$3]) {
                                    if (warp == null) continue;
                                    warp.changeColor(warp.id);
                                    System.out.println("drawing warp: " + warp);
                                    g2D.drawImage((Image)warp.sprite, GameLogic.playerOne.x, GameLogic.playerOne.y, this);
                                }
                            }
                        }
                    }
                }
            }
            if (GameLogic.playerTwo != null && GameLogic.playerTwo.isInWarp()) {
                GameLogic.playerTwo.drawToScreen(g2D, GameLogic.playerTwo.entityX, GameLogic.playerTwo.entityY);
                if (MapScene.this.drawDebug) {
                    g2D.setColor(Color.BLUE);
                    int drawX = GameLogic.playerTwo.x / 32;
                    drawY = (int)Math.floor(GameLogic.playerTwo.y / 32);
                    if (GameLogic.playerTwo.facingRight) {
                        ++drawX;
                    }
                    g2D.draw(new Rectangle(drawX * 32, drawY * 32, 32, 32));
                    g2D.setColor(Color.GREEN);
                    g2D.draw(GameLogic.playerTwo);
                }
            }
            if (GameLogic.playerThree != null && GameLogic.playerThree.isInWarp()) {
                GameLogic.playerThree.drawToScreen(g2D, GameLogic.playerThree.entityX, GameLogic.playerThree.entityY);
                if (MapScene.this.drawDebug) {
                    g2D.setColor(Color.BLUE);
                    int drawX = GameLogic.playerThree.x / 32;
                    drawY = (int)Math.floor(GameLogic.playerThree.y / 32);
                    if (GameLogic.playerThree.facingRight) {
                        ++drawX;
                    }
                    g2D.draw(new Rectangle(drawX * 32, drawY * 32, 32, 32));
                    g2D.setColor(Color.GREEN);
                    g2D.draw(GameLogic.playerThree);
                }
            }
            if (GameLogic.playerFour != null && GameLogic.playerFour.isInWarp()) {
                GameLogic.playerFour.drawToScreen(g2D, GameLogic.playerFour.entityX, GameLogic.playerFour.entityY);
                if (MapScene.this.drawDebug) {
                    g2D.setColor(Color.BLUE);
                    int drawX = GameLogic.playerFour.x / 32;
                    drawY = (int)Math.floor(GameLogic.playerFour.y / 32);
                    if (GameLogic.playerFour.facingRight) {
                        ++drawX;
                    }
                    g2D.draw(new Rectangle(drawX * 32, drawY * 32, 32, 32));
                    g2D.setColor(Color.GREEN);
                    g2D.draw(GameLogic.playerFour);
                }
            }
            for (OrderedTile[][] tiles : GameLogic.currentMap.tilesBackground) {
                this.paintTileArray(0, 0, tiles, g2D);
            }
            for (Platform plat : GameLogic.currentMap.platforms) {
                if (plat instanceof DonutBlock.DonutPlatform) {
                    this.paintPlatformArray(plat.getCurrentX() - 32, plat.getCurrentY() - 32, plat.gTiles, g2D);
                    continue;
                }
                this.paintPlatformArray(plat.getCurrentX(), plat.getCurrentY(), plat.gTiles, g2D);
            }
            Integer[] keys = GameLogic.entities.keySet().toArray(new Integer[1]);
            if (keys != null) {
                Integer[] arr$ = keys;
                int len$4 = arr$.length;
                for (i$ = 0; i$ < len$4; ++i$) {
                    int i = arr$[i$];
                    Entity e = GameLogic.entities.get(i);
                    if (e == null || e.equals(GameLogic.playerOne) && GameLogic.playerOne.isInWarp() || e.equals(GameLogic.playerTwo) && GameLogic.playerTwo.isInWarp() || e.equals(GameLogic.playerThree) && GameLogic.playerThree.isInWarp() || e.equals(GameLogic.playerFour) && GameLogic.playerFour.isInWarp()) continue;
                    e.drawToScreen(g2D, e.entityX, e.entityY);
                    if (!MapScene.this.drawDebug) continue;
                    g2D.setColor(Color.BLUE);
                    int drawX = e.x / 32;
                    int drawY2 = (int)Math.floor(e.y / 32);
                    if (e.facingRight) {
                        ++drawX;
                    }
                    g2D.draw(new Rectangle(drawX * 32, drawY2 * 32, 32, 32));
                    g2D.setColor(Color.GREEN);
                    g2D.draw(e);
                }
            }
            for (Entity e : GameLogic.mapEntities) {
                e.drawToScreen(g2D, e.entityX, e.entityY);
                if (!MapScene.this.drawDebug) continue;
                g2D.setColor(Color.BLUE);
                int drawX = e.x / 32;
                int drawY3 = (int)Math.floor(e.y / 32);
                g2D.draw(new Rectangle(drawX * 32, drawY3 * 32, 32, 32));
                g2D.setColor(Color.GREEN);
                g2D.draw(e);
            }
            for (OrderedTile[][] tiles : GameLogic.currentMap.tilesForeground) {
                this.paintTileArray(0, 0, tiles, g2D);
            }
            InteractiveTile[][] arr$ = GameLogic.currentMap.iTiles;
            int len$5 = arr$.length;
            for (i$ = 0; i$ < len$5; ++i$) {
                InteractiveTile[] array;
                for (InteractiveTile iTile : array = arr$[i$]) {
                    if (iTile == null) continue;
                    g2D.drawImage((Image)iTile.getImage(), (int)iTile.mapX, (int)iTile.mapY, null);
                }
            }
            this.paintWarpLocks(g2D);
            for (Platform plat : GameLogic.currentMap.platforms) {
                InteractiveTile[][] arr$3 = plat.iTiles;
                len$ = arr$3.length;
                for (int i$4 = 0; i$4 < len$; ++i$4) {
                    InteractiveTile[] array;
                    for (InteractiveTile iTile : array = arr$3[i$4]) {
                        if (iTile == null) continue;
                        g2D.drawImage((Image)iTile.getImage(), (int)(iTile.mapX + iTile.platOffsetX), (int)(iTile.mapY + iTile.platOffsetY), null);
                    }
                }
            }
            for (Particle part : GameLogic.particles) {
                g2D.drawImage((Image)part.getImage(), (int)part.x, (int)part.y, null);
            }
            MapScene.this.eyeCandyGenerator.drawEyeCandy(g2D);
            for (Platform platform : GameLogic.currentMap.platforms) {
                if (!MapScene.this.drawDebug) continue;
                g2D.draw(platform);
                PhysicalTile[][] arr$4 = platform.pTiles;
                len$ = arr$4.length;
                for (int i$5 = 0; i$5 < len$; ++i$5) {
                    PhysicalTile[] array;
                    for (PhysicalTile pTile : array = arr$4[i$5]) {
                        if (pTile == null) continue;
                        g2D.draw(pTile.mask);
                    }
                }
            }
            this.paintHUD(g2D);
            if (MapScene.this.d != null && MapScene.this.d.hasErrors()) {
                MapScene.this.font.drawString(g2D, "Check debug console!", 4.0f, 32.0f);
            }
            if (MapScene.this.drawDebug) {
                Logic.AlertObject target;
                g2D.setColor(Color.RED);
                arr$ = GameLogic.currentMap.warps;
                len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    InteractiveTile[] primaryWarps;
                    InteractiveTile[] arr$5 = primaryWarps = arr$[i$];
                    int len$6 = arr$5.length;
                    for (int i$6 = 0; i$6 < len$6; ++i$6) {
                        InteractiveTile secondaryWarps;
                        for (InteractiveTile w : secondaryWarps = arr$5[i$6]) {
                            if (w == null) continue;
                            g2D.setColor(((Warp)((Object)w)).id);
                            g2D.fill(((Warp)((Object)w)).getBBox());
                        }
                    }
                }
                g2D.setColor(Color.BLACK);
                if (GameLogic.playerOne.entryWarp != null) {
                    g2D.fill(GameLogic.playerOne.entryWarp.getBBox());
                }
                if (GameLogic.playerTwo != null && GameLogic.playerTwo instanceof AI) {
                    g2D.setColor(Color.GREEN);
                    target = ((AI)GameLogic.playerTwo).getCurrentFocus();
                    g2D.fillOval((int)target.getTargetX(), (int)target.getTargetY(), 16, 16);
                }
                if (GameLogic.playerThree != null && GameLogic.playerThree instanceof AI) {
                    g2D.setColor(Color.YELLOW);
                    target = ((AI)GameLogic.playerThree).getCurrentFocus();
                    g2D.fillOval((int)target.getTargetX(), (int)target.getTargetY(), 16, 16);
                }
                if (GameLogic.playerFour != null && GameLogic.playerFour instanceof AI) {
                    g2D.setColor(Color.BLUE);
                    target = ((AI)GameLogic.playerFour).getCurrentFocus();
                    g2D.fillOval((int)target.getTargetX(), (int)target.getTargetY(), 16, 16);
                }
            }
            g2D.dispose();
        }

        private synchronized void paintTileArray(int xloc, int yloc, OrderedTile[][] tiles, Graphics2D g2D) {
            for (int x = 0; x < tiles.length; ++x) {
                for (int y = 0; y < tiles[x].length; ++y) {
                    if (tiles[x][y] == null || tiles[x][y].getUnclonedGraphicTile() == null) continue;
                    g2D.drawImage((Image)tiles[x][y].getUnclonedGraphicTile().getImage(), xloc + x * 32, yloc + y * 32, null);
                }
            }
        }

        private synchronized void paintPlatformArray(int xloc, int yloc, GraphicTile[][] tiles, Graphics2D g2D) {
            for (int x = 0; x < tiles.length; ++x) {
                for (int y = 0; y < tiles[x].length; ++y) {
                    if (tiles[x][y] == null) continue;
                    g2D.drawImage((Image)tiles[x][y].getImage(), xloc + x * 32 + 32, yloc + y * 32 + 32, null);
                }
            }
        }

        private synchronized void paintHUD(Graphics2D g2D) {
            if (GameLogic.playerOne != null) {
                this.paintPlayerInfo(g2D, GameLogic.playerOne, 0, 0);
            }
            if (GameLogic.playerTwo != null) {
                this.paintPlayerInfo(g2D, GameLogic.playerTwo, MapScene.this.shadeImage.getWidth() + 8, 0);
            }
            if (GameLogic.playerThree != null) {
                this.paintPlayerInfo(g2D, GameLogic.playerThree, MapScene.this.shadeImage.getWidth() * 2 + 16, 0);
            }
            if (GameLogic.playerFour != null) {
                this.paintPlayerInfo(g2D, GameLogic.playerFour, MapScene.this.shadeImage.getWidth() * 3 + 24, 0);
            }
        }

        private synchronized void paintPlayerInfo(Graphics2D g2D, Player player, int offX, int offY) {
            Composite oldComposite = g2D.getComposite();
            g2D.setComposite(AlphaComposite.getInstance(10, 0.6f));
            g2D.drawImage((Image)MapScene.this.shadeImage, offX + 8, offY + 8, null);
            g2D.setComposite(oldComposite);
            g2D.drawImage((Image)player.getHUDImage(), offX + 10, offY + 10, null);
            MapScene.this.score.drawString(g2D, Integer.toString(player.getScore()), offX + 45, 11.5f);
        }

        private synchronized void paintWarpLocks(Graphics2D g2D) {
            int y;
            int x;
            Warp w;
            if (GameLogic.playerOne != null && GameLogic.playerOne.isInWarp()) {
                w = GameLogic.playerOne.getEntryWarp();
                if (Warp.canWarpsCombine(w, GameLogic.currentMap.warps[w.colorID][w.mapRelX + 1][w.mapRelY])) {
                    x = Math.round(w.useX + 16.0f);
                    y = Math.round(w.useY);
                } else if (Warp.canWarpsCombine(w, GameLogic.currentMap.warps[w.colorID][w.mapRelX - 1][w.mapRelY])) {
                    x = Math.round(w.useX - 16.0f);
                    y = Math.round(w.useY);
                } else if (Warp.canWarpsCombine(w, GameLogic.currentMap.warps[w.colorID][w.mapRelX][w.mapRelY + 1])) {
                    x = Math.round(w.useX);
                    y = Math.round(w.useY + 16.0f);
                } else if (Warp.canWarpsCombine(w, GameLogic.currentMap.warps[w.colorID][w.mapRelX][w.mapRelY - 1])) {
                    x = Math.round(w.useX);
                    y = Math.round(w.useY - 16.0f);
                } else {
                    x = Math.round(w.useX);
                    y = Math.round(w.useY);
                }
                g2D.drawImage((Image)MapScene.this.warpLock, x, y, null);
                w = GameLogic.playerOne.getDestinationWarp();
                g2D.drawImage((Image)MapScene.this.warpLock, Math.round(w.useX), Math.round(w.useY), null);
            }
            if (GameLogic.playerTwo != null && GameLogic.playerTwo.isInWarp()) {
                w = GameLogic.playerTwo.getEntryWarp();
                if (Warp.canWarpsCombine(w, GameLogic.currentMap.warps[w.colorID][w.mapRelX + 1][w.mapRelY])) {
                    x = Math.round(w.useX + 16.0f);
                    y = Math.round(w.useY);
                } else if (Warp.canWarpsCombine(w, GameLogic.currentMap.warps[w.colorID][w.mapRelX - 1][w.mapRelY])) {
                    x = Math.round(w.useX - 16.0f);
                    y = Math.round(w.useY);
                } else if (Warp.canWarpsCombine(w, GameLogic.currentMap.warps[w.colorID][w.mapRelX][w.mapRelY + 1])) {
                    x = Math.round(w.useX);
                    y = Math.round(w.useY + 16.0f);
                } else if (Warp.canWarpsCombine(w, GameLogic.currentMap.warps[w.colorID][w.mapRelX][w.mapRelY - 1])) {
                    x = Math.round(w.useX);
                    y = Math.round(w.useY - 16.0f);
                } else {
                    x = Math.round(w.useX);
                    y = Math.round(w.useY);
                }
                g2D.drawImage((Image)MapScene.this.warpLock, x, y, null);
                w = GameLogic.playerTwo.getDestinationWarp();
                g2D.drawImage((Image)MapScene.this.warpLock, Math.round(w.useX), Math.round(w.useY), null);
            }
            if (GameLogic.playerThree != null && GameLogic.playerThree.isInWarp()) {
                w = GameLogic.playerThree.getEntryWarp();
                if (Warp.canWarpsCombine(w, GameLogic.currentMap.warps[w.colorID][w.mapRelX + 1][w.mapRelY])) {
                    x = Math.round(w.useX + 16.0f);
                    y = Math.round(w.useY);
                } else if (Warp.canWarpsCombine(w, GameLogic.currentMap.warps[w.colorID][w.mapRelX - 1][w.mapRelY])) {
                    x = Math.round(w.useX - 16.0f);
                    y = Math.round(w.useY);
                } else if (Warp.canWarpsCombine(w, GameLogic.currentMap.warps[w.colorID][w.mapRelX][w.mapRelY + 1])) {
                    x = Math.round(w.useX);
                    y = Math.round(w.useY + 16.0f);
                } else if (Warp.canWarpsCombine(w, GameLogic.currentMap.warps[w.colorID][w.mapRelX][w.mapRelY - 1])) {
                    x = Math.round(w.useX);
                    y = Math.round(w.useY - 16.0f);
                } else {
                    x = Math.round(w.useX);
                    y = Math.round(w.useY);
                }
                g2D.drawImage((Image)MapScene.this.warpLock, x, y, null);
                w = GameLogic.playerThree.getDestinationWarp();
                g2D.drawImage((Image)MapScene.this.warpLock, Math.round(w.useX), Math.round(w.useY), null);
            }
            if (GameLogic.playerFour != null && GameLogic.playerFour.isInWarp()) {
                w = GameLogic.playerFour.getEntryWarp();
                if (Warp.canWarpsCombine(w, GameLogic.currentMap.warps[w.colorID][w.mapRelX + 1][w.mapRelY])) {
                    x = Math.round(w.useX + 16.0f);
                    y = Math.round(w.useY);
                } else if (Warp.canWarpsCombine(w, GameLogic.currentMap.warps[w.colorID][w.mapRelX - 1][w.mapRelY])) {
                    x = Math.round(w.useX - 16.0f);
                    y = Math.round(w.useY);
                } else if (Warp.canWarpsCombine(w, GameLogic.currentMap.warps[w.colorID][w.mapRelX][w.mapRelY + 1])) {
                    x = Math.round(w.useX);
                    y = Math.round(w.useY + 16.0f);
                } else if (Warp.canWarpsCombine(w, GameLogic.currentMap.warps[w.colorID][w.mapRelX][w.mapRelY - 1])) {
                    x = Math.round(w.useX);
                    y = Math.round(w.useY - 16.0f);
                } else {
                    x = Math.round(w.useX);
                    y = Math.round(w.useY);
                }
                g2D.drawImage((Image)MapScene.this.warpLock, x, y, null);
                w = GameLogic.playerFour.getDestinationWarp();
                g2D.drawImage((Image)MapScene.this.warpLock, Math.round(w.useX), Math.round(w.useY), null);
            }
        }
    }
}

