/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame;

import com.dmgame.Updatable;
import com.dmgame.Utility;
import com.dmgame.net.client.NetplayClient;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.io.Serializable;

public strictfp final class PathFollower
implements Serializable,
Updatable {
    private static final long serialVersionUID = 5875532316722436736L;
    private Shape path;
    private transient PathIterator iterator;
    private boolean reverse;
    private transient boolean polygonOverride;
    private double startTime;
    private double speed;
    private transient float time;
    private Point2D.Float controlPoint;
    private Point2D.Float currentPoint;
    private Point2D.Float startPoint;
    private final int MAX_NUM_CYCLES;
    private int currentCycle;

    public PathFollower(Shape path, boolean reverse, double speed) {
        this(path, reverse, speed, 0.0, -1);
    }

    public PathFollower(Shape path, boolean reverse, double speed, double startTime) {
        this(path, reverse, speed, startTime, -1);
    }

    public PathFollower(Shape path, boolean reverse, double speed, double startTime, int numCycles) {
        while (speed > 1.0) {
            speed *= 0.1;
        }
        this.path = path;
        this.reverse = reverse;
        this.startTime = startTime;
        this.speed = speed * 0.01;
        this.MAX_NUM_CYCLES = numCycles > 0 ? numCycles * 4 : numCycles;
        this.currentCycle = 0;
        this.reset();
    }

    public Point2D.Float getStartPoint() {
        return this.startPoint;
    }

    public PathIterator getPathIterator() {
        return this.reverse ? ReversePathIterator.getReversePathIterator(this.path) : this.path.getPathIterator(null);
    }

    public boolean isReversed() {
        return this.reverse;
    }

    public void reverseAndReset() {
        this.reverse = !this.reverse;
        this.reset();
    }

    public Point2D.Float getCurrentPoint() {
        return this.currentPoint;
    }

    public void reset() {
        this.iterator = this.getPathIterator();
        this.time = 0.0f;
        this.currentPoint = this.startPoint = (this.controlPoint = this.getStartingPoint());
    }

    public boolean isDone() {
        return this.MAX_NUM_CYCLES == -1 ? false : this.currentCycle > this.MAX_NUM_CYCLES;
    }

    public int getCurrentCycle() {
        return this.currentCycle;
    }

    @Override
    public void update(long timePassed) {
        Point2D.Float pointOnPath;
        int segment;
        if (this.MAX_NUM_CYCLES > 0) {
            if (Utility.approxEquals(this.currentPoint, this.startPoint)) {
                ++this.currentCycle;
            }
            if (this.currentCycle > this.MAX_NUM_CYCLES) {
                return;
            }
        }
        if (NetplayClient.running) {
            return;
        }
        this.time = (float)((double)this.time + this.speed);
        double[] cp = new double[6];
        if (this.time > 1.0f) {
            if (this.path instanceof Line2D) {
                this.reverseAndReset();
                return;
            }
            this.time -= 1.0f;
            segment = this.iterator.currentSegment(cp);
            if (segment == 3) {
                this.controlPoint.setLocation(cp[4], cp[5]);
            } else if (segment == 2) {
                this.controlPoint.setLocation(cp[2], cp[3]);
            } else if (segment == 1 || segment == 0) {
                this.controlPoint.setLocation(cp[0], cp[1]);
            }
            this.iterator.next();
            segment = this.iterator.currentSegment(cp);
            if (this.polygonOverride) {
                this.polygonOverride = false;
                this.iterator = this.getPathIterator();
                segment = this.iterator.currentSegment(cp);
                this.controlPoint.setLocation(cp[0], cp[1]);
                this.iterator.next();
                segment = this.iterator.currentSegment(cp);
            }
        }
        if ((segment = this.iterator.currentSegment(cp)) == 4) {
            if (!(this.path instanceof Polygon)) {
                this.iterator = this.getPathIterator();
                segment = this.iterator.currentSegment(cp);
                this.controlPoint.setLocation(cp[0], cp[1]);
                this.iterator.next();
            } else {
                Point2D.Float pointOnPath2;
                this.polygonOverride = true;
                double[] points = new double[6];
                int type = 1;
                Polygon poly = (Polygon)this.path;
                this.controlPoint = new Point2D.Float(poly.xpoints[poly.npoints - 1], poly.ypoints[poly.npoints - 1]);
                points[0] = poly.xpoints[0];
                points[1] = poly.ypoints[0];
                this.currentPoint = pointOnPath2 = PathFollower.getPointOnPath(type, points, this.time, this.controlPoint);
                return;
            }
        }
        double[] points = new double[6];
        int type = this.iterator.currentSegment(points);
        this.currentPoint = pointOnPath = PathFollower.getPointOnPath(type, points, this.time, this.controlPoint);
    }

    private Point2D.Float getStartingPoint() {
        if (this.path instanceof Polygon) {
            Polygon poly = (Polygon)this.path;
            return new Point2D.Float(poly.xpoints[0], poly.ypoints[0]);
        }
        Point2D.Float startPoint = null;
        this.iterator = this.getPathIterator();
        int segments = 0;
        double[] coords = new double[6];
        this.iterator.currentSegment(coords);
        this.iterator.next();
        while (!this.iterator.isDone()) {
            int type = this.iterator.currentSegment(new double[6]);
            if (type != 4 && type != 0) {
                ++segments;
            }
            this.iterator.next();
        }
        double startVal = this.startTime * (double)segments;
        this.iterator = this.getPathIterator();
        int i = 0;
        i = 0;
        while ((double)i <= startVal - 1.0) {
            this.iterator.next();
            if (this.iterator.currentSegment(new double[6]) == 0) {
                ++i;
            }
            ++i;
        }
        switch (this.iterator.currentSegment(coords)) {
            case 0: 
            case 1: {
                startPoint = new Point2D.Float((float)coords[0], (float)coords[1]);
                break;
            }
            case 2: {
                startPoint = new Point2D.Float((float)coords[2], (float)coords[3]);
                break;
            }
            case 3: {
                startPoint = new Point2D.Float((float)coords[4], (float)coords[5]);
            }
        }
        this.iterator.next();
        startVal -= (double)((int)startVal);
        int type = this.iterator.currentSegment(coords);
        this.time = (float)startVal;
        return PathFollower.getPointOnPath(type, coords, startVal, startPoint);
    }

    public static Point2D.Float getPointOnPath(int type, double[] points, double t, Point2D.Float start) {
        double x;
        double y;
        switch (type) {
            case 1: {
                y = PathFollower.funcB(1, 0, t) * start.getY() + PathFollower.funcB(1, 1, t) * points[1];
                x = PathFollower.funcB(1, 0, t) * start.getX() + PathFollower.funcB(1, 1, t) * points[0];
                break;
            }
            case 2: {
                y = PathFollower.funcB(2, 0, t) * start.getY() + PathFollower.funcB(2, 1, t) * points[1] + PathFollower.funcB(2, 2, t) * points[3];
                x = PathFollower.funcB(2, 0, t) * start.getX() + PathFollower.funcB(2, 1, t) * points[0] + PathFollower.funcB(2, 2, t) * points[2];
                break;
            }
            case 3: {
                y = PathFollower.funcB(3, 0, t) * start.getY() + PathFollower.funcB(3, 1, t) * points[1] + PathFollower.funcB(3, 2, t) * points[3] + PathFollower.funcB(3, 3, t) * points[5];
                x = PathFollower.funcB(3, 0, t) * start.getX() + PathFollower.funcB(3, 1, t) * points[0] + PathFollower.funcB(3, 2, t) * points[2] + PathFollower.funcB(3, 3, t) * points[4];
                break;
            }
            default: {
                return new Point2D.Float();
            }
        }
        return new Point2D.Float((float)x, (float)y);
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }

    private static double funcB(int n, int m, double t) {
        return PathFollower.funcC(n, m) * Math.pow(t, m) * Math.pow(1.0 - t, n - m);
    }

    private static double funcC(int n, int m) {
        return PathFollower.factorial(n) / (PathFollower.factorial(m) * PathFollower.factorial(n - m));
    }

    private static double factorial(int f) {
        return f == 0 ? 1.0 : (double)f * PathFollower.factorial(f - 1);
    }

    public strictfp static class ReversePathIterator
    implements PathIterator {
        private final int windingRule;
        private final double[] coordinates;
        private final int[] segmentTypes;
        private int coordIndex = 0;
        private int segmentIndex = 0;

        public static PathIterator getReversePathIterator(Shape shape) {
            return new ReversePathIterator(shape.getPathIterator(null));
        }

        public static PathIterator getReversePathIterator(Shape shape, double flatness) {
            return new ReversePathIterator(shape.getPathIterator(null, flatness));
        }

        public static PathIterator getReversePathIterator(Shape shape, AffineTransform at) {
            return new ReversePathIterator(shape.getPathIterator(at));
        }

        public static PathIterator getReversePathIterator(Shape shape, AffineTransform at, double flatness) {
            return new ReversePathIterator(shape.getPathIterator(at, flatness));
        }

        public static PathIterator getReversePathIterator(Shape shape, int windingRule) {
            return new ReversePathIterator(shape.getPathIterator(null), windingRule);
        }

        public static PathIterator getReversePathIterator(Shape shape, double flatness, int windingRule) {
            return new ReversePathIterator(shape.getPathIterator(null, flatness), windingRule);
        }

        public static PathIterator getReversePathIterator(Shape shape, AffineTransform at, int windingRule) {
            return new ReversePathIterator(shape.getPathIterator(at), windingRule);
        }

        public static PathIterator getReversePathIterator(Shape shape, AffineTransform at, double flatness, int windingRule) {
            return new ReversePathIterator(shape.getPathIterator(at, flatness), windingRule);
        }

        public ReversePathIterator(PathIterator original) {
            this(original, original.getWindingRule());
        }

        public ReversePathIterator(PathIterator original, int windingRule) {
            this.windingRule = windingRule;
            double[] coords = new double[16];
            int coordPos = 0;
            int[] segTypes = new int[8];
            int segPos = 0;
            boolean first = true;
            double[] temp = new double[6];
            while (!original.isDone()) {
                int copy;
                if (segPos == segTypes.length) {
                    int[] dummy = new int[2 * segPos];
                    System.arraycopy(segTypes, 0, dummy, 0, segPos);
                    segTypes = dummy;
                }
                int n = segPos++;
                int n2 = original.currentSegment(temp);
                segTypes[n] = n2;
                int segType = n2;
                if (first) {
                    if (segType != 0) {
                        throw new IllegalPathStateException("missing initial moveto in path definition");
                    }
                    first = false;
                }
                switch (segType) {
                    case 0: 
                    case 1: {
                        copy = 2;
                        break;
                    }
                    case 2: {
                        copy = 4;
                        break;
                    }
                    case 3: {
                        copy = 6;
                        break;
                    }
                    default: {
                        copy = 0;
                    }
                }
                if (copy > 0) {
                    if (coordPos + copy > coords.length) {
                        double[] dummy = new double[coords.length * 2];
                        System.arraycopy(coords, 0, dummy, 0, coords.length);
                        coords = dummy;
                    }
                    for (int c = 0; c < copy; ++c) {
                        coords[coordPos++] = temp[c];
                    }
                }
                original.next();
            }
            this.coordinates = new double[coordPos];
            for (int p = coordPos / 2 - 1; p >= 0; --p) {
                this.coordinates[2 * p] = coords[coordPos - 2 * p - 2];
                this.coordinates[2 * p + 1] = coords[coordPos - 2 * p - 1];
            }
            this.segmentTypes = new int[segPos];
            if (segPos > 0) {
                boolean pendingClose = false;
                int sr = 0;
                this.segmentTypes[sr++] = 0;
                block12: for (int s = segPos - 1; s > 0; --s) {
                    switch (segTypes[s]) {
                        case 0: {
                            if (pendingClose) {
                                pendingClose = false;
                                this.segmentTypes[sr++] = 4;
                            }
                            this.segmentTypes[sr++] = 0;
                            continue block12;
                        }
                        case 4: {
                            pendingClose = true;
                            continue block12;
                        }
                        default: {
                            this.segmentTypes[sr++] = segTypes[s];
                        }
                    }
                }
                if (pendingClose) {
                    this.segmentTypes[sr] = 4;
                }
            }
        }

        @Override
        public int getWindingRule() {
            return this.windingRule;
        }

        private static int coordinatesForSegmentType(int segtype) {
            switch (segtype) {
                case 0: 
                case 1: {
                    return 2;
                }
                case 2: {
                    return 4;
                }
                case 3: {
                    return 6;
                }
            }
            return 0;
        }

        @Override
        public void next() {
            this.coordIndex += ReversePathIterator.coordinatesForSegmentType(this.segmentTypes[this.segmentIndex++]);
        }

        @Override
        public boolean isDone() {
            return this.segmentIndex >= this.segmentTypes.length;
        }

        @Override
        public int currentSegment(double[] coords) {
            int segmentType = this.segmentTypes[this.segmentIndex];
            int copy = ReversePathIterator.coordinatesForSegmentType(segmentType);
            if (copy > 0) {
                System.arraycopy(this.coordinates, this.coordIndex, coords, 0, copy);
            }
            return segmentType;
        }

        @Override
        public int currentSegment(float[] coords) {
            int segmentType = this.segmentTypes[this.segmentIndex];
            int copy = ReversePathIterator.coordinatesForSegmentType(segmentType);
            if (copy > 0) {
                for (int c = 0; c < copy; ++c) {
                    coords[c] = (float)this.coordinates[this.coordIndex + c];
                }
            }
            return segmentType;
        }
    }
}

