/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame;

import com.dmgame.ScreenManager;
import com.dmgame.Updatable;
import com.dmgame.Utility;
import com.dmgame.sound.SoundPlayer;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public abstract class Scene
extends JPanel
implements Runnable,
Updatable {
    private static final long serialVersionUID = -6944857601161120640L;
    protected double windowScale = 1.0;
    protected static final double WINDOW_SCALE_LARGE = 1.0;
    protected static final double WINDOW_SCALE_MEDIUM = 0.78125;
    protected static final double WINDOW_SCALE_SMALL = 0.625;
    public static final int WINDOW_WIDTH = 1024;
    public static final int WINDOW_HEIGHT = 768;
    public static String texturePackName = "Default";
    public static String musicPackName = "default";
    protected BufferedImage windowIcon;
    public static final int frameDelay = 16;
    public static final DisplayMode[] MODES = new DisplayMode[]{new DisplayMode(1024, 768, 32, 0), new DisplayMode(1024, 768, 24, 0), new DisplayMode(1024, 768, 16, 0)};
    protected DisplayMode mode;
    protected JPanel containerPanel;
    protected static ScreenManager s;
    protected boolean running;
    protected static int screenshotName;
    public static final File DATA;

    public Scene() {
        try {
            this.windowIcon = ImageIO.read(new File("lib/res/smw.png"));
        }
        catch (IOException ex) {
            Logger.getLogger(Scene.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void stop() {
        this.running = false;
        this.quitGame();
    }

    @Override
    public void run() {
        this.init();
        this.gameLoop();
        s.restoreScreen();
    }

    public void init() {
        try {
            if (!DATA.exists()) {
                Utility.saveDefaultConfig();
            }
            this.setPreferredSize(new Dimension(1024, 768));
            this.setMinimumSize(new Dimension(1024, 768));
            if (s == null) {
                s = new ScreenManager("Super Mario War", this);
            }
            this.mode = s.findFirstCompatibleMode(MODES);
            Scene.s.windowFrame.setIgnoreRepaint(false);
            Scene.s.windowFrame.add(this);
            Scene.s.windowFrame.setIconImage(this.windowIcon);
            Scene.s.fullScreenFrame.setIconImage(this.windowIcon);
            Scene.s.windowFrame.pack();
            s.setWindowed();
            this.running = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void gameLoop() {
        long startTime;
        long totalTime = startTime = System.currentTimeMillis();
        while (this.running) {
            long timePassed = System.currentTimeMillis() - totalTime;
            totalTime += timePassed;
            this.update(timePassed);
            this.repaint();
            try {
                Thread.sleep(16L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    public boolean running() {
        return this.running;
    }

    public void setWindowScale(double windowScale) {
        this.windowScale = windowScale;
        this.setPreferredSize(new Dimension((int)(1024.0 * windowScale), (int)(768.0 * windowScale)));
        Scene.s.windowFrame.pack();
    }

    public synchronized double getWindowScale() {
        return this.windowScale;
    }

    public void quitGame() {
        SoundPlayer.close();
        System.out.println("Super Mario War: Stomp Arena by:\nEON8ight, JM Dragon, and JJames19119\n72dpiarmy.supersantuary.net");
        System.out.println(Utility.lang.get("extra credits"));
        System.exit(0);
    }

    static {
        screenshotName = 0;
        DATA = new File("settings.cfg");
    }
}

