/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame;

import com.dmgame.Scene;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;

public class ScreenManager {
    private GraphicsDevice videoCard;
    public JFrame windowFrame;
    public JFrame fullScreenFrame;
    private boolean fullscreen;
    private Scene parentScene;

    public ScreenManager(String name, Scene parentScene) {
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.videoCard = e.getDefaultScreenDevice();
        this.windowFrame = new JFrame(name);
        this.windowFrame.setIgnoreRepaint(true);
        this.windowFrame.pack();
        this.windowFrame.setResizable(false);
        this.windowFrame.setDefaultCloseOperation(2);
        this.windowFrame.addWindowListener(new WindowListener(){

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
                ScreenManager.this.parentScene.stop();
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }
        });
        this.setWindowFramePosition();
        this.fullScreenFrame = new JFrame();
        this.fullScreenFrame.setUndecorated(true);
        this.fullScreenFrame.setIgnoreRepaint(true);
        this.fullScreenFrame.pack();
        this.fullScreenFrame.setResizable(false);
        this.fullscreen = false;
        this.parentScene = parentScene;
    }

    private void setWindowFramePosition() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        if (screenSize.width < 1024 || screenSize.height < 768) {
            return;
        }
        Point centerPoint = new Point((screenSize.width - 1024) / 2, (screenSize.height - 768) / 2);
        this.windowFrame.setLocation(centerPoint);
    }

    public DisplayMode[] getCompatibleDisplayModes() {
        return this.videoCard.getDisplayModes();
    }

    public DisplayMode findFirstCompatibleMode(DisplayMode[] modes) {
        DisplayMode[] goodModes = this.videoCard.getDisplayModes();
        for (int i = 0; i < modes.length; ++i) {
            for (int j = 0; j < goodModes.length; ++j) {
                if (!this.displayModesMatch(modes[i], goodModes[j])) continue;
                return modes[i];
            }
        }
        return null;
    }

    public DisplayMode getCurrentDisplayMode() {
        return this.videoCard.getDisplayMode();
    }

    public boolean displayModesMatch(DisplayMode modeOne, DisplayMode modeTwo) {
        if (modeOne.getWidth() != modeTwo.getWidth() || modeOne.getHeight() != modeTwo.getHeight()) {
            return false;
        }
        if (modeOne.getBitDepth() != -1 && modeTwo.getBitDepth() != -1 && modeOne.getBitDepth() != modeTwo.getBitDepth()) {
            return false;
        }
        return modeOne.getRefreshRate() == 0 || modeTwo.getRefreshRate() == 0 || modeOne.getRefreshRate() == modeTwo.getRefreshRate();
    }

    public void setFullscreen(DisplayMode mode) {
        this.fullscreen = true;
        this.videoCard.setFullScreenWindow(this.fullScreenFrame);
        if (mode != null && this.videoCard.isDisplayChangeSupported()) {
            this.videoCard.setDisplayMode(mode);
        }
        this.fullScreenFrame.createBufferStrategy(2);
        this.windowFrame.setVisible(false);
        this.fullScreenFrame.setVisible(true);
    }

    public void setWindowed() {
        this.fullscreen = false;
        this.videoCard.setFullScreenWindow(null);
        this.windowFrame.setVisible(true);
        this.fullScreenFrame.setVisible(false);
        this.windowFrame.createBufferStrategy(2);
    }

    public Graphics2D getGraphics() {
        BufferStrategy s = this.fullscreen ? this.fullScreenFrame.getBufferStrategy() : this.windowFrame.getBufferStrategy();
        return (Graphics2D)s.getDrawGraphics();
    }

    public void update() {
        BufferStrategy s;
        BufferStrategy bufferStrategy = s = this.fullscreen ? this.fullScreenFrame.getBufferStrategy() : this.windowFrame.getBufferStrategy();
        if (!s.contentsLost()) {
            s.show();
        }
    }

    public void restoreScreen() {
        if (!this.fullscreen) {
            return;
        }
        Window w = this.videoCard.getFullScreenWindow();
        if (w != null) {
            w.dispose();
        }
        this.videoCard.setFullScreenWindow(null);
    }

    public BufferedImage createCompatibleImage(int width, int height, int alpha) {
        GraphicsConfiguration gc = null;
        if (this.fullscreen) {
            Window w = this.videoCard.getFullScreenWindow();
            if (w != null) {
                gc = w.getGraphicsConfiguration();
            }
        } else {
            gc = this.windowFrame.getGraphicsConfiguration();
        }
        return gc == null ? null : gc.createCompatibleImage(width, height, alpha);
    }

    public void switchScene(Scene newScene) {
        this.windowFrame.remove(this.parentScene.containerPanel);
        this.fullScreenFrame.remove(this.parentScene.containerPanel);
        this.windowFrame.setFocusable(true);
        this.fullScreenFrame.setFocusable(true);
        this.parentScene = newScene;
        new Thread(newScene).start();
        this.windowFrame.requestFocus();
    }

    public boolean isFullscreen() {
        return this.fullscreen;
    }
}

