/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame;

import com.dmgame.ColorSet;
import com.dmgame.SMWException;
import java.awt.Color;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SpriteColorModel {
    public static final byte RED = 0;
    public static final byte GREEN = 1;
    public static final byte BLUE = 2;
    public static final byte OTHER = 3;
    private static final short COLORGAP = 125;
    private List<HashMap<Point, Color>> redPixels;
    private List<HashMap<Point, Color>> bluePixels;
    private List<HashMap<Point, Color>> greenPixels;
    private List<HashMap<Point, Color>> otherPixels;
    private List<BufferedImage> sprites;
    private ColorSet colorSet;
    private volatile boolean invincible;
    private int invincibleCount;
    private boolean inverted;

    public SpriteColorModel(ColorSet colorSet, Color col, BufferedImage ... sprites) throws SMWException {
        if (col != Color.RED && col != Color.BLUE && col != Color.GREEN) {
            throw new SMWException("Color flag must be pure red, pure blue, or pure green.");
        }
        this.colorSet = colorSet;
        this.invincible = false;
        this.invincibleCount = 0;
        this.inverted = false;
        this.redPixels = new ArrayList<HashMap<Point, Color>>(sprites.length);
        this.bluePixels = new ArrayList<HashMap<Point, Color>>(sprites.length);
        this.greenPixels = new ArrayList<HashMap<Point, Color>>(sprites.length);
        this.otherPixels = new ArrayList<HashMap<Point, Color>>(sprites.length);
        this.sprites = new ArrayList<BufferedImage>(sprites.length);
        this.sprites.addAll(Arrays.asList(sprites));
        for (int spriteNum = 0; spriteNum < this.sprites.size(); ++spriteNum) {
            BufferedImage b = this.sprites.get(spriteNum);
            this.redPixels.add(new HashMap());
            this.greenPixels.add(new HashMap());
            this.bluePixels.add(new HashMap());
            this.otherPixels.add(new HashMap());
            for (int j = 0; j < b.getHeight(); ++j) {
                for (int i = 0; i < b.getWidth(); ++i) {
                    int color = b.getRGB(i, j);
                    int transColor = color >> 24 & 0xFF;
                    int redColor = color >> 16 & 0xFF;
                    int greenColor = color >> 8 & 0xFF;
                    int blueColor = color & 0xFF;
                    if (redColor == 255 && blueColor == 255 && greenColor == 0) {
                        b.setRGB(i, j, new Color(0, 0, 0, 0).getRGB());
                        continue;
                    }
                    if (redColor - greenColor >= 125 && redColor - blueColor >= 125) {
                        this.redPixels.get(spriteNum).put(new Point(i, j), new Color(color, true));
                        continue;
                    }
                    if (greenColor - redColor >= 125 && greenColor - blueColor >= 125) {
                        this.greenPixels.get(spriteNum).put(new Point(i, j), new Color(color, true));
                        continue;
                    }
                    if (blueColor - greenColor >= 125 && blueColor - redColor >= 125) {
                        this.bluePixels.get(spriteNum).put(new Point(i, j), new Color(color, true));
                        continue;
                    }
                    if (transColor == 0) continue;
                    this.otherPixels.get(spriteNum).put(new Point(i, j), new Color(color, true));
                }
            }
        }
    }

    public void clear() {
        this.sprites = new ArrayList<BufferedImage>();
        this.redPixels = new ArrayList<HashMap<Point, Color>>();
        this.bluePixels = new ArrayList<HashMap<Point, Color>>();
        this.greenPixels = new ArrayList<HashMap<Point, Color>>();
    }

    public void addSprites(BufferedImage ... sprites) {
        int oldSize = this.sprites.size();
        this.sprites.addAll(Arrays.asList(sprites));
        for (int spriteNum = oldSize; spriteNum < this.sprites.size(); ++spriteNum) {
            BufferedImage b = this.sprites.get(spriteNum);
            this.redPixels.add(new HashMap());
            this.greenPixels.add(new HashMap());
            this.bluePixels.add(new HashMap());
            for (int j = 0; j < b.getHeight(); ++j) {
                for (int i = 0; i < b.getWidth(); ++i) {
                    int color = b.getRGB(i, j);
                    int redColor = color >> 16 & 0xFF;
                    int greenColor = color >> 8 & 0xFF;
                    int blueColor = color & 0xFF;
                    if (redColor == 255 && blueColor == 255) {
                        b.setRGB(i, j, new Color(0, 0, 0, 0).getRGB());
                        continue;
                    }
                    if (redColor - greenColor >= 125 && redColor - blueColor >= 125) {
                        this.redPixels.get(spriteNum).put(new Point(i, j), new Color(color, true));
                        continue;
                    }
                    if (greenColor - redColor >= 125 && greenColor - blueColor >= 125) {
                        this.greenPixels.get(spriteNum).put(new Point(i, j), new Color(color, true));
                        continue;
                    }
                    if (blueColor - greenColor < 125 || blueColor - redColor < 125) continue;
                    this.bluePixels.get(spriteNum).put(new Point(i, j), new Color(color, true));
                }
            }
        }
    }

    public void shiftColor(float hueShift, float satShift, float brightShift, byte colorID, int pos) throws SMWException {
        if ((double)satShift != -1.0 && ((double)satShift < 0.0 || (double)satShift > 1.0)) {
            throw new SMWException("Saturation must be between 0 and 1.");
        }
        if ((double)brightShift != -1.0 && ((double)brightShift < 0.0 || (double)brightShift > 1.0)) {
            throw new SMWException("Saturation must be between 0 and 1.");
        }
        Set<Object> set = new HashSet();
        switch (colorID) {
            case 0: {
                set = this.redPixels.get(pos).entrySet();
                break;
            }
            case 1: {
                set = this.greenPixels.get(pos).entrySet();
                break;
            }
            case 2: {
                set = this.bluePixels.get(pos).entrySet();
                break;
            }
            case 3: {
                set = this.otherPixels.get(pos).entrySet();
                break;
            }
            default: {
                throw new SMWException("Color must be pure red, green, or blue.");
            }
        }
        for (Map.Entry entry : set) {
            Point point = (Point)entry.getKey();
            int color = ((Color)entry.getValue()).getRGB();
            int trans = color >> 24 & 0xFF;
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            float[] tempHSB = Color.RGBtoHSB(r, g, b, null);
            tempHSB[0] = tempHSB[0] + hueShift;
            if ((double)satShift != -1.0 && satShift + tempHSB[1] <= 1.0f && satShift + tempHSB[1] >= 0.0f) {
                tempHSB[1] = tempHSB[1] + satShift;
            }
            if ((double)brightShift != -1.0 && brightShift + tempHSB[2] <= 1.0f && brightShift + tempHSB[2] >= 0.0f) {
                tempHSB[2] = tempHSB[2] + brightShift;
            }
            int tempRGB = Color.HSBtoRGB(tempHSB[0], tempHSB[1], tempHSB[2]);
            this.sprites.get(pos).setRGB(point.x, point.y, tempRGB |= trans << 24);
        }
    }

    public void shiftColor(float hueShift, float satShift, float brightShift, byte colorID) throws SMWException {
        for (int i = 0; i < this.sprites.size(); ++i) {
            this.shiftColor(hueShift, satShift, brightShift, colorID, i);
        }
    }

    public void shiftColor(int csv, byte colorID) throws SMWException {
        this.shiftColor(this.colorSet.hueShifts[colorID][csv], this.colorSet.satShifts[colorID][csv], this.colorSet.brightShifts[colorID][csv], colorID);
    }

    public void shiftAllColors(int csv) throws SMWException {
        this.shiftColor(this.colorSet.hueShifts[0][csv], this.colorSet.satShifts[0][csv], this.colorSet.brightShifts[0][csv], (byte)0);
        this.shiftColor(this.colorSet.hueShifts[1][csv], this.colorSet.satShifts[1][csv], this.colorSet.brightShifts[1][csv], (byte)1);
        this.shiftColor(this.colorSet.hueShifts[2][csv], this.colorSet.satShifts[2][csv], this.colorSet.brightShifts[2][csv], (byte)2);
        this.shiftColor(this.colorSet.hueShifts[3][csv], this.colorSet.satShifts[3][csv], this.colorSet.brightShifts[3][csv], (byte)3);
    }

    public void invert(int pos) {
        for (int width = 0; width < this.sprites.get(pos).getWidth(); ++width) {
            for (int height = 0; height < this.sprites.get(pos).getHeight(); ++height) {
                Color c = new Color(this.sprites.get(pos).getRGB(width, height), true);
                Color invC = new Color(255 - c.getRed(), 255 - c.getGreen(), 255 - c.getBlue(), c.getAlpha());
                this.sprites.get(pos).setRGB(width, height, invC.getRGB());
            }
        }
    }

    public void invert() {
        this.inverted = !this.inverted;
        for (int i = 0; i < this.sprites.size(); ++i) {
            this.invert(i);
        }
    }

    public void greyscale(int pos) {
        for (int width = 0; width < this.sprites.get(pos).getWidth(); ++width) {
            for (int height = 0; height < this.sprites.get(pos).getHeight(); ++height) {
                int color = this.sprites.get(pos).getRGB(width, height);
                int trans = color >> 24 & 0xFF;
                if (trans == 0) continue;
                int r = color >> 16 & 0xFF;
                int g = color >> 8 & 0xFF;
                int b = color & 0xFF;
                float[] tempHSB = Color.RGBtoHSB(r, g, b, null);
                tempHSB[1] = 0.0f;
                int tempRGB = Color.HSBtoRGB(tempHSB[0], tempHSB[1], tempHSB[2]);
                this.sprites.get(pos).setRGB(width, height, tempRGB |= trans << 24);
            }
        }
    }

    public void greyscale() {
        for (int i = 0; i < this.sprites.size(); ++i) {
            this.greyscale(i);
        }
    }

    public void update() {
        if (this.invincible) {
            try {
                switch (++this.invincibleCount) {
                    case 0: {
                        this.shiftAllColors(0);
                        break;
                    }
                    case 10: {
                        this.invert();
                        break;
                    }
                    case 20: {
                        this.shiftAllColors(0);
                        this.shiftColor(1, (byte)0);
                        break;
                    }
                    case 30: {
                        this.shiftColor(1, (byte)0);
                        this.invert();
                        break;
                    }
                    case 39: {
                        this.invincibleCount = -1;
                    }
                }
            }
            catch (SMWException sMWException) {
                // empty catch block
            }
        }
    }

    public void setInvincible(boolean b) {
        this.invincible = b;
        try {
            this.shiftAllColors(0);
        }
        catch (SMWException sMWException) {
            // empty catch block
        }
    }
}

