/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame;

import com.dmgame.Updatable;

public abstract class UnthreadedTimer
implements Updatable {
    private final long MAX_TIME;
    private long time;
    private boolean ended;

    public UnthreadedTimer(long maxTime) {
        this.MAX_TIME = maxTime;
        this.time = 0L;
        this.ended = false;
    }

    @Override
    public void update(long timePassed) {
        this.time += timePassed;
        if (!this.ended && this.time > this.MAX_TIME) {
            this.ended = true;
            this.end();
        }
    }

    public void reset() {
        this.time = 0L;
        this.ended = false;
    }

    public long getCurrentTime() {
        return this.time;
    }

    public long getMaxTime() {
        return this.MAX_TIME;
    }

    public double getPercentDone() {
        double d = (double)this.time / (double)this.MAX_TIME;
        return d <= 1.0 ? d : 1.0;
    }

    public boolean isDone() {
        return this.ended;
    }

    public boolean isActive() {
        return this.time > 0L && this.time < this.MAX_TIME;
    }

    public abstract void end();
}

