/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame;

import com.dmgame.Animation;
import com.dmgame.SMWException;
import com.dmgame.Scene;
import com.dmgame.entity.BulletBillEntity;
import com.dmgame.entity.Entity;
import com.dmgame.entity.FireballBar;
import com.dmgame.entity.Rotodisc;
import com.dmgame.io.MapIO;
import com.dmgame.map.Map;
import com.dmgame.map.Platform;
import com.dmgame.map.Warp;
import com.dmgame.options.OptionsHandlerBean;
import com.dmgame.options.PlayerControlsBean;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class Utility {
    public static final byte DEGREES_0 = 0;
    public static final byte DEGREES_90 = 1;
    public static final byte DEGREES_180 = 2;
    public static final byte DEGREES_270 = 3;
    private static final String LOGGER_NAME = "Utility";
    private static final byte PREVIEW_SCALE = 4;
    public static Properties lang = Utility.loadProps();

    private Utility() throws SMWException {
        throw new SMWException("Illegal instantiation of the Utility class.");
    }

    public static void checkLWJGL() {
        String os = null;
        String opSystem = System.getProperty("os.name").toLowerCase();
        if (opSystem.contains("win")) {
            os = "windows";
        } else if (opSystem.contains("mac")) {
            os = "macosx";
        } else if (opSystem.contains("nix") || opSystem.contains("nux")) {
            os = "linux";
        } else if (opSystem.contains("sunos")) {
            os = "solaris";
        } else {
            System.err.println(lang.getProperty("os error"));
            System.exit(-1);
        }
        System.setProperty("org.lwjgl.librarypath", System.getProperty("user.dir") + "/lib/native/" + os);
    }

    public static BufferedImage getHorizontalFlippedCopy(BufferedImage sprite) {
        BufferedImage flippedSprite = new BufferedImage(sprite.getWidth(), sprite.getHeight(), sprite.getType());
        Graphics2D g = flippedSprite.createGraphics();
        g.drawImage(sprite, 0, 0, sprite.getWidth(), sprite.getHeight(), sprite.getWidth(), 0, 0, sprite.getHeight(), null);
        g.dispose();
        return flippedSprite;
    }

    public static Animation getHorizontalFlippedCopy(Animation anim) {
        try {
            BufferedImage[] frames = new BufferedImage[anim.size()];
            for (int i = 0; i < frames.length; ++i) {
                frames[i] = Utility.getHorizontalFlippedCopy(anim.getImageAt(i));
            }
            return new Animation(anim.getFrameDuration(), frames);
        }
        catch (SMWException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BufferedImage getVerticalFlippedCopy(BufferedImage sprite) {
        BufferedImage flippedSprite = new BufferedImage(sprite.getWidth(), sprite.getHeight(), sprite.getType());
        Graphics2D g = flippedSprite.createGraphics();
        g.drawImage(sprite, 0, 0, sprite.getWidth(), sprite.getHeight(), 0, sprite.getHeight(), sprite.getWidth(), 0, null);
        g.dispose();
        return flippedSprite;
    }

    public static Animation getVerticalFlippedCopy(Animation anim) {
        try {
            BufferedImage[] frames = new BufferedImage[anim.size()];
            for (int i = 0; i < frames.length; ++i) {
                frames[i] = Utility.getVerticalFlippedCopy(anim.getImageAt(i));
            }
            return new Animation(anim.getFrameDuration(), frames);
        }
        catch (SMWException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Animation getSubanimation(Animation a, int x, int y, int w, int h) {
        Animation subanimation = null;
        try {
            BufferedImage[] sub = new BufferedImage[a.size()];
            for (int i = 0; i < sub.length; ++i) {
                sub[i] = a.getImageAt(i).getSubimage(x, y, w, h);
            }
            subanimation = new Animation(a.getFrameDuration(), sub);
        }
        catch (SMWException e) {
            e.printStackTrace();
        }
        return subanimation;
    }

    public static BufferedImage rotateImage90(BufferedImage image, byte mult) {
        if (mult > 3) {
            while (mult > 3) {
                mult = (byte)(mult - 3);
            }
        } else if (mult < 0) {
            while (mult < 0) {
                mult = (byte)(mult + 3);
            }
        }
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage rotatedImage = mult % 2 == 0 ? new BufferedImage(width, height, image.getType()) : new BufferedImage(height, width, image.getType());
        Graphics2D g2D = rotatedImage.createGraphics();
        g2D.rotate(Math.toRadians(90 * mult), image.getWidth() / 2, image.getHeight() / 2);
        int offset = (image.getWidth() - image.getHeight()) / 2;
        if (mult > 2) {
            offset = -offset;
        }
        g2D.drawImage(image, null, offset, offset);
        return rotatedImage;
    }

    public static Animation rotateAnimation90(Animation anim, byte mult) {
        try {
            BufferedImage[] frames = new BufferedImage[anim.size()];
            for (int i = 0; i < frames.length; ++i) {
                frames[i] = Utility.rotateImage90(anim.getImageAt(i), mult);
            }
            return new Animation(anim.getFrameDuration(), frames);
        }
        catch (SMWException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void saveConfig(OptionsHandlerBean options) {
        try {
            XMLEncoder coder = new XMLEncoder(new FileOutputStream("settings.cfg"));
            coder.writeObject(options);
            coder.flush();
            coder.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static OptionsHandlerBean loadConfig() throws FileNotFoundException {
        XMLDecoder coder = new XMLDecoder(new FileInputStream("settings.cfg"));
        OptionsHandlerBean toReturn = (OptionsHandlerBean)coder.readObject();
        coder.close();
        return toReturn;
    }

    public static OptionsHandlerBean getDefaultConfig() {
        OptionsHandlerBean options = new OptionsHandlerBean();
        PlayerControlsBean controlsBean = new PlayerControlsBean();
        controlsBean.setUp(38);
        controlsBean.setDown(40);
        controlsBean.setLeft(37);
        controlsBean.setRight(39);
        controlsBean.setTurbo(17);
        controlsBean.setReserve(16);
        options.setPlayerOneControls(controlsBean);
        controlsBean = new PlayerControlsBean();
        controlsBean.setUp(87);
        controlsBean.setDown(83);
        controlsBean.setLeft(65);
        controlsBean.setRight(68);
        controlsBean.setTurbo(90);
        controlsBean.setReserve(81);
        options.setPlayerTwoControls(controlsBean);
        controlsBean = new PlayerControlsBean();
        controlsBean.setUp(89);
        controlsBean.setDown(72);
        controlsBean.setLeft(71);
        controlsBean.setRight(74);
        controlsBean.setTurbo(66);
        controlsBean.setReserve(84);
        options.setPlayerThreeControls(controlsBean);
        controlsBean = new PlayerControlsBean();
        controlsBean.setUp(80);
        controlsBean.setDown(59);
        controlsBean.setLeft(76);
        controlsBean.setRight(222);
        controlsBean.setTurbo(79);
        controlsBean.setReserve(46);
        options.setPlayerFourControls(controlsBean);
        return options;
    }

    public static void saveDefaultConfig() {
        try {
            XMLEncoder coder = new XMLEncoder(new FileOutputStream(Scene.DATA));
            coder.writeObject(Utility.getDefaultConfig());
            coder.flush();
            coder.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static boolean approxEquals(Point2D.Float one, Point2D.Float two) {
        if (Float.floatToIntBits(one.x) != Float.floatToIntBits(two.x)) {
            return false;
        }
        return Float.floatToIntBits(one.y) == Float.floatToIntBits(two.y);
    }

    public static List<File> getMusicFilesInCategory(String musicPack, String categoryString) {
        File cat = new File("res/music/game/" + musicPack + "/category.xml");
        ArrayList<File> musicFiles = new ArrayList<File>();
        try {
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document xmldoc = db.parse(cat);
            Element topElement = xmldoc.getDocumentElement();
            if (!topElement.getTagName().equals("music_category")) {
                return null;
            }
            NodeList category = topElement.getElementsByTagName(categoryString = categoryString.replace(" ", "_"));
            Node node = category.item(0);
            if (node instanceof Element) {
                Element selected = (Element)node;
                NodeList music = selected.getChildNodes();
                for (int i = 0; i < music.getLength(); ++i) {
                    Element file;
                    Node child = music.item(i);
                    if (!(child instanceof Element) || !(file = (Element)child).getTagName().equals("file")) continue;
                    musicFiles.add(new File("res/music/game/" + musicPack + "/" + file.getAttribute("path")));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return musicFiles;
    }

    private static Properties loadProps() {
        Properties props = new Properties();
        File langFile = new File("res/lang.properties");
        if (langFile.exists()) {
            try {
                props.load(new FileReader("res/lang.properties"));
            }
            catch (IOException ex) {
                Utility.createEnglishProperties(props);
            }
        } else {
            Utility.createEnglishProperties(props);
        }
        return props;
    }

    private static void createEnglishProperties(Properties props) {
        props.put("ready", "Ready!");
        props.put("back", "Back");
        props.put("pause-back", "Back to menu");
        props.put("continue", "Continue game");
        props.put("pause", "Pause");
        props.put("os error", "Your OS is not supported by LWJGL.");
        props.put("reconnect fail", "Could not reconnect player#.");
        props.put("connected client", "Client connected.");
        props.put("starting game", "Starting game...");
        props.put("disconnect", "Client disconnected.");
        props.put("scripts reloaded", "Finished reloading scripts!");
        props.put("console command error", "Error parsing console command!");
        props.put("command exception", "Command failed with exception:");
        props.put("unknown script", "Unknown scripting language:");
        props.put("script error", "Error processing script:");
        props.put("server wait", "Waiting for server...");
        props.put("start countdown", "Starting game in");
        props.put("start game", "Start Game");
        props.put("network", "Join Network Game");
        props.put("options", "Options");
        props.put("quit", "Quit Game");
        props.put("ip", "IP:");
        props.put("port", "Port:");
        props.put("connect", "Connect");
        props.put("start", "Start");
        props.put("up", "Up");
        props.put("down", "Down");
        props.put("left", "Left");
        props.put("right", "Right");
        props.put("turbo", "Turbo");
        props.put("reserve", "Reserve");
        props.put("get default", "Use Defaults");
        props.put("save", "Save");
        props.put("extra credits", "");
        try {
            props.store(new FileWriter("res/lang.properties"), "This is the default auto-generated language file.\r\n");
        }
        catch (IOException ex) {
            Logger.getLogger(Utility.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void cacheAllMaps() {
        File[] maps = new File("res/maps/").listFiles();
        for (int i = 0; i < maps.length; ++i) {
            String mapName = "res/maps/cache/" + maps[i].getName().substring(0, maps[i].getName().length() - 4) + ".png";
            if (maps[i].getName().equals("cache") || new File(mapName).exists()) continue;
            System.out.println("Cached " + mapName);
            Utility.cacheMapScreenshot(maps[i], 0.25);
        }
    }

    public static void cacheMapScreenshot(File file, double scale) {
        try {
            Utility.cacheMapScreenshot(file.getName().substring(0, file.getName().length() - 4), MapIO.loadMap(file, false), scale);
        }
        catch (SMWException | IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void cacheMapScreenshot(String filename, Map map, double scale) {
        void var8_18;
        int l;
        BufferedImage shot = new BufferedImage((int)(1024.0 * scale), (int)(768.0 * scale), 2);
        Graphics2D g2D = shot.createGraphics();
        g2D.scale(scale, scale);
        g2D.setColor(map.bgColor);
        g2D.fillRect(0, 0, map.MAP_WIDTH, map.MAP_HEIGHT);
        if (map.background != null) {
            Rectangle r = new Rectangle(0, 0, map.background.getWidth(), map.background.getHeight());
            Paint paint = g2D.getPaint();
            g2D.setPaint(new TexturePaint(map.background, r));
            g2D.fill(new Rectangle(0, 0, map.MAP_WIDTH, map.MAP_HEIGHT));
            g2D.setPaint(paint);
        }
        for (l = 0; l < map.tilesBackground.size(); ++l) {
            for (int x = 0; x < map.tilesBackground.get(l).length; ++x) {
                for (int i = 0; i < map.tilesBackground.get(l)[x].length; ++i) {
                    if (map.tilesBackground.get(l)[x][i] == null || map.tilesBackground.get(l)[x][i].getUnclonedGraphicTile() == null) continue;
                    g2D.drawImage((Image)map.tilesBackground.get(l)[x][i].getUnclonedGraphicTile().getImage(), x * 32, i * 32, null);
                }
            }
        }
        for (l = 0; l < map.tilesForeground.size(); ++l) {
            for (int x = 0; x < map.tilesForeground.get(l).length; ++x) {
                for (int i = 0; i < map.tilesForeground.get(l)[x].length; ++i) {
                    if (map.tilesForeground.get(l)[x][i] == null || map.tilesForeground.get(l)[x][i].getUnclonedGraphicTile() == null) continue;
                    g2D.drawImage((Image)map.tilesForeground.get(l)[x][i].getUnclonedGraphicTile().getImage(), x * 32, i * 32, null);
                }
            }
        }
        for (int x = 0; x < map.iTiles.length; ++x) {
            for (int y2 = 0; y2 < map.iTiles[x].length; ++y2) {
                if (map.iTiles[x][y2] == null) continue;
                g2D.drawImage((Image)map.iTiles[x][y2].tile.getImageAt(0), x * 32, y2 * 32, null);
            }
        }
        Warp[][][] arr$ = map.warps;
        int len$ = arr$.length;
        boolean bl = false;
        while (var8_18 < len$) {
            Warp[][] array;
            Warp[][] arr$2 = array = arr$[var8_18];
            int len$2 = arr$2.length;
            for (int i$2 = 0; i$2 < len$2; ++i$2) {
                Warp[] arrayTwo;
                for (Warp w : arrayTwo = arr$2[i$2]) {
                    if (w == null) continue;
                    g2D.drawImage((Image)w.sprite, w.mapRelX * 32, w.mapRelY * 32, null);
                }
            }
            ++var8_18;
        }
        for (Platform platform : map.platforms) {
            int x;
            Point2D.Float startPoint = platform.helper.getStartPoint();
            for (x = 0; x < platform.gTiles.length; ++x) {
                for (int y3 = 0; y3 < platform.gTiles[x].length; ++y3) {
                    if (platform.gTiles[x][y3] == null) continue;
                    g2D.drawImage((Image)platform.gTiles[x][y3].getImage(), (int)((double)startPoint.x - platform.getWidth() / 2.0) + x * 32, (int)((double)startPoint.y - platform.getWidth() / 2.0) + y3 * 32, null);
                }
            }
            for (x = 0; x < platform.iTiles.length; ++x) {
                for (int y4 = 0; y4 < platform.iTiles[x].length; ++y4) {
                    if (platform.iTiles[x][y4] == null) continue;
                    g2D.drawImage((Image)platform.iTiles[x][y4].tile.getImage(), (int)((double)startPoint.x - platform.getWidth() / 2.0) + x * 32, (int)((double)startPoint.y - platform.getWidth() / 2.0) + y4 * 32, null);
                }
            }
            Shape s = platform.getPath();
            if (s instanceof Line2D) {
                g2D.setColor(Color.RED);
            } else if (s instanceof Ellipse2D) {
                g2D.setColor(Color.GREEN);
            } else if (s instanceof Rectangle) {
                g2D.setColor(Color.BLUE);
            } else if (s instanceof RoundRectangle2D) {
                g2D.setColor(Color.MAGENTA);
            } else if (s instanceof Polygon) {
                g2D.setColor(Color.GRAY);
            }
            g2D.draw(platform.getPath());
        }
        for (Entity entity : map.mapEntities) {
            g2D.drawImage((Image)entity.getImage(), Math.round(entity.entityX), Math.round(entity.entityY), null);
            if (entity instanceof BulletBillEntity) {
                ((BulletBillEntity)entity).drawPath(g2D, map);
            }
            if (entity instanceof Rotodisc) {
                for (Rotodisc.Disc d : ((Rotodisc)entity).discs) {
                    d.drawToScreen(g2D, d.entityX, d.entityY);
                }
            }
            if (!(entity instanceof FireballBar)) continue;
            for (FireballBar.BarFireball b : ((FireballBar)entity).fireballs) {
                b.drawToScreen(g2D, b.entityX, b.entityY);
            }
        }
        g2D.dispose();
        try {
            ImageIO.write((RenderedImage)shot, "png", new File("res/maps/cache/" + filename + ".png"));
        }
        catch (IOException e) {
            Logger.getLogger(LOGGER_NAME).log(Level.WARNING, "Error while caching map screenshot", e);
            e.printStackTrace();
        }
    }
}

