/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.entity;

import com.dmgame.Direction;
import com.dmgame.GameLogic;
import com.dmgame.entity.DroppedBomb;
import com.dmgame.entity.ExplosionEntity;
import com.dmgame.entity.Flamethrower;
import com.dmgame.entity.PiranhaPlant;
import com.dmgame.entity.Player;
import com.dmgame.entity.Rotodisc;
import com.dmgame.entity.Shell;
import com.dmgame.entity.Spike;
import com.dmgame.entity.Team;
import com.dmgame.entity.ThrowBlockEntity;
import com.dmgame.entity.logic.BasicLogic;
import com.dmgame.entity.logic.Logic;
import com.dmgame.entity.powerups.PoisonMushroom;
import com.dmgame.entity.powerups.PowerUp;
import com.dmgame.entity.projectiles.Projectile;
import com.dmgame.map.InteractiveTile;
import com.dmgame.map.interactivetiles.BlueThrowBlock;
import com.dmgame.map.interactivetiles.GrayThrowBlock;
import com.dmgame.map.interactivetiles.RedThrowBlock;
import java.awt.geom.Point2D;

public class AI
extends Player {
    private static final long serialVersionUID = -4312694387269068890L;
    private Logic logic;
    private Logic.AlertObject currentFocus;
    public static final long ASSESS_FREQUENCY = 250L;

    public AI(String skinName, float entityX, float entityY, Team teamColor, int score) {
        super(skinName, entityX, entityY, null, teamColor, score);
        this.setKeyCodes(new int[]{-1, -2, -3, -4, -5, -6});
        this.logic = new BasicLogic(this);
        this.logic.assess();
        this.currentFocus = this.logic.getCurrentFocus();
        GameLogic.startDelayedRepeatingAction(250L, new Runnable(){

            @Override
            public void run() {
                AI.this.logic.assess();
                AI.this.currentFocus = AI.this.logic.getCurrentFocus();
            }
        });
    }

    @Override
    protected void updateMovement(long timePassed) {
        super.updateMovement(timePassed);
        this.movementHelper();
    }

    protected void movementHelper() {
        if (this.currentFocus == null) {
            return;
        }
        if (this.currentFocus.getTarget() instanceof InteractiveTile) {
            if (this.currentFocus.getTarget() instanceof BlueThrowBlock || this.currentFocus.getTarget() instanceof RedThrowBlock || this.currentFocus.getTarget() instanceof GrayThrowBlock) {
                float dist = (float)new Point2D.Float(this.entityX, this.entityY).distance(new Point2D.Float(this.currentFocus.getTargetX(), this.currentFocus.getTargetY()));
                if (dist >= (float)this.width) {
                    this.moveToward(this.currentFocus.getTargetX(), this.currentFocus.getTargetY());
                } else {
                    this.keyPressed(this.keyCodeTurbo);
                }
            } else {
                this.moveTowardInteractiveTile(this.currentFocus.getTargetX(), this.currentFocus.getTargetY());
            }
        } else if (this.currentFocus.getTarget() instanceof PowerUp) {
            if (this.currentFocus.getTarget() instanceof PoisonMushroom) {
                this.moveAway(this.currentFocus.getTargetX(), this.currentFocus.getTargetY());
            } else {
                this.moveToward(this.currentFocus.getTargetX(), this.currentFocus.getTargetY());
            }
        } else if (this.currentFocus.getTarget() instanceof Projectile) {
            if (this.currentFocus.getTeamColor() != this.teamColor) {
                this.moveAway(this.currentFocus.getTargetX(), this.currentFocus.getTargetY());
            }
        } else if (this.currentFocus.getTarget() instanceof Player) {
            Player e = (Player)this.currentFocus.getTarget();
            if (e.teamColor != this.teamColor) {
                if (!this.isHoldingItem()) {
                    this.keyReleased(this.keyCodeTurbo);
                }
                if (Math.abs(e.entityX - this.entityX) <= 64.0f) {
                    if (e.entityY < this.entityY) {
                        this.moveAway(this.currentFocus.getTargetX(), this.currentFocus.getTargetY());
                    } else {
                        this.moveTowardEntity(Direction.DOWN, this.currentFocus.getTargetX(), this.currentFocus.getTargetY());
                    }
                }
            }
        } else if (this.currentFocus.getTarget() instanceof Shell) {
            Shell e = (Shell)this.currentFocus.getTarget();
            if (e.isInMotion()) {
                this.moveAway(this.currentFocus.getTargetX(), this.currentFocus.getTargetY());
            } else {
                float dist = (float)new Point2D.Float(this.entityX, this.entityY).distance(new Point2D.Float(e.entityX, e.entityY));
                if (dist >= (float)this.width) {
                    this.moveTowardEntity(Direction.DOWN, this.currentFocus.getTargetX(), this.currentFocus.getTargetY());
                } else {
                    this.keyPressed(this.keyCodeTurbo);
                }
            }
        } else if (this.currentFocus.getTarget() instanceof ThrowBlockEntity) {
            this.moveAway(this.currentFocus.getTargetX(), this.currentFocus.getTargetY());
        } else if (this.currentFocus.getTarget() instanceof DroppedBomb) {
            if (this.currentFocus.getTeamColor() != this.teamColor) {
                this.moveAway(this.currentFocus.getTargetX(), this.currentFocus.getTargetY());
            }
        } else if (this.currentFocus.getTarget() instanceof ExplosionEntity) {
            if (this.currentFocus.getTeamColor() != this.teamColor) {
                this.moveAway(this.currentFocus.getTargetX(), this.currentFocus.getTargetY());
            }
        } else if (this.currentFocus.getTarget() instanceof Flamethrower) {
            this.moveAway(this.currentFocus.getTargetX(), this.currentFocus.getTargetY());
        } else if (this.currentFocus.getTarget() instanceof PiranhaPlant) {
            this.moveAway(this.currentFocus.getTargetX(), this.currentFocus.getTargetY());
        } else if (this.currentFocus.getTarget() instanceof Rotodisc.Disc) {
            this.moveAway(this.currentFocus.getTargetX(), this.currentFocus.getTargetY());
        } else if (this.currentFocus.getTarget() instanceof Spike) {
            this.moveAway(this.currentFocus.getTargetX(), this.currentFocus.getTargetY());
        }
    }

    public void moveToward(float xLoc, float yLoc) {
        if (xLoc > this.entityX) {
            this.keyReleased(this.keyCodeLeft);
            this.keyPressed(this.keyCodeRight);
            if (!this.canMoveRight) {
                this.keyPressed(this.keyCodeUp);
            }
        } else if (xLoc < this.entityX) {
            this.keyReleased(this.keyCodeRight);
            this.keyPressed(this.keyCodeLeft);
            if (!this.canMoveLeft) {
                this.keyPressed(this.keyCodeUp);
            }
        }
        if (yLoc > this.entityY) {
            this.keyReleased(this.keyCodeUp);
            if (this.isOnFallthroughTile()) {
                this.keyPressed(this.keyCodeDown);
            }
        } else if (yLoc < this.entityY) {
            this.keyReleased(this.keyCodeDown);
            this.keyPressed(this.keyCodeUp);
        }
    }

    public void moveTowardEntity(Direction dir, float xLoc, float yLoc) {
        switch (dir) {
            case UP: {
                this.moveToward(xLoc, yLoc + (float)this.height);
                break;
            }
            case DOWN: {
                this.moveToward(xLoc, yLoc - (float)this.height);
                break;
            }
            case LEFT: {
                this.moveToward(xLoc - (float)this.height, yLoc);
                break;
            }
            case RIGHT: {
                this.moveToward(xLoc + (float)this.height, yLoc);
                break;
            }
            default: {
                this.moveToward(xLoc, yLoc);
            }
        }
    }

    public void moveTowardInteractiveTile(float xLoc, float yLoc) {
        this.moveToward(xLoc, yLoc + (float)this.height);
    }

    public void moveAway(float xLoc, float yLoc) {
        if (xLoc < this.entityX) {
            this.keyReleased(this.keyCodeLeft);
            this.keyPressed(this.keyCodeRight);
            if (!this.canMoveRight) {
                this.keyPressed(this.keyCodeUp);
            }
        } else if (xLoc > this.entityX) {
            this.keyReleased(this.keyCodeRight);
            this.keyPressed(this.keyCodeLeft);
            if (!this.canMoveLeft) {
                this.keyPressed(this.keyCodeUp);
            }
        }
        if (yLoc > this.entityY) {
            this.keyReleased(this.keyCodeDown);
            this.keyPressed(this.keyCodeUp);
        } else if (yLoc < this.entityY) {
            this.keyReleased(this.keyCodeUp);
            if (this.isOnFallthroughTile()) {
                this.keyPressed(this.keyCodeDown);
            }
        }
    }

    public Logic.AlertObject getCurrentFocus() {
        return this.currentFocus;
    }
}

