/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.entity;

import com.dmgame.Direction;
import com.dmgame.GameLogic;
import com.dmgame.Interactive;
import com.dmgame.entity.Player;
import com.dmgame.entity.Shell;

public class BeetleShell
extends Shell {
    private static final long serialVersionUID = -8254240903136367119L;

    public BeetleShell(float x, float y) {
        super("beetleshell", x, y, Long.MAX_VALUE);
    }

    @Override
    public String getScriptCreateStatement() {
        return this.buildString(this.getClass().getSimpleName(), "(", Float.valueOf(this.entityX), ",", Float.valueOf(this.entityY), ")");
    }

    @Override
    public void react(Interactive i, Direction direction) {
        if (i instanceof Player && this.canReact) {
            Player player = (Player)i;
            switch (direction) {
                case UP: {
                    if (this.moving) {
                        GameLogic.gamemode.reportKill(this, player);
                        player.die();
                        break;
                    }
                }
                case LEFT: {
                    if (!this.moving) break;
                    if (this.hspeed < 0.0f) {
                        GameLogic.gamemode.reportKill(this, player);
                        player.die();
                        break;
                    }
                    this.hspeed += 5.0f;
                    break;
                }
                case RIGHT: {
                    if (!this.moving) break;
                    if (this.hspeed > 0.0f) {
                        GameLogic.gamemode.reportKill(this, player);
                        player.die();
                        break;
                    }
                    this.hspeed -= 5.0f;
                    break;
                }
            }
        }
    }
}

