/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.entity;

import com.dmgame.Direction;
import com.dmgame.GameLogic;
import com.dmgame.Interactive;
import com.dmgame.MapScene;
import com.dmgame.Utility;
import com.dmgame.entity.EditableEntity;
import com.dmgame.entity.Entity;
import com.dmgame.entity.Team;
import com.dmgame.entity.powerups.PowerUp;
import com.dmgame.map.Map;
import com.dmgame.sound.Sound;
import com.dmgame.sound.SoundPlayer;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BulletBillEntity
extends EditableEntity {
    private static final long serialVersionUID = 7395619552850752908L;
    public static final int FREQUENCY_MIN = 1000;
    public static final int FREQUENCY_MAX = 10000;
    public transient BufferedImage pathPoint;
    public static final int MIN_HSPEED = 1;
    public static final int MAX_HSPEED = 10;
    private transient BufferedImage facingLeftSprite;
    private transient BufferedImage facingRightSprite;
    private transient JSlider frequencySlider;
    private transient JSlider speedSlider;
    private long frequency;
    protected final int networkBytes;

    public BulletBillEntity(Team teamColor, boolean facingRight) {
        super("bulletbill", (float)(facingRight ? -31 : GameLogic.currentMap.MAP_WIDTH + 31), (float)((int)(GameLogic.random.nextDouble() * (double)GameLogic.currentMap.MAP_HEIGHT)), false);
        this.getClass();
        this.networkBytes = 23 + 1;
        this.currentImage = facingRight ? this.facingRightSprite : this.facingLeftSprite;
        this.hspeed = facingRight ? 3.0f : -3.0f;
        this.vspeed = 0.0f;
    }

    @Override
    public String getScriptCreateStatement() {
        return this.buildString(new Object[]{this.getClass().getSimpleName(), "(", this.teamColor, ",", this.facingRight, ")"});
    }

    public BulletBillEntity(float entityX, float entityY, boolean editorMode) {
        super("bulletbill", entityX, entityY, editorMode);
        this.getClass();
        this.networkBytes = 23 + 1;
        if (!editorMode) {
            SoundPlayer.playSound(Sound.LAUNCH);
        }
        this.facingRight = true;
        this.currentImage = this.facingRightSprite;
        this.hspeed = 5.0f;
        this.vspeed = 0.0f;
        this.frequency = 5000L;
        try {
            this.pathPoint = ImageIO.read(new File("res/gfx/leveleditor/pathpoint.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!editorMode) {
            this.initializeTimer();
        }
    }

    private void initializeTimer() {
        GameLogic.startDelayedAction(this.frequency, new Runnable(){

            @Override
            public void run() {
                GameLogic.addMapEntity(BulletBillEntity.this.getNew());
            }
        });
    }

    private void setFacingRight(boolean facingRight) {
        this.facingRight = facingRight;
        this.currentImage = facingRight ? this.facingRightSprite : this.facingLeftSprite;
        this.hspeed = facingRight ? Math.abs(this.hspeed) : -Math.abs(this.hspeed);
    }

    @Override
    protected void createSprites(String spriteFilename) {
        try {
            this.facingLeftSprite = ImageIO.read(new File("res/gfx/packs/" + MapScene.texturePackName + "/powerups/" + spriteFilename + ".png"));
            this.facingRightSprite = Utility.getHorizontalFlippedCopy(this.facingLeftSprite);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void react(Interactive i, Direction direction) {
        if (i instanceof PowerUp) {
            return;
        }
        if (i instanceof Entity && ((Entity)i).teamColor.equals((Object)this.teamColor)) {
            Entity e = (Entity)i;
            if (direction != Direction.DOWN) {
                e.die();
            } else {
                e.vspeed = -3.0f;
            }
            this.die();
        }
    }

    @Override
    protected void updateMovement(long timePassed) {
        this.entityX += this.hspeed;
        this.entityY += this.vspeed;
        this.x = (int)this.entityX;
        this.y = (int)this.entityY;
        if (this.entityX <= -32.0f || this.entityX >= (float)GameLogic.currentMap.MAP_WIDTH + 32.0f) {
            this.die();
        }
        if (this.entityY > (float)GameLogic.currentMap.MAP_HEIGHT) {
            this.entityY = -32.0f;
        }
    }

    @Override
    protected void updateImage(long timePassed) {
    }

    @Override
    public void collisionLogic() {
    }

    @Override
    public void drawToScreen(Graphics2D g2D, float xPos, float yPos) {
        g2D.drawImage((Image)this.getImage(), Math.round(xPos), Math.round(yPos), null);
    }

    @Override
    public byte[] prepareNetworkUpdate() {
        byte[] otherData = super.prepareNetworkUpdate();
        byte[] updateData = new byte[this.networkBytes];
        System.arraycopy(otherData, 0, updateData, 0, otherData.length);
        this.getClass();
        updateData[23] = (byte)(this.currentImage == this.facingRightSprite ? 0 : 255);
        return updateData;
    }

    @Override
    public void getNetworkUpdate(float x, float y, float h, float v, byte[] extra) {
        super.getNetworkUpdate(x, y, h, v, extra);
        this.currentImage = extra[this.networkBytes - 1] == 0 ? this.facingRightSprite : this.facingLeftSprite;
    }

    @Override
    protected JComponent[] setupComponents() {
        JComponent[] list = new JComponent[4];
        this.speedSlider = new JSlider(0, 1, 10, (int)this.hspeed);
        this.speedSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                BulletBillEntity.this.hspeed = BulletBillEntity.this.facingRight ? (float)source.getValue() : (float)(-source.getValue());
            }
        });
        JLabel label = new JLabel("Speed", 0);
        label.setAlignmentX(0.5f);
        list[0] = label;
        list[1] = this.speedSlider;
        this.frequencySlider = new JSlider(0, 1000, 10000, (int)this.frequency);
        this.frequencySlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                if (!source.getValueIsAdjusting()) {
                    BulletBillEntity.this.frequency = source.getValue();
                }
            }
        });
        label = new JLabel("Frequency", 0);
        label.setAlignmentX(0.5f);
        list[2] = label;
        list[3] = this.frequencySlider;
        return list;
    }

    @Override
    protected JMenu[] getSettingsMenuOptions() {
        JMenu[] toReturn = new JMenu[1];
        JMenu menu = new JMenu("Direction");
        ButtonGroup group = new ButtonGroup();
        JRadioButtonMenuItem leftButton = new JRadioButtonMenuItem("Left");
        leftButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BulletBillEntity.this.setFacingRight(false);
            }
        });
        group.add(leftButton);
        menu.add(leftButton);
        JRadioButtonMenuItem rightButton = new JRadioButtonMenuItem("Right");
        rightButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BulletBillEntity.this.setFacingRight(true);
            }
        });
        group.add(rightButton);
        menu.add(rightButton);
        if (this.facingRight) {
            rightButton.setSelected(true);
        } else {
            leftButton.setSelected(true);
        }
        menu.validate();
        toReturn[0] = menu;
        return toReturn;
    }

    @Override
    protected LayoutManager getLayout() {
        return new GridLayout(0, 2);
    }

    public void drawPath(Graphics2D g2D, Map map) {
        float inc = Math.abs(this.hspeed) * 10.0f;
        if (this.facingRight) {
            for (float f = this.entityX + inc; f < 1024.0f; f += inc) {
                g2D.drawImage((Image)this.pathPoint, Math.round(f), Math.round(this.entityY + this.vspeed), null);
            }
        } else {
            for (float f = this.entityX - inc; f > 0.0f; f -= inc) {
                g2D.drawImage((Image)this.pathPoint, Math.round(f), Math.round(this.entityY), null);
            }
        }
    }

    @Override
    public Object clone() {
        BulletBillEntity b = new BulletBillEntity(this.entityX, this.entityY, this.editorMode);
        b.x = Math.round(this.entityX);
        b.y = Math.round(this.entityY);
        b.frequency = this.frequency;
        return b;
    }

    private BulletBillEntity getNew() {
        return (BulletBillEntity)this.clone();
    }

    @Override
    public void iTileBumpTop() {
    }
}

