/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.entity;

import com.dmgame.Animation;
import com.dmgame.Direction;
import com.dmgame.GameLogic;
import com.dmgame.Interactive;
import com.dmgame.MapScene;
import com.dmgame.SMWException;
import com.dmgame.SpriteColorModel;
import com.dmgame.entity.Entity;
import com.dmgame.entity.ExplosionEntity;
import com.dmgame.entity.Holdable;
import com.dmgame.entity.Player;
import com.dmgame.entity.Team;
import com.dmgame.entity.projectiles.Projectile;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;

public strictfp class DroppedBomb
extends Projectile
implements Holdable {
    private static final long serialVersionUID = -5330328602863378835L;
    public static final long MAX_LIFE_TIME = 2000L;
    private boolean released;
    private boolean live;
    private boolean aboutToExplode;
    private transient Animation liveAnim;
    private transient Animation detonatingAnim;
    private ExplosionEntity explosion;
    private Player thrower;

    public DroppedBomb(Player thrower) {
        super("droppedbomb", thrower.entityX, thrower.entityY, thrower);
        this.setSize(28, 38);
        this.thrower = thrower;
        this.live = true;
        this.aboutToExplode = false;
        this.released = false;
        GameLogic.startDelayedAction(2000L, new Runnable(){

            @Override
            public void run() {
                DroppedBomb.this.live = false;
                DroppedBomb.this.aboutToExplode = true;
            }
        });
    }

    @Override
    public String getScriptCreateStatement() {
        return "null";
    }

    @Override
    protected void createSprites(String spriteFilename) {
        try {
            BufferedImage spritesDetonating = ImageIO.read(new File("res/gfx/packs/" + MapScene.texturePackName + "/projectiles/" + spriteFilename + ".png"));
            BufferedImage spritesheetDetonatingPartTwo = spritesDetonating.getSubimage(112, 0, 28, 38);
            this.teamColors = new SpriteColorModel(this.teamColor.colors, Color.RED, spritesDetonating, spritesheetDetonatingPartTwo);
            BufferedImage[] spritesheetDetonatingPartOne = new BufferedImage[]{spritesDetonating.getSubimage(0, 0, 28, 38), spritesDetonating.getSubimage(28, 0, 28, 38), spritesDetonating.getSubimage(56, 0, 28, 38), spritesDetonating.getSubimage(84, 0, 28, 38)};
            this.liveAnim = new Animation(80L, spritesheetDetonatingPartOne);
            this.detonatingAnim = new Animation(120L, spritesheetDetonatingPartOne[3], spritesheetDetonatingPartTwo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void setTeamColor(Team teamColor) {
        try {
            float colorShift = 0.0f;
            switch (teamColor) {
                case GREEN: {
                    colorShift = 0.3f;
                    break;
                }
                case YELLOW: {
                    colorShift = 0.15f;
                    break;
                }
                case BLUE: {
                    colorShift = -0.3f;
                    break;
                }
                default: {
                    return;
                }
            }
            if (colorShift != 0.0f) {
                this.teamColors.shiftColor(colorShift, -1.0f, -1.0f, (byte)0);
            }
        }
        catch (SMWException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void react(Interactive i, Direction direction) {
    }

    @Override
    public void update(long timePassed) {
        if (this.aboutToExplode && this.detonatingAnim.firstCycleCompleted()) {
            this.die();
            this.explosion = new ExplosionEntity(28, 38, this.thrower);
            if (this.thrower.heldItem != null && this.thrower.heldItem.equals(this)) {
                this.thrower.heldItem = null;
                this.explosion.updateCoords(this.thrower.facingRight ? this.thrower.entityX + 16.0f : this.thrower.entityX - 16.0f, this.thrower.entityY);
            } else {
                this.explosion.updateCoords(this.entityX, this.entityY);
            }
            GameLogic.addEntity(this.explosion);
            this.explosion.startTimer();
            return;
        }
        if (this.released) {
            super.update(timePassed);
        } else {
            this.updateImage(timePassed);
        }
    }

    @Override
    protected void updateMovement(long timePassed) {
        if (!this.onGround) {
            this.vspeed += 0.4f;
        }
        if (this.vspeed > 18.0f) {
            this.vspeed = 18.0f;
        }
        if (this.onGround) {
            if (this.facingRight && this.hspeed != 0.0f && this.canMoveRight) {
                this.hspeed = this.onSlippery ? (this.hspeed -= 0.05f) : (this.hspeed -= 0.2f);
                if (this.hspeed < 0.0f) {
                    this.hspeed = 0.0f;
                }
            } else if (this.hspeed != 0.0f && this.canMoveLeft) {
                this.hspeed = this.onSlippery ? (this.hspeed += 0.05f) : (this.hspeed += 0.2f);
                if (this.hspeed > 0.0f) {
                    this.hspeed = 0.0f;
                }
            }
        } else if (this.facingRight && this.hspeed != 0.0f && this.canMoveRight) {
            this.hspeed -= 0.05f;
            if (this.hspeed < 0.0f) {
                this.hspeed = 0.0f;
            }
        } else if (this.hspeed != 0.0f && this.canMoveLeft) {
            this.hspeed += 0.05f;
            if (this.hspeed > 0.0f) {
                this.hspeed = 0.0f;
            }
        }
        this.entityX += this.hspeed;
        this.entityY += this.vspeed;
        if (this.ridingPlatform != null) {
            this.entityX = (float)((double)this.entityX + this.ridingPlatform.hspeed);
            this.entityY = (float)((double)this.entityY + this.ridingPlatform.vspeed);
        }
        this.x = (int)this.entityX;
        this.y = (int)this.entityY;
        if (this.entityX < 0.0f) {
            this.entityX += (float)GameLogic.currentMap.MAP_WIDTH;
        } else if (this.entityX > (float)GameLogic.currentMap.MAP_WIDTH) {
            this.entityX -= (float)GameLogic.currentMap.MAP_WIDTH;
        }
        if (this.entityY > (float)GameLogic.currentMap.MAP_HEIGHT) {
            this.entityY = -32.0f;
        }
    }

    @Override
    protected void updateImage(long timePassed) {
        if (this.live) {
            this.detonatingAnim.reset();
            this.liveAnim.update(timePassed);
            this.currentImage = this.liveAnim.getImage();
        } else if (this.aboutToExplode) {
            this.liveAnim.reset();
            this.detonatingAnim.update(timePassed);
            this.currentImage = this.detonatingAnim.getImage();
        }
    }

    @Override
    public void drawToScreen(Graphics2D g2D, float xPos, float yPos) {
        super.drawToScreen(g2D, xPos, yPos);
    }

    @Override
    public BufferedImage getHeldImage() {
        if (this.live) {
            return this.liveAnim.getImage();
        }
        if (this.aboutToExplode) {
            return this.detonatingAnim.getImage();
        }
        return null;
    }

    @Override
    public void release(Entity thrower) {
        this.facingRight = thrower.facingRight;
        this.entityX = thrower.facingRight ? thrower.entityX + 16.0f : thrower.entityX - 16.0f;
        this.entityY = thrower.entityY - 6.0f;
        this.hspeed = thrower.facingRight ? 3.0f : -3.0f;
        this.vspeed = -3.0f;
        this.released = true;
        this.spawn();
    }

    @Override
    public void iTileBumpTop() {
        this.vspeed = -3.0f;
    }
}

