/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.entity;

import com.dmgame.GameLogic;
import com.dmgame.entity.Entity;
import com.dmgame.entity.Team;
import com.dmgame.leveleditor.LevelEditorScene;
import com.dmgame.map.Map;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JMenu;

public abstract class EditableEntity
extends Entity
implements Cloneable {
    private static final long serialVersionUID = -7983305132494122584L;
    public transient JComponent[] components;
    public transient JMenu[] menuOptions;
    public transient LayoutManager layout;
    protected boolean editorMode;
    protected Map map;

    public EditableEntity(String spriteFilename, float entityX, float entityY, boolean editorMode) {
        super(spriteFilename, entityX, entityY, Team.UNALLIED);
        this.editorMode = editorMode;
        this.map = editorMode ? LevelEditorScene.map : GameLogic.currentMap;
        this.vspeed = 0.0f;
        this.hspeed = 0.0f;
    }

    @Override
    protected void setTeamColor(Team teamColor) {
    }

    protected abstract JComponent[] setupComponents();

    protected abstract JMenu[] getSettingsMenuOptions();

    protected abstract LayoutManager getLayout();

    @Override
    public void drawToScreen(Graphics2D g2D, float xPos, float yPos) {
        g2D.drawImage((Image)this.getImage(), Math.round(xPos), Math.round(yPos), null);
        if (Math.round(xPos) > this.map.MAP_WIDTH - 32) {
            this.drawToScreen(g2D, xPos - (float)this.map.MAP_WIDTH, yPos);
        }
    }

    @Override
    public void update(long timePassed) {
        if (this.editorMode) {
            this.updateImage(timePassed);
        } else {
            super.update(timePassed);
        }
    }

    @Override
    public void spawn() {
        GameLogic.addMapEntity(this);
    }

    @Override
    public void die() {
        GameLogic.removeMapEntity(this);
    }

    public final boolean inEditor() {
        return this.editorMode;
    }

    public final void setEditorMode(boolean editorMode) {
        this.editorMode = editorMode;
    }

    public void setLocation(float entityX, float entityY) {
        this.entityX = entityX;
        this.entityY = entityY;
        this.relX = (int)(this.entityX / 32.0f);
        this.relY = (int)(this.entityY / 32.0f);
        this.x = Math.round(entityX);
        this.y = Math.round(entityY);
    }

    public void setRelLocation(int relX, int relY) {
        this.entityX = relX * 16;
        this.entityY = relY * 16;
        this.relX = (int)(this.entityX / 32.0f);
        this.relY = (int)(this.entityY / 32.0f);
        this.x = Math.round(this.entityX);
        this.y = Math.round(this.entityY);
    }

    public void setSwingComponents() {
        this.components = this.setupComponents();
        this.menuOptions = this.getSettingsMenuOptions();
        this.layout = this.getLayout();
    }

    @Override
    public abstract Object clone();
}

