/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.entity;

import com.dmgame.Direction;
import com.dmgame.Drawable;
import com.dmgame.GameLogic;
import com.dmgame.Geometry;
import com.dmgame.Interactive;
import com.dmgame.MapScene;
import com.dmgame.SpriteColorModel;
import com.dmgame.Updatable;
import com.dmgame.entity.Team;
import com.dmgame.leveleditor.LevelEditorScene;
import com.dmgame.map.InteractiveTile;
import com.dmgame.map.Map;
import com.dmgame.map.PhysicalTile;
import com.dmgame.map.Platform;
import com.dmgame.map.TileType;
import com.dmgame.net.server.NetplayServer;
import com.dmgame.sound.Sound;
import com.dmgame.sound.SoundPlayer;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.imageio.ImageIO;

public strictfp abstract class Entity
extends Rectangle
implements Serializable,
Interactive,
Updatable,
Drawable {
    private static final long serialVersionUID = -5844802055298308040L;
    public int entityID = GameLogic.getUniqueEntityID();
    private String spriteFilename;
    public transient BufferedImage currentImage;
    protected float baseFrameRate = 30.0f;
    public float entityX;
    public float entityY;
    public float hspeed;
    public float vspeed;
    public int relX;
    public int relY;
    protected boolean canReact;
    protected transient int spawning;
    public boolean onGround;
    public boolean canMoveLeft;
    public boolean canMoveRight;
    public boolean canMoveUp;
    public boolean facingRight;
    public boolean onSlippery;
    protected transient Platform ridingPlatform;
    protected final int networkBytes = 23;
    protected transient SpriteColorModel teamColors;
    public Team teamColor;
    public static final BufferedImage ICE_BLOCK = Entity.iceBlock();
    protected boolean frozen;
    public int ownedProjectiles = 0;
    public Set<CollisionType> ctypes;

    public Entity(String spriteFilename, float entityX, float entityY, Team teamColor) {
        super(32, 32);
        this.spriteFilename = spriteFilename;
        this.ctypes = new HashSet<CollisionType>();
        this.frozen = false;
        this.onSlippery = false;
        this.onGround = false;
        this.facingRight = true;
        this.canMoveUp = true;
        this.canMoveRight = true;
        this.canMoveLeft = true;
        this.vspeed = 0.0f;
        this.hspeed = 0.0f;
        this.canReact = true;
        this.teamColor = teamColor;
        this.createSprites(spriteFilename);
        this.setTeamColor(teamColor);
        this.entityX = entityX;
        this.entityY = entityY;
        this.relX = (int)(entityX / 32.0f);
        this.relY = (int)(entityY / 32.0f);
        this.x = Math.round(entityX);
        this.y = Math.round(entityY);
        if (NetplayServer.running) {
            NetplayServer.queueCreateUpdate(this);
        }
    }

    public abstract String getScriptCreateStatement();

    protected String buildString(Object ... vars) {
        StringBuilder builder = new StringBuilder();
        for (Object o : vars) {
            builder.append(o);
        }
        return builder.toString();
    }

    private static BufferedImage iceBlock() {
        try {
            return ImageIO.read(new File("res/gfx/packs/" + MapScene.texturePackName + "/eyecandy/iceblock.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected abstract void setTeamColor(Team var1);

    protected abstract void createSprites(String var1);

    protected abstract void updateMovement(long var1);

    protected abstract void updateImage(long var1);

    public void collisionLogic() {
        if (!this.canReact) {
            return;
        }
        this.relX = (int)(this.getCenterX() / 32.0);
        this.relY = (int)(this.getCenterY() / 32.0);
        PhysicalTile[][] pTiles = new PhysicalTile[3][3];
        InteractiveTile[][] iTiles = new InteractiveTile[3][3];
        int useX = this.relX - 1;
        int useY = this.relY - 1;
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                if (useY + y < 0 || useY + y > GameLogic.usePTiles[0].length - 1) {
                    pTiles[x][y] = null;
                    iTiles[x][y] = null;
                    continue;
                }
                if (useX + x < 0) {
                    pTiles[x][y] = GameLogic.usePTiles[GameLogic.usePTiles.length - 1][useY + y];
                    iTiles[x][y] = GameLogic.currentMap.iTiles[GameLogic.usePTiles.length - 1][useY + y];
                    continue;
                }
                if (useX + x >= GameLogic.usePTiles.length) {
                    pTiles[x][y] = GameLogic.usePTiles[0][useY + y];
                    iTiles[x][y] = GameLogic.currentMap.iTiles[0][useY + y];
                    continue;
                }
                pTiles[x][y] = GameLogic.usePTiles[useX + x][useY + y];
                iTiles[x][y] = GameLogic.currentMap.iTiles[useX + x][useY + y];
            }
        }
        this.collisionLogic(pTiles, iTiles, false);
        this.ridingPlatform = null;
        for (int i = 0; i < GameLogic.currentMap.platforms.size(); ++i) {
            Platform p = GameLogic.currentMap.platforms.get(i);
            if (!this.intersects(p)) continue;
            useX = (int)((this.entityX - (float)p.getCurrentX()) / 32.0f) - 2;
            useY = (int)((this.entityY - (float)p.getCurrentY()) / 32.0f) - 2;
            for (int x = 0; x < 3; ++x) {
                for (int y = 0; y < 3; ++y) {
                    if (useY + y < 0 || useY + y > p.pTiles[0].length - 1) {
                        pTiles[x][y] = null;
                        iTiles[x][y] = null;
                        continue;
                    }
                    if (useX + x < 0) {
                        pTiles[x][y] = p.pTiles[p.pTiles.length - 1][y];
                        iTiles[x][y] = p.iTiles[p.pTiles.length - 1][y];
                        continue;
                    }
                    if (useX + x >= p.pTiles.length) {
                        pTiles[x][y] = p.pTiles[0][y];
                        iTiles[x][y] = p.iTiles[0][y];
                        continue;
                    }
                    pTiles[x][y] = p.pTiles[useX + x][useY + y];
                    iTiles[x][y] = p.iTiles[useX + x][useY + y];
                }
            }
            if (!this.collisionLogic(pTiles, iTiles, true)) continue;
            this.ridingPlatform = p;
        }
        if (!this.canMoveLeft && !this.canMoveRight) {
            GameLogic.gamemode.reportKill(null, this);
            this.die();
        }
    }

    protected synchronized boolean collisionLogic(PhysicalTile[][] pTiles, InteractiveTile[][] iTiles, boolean platformCollision) {
        int i;
        int checkHeight;
        int matches;
        Polygon p;
        Direction dir;
        Direction dir2;
        Rectangle useBBox;
        Rectangle predictingBox = new Rectangle(this);
        predictingBox.x = (int)((float)predictingBox.x + this.hspeed);
        predictingBox.y = (int)((float)predictingBox.y + this.vspeed);
        Rectangle wrapBox = new Rectangle(predictingBox);
        wrapBox.translate(-GameLogic.currentMap.MAP_WIDTH, 0);
        this.canMoveUp = true;
        if (!platformCollision) {
            this.canMoveLeft = true;
            this.canMoveRight = true;
            this.onGround = false;
        }
        boolean foundGround = false;
        PhysicalTile checkTile = pTiles[0][1];
        if (checkTile != null && (checkTile.mask.intersects(predictingBox) || checkTile.mask.intersects(wrapBox))) {
            useBBox = checkTile.mask.intersects(predictingBox) ? predictingBox : wrapBox;
            dir2 = Direction.LEFT;
            if (checkTile.type.willKill(dir2) && !this.ctypes.contains((Object)CollisionType.NO_KILL)) {
                GameLogic.gamemode.reportKill(null, this);
                this.die();
                return false;
            }
            if (checkTile.type.isSolid(dir2)) {
                if (checkTile.mask instanceof Polygon) {
                    this.entityY = Geometry.calculateVerticalCollision(checkTile.mask, useBBox, false) + 1;
                    this.y = (int)this.entityY;
                    this.vspeed = 0.0f;
                    this.onGround = true;
                    foundGround = true;
                    if (this.ctypes.contains((Object)CollisionType.VERT_DIE) || this.ctypes.contains((Object)CollisionType.CONTACT_DIE)) {
                        this.die();
                    }
                } else {
                    this.entityX = Geometry.calculateSideCollision(checkTile.mask, useBBox, true);
                    if (!this.ctypes.contains((Object)CollisionType.HORIZ_BOUNCE)) {
                        this.hspeed = 0.0f;
                    }
                    this.canMoveLeft = false;
                    if (this.ctypes.contains((Object)CollisionType.HORIZ_DIE) || this.ctypes.contains((Object)CollisionType.CONTACT_DIE)) {
                        this.die();
                    } else if (this.ctypes.contains((Object)CollisionType.HORIZ_BOUNCE)) {
                        this.hspeed = -this.hspeed;
                        SoundPlayer.playSound(Sound.BUMP);
                    }
                }
            }
            if (checkTile.type == TileType.INTERACTIVE && !this.ctypes.contains((Object)CollisionType.NO_ITILE) && iTiles[0][1] != null) {
                iTiles[0][1].react(this, dir2);
            }
        }
        predictingBox = new Rectangle(this);
        wrapBox = new Rectangle(predictingBox);
        wrapBox.translate(-GameLogic.currentMap.MAP_WIDTH, 0);
        checkTile = pTiles[1][1];
        if (checkTile != null && (checkTile.mask.intersects(predictingBox) || checkTile.mask.intersects(wrapBox))) {
            useBBox = checkTile.mask.intersects(predictingBox) ? predictingBox : wrapBox;
            dir2 = Direction.DOWN;
            if (checkTile.type.willKill(dir2) && !this.ctypes.contains((Object)CollisionType.NO_KILL)) {
                GameLogic.gamemode.reportKill(null, this);
                this.die();
                return false;
            }
            if (checkTile.type.isSolid(dir2) && checkTile.mask instanceof Polygon) {
                this.entityY = Geometry.calculateVerticalCollision(checkTile.mask, useBBox, false) + 1;
                this.y = (int)this.entityY;
                this.vspeed = 0.0f;
                this.onGround = true;
                foundGround = true;
                if (this.ctypes.contains((Object)CollisionType.VERT_DIE) || this.ctypes.contains((Object)CollisionType.CONTACT_DIE)) {
                    this.die();
                }
            }
            if (checkTile.type == TileType.INTERACTIVE && !this.ctypes.contains((Object)CollisionType.NO_ITILE) && iTiles[1][1] != null) {
                iTiles[1][1].react(this, dir2);
            }
        }
        predictingBox = new Rectangle(this);
        wrapBox = new Rectangle(predictingBox);
        wrapBox.translate(-GameLogic.currentMap.MAP_WIDTH, 0);
        checkTile = pTiles[2][1];
        if (checkTile != null && (checkTile.mask.intersects(predictingBox) || checkTile.mask.intersects(wrapBox))) {
            useBBox = checkTile.mask.intersects(predictingBox) ? predictingBox : wrapBox;
            dir2 = Direction.RIGHT;
            if (checkTile.type.willKill(dir2) && !this.ctypes.contains((Object)CollisionType.NO_KILL)) {
                GameLogic.gamemode.reportKill(null, this);
                this.die();
                return false;
            }
            if (checkTile.type.isSolid(dir2)) {
                if (checkTile.mask instanceof Polygon) {
                    this.entityY = Geometry.calculateVerticalCollision(checkTile.mask, useBBox, false) + 1;
                    this.y = (int)this.entityY;
                    this.vspeed = 0.0f;
                    this.onGround = true;
                } else {
                    this.entityX = Geometry.calculateSideCollision(checkTile.mask, useBBox, false) - 4;
                    if (!this.ctypes.contains((Object)CollisionType.HORIZ_BOUNCE)) {
                        this.hspeed = 0.0f;
                    }
                    this.canMoveRight = false;
                    if (this.ctypes.contains((Object)CollisionType.HORIZ_DIE) || this.ctypes.contains((Object)CollisionType.CONTACT_DIE)) {
                        this.die();
                    } else if (this.ctypes.contains((Object)CollisionType.HORIZ_BOUNCE)) {
                        this.hspeed = -this.hspeed;
                        SoundPlayer.playSound(Sound.BUMP);
                    }
                }
            }
            if (checkTile.type == TileType.INTERACTIVE && !this.ctypes.contains((Object)CollisionType.NO_ITILE)) {
                iTiles[2][1].react(this, dir2);
            }
        }
        predictingBox = new Rectangle(this);
        wrapBox = new Rectangle(predictingBox);
        wrapBox.translate(-GameLogic.currentMap.MAP_WIDTH, 0);
        checkTile = pTiles[1][0];
        if (checkTile != null && (checkTile.mask.intersects(predictingBox) || checkTile.mask.intersects(wrapBox))) {
            useBBox = checkTile.mask.intersects(predictingBox) ? predictingBox : wrapBox;
            dir2 = Direction.UP;
            if (checkTile.type.willKill(dir2) && !this.ctypes.contains((Object)CollisionType.NO_KILL)) {
                GameLogic.gamemode.reportKill(null, this);
                this.die();
                return false;
            }
            if (checkTile.type.isSolid(dir2)) {
                this.entityY = Geometry.calculateVerticalCollision(checkTile.mask, useBBox, true) + 1;
                this.vspeed = 0.0f;
                this.canMoveUp = false;
            }
            if (checkTile.type == TileType.INTERACTIVE && !this.ctypes.contains((Object)CollisionType.NO_ITILE) && iTiles[1][0] != null) {
                iTiles[1][0].react(this, dir2);
            }
        }
        predictingBox = new Rectangle(this);
        wrapBox = new Rectangle(predictingBox);
        wrapBox.translate(-GameLogic.currentMap.MAP_WIDTH, 0);
        checkTile = pTiles[0][0];
        if (this.canMoveLeft && this.canMoveUp && checkTile != null && (checkTile.mask.intersects(predictingBox) || checkTile.mask.intersects(wrapBox))) {
            float slope;
            Rectangle rectangle = useBBox = checkTile.mask.intersects(predictingBox) ? predictingBox : wrapBox;
            boolean fromSide = checkTile.mask.getBounds().x == (int)this.entityX ? false : (slope = ((float)checkTile.mask.getBounds().y - this.entityY) / ((float)checkTile.mask.getBounds().x - this.entityX)) < 1.0f;
            Direction direction = dir = fromSide ? Direction.LEFT : Direction.UP;
            if (checkTile.type.willKill(dir) && !this.ctypes.contains((Object)CollisionType.NO_KILL)) {
                GameLogic.gamemode.reportKill(null, this);
                this.die();
                return false;
            }
            if (checkTile.type.isSolid(dir)) {
                if (checkTile.mask instanceof Polygon) {
                    p = (Polygon)checkTile.mask;
                    matches = 0;
                    checkHeight = p.getBounds().y;
                    for (i = 0; i < p.npoints; ++i) {
                        if (p.ypoints[i] != checkHeight) continue;
                        ++matches;
                    }
                    if (matches < 2) {
                        this.entityY = Geometry.calculateVerticalCollision(checkTile.mask, useBBox, true);
                        this.vspeed = 0.0f;
                        this.onGround = true;
                        foundGround = true;
                        if (this.ctypes.contains((Object)CollisionType.VERT_DIE) || this.ctypes.contains((Object)CollisionType.CONTACT_DIE)) {
                            this.die();
                        }
                    }
                }
                if (fromSide) {
                    this.entityX = Geometry.calculateSideCollision(checkTile.mask, useBBox, true);
                    if (!this.ctypes.contains((Object)CollisionType.HORIZ_BOUNCE)) {
                        this.hspeed = 0.0f;
                    }
                    this.canMoveLeft = false;
                    if (this.ctypes.contains((Object)CollisionType.HORIZ_DIE) || this.ctypes.contains((Object)CollisionType.CONTACT_DIE)) {
                        this.die();
                    } else if (this.ctypes.contains((Object)CollisionType.HORIZ_BOUNCE)) {
                        this.hspeed = -this.hspeed;
                    }
                } else {
                    this.entityY = Geometry.calculateVerticalCollision(checkTile.mask, useBBox, true);
                    this.vspeed = 0.0f;
                    this.canMoveUp = false;
                }
            }
            if (checkTile.type == TileType.INTERACTIVE && !this.ctypes.contains((Object)CollisionType.NO_ITILE) && iTiles[0][0] != null) {
                iTiles[0][0].react(this, dir);
            }
        }
        predictingBox = new Rectangle(this);
        wrapBox = new Rectangle(predictingBox);
        wrapBox.translate(-GameLogic.currentMap.MAP_WIDTH, 0);
        checkTile = pTiles[2][0];
        if (this.canMoveRight && this.canMoveUp && checkTile != null && (checkTile.mask.intersects(predictingBox) || checkTile.mask.intersects(wrapBox))) {
            float slope;
            Rectangle rectangle = useBBox = checkTile.mask.intersects(predictingBox) ? predictingBox : wrapBox;
            boolean fromSide = checkTile.mask.getBounds().x == (int)this.entityX ? false : (slope = ((float)checkTile.mask.getBounds().y - this.entityY) / ((float)checkTile.mask.getBounds().x - this.entityX)) < 1.0f;
            Direction direction = dir = fromSide ? Direction.RIGHT : Direction.UP;
            if (checkTile.type.willKill(dir) && this.ctypes.contains((Object)CollisionType.NO_KILL)) {
                GameLogic.gamemode.reportKill(null, this);
                this.die();
                return false;
            }
            if (checkTile.type.isSolid(dir)) {
                if (checkTile.mask instanceof Polygon) {
                    p = (Polygon)checkTile.mask;
                    matches = 0;
                    checkHeight = p.getBounds().y + p.getBounds().height;
                    for (i = 0; i < p.npoints; ++i) {
                        if (p.ypoints[i] != checkHeight) continue;
                        ++matches;
                    }
                    if (matches < 2) {
                        this.entityY = Geometry.calculateVerticalCollision(checkTile.mask, useBBox, false);
                        this.vspeed = 0.0f;
                    }
                }
                if (fromSide) {
                    this.entityX = Geometry.calculateSideCollision(checkTile.mask, useBBox, false) - 4;
                    this.hspeed = 0.0f;
                    this.canMoveRight = false;
                    if (this.ctypes.contains((Object)CollisionType.HORIZ_DIE) || this.ctypes.contains((Object)CollisionType.CONTACT_DIE)) {
                        this.die();
                    } else if (this.ctypes.contains((Object)CollisionType.HORIZ_BOUNCE)) {
                        this.hspeed = -this.hspeed;
                        SoundPlayer.playSound(Sound.BUMP);
                    }
                } else {
                    this.entityY = Geometry.calculateVerticalCollision(checkTile.mask, useBBox, true);
                    this.vspeed = 0.0f;
                    this.canMoveUp = false;
                }
            }
            if (checkTile.type == TileType.INTERACTIVE && !this.ctypes.contains((Object)CollisionType.NO_ITILE) && iTiles[2][0] != null) {
                iTiles[2][0].react(this, dir);
            }
        }
        predictingBox = new Rectangle(this);
        wrapBox = new Rectangle(predictingBox);
        wrapBox.translate(-GameLogic.currentMap.MAP_WIDTH, 0);
        checkTile = pTiles[1][2];
        if (checkTile != null && (checkTile.mask.intersects(predictingBox) || checkTile.mask.intersects(wrapBox))) {
            useBBox = checkTile.mask.intersects(predictingBox) ? predictingBox : wrapBox;
            dir = Direction.DOWN;
            if (checkTile.type.willKill(dir) && !this.ctypes.contains((Object)CollisionType.NO_KILL)) {
                GameLogic.gamemode.reportKill(null, this);
                this.die();
                return false;
            }
            if (checkTile.type.isSolid(dir) && this.vspeed >= 0.0f) {
                this.entityY = Geometry.calculateVerticalCollision(checkTile.mask, useBBox, false) + 1;
                this.vspeed = 0.0f;
                this.onGround = true;
                foundGround = true;
                if (this.ctypes.contains((Object)CollisionType.VERT_DIE) || this.ctypes.contains((Object)CollisionType.CONTACT_DIE)) {
                    this.die();
                }
            }
            if (checkTile.type == TileType.INTERACTIVE && !this.ctypes.contains((Object)CollisionType.NO_ITILE) && iTiles[1][2] != null) {
                iTiles[1][2].react(this, dir);
            }
        }
        predictingBox = new Rectangle(this);
        wrapBox = new Rectangle(predictingBox);
        wrapBox.translate(-GameLogic.currentMap.MAP_WIDTH, 0);
        checkTile = pTiles[0][2];
        if (this.canMoveLeft && !this.onGround && checkTile != null && (checkTile.mask.intersects(predictingBox) || checkTile.mask.intersects(wrapBox))) {
            float slope;
            Rectangle rectangle = useBBox = checkTile.mask.intersects(predictingBox) ? predictingBox : wrapBox;
            boolean fromSide = checkTile.mask.getBounds().x == (int)this.entityX ? false : (slope = ((float)checkTile.mask.getBounds().y - this.entityY) / ((float)checkTile.mask.getBounds().x - this.entityX)) < 1.0f;
            dir = Direction.DOWN;
            if (checkTile.type.willKill(dir) && !this.ctypes.contains((Object)CollisionType.NO_KILL)) {
                GameLogic.gamemode.reportKill(null, this);
                this.die();
                return false;
            }
            if (checkTile.type.isSolid(dir)) {
                if (checkTile.mask instanceof Polygon) {
                    p = (Polygon)checkTile.mask;
                    matches = 0;
                    checkHeight = p.getBounds().y + p.getBounds().height;
                    for (i = 0; i < p.npoints; ++i) {
                        if (p.ypoints[i] != checkHeight) continue;
                        ++matches;
                    }
                    if (matches < 2 && this.vspeed >= 0.0f) {
                        this.entityY = Geometry.calculateVerticalCollision(checkTile.mask, useBBox, false) + 1;
                        this.vspeed = 0.0f;
                        this.onGround = true;
                        foundGround = true;
                        if (this.ctypes.contains((Object)CollisionType.VERT_DIE) || this.ctypes.contains((Object)CollisionType.CONTACT_DIE)) {
                            this.die();
                        }
                    }
                }
                if (this.canMoveLeft && this.vspeed >= 0.0f) {
                    this.entityY = Geometry.calculateVerticalCollision(checkTile.mask, useBBox, false) + 1;
                    this.vspeed = 0.0f;
                    this.onGround = true;
                    foundGround = true;
                    if (this.ctypes.contains((Object)CollisionType.VERT_DIE) || this.ctypes.contains((Object)CollisionType.CONTACT_DIE)) {
                        this.die();
                    }
                }
            }
            if (checkTile.type == TileType.INTERACTIVE && !this.ctypes.contains((Object)CollisionType.NO_ITILE) && iTiles[0][2] != null) {
                iTiles[0][2].react(this, dir);
            }
        }
        predictingBox = new Rectangle(this);
        wrapBox = new Rectangle(predictingBox);
        wrapBox.translate(-GameLogic.currentMap.MAP_WIDTH, 0);
        checkTile = pTiles[2][2];
        if (this.canMoveRight && !this.onGround && checkTile != null && (checkTile.mask.intersects(predictingBox) || checkTile.mask.intersects(wrapBox))) {
            Rectangle rectangle = useBBox = checkTile.mask.intersects(predictingBox) ? predictingBox : wrapBox;
            if (checkTile.mask.getBounds().x == (int)this.entityX) {
                boolean fromSide = false;
            } else {
                float slope = ((float)checkTile.mask.getBounds().y - this.entityY) / ((float)checkTile.mask.getBounds().x - this.entityX);
                boolean fromSide = (double)slope < 0.8 && this.entityY - (float)checkTile.mask.getBounds().y > 8.0f;
            }
            Direction dir3 = Direction.DOWN;
            if (checkTile.type.willKill(dir3) && !this.ctypes.contains((Object)CollisionType.NO_KILL)) {
                GameLogic.gamemode.reportKill(null, this);
                this.die();
                return false;
            }
            if (checkTile.type.isSolid(dir3) && this.vspeed >= 0.0f) {
                this.entityY = Geometry.calculateVerticalCollision(checkTile.mask, useBBox, false) + 1;
                this.vspeed = 0.0f;
                this.onGround = true;
                foundGround = true;
                if (this.ctypes.contains((Object)CollisionType.VERT_DIE) || this.ctypes.contains((Object)CollisionType.CONTACT_DIE)) {
                    this.die();
                }
            }
            if (checkTile.type == TileType.INTERACTIVE && !this.ctypes.contains((Object)CollisionType.NO_ITILE) && iTiles[2][2] != null) {
                iTiles[2][2].react(this, dir3);
            }
        }
        return platformCollision && foundGround;
    }

    public void reactionLogic(Collection<Entity> entities) {
        for (Entity e : entities) {
            if (this.equals(e) || !this.intersects(e)) continue;
            float slope = Math.abs(e.entityY - this.entityY) / Math.abs(e.entityX - this.entityX);
            if (slope > 1.0f) {
                if (e.entityY < this.entityY) {
                    e.react(this, Direction.UP);
                    continue;
                }
                e.react(this, Direction.DOWN);
                continue;
            }
            if (!(slope < 1.0f)) continue;
            if (e.entityX < this.entityX) {
                e.react(this, Direction.RIGHT);
                continue;
            }
            e.react(this, Direction.LEFT);
        }
    }

    public void spawn() {
        GameLogic.addEntity(this);
    }

    public void die() {
        GameLogic.removeEntity(this);
        if (NetplayServer.running) {
            NetplayServer.reportDeath(this);
        }
    }

    public BufferedImage getImage() {
        return this.currentImage;
    }

    @Override
    public void drawToScreen(Graphics2D g2D, float xPos, float yPos) {
        Map map;
        g2D.drawImage((Image)this.getImage(), Math.round(xPos), Math.round(yPos), null);
        Map map2 = map = LevelEditorScene.isRunning() ? LevelEditorScene.map : GameLogic.currentMap;
        if (Math.round(xPos) > map.MAP_WIDTH - 32) {
            this.drawToScreen(g2D, xPos - (float)map.MAP_WIDTH, yPos);
        }
    }

    @Override
    public void update(long timePassed) {
        if (this.canReact) {
            this.updateMovement(timePassed);
        }
        this.updateImage(timePassed);
        if (!this.canReact) {
            this.moveOneNorth();
            ++this.spawning;
            if (this.spawning > 32) {
                this.canReact = true;
            }
        }
    }

    protected final void moveOneNorth() {
        this.entityY -= 1.0f;
        this.x = (int)this.entityX;
        this.y = (int)this.entityY;
        this.relY = (int)(this.entityY / 32.0f);
    }

    protected final void moveOneSouth() {
        this.entityY += 1.0f;
        this.x = (int)this.entityX;
        this.y = (int)this.entityY;
        this.relY = (int)(this.entityY / 32.0f);
    }

    protected final void moveOneEast() {
        this.entityX += 1.0f;
        this.x = (int)this.entityX;
        this.y = (int)this.entityY;
        this.relX = (int)(this.entityX / 32.0f);
    }

    protected final void moveOneWest() {
        this.entityX -= 1.0f;
        this.x = (int)this.entityX;
        this.y = (int)this.entityY;
        this.relX = (int)(this.entityX / 32.0f);
    }

    public byte[] prepareNetworkUpdate() {
        byte[] updateData = new byte[23];
        updateData[0] = 60;
        System.arraycopy(ByteBuffer.allocate(4).putInt(this.entityID).array(), 0, updateData, 1, 4);
        System.arraycopy(ByteBuffer.allocate(4).putFloat(this.entityX).array(), 0, updateData, 5, 4);
        System.arraycopy(ByteBuffer.allocate(4).putFloat(this.entityY).array(), 0, updateData, 9, 4);
        System.arraycopy(ByteBuffer.allocate(4).putFloat(this.hspeed).array(), 0, updateData, 13, 4);
        System.arraycopy(ByteBuffer.allocate(4).putFloat(this.vspeed).array(), 0, updateData, 17, 4);
        return updateData;
    }

    public void getNetworkUpdate(float x, float y, float h, float v, byte[] extra) {
        this.entityX = x;
        this.x = Math.round(x);
        this.entityY = y;
        this.y = Math.round(y);
        this.hspeed = h;
        this.vspeed = v;
        if (this.vspeed > 18.0f) {
            this.vspeed = 18.0f;
        } else if ((double)this.vspeed < -18.0 * GameLogic.speedMultiplier) {
            this.vspeed = (float)(-18.0 * GameLogic.speedMultiplier);
        }
    }

    @Override
    public String toString() {
        return "[" + this.getClass().getName() + ", " + (Object)((Object)this.teamColor) + ", Rel X: " + this.relX + ", Rel Y: " + this.relY + ", X: " + this.entityX + ", Y: " + this.entityY + "]";
    }

    public boolean isOnGround() {
        return this.onGround;
    }

    public boolean isInMotion() {
        return this.hspeed != 0.0f || this.vspeed != 0.0f;
    }

    public boolean isOnSlipperyTile() {
        return this.onSlippery;
    }

    public void freeze() {
        this.frozen = true;
        SoundPlayer.playSound(Sound.TRANSFORM);
        GameLogic.startDelayedAction(3000L, new Runnable(){

            @Override
            public void run() {
                Entity.this.frozen = false;
            }
        });
    }

    public abstract void iTileBumpTop();

    public void postNetworkCreate() {
        this.createSprites(this.spriteFilename);
        this.setTeamColor(this.teamColor);
    }

    public strictfp static enum CollisionType {
        HORIZ_BOUNCE,
        HORIZ_DIE,
        VERT_BOUNCE,
        VERT_DIE,
        CONTACT_DIE,
        NO_KILL,
        NO_ITILE;

    }
}

