/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.entity;

import com.dmgame.Animation;
import com.dmgame.Direction;
import com.dmgame.GameLogic;
import com.dmgame.Interactive;
import com.dmgame.MapScene;
import com.dmgame.entity.Entity;
import com.dmgame.entity.Team;
import com.dmgame.entity.powerups.PowerUp;
import com.dmgame.sound.Sound;
import com.dmgame.sound.SoundPlayer;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;

public final class ExplosionEntity
extends Entity {
    private static final long serialVersionUID = -5303230779593774373L;
    public Entity spawner;
    private transient Animation effectAnim;
    public static final long MAX_EXPLODE_TIME = 1000L;
    public Ellipse2D.Float dieRadius;
    public static final float BLAST_RADIUS_X = 96.0f;
    public static final float BLAST_RADIUS_Y = 64.0f;
    public int entityWidth;
    public int entityHeight;

    public ExplosionEntity(int entityWidth, int entityHeight, Entity spawner) {
        super("explosion", spawner.entityX - (96.0f - (float)(entityWidth / 2)), spawner.entityY - (64.0f - (float)(entityHeight / 2)), Team.UNALLIED);
        this.spawner = spawner;
        this.teamColor = spawner.teamColor;
        this.entityWidth = entityWidth;
        this.entityHeight = entityHeight;
        this.dieRadius = new Ellipse2D.Float(spawner.entityX - (96.0f - (float)(entityWidth / 2)), spawner.entityY - (64.0f - (float)(entityHeight / 2)), 192.0f, 128.0f);
        this.x = (int)this.dieRadius.x;
        this.y = (int)this.dieRadius.y;
        this.width = (int)this.dieRadius.width;
        this.height = (int)this.dieRadius.height;
    }

    @Override
    public String getScriptCreateStatement() {
        return this.buildString(this.getClass().getSimpleName(), "(", this.entityWidth, ",", this.entityHeight, ",", "entities.get(", this.spawner.entityID, "))");
    }

    @Override
    protected void createSprites(String spriteFilename) {
        try {
            BufferedImage sprites = ImageIO.read(new File("res/gfx/packs/" + MapScene.texturePackName + "/eyecandy/" + spriteFilename + ".png"));
            BufferedImage[] spritesheet = new BufferedImage[]{sprites.getSubimage(0, 0, 192, 128), sprites.getSubimage(192, 0, 192, 128)};
            this.effectAnim = new Animation(100L, spritesheet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void setTeamColor(Team teamColor) {
    }

    @Override
    public void react(Interactive i, Direction direction) {
        if (i instanceof Entity && !((Entity)i instanceof PowerUp) && ((Entity)i).teamColor != this.teamColor && ((Entity)i).intersects(this.dieRadius.getBounds2D())) {
            GameLogic.gamemode.reportKill(this.spawner, (Entity)i);
            ((Entity)i).die();
        }
    }

    @Override
    protected void updateMovement(long timePassed) {
    }

    @Override
    protected void updateImage(long timePassed) {
        this.effectAnim.update(timePassed);
        this.currentImage = this.effectAnim.getImage();
    }

    public void updateCoords(float newX, float newY) {
        this.dieRadius.x = this.entityX = newX - (96.0f - (float)(this.entityWidth / 2));
        this.dieRadius.y = this.entityY = newY - (64.0f - (float)(this.entityWidth / 2));
        this.x = (int)this.entityX;
        this.y = (int)this.entityY;
    }

    @Override
    public void collisionLogic() {
    }

    public void startTimer() {
        SoundPlayer.playSound(Sound.EXPLODE);
        GameLogic.startDelayedAction(1000L, new Runnable(){

            @Override
            public void run() {
                ExplosionEntity.this.die();
            }
        });
    }

    @Override
    public void iTileBumpTop() {
    }
}

