/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.entity;

import com.dmgame.Direction;
import com.dmgame.GameLogic;
import com.dmgame.Interactive;
import com.dmgame.PathFollower;
import com.dmgame.entity.EditableEntity;
import com.dmgame.entity.Entity;
import com.dmgame.entity.projectiles.FireballProjectile;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FireballBar
extends EditableEntity {
    private static final long serialVersionUID = -6469575255453228687L;
    public static final int SPEED_MIN = 1;
    public static final int SPEED_MAX = 10;
    public transient ArrayList<BarFireball> fireballs;
    private float speed;
    private int numFireballs;
    private Direction dir;
    private transient JSlider speedSlider;
    private transient JSpinner numFireballsSpinner;

    public FireballBar(float entityX, float entityY, boolean editorMode) {
        super("fireball", entityX, entityY, editorMode);
        this.speed = 5.0f;
        this.numFireballs = 2;
        this.dir = Direction.CLOCKWISE;
        this.setNumFireballs(2);
    }

    @Override
    public String getScriptCreateStatement() {
        return this.buildString(this.getClass().getSimpleName(), "(", Float.valueOf(this.entityX), ",", Float.valueOf(this.entityY), ",", this.editorMode, ")");
    }

    public FireballBar(float entityX, float entityY, boolean editorMode, int[] iParams, float[] dParams) {
        super("fireball", entityX, entityY, editorMode);
        this.numFireballs = iParams[0];
        this.speed = dParams[0];
        this.dir = iParams[1] == 0 ? Direction.CLOCKWISE : Direction.COUNTER_CLOCKWISE;
        this.setNumFireballs(this.numFireballs);
    }

    @Override
    protected void createSprites(String spriteFilename) {
        this.currentImage = null;
    }

    @Override
    public void react(Interactive i, Direction direction) {
    }

    @Override
    public void update(long timePassed) {
        super.update(timePassed);
        for (BarFireball b : this.fireballs) {
            if (this.editorMode) {
                b.updateImage(timePassed);
                continue;
            }
            b.update(timePassed);
        }
    }

    @Override
    protected void updateMovement(long timePassed) {
        this.x = (int)this.entityX;
        this.y = (int)this.entityY;
        if (this.entityX < 0.0f) {
            this.entityX += (float)GameLogic.currentMap.MAP_WIDTH;
        } else if (this.entityX > (float)GameLogic.currentMap.MAP_WIDTH) {
            this.entityX -= (float)GameLogic.currentMap.MAP_WIDTH;
        }
        if (this.entityY > (float)GameLogic.currentMap.MAP_HEIGHT) {
            this.entityY = -32.0f;
        }
        this.relX = (int)(this.entityX / 32.0f);
        this.relY = (int)(this.entityY / 32.0f);
    }

    @Override
    protected void updateImage(long timePassed) {
    }

    @Override
    public void drawToScreen(Graphics2D g2D, float xLoc, float yLoc) {
        for (BarFireball b : this.fireballs) {
            b.drawToScreen(g2D, b.entityX, b.entityY);
        }
    }

    @Override
    public void collisionLogic() {
    }

    @Override
    protected JComponent[] setupComponents() {
        JComponent[] toReturn = new JComponent[4];
        this.speedSlider = new JSlider(0, 1, 10, (int)this.speed);
        this.speedSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                FireballBar.this.speed = source.getValue();
            }
        });
        JLabel speedLabel = new JLabel("Speed");
        speedLabel.setAlignmentX(0.5f);
        JLabel numFireballsLabel = new JLabel("Number of Fireballs");
        SpinnerListModel numFireballsModel = new SpinnerListModel(new String[]{"2", "3", "4", "5", "6", "7", "8", "9"});
        numFireballsModel.setValue(Integer.toString(this.fireballs.size()));
        this.numFireballsSpinner = new JSpinner(numFireballsModel);
        this.numFireballsSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSpinner source = (JSpinner)e.getSource();
                FireballBar.this.setNumFireballs(Integer.parseInt((String)source.getValue()));
            }
        });
        toReturn[0] = speedLabel;
        toReturn[1] = this.speedSlider;
        toReturn[2] = numFireballsLabel;
        toReturn[3] = this.numFireballsSpinner;
        return toReturn;
    }

    @Override
    protected JMenu[] getSettingsMenuOptions() {
        JMenu[] toReturn = new JMenu[1];
        JMenu menu = new JMenu("Direction");
        ButtonGroup group = new ButtonGroup();
        JRadioButtonMenuItem clockwiseButton = new JRadioButtonMenuItem("Clockwise");
        clockwiseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FireballBar.this.dir = Direction.CLOCKWISE;
                for (BarFireball b : FireballBar.this.fireballs) {
                    b.setPath(FireballBar.this.dir);
                }
            }
        });
        group.add(clockwiseButton);
        menu.add(clockwiseButton);
        JRadioButtonMenuItem counterClockwiseButton = new JRadioButtonMenuItem("Counter-Clockwise");
        counterClockwiseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FireballBar.this.dir = Direction.COUNTER_CLOCKWISE;
                for (BarFireball b : FireballBar.this.fireballs) {
                    b.setPath(FireballBar.this.dir);
                }
            }
        });
        group.add(counterClockwiseButton);
        menu.add(counterClockwiseButton);
        switch (this.dir) {
            case CLOCKWISE: {
                clockwiseButton.setSelected(true);
                break;
            }
            case COUNTER_CLOCKWISE: {
                counterClockwiseButton.setSelected(true);
                break;
            }
        }
        menu.validate();
        toReturn[0] = menu;
        return toReturn;
    }

    @Override
    protected LayoutManager getLayout() {
        return new GridLayout(0, 2);
    }

    public void setNumFireballs(int numFireballs) {
        this.numFireballs = numFireballs;
        this.fireballs = new ArrayList(numFireballs);
        for (int i = 0; i < numFireballs; ++i) {
            this.fireballs.add(new BarFireball(this.entityX, this.entityY));
        }
        this.setFireballsPosition();
    }

    private void setFireballsPosition() {
        for (int i = 0; i < this.numFireballs; ++i) {
            this.fireballs.get(i).setPathRadius(i);
        }
    }

    @Override
    public void setLocation(float entityX, float entityY) {
        super.setLocation(entityX, entityY);
        this.setFireballsPosition();
    }

    @Override
    public void setRelLocation(int relX, int relY) {
        super.setRelLocation(relX, relY);
        this.setFireballsPosition();
    }

    public float getBarX() {
        return this.entityX;
    }

    public float getBarY() {
        return this.entityY;
    }

    @Override
    public Object clone() {
        FireballBar f = new FireballBar(this.entityX, this.entityY, this.editorMode);
        f.x = Math.round(this.entityX);
        f.y = Math.round(this.entityY);
        f.speed = this.speed;
        f.dir = this.dir;
        f.setNumFireballs(this.numFireballs);
        return f;
    }

    @Override
    public void iTileBumpTop() {
    }

    public class BarFireball
    extends FireballProjectile {
        private static final long serialVersionUID = -7020520706042935369L;
        public static final transient int SIDE = 18;
        private Ellipse2D.Float path;
        private PathFollower helper;

        public BarFireball(float x, float y) {
            super(x, y);
            this.path = new Ellipse2D.Float(FireballBar.this.getBarX() - 9.0f, FireballBar.this.getBarY() - 9.0f, 18.0f, 18.0f);
            this.resetPathFollower();
        }

        @Override
        public void react(Interactive i, Direction direction) {
            if (i instanceof Entity) {
                GameLogic.gamemode.reportKill(this, (Entity)i);
                ((Entity)i).die();
            }
        }

        @Override
        public void drawToScreen(Graphics2D g2D, float xPos, float yPos) {
            g2D.drawImage((Image)this.getImage(), Math.round(xPos), Math.round(yPos), null);
            if (Math.round(xPos) > FireballBar.this.map.MAP_WIDTH - 32) {
                this.drawToScreen(g2D, xPos - (float)FireballBar.this.map.MAP_WIDTH, yPos);
            }
        }

        @Override
        public void update(long timePassed) {
            super.update(timePassed);
            this.helper.update(timePassed);
        }

        @Override
        public void updateMovement(long timePassed) {
            this.setMapLocation(this.helper.getCurrentPoint());
        }

        public void setMapLocation(float entityX, float entityY) {
            this.entityX = entityX;
            this.entityY = entityY;
            this.x = (int)entityX;
            this.y = (int)entityY;
            if (this.entityX < 0.0f) {
                this.entityX += (float)FireballBar.this.map.MAP_WIDTH;
            } else if (this.entityX > (float)FireballBar.this.map.MAP_WIDTH) {
                this.entityX -= (float)FireballBar.this.map.MAP_WIDTH;
            }
        }

        private void setMapLocation(Point2D.Float point) {
            this.setMapLocation(point.x - (float)(this.width / 2), point.y - (float)(this.height / 2));
        }

        public void setPathRadius(float radius) {
            this.path = new Ellipse2D.Float(FireballBar.this.getBarX() + 18.0f - radius * 18.0f, FireballBar.this.getBarY() + 18.0f - radius * 18.0f, radius * 18.0f * 2.0f, radius * 18.0f * 2.0f);
            this.resetPathFollower();
        }

        public void setPath(Direction dir) {
            if (dir == Direction.CLOCKWISE) {
                if (this.helper.isReversed()) {
                    this.helper.reverseAndReset();
                }
            } else if (dir == Direction.COUNTER_CLOCKWISE && !this.helper.isReversed()) {
                this.helper.reverseAndReset();
            }
        }

        public void resetPathFollower() {
            this.helper = new PathFollower(this.path, FireballBar.this.dir == Direction.COUNTER_CLOCKWISE, FireballBar.this.speed);
            this.setMapLocation(this.helper.getCurrentPoint());
        }

        @Override
        public void collisionLogic() {
        }

        @Override
        public void iTileBumpTop() {
        }
    }
}

