/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.entity;

import com.dmgame.Animation;
import com.dmgame.Direction;
import com.dmgame.GameLogic;
import com.dmgame.Interactive;
import com.dmgame.MapScene;
import com.dmgame.UnthreadedTimer;
import com.dmgame.Utility;
import com.dmgame.entity.EditableEntity;
import com.dmgame.entity.Entity;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Flamethrower
extends EditableEntity {
    private static final long serialVersionUID = -7768756858009025764L;
    public static final Dimension DIM = new Dimension(96, 32);
    public static final Dimension DIM_FLIPPED = new Dimension(32, 96);
    public static final int SMALL = 0;
    public static final int BIG = 1;
    public static final int FREQUENCY_MIN = 1000;
    public static final int FREQUENCY_MAX = 10000;
    public static final long SMALL_ANIM_TIME = 250L;
    public static final long BIG_ANIM_TIME = 500L;
    private long frequency;
    private Direction or;
    private transient UnthreadedTimer animTimer;
    private transient UnthreadedTimer frequencyTimer;
    private transient boolean canKill;
    private transient boolean smallPhase;
    public transient Animation[] anims;
    private transient JSlider frequencySlider;

    public Flamethrower(float entityX, float entityY, boolean editorMode) {
        super("flamethrower", entityX, entityY, editorMode);
        this.or = Direction.RIGHT;
        this.canKill = true;
        this.smallPhase = true;
        this.frequency = 5000L;
        this.setSize(DIM);
        if (!editorMode) {
            this.initializeTimers();
        }
    }

    @Override
    public String getScriptCreateStatement() {
        return this.buildString(this.getClass().getSimpleName(), "(", Float.valueOf(this.entityX), ",", Float.valueOf(this.entityY), ",", this.editorMode, ")");
    }

    public Flamethrower(float entityX, float entityY, boolean editorMode, int[] iParams, float[] dParams) {
        super("flamethrower", entityX, entityY, editorMode);
        this.or = iParams[1] == 1 ? Direction.RIGHT : Direction.LEFT;
        this.canKill = true;
        this.smallPhase = true;
        this.frequency = 5000L;
        this.setSize(DIM);
        if (!editorMode) {
            this.initializeTimers();
        }
    }

    private void initializeTimers() {
        this.animTimer = new UnthreadedTimer(1000L){

            @Override
            public void update(long timePassed) {
                super.update(timePassed);
                if (this.getPercentDone() >= 0.75) {
                    Flamethrower.this.smallPhase = true;
                } else if (this.getPercentDone() >= 0.25) {
                    Flamethrower.this.smallPhase = false;
                } else if (this.getPercentDone() >= 0.0) {
                    Flamethrower.this.smallPhase = true;
                }
            }

            @Override
            public void end() {
                Flamethrower.this.canKill = false;
                this.reset();
            }
        };
        this.frequencyTimer = new UnthreadedTimer(this.frequency){

            @Override
            public void end() {
                Flamethrower.this.canKill = true;
                this.reset();
            }
        };
    }

    @Override
    protected void createSprites(String spriteFilename) {
        try {
            BufferedImage sprites = ImageIO.read(new File("res/gfx/packs/" + MapScene.texturePackName + "/hazards/" + spriteFilename + ".png"));
            BufferedImage[] small = new BufferedImage[2];
            BufferedImage[] big = new BufferedImage[2];
            small[0] = sprites.getSubimage(0, 0, 96, 32);
            small[1] = sprites.getSubimage(0, 32, 96, 32);
            big[0] = sprites.getSubimage(0, 64, 96, 32);
            big[1] = sprites.getSubimage(0, 96, 96, 32);
            this.anims = new Animation[2];
            this.anims[0] = new Animation(80L, small);
            this.anims[1] = new Animation(80L, big);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void update(long timePassed) {
        if (this.canKill) {
            this.animTimer.update(timePassed);
            this.frequencyTimer.reset();
        } else {
            this.frequencyTimer.update(timePassed);
            this.animTimer.reset();
        }
        super.update(timePassed);
    }

    @Override
    public void react(Interactive i, Direction direction) {
        if (this.canKill && i instanceof Entity) {
            GameLogic.gamemode.reportKill(this, (Entity)i);
            ((Entity)i).die();
        }
    }

    @Override
    protected void updateMovement(long timePassed) {
    }

    @Override
    protected void updateImage(long timePassed) {
        if (this.editorMode) {
            this.anims[1].update(timePassed);
            this.currentImage = this.anims[1].getImage();
        } else if (this.smallPhase) {
            this.anims[1].reset();
            this.anims[0].update(timePassed);
            this.currentImage = this.anims[0].getImage();
        } else {
            this.anims[0].reset();
            this.anims[1].update(timePassed);
            this.currentImage = this.anims[1].getImage();
        }
    }

    @Override
    public void drawToScreen(Graphics2D g2D, float xLoc, float yLoc) {
        if (this.canKill) {
            super.drawToScreen(g2D, xLoc, yLoc);
        }
    }

    @Override
    public void collisionLogic() {
    }

    @Override
    protected JComponent[] setupComponents() {
        JComponent[] list = new JComponent[2];
        this.frequencySlider = new JSlider(0, 1000, 10000, (int)this.frequency);
        this.frequencySlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                if (!source.getValueIsAdjusting()) {
                    Flamethrower.this.frequency = source.getValue();
                }
            }
        });
        JLabel frequencyLabel = new JLabel("Frequency", 0);
        frequencyLabel.setAlignmentX(0.5f);
        list[0] = frequencyLabel;
        list[1] = this.frequencySlider;
        return list;
    }

    @Override
    protected JMenu[] getSettingsMenuOptions() {
        JMenu[] toReturn = new JMenu[1];
        JMenu menu = new JMenu("Orientation");
        ButtonGroup group = new ButtonGroup();
        JRadioButtonMenuItem upButton = new JRadioButtonMenuItem("Up");
        upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Flamethrower.this.rotateAll(Direction.UP);
            }
        });
        group.add(upButton);
        menu.add(upButton);
        JRadioButtonMenuItem downButton = new JRadioButtonMenuItem("Down");
        downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Flamethrower.this.rotateAll(Direction.DOWN);
            }
        });
        group.add(downButton);
        menu.add(downButton);
        JRadioButtonMenuItem leftButton = new JRadioButtonMenuItem("Left");
        leftButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Flamethrower.this.rotateAll(Direction.LEFT);
            }
        });
        group.add(leftButton);
        menu.add(leftButton);
        JRadioButtonMenuItem rightButton = new JRadioButtonMenuItem("Right");
        rightButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Flamethrower.this.rotateAll(Direction.RIGHT);
            }
        });
        group.add(rightButton);
        menu.add(rightButton);
        switch (this.or) {
            case UP: {
                upButton.setSelected(true);
                break;
            }
            case DOWN: {
                downButton.setSelected(true);
                break;
            }
            case LEFT: {
                leftButton.setSelected(true);
                break;
            }
            case RIGHT: {
                rightButton.setSelected(true);
                break;
            }
        }
        menu.validate();
        toReturn[0] = menu;
        return toReturn;
    }

    @Override
    protected LayoutManager getLayout() {
        return new GridLayout(0, 2);
    }

    private void rotateAll(Direction or) {
        block0 : switch (this.or) {
            case UP: {
                switch (or) {
                    case DOWN: {
                        for (int i = 0; i < this.anims.length; ++i) {
                            this.anims[i] = Utility.getVerticalFlippedCopy(this.anims[i]);
                        }
                        this.setSize(DIM);
                        break block0;
                    }
                    case LEFT: {
                        for (int i = 0; i < this.anims.length; ++i) {
                            this.anims[i] = Utility.rotateAnimation90(this.anims[i], (byte)3);
                        }
                        this.setSize(DIM_FLIPPED);
                        break block0;
                    }
                    case RIGHT: {
                        for (int i = 0; i < this.anims.length; ++i) {
                            this.anims[i] = Utility.rotateAnimation90(this.anims[i], (byte)1);
                        }
                        this.setSize(DIM_FLIPPED);
                        break block0;
                    }
                }
                break;
            }
            case DOWN: {
                switch (or) {
                    case UP: {
                        for (int i = 0; i < this.anims.length; ++i) {
                            this.anims[i] = Utility.getVerticalFlippedCopy(this.anims[i]);
                        }
                        this.setSize(DIM);
                        break block0;
                    }
                    case LEFT: {
                        for (int i = 0; i < this.anims.length; ++i) {
                            this.anims[i] = Utility.rotateAnimation90(this.anims[i], (byte)1);
                        }
                        this.setSize(DIM_FLIPPED);
                        break block0;
                    }
                    case RIGHT: {
                        for (int i = 0; i < this.anims.length; ++i) {
                            this.anims[i] = Utility.rotateAnimation90(this.anims[i], (byte)3);
                        }
                        this.setSize(DIM_FLIPPED);
                        break block0;
                    }
                }
                break;
            }
            case LEFT: {
                switch (or) {
                    case UP: {
                        for (int i = 0; i < this.anims.length; ++i) {
                            this.anims[i] = Utility.rotateAnimation90(this.anims[i], (byte)1);
                        }
                        this.setSize(DIM);
                        break block0;
                    }
                    case DOWN: {
                        for (int i = 0; i < this.anims.length; ++i) {
                            this.anims[i] = Utility.rotateAnimation90(this.anims[i], (byte)3);
                        }
                        this.setSize(DIM);
                        break block0;
                    }
                    case RIGHT: {
                        for (int i = 0; i < this.anims.length; ++i) {
                            this.anims[i] = Utility.getHorizontalFlippedCopy(this.anims[i]);
                        }
                        this.setSize(DIM_FLIPPED);
                        break block0;
                    }
                }
                break;
            }
            case RIGHT: {
                switch (or) {
                    case UP: {
                        for (int i = 0; i < this.anims.length; ++i) {
                            this.anims[i] = Utility.rotateAnimation90(this.anims[i], (byte)3);
                        }
                        this.setSize(DIM);
                        break block0;
                    }
                    case DOWN: {
                        for (int i = 0; i < this.anims.length; ++i) {
                            this.anims[i] = Utility.rotateAnimation90(this.anims[i], (byte)1);
                        }
                        this.setSize(DIM);
                        break block0;
                    }
                    case LEFT: {
                        for (int i = 0; i < this.anims.length; ++i) {
                            this.anims[i] = Utility.getHorizontalFlippedCopy(this.anims[i]);
                        }
                        this.setSize(DIM_FLIPPED);
                        break block0;
                    }
                }
                break;
            }
        }
        this.or = or;
    }

    @Override
    public Object clone() {
        Flamethrower f = new Flamethrower(this.entityX, this.entityY, this.editorMode);
        f.x = Math.round(this.entityX);
        f.y = Math.round(this.entityY);
        f.frequency = this.frequency;
        f.rotateAll(this.or);
        return f;
    }

    @Override
    public void iTileBumpTop() {
    }
}

