/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.entity;

import com.dmgame.Animation;
import com.dmgame.MapScene;
import com.dmgame.entity.Entity;
import com.dmgame.entity.ThrowBlockEntity;
import com.dmgame.particle.AnimatedParticle;
import com.dmgame.particle.GravityParticleLogic;
import com.dmgame.particle.ParticleLogic;
import com.dmgame.sound.Sound;
import com.dmgame.sound.SoundPlayer;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;

public class GrayThrowBlockEntity
extends ThrowBlockEntity {
    private static final long serialVersionUID = 9007303883756701391L;

    public GrayThrowBlockEntity(float x, float y, Entity thrower) {
        super("graythrowblock", x, y, 10000L, thrower);
    }

    @Override
    public String getScriptCreateStatement() {
        return this.buildString(this.getClass().getSimpleName(), "(", Float.valueOf(this.entityX), ",", Float.valueOf(this.entityY), ",", "entities.get(", this.thrower.entityID, "))");
    }

    @Override
    protected void createParticles() {
        try {
            BufferedImage brokeBlock = ImageIO.read(new File("res/gfx/packs/" + MapScene.texturePackName + "/particles/brokenblueblock.png"));
            SoundPlayer.playSound(Sound.BREAK);
            int width = brokeBlock.getWidth() / 6;
            int height = brokeBlock.getHeight();
            Animation ani = new Animation(30L, brokeBlock.getSubimage(0, 0, width, height), brokeBlock.getSubimage(0, 0, width, height), brokeBlock.getSubimage(16, 0, width, height), brokeBlock.getSubimage(32, 0, width, height), brokeBlock.getSubimage(48, 0, width, height), brokeBlock.getSubimage(64, 0, width, height), brokeBlock.getSubimage(80, 0, width, height));
            AnimatedParticle p = new AnimatedParticle((Animation)ani.clone(), (ParticleLogic)new GravityParticleLogic(-3.0f, -8.0f), (float)((int)this.entityX), (float)((int)this.entityY));
            p.addToMap();
            p = new AnimatedParticle((Animation)ani.clone(), (ParticleLogic)new GravityParticleLogic(3.0f, -8.0f), (float)((int)this.entityX + this.getImage().getWidth() - width), (float)((int)this.entityY));
            p.addToMap();
            p = new AnimatedParticle((Animation)ani.clone(), (ParticleLogic)new GravityParticleLogic(3.0f, 0.0f), (float)((int)this.entityX + this.getImage().getWidth() - width), (float)((int)this.entityY + this.getImage().getHeight() - height));
            p.addToMap();
            p = new AnimatedParticle((Animation)ani.clone(), (ParticleLogic)new GravityParticleLogic(-3.0f, 0.0f), (float)((int)this.entityX), (float)((int)this.entityY + this.getImage().getHeight() - height));
            p.addToMap();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

