/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.entity;

import com.dmgame.Animation;
import com.dmgame.Direction;
import com.dmgame.GameLogic;
import com.dmgame.Interactive;
import com.dmgame.MapScene;
import com.dmgame.Utility;
import com.dmgame.entity.EditableEntity;
import com.dmgame.entity.Entity;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;

public class KuriboShoe
extends EditableEntity {
    private static final long serialVersionUID = 6530899747381387118L;
    public static final int GREEN = 0;
    public static final int PURPLE = 1;
    private KuriboShoeColor color = KuriboShoeColor.GREEN;
    public boolean combo;
    public transient Animation[] sprites;
    public transient Animation[] spritesLeft;

    public KuriboShoe(float entityX, float entityY, boolean editorMode) {
        super("greenkuriboshoe", entityX, entityY, editorMode);
    }

    @Override
    public String getScriptCreateStatement() {
        return this.buildString(this.getClass().getSimpleName(), "(", Float.valueOf(this.entityX), ",", Float.valueOf(this.entityY), ",", this.editorMode, ")");
    }

    @Override
    protected void createSprites(String spriteFilename) {
        try {
            BufferedImage[] preSprites = new BufferedImage[8];
            BufferedImage green = ImageIO.read(new File("res/gfx/packs/" + MapScene.texturePackName + "/mapobjects/" + spriteFilename + ".png"));
            BufferedImage purple = ImageIO.read(new File("res/gfx/packs/" + MapScene.texturePackName + "/mapobjects/purplekuriboshoe.png"));
            preSprites[0] = green.getSubimage(0, 0, 32, 32);
            preSprites[1] = green.getSubimage(32, 0, 32, 32);
            preSprites[2] = purple.getSubimage(0, 0, 32, 32);
            preSprites[3] = purple.getSubimage(32, 0, 32, 32);
            for (int i = 0; i < 4; ++i) {
                preSprites[i + 4] = Utility.getHorizontalFlippedCopy(preSprites[i]);
            }
            this.sprites = new Animation[2];
            this.sprites[0] = new Animation(120L, preSprites[0], preSprites[1]);
            this.sprites[1] = new Animation(120L, preSprites[2], preSprites[3]);
            this.spritesLeft = new Animation[2];
            this.spritesLeft[0] = new Animation(120L, preSprites[4], preSprites[5]);
            this.spritesLeft[1] = new Animation(120L, preSprites[6], preSprites[7]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void comboMovementRule(Entity user) {
        if (user.vspeed < 3.0f) {
            user.vspeed = 3.0f;
        }
        user.vspeed += 0.6f;
        if (user.vspeed > 18.0f) {
            user.vspeed = 18.0f;
        }
        user.entityX += user.hspeed;
        user.entityY += user.vspeed;
        user.x = Math.round(user.entityX);
        user.y = Math.round(user.entityY);
        if (user.entityX < 0.0f) {
            user.entityX += (float)GameLogic.currentMap.MAP_WIDTH;
        } else if (user.entityX >= (float)GameLogic.currentMap.MAP_WIDTH) {
            user.entityX -= (float)GameLogic.currentMap.MAP_WIDTH;
        }
    }

    @Override
    public void react(Interactive i, Direction direction) {
    }

    @Override
    protected void updateMovement(long timePassed) {
    }

    @Override
    protected void updateImage(long timePassed) {
        switch (this.color) {
            case GREEN: {
                this.sprites[0].update(timePassed);
                this.spritesLeft[0].update(timePassed);
                this.currentImage = this.sprites[0].getImage();
                break;
            }
            case PURPLE: {
                this.sprites[1].update(timePassed);
                this.spritesLeft[1].update(timePassed);
                this.currentImage = this.sprites[1].getImage();
            }
        }
    }

    public void drawOverlayToScreen(Graphics2D g2D, float xPos, float yPos, boolean facingRight) {
        switch (this.color) {
            case GREEN: {
                g2D.drawImage((Image)(facingRight ? this.sprites[0].getImage() : this.spritesLeft[0].getImage()), Math.round(xPos), Math.round(yPos), null);
                break;
            }
            case PURPLE: {
                g2D.drawImage((Image)(facingRight ? this.sprites[1].getImage() : this.spritesLeft[1].getImage()), Math.round(xPos), Math.round(yPos), null);
            }
        }
    }

    public boolean isPurple() {
        return this.color == KuriboShoeColor.PURPLE;
    }

    public void setPurple(boolean b) {
        this.color = b ? KuriboShoeColor.PURPLE : KuriboShoeColor.GREEN;
    }

    @Override
    protected JComponent[] setupComponents() {
        return null;
    }

    @Override
    protected JMenu[] getSettingsMenuOptions() {
        JMenu[] toReturn = new JMenu[1];
        JMenu menu = new JMenu("Shoe Type");
        ButtonGroup group = new ButtonGroup();
        JRadioButtonMenuItem greenButton = new JRadioButtonMenuItem("Green");
        greenButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KuriboShoe.this.color = KuriboShoeColor.GREEN;
            }
        });
        group.add(greenButton);
        menu.add(greenButton);
        JRadioButtonMenuItem purpleButton = new JRadioButtonMenuItem("Purple");
        purpleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KuriboShoe.this.color = KuriboShoeColor.PURPLE;
            }
        });
        group.add(purpleButton);
        menu.add(purpleButton);
        switch (this.color) {
            case GREEN: {
                greenButton.setSelected(true);
                break;
            }
            case PURPLE: {
                purpleButton.setSelected(true);
            }
        }
        menu.validate();
        toReturn[0] = menu;
        return toReturn;
    }

    @Override
    protected LayoutManager getLayout() {
        return null;
    }

    @Override
    public Object clone() {
        KuriboShoe k = new KuriboShoe(this.entityX, this.entityY, this.editorMode);
        k.x = Math.round(this.entityX);
        k.y = Math.round(this.entityY);
        k.color = this.color;
        return k;
    }

    @Override
    public void iTileBumpTop() {
        this.vspeed = -3.0f;
    }

    public KuriboShoe setPurple() {
        this.color = KuriboShoeColor.PURPLE;
        return this;
    }

    protected static enum KuriboShoeColor {
        GREEN,
        PURPLE;

    }
}

