/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.entity;

import com.dmgame.Animation;
import com.dmgame.Direction;
import com.dmgame.GameLogic;
import com.dmgame.Interactive;
import com.dmgame.MapScene;
import com.dmgame.UnthreadedTimer;
import com.dmgame.Utility;
import com.dmgame.entity.EditableEntity;
import com.dmgame.entity.Entity;
import com.dmgame.entity.Player;
import com.dmgame.entity.projectiles.FireballProjectile;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PiranhaPlant
extends EditableEntity {
    private static final long serialVersionUID = 6555144423144180975L;
    public static final transient Dimension TALL_DIM = new Dimension(32, 64);
    public static final transient Dimension STANDARD_DIM = new Dimension(32, 48);
    public static final transient Dimension TALL_DIM_FLIPPED = new Dimension(64, 32);
    public static final transient Dimension STANDARD_DIM_FLIPPED = new Dimension(48, 32);
    public static final transient int GREEN = 0;
    public static final transient int RED = 1;
    public static final transient int SHORT = 0;
    public static final transient int TALL = 1;
    public static final transient long STAY_TIME = 1500L;
    private PlantType type = PlantType.RED;
    private Direction dir = Direction.UP;
    private Direction or = Direction.UP;
    public transient BufferedImage[] upSprites;
    public transient BufferedImage[] downSprites;
    public transient BufferedImage[] upLeftSprites;
    public transient BufferedImage[] downLeftSprites;
    public transient Animation[] shortTallAnims;
    private transient boolean canFire = false;
    private transient UnthreadedTimer stayTimer;
    private transient UnthreadedTimer freqTimer;
    private transient boolean upPhase = false;
    private transient boolean stayPhase = true;
    private long frequency = 5000L;
    public static final transient int FREQUENCY_MIN = 1000;
    public static final transient int FREQUENCY_MAX = 10000;
    private transient JSlider frequencySlider;
    private transient int counter = 0;

    public PiranhaPlant(float entityX, float entityY, boolean editorMode) {
        super("redpiranhaplant", entityX, entityY, editorMode);
        this.setSize(STANDARD_DIM);
        if (!editorMode) {
            this.initializeTimers();
        }
    }

    @Override
    public String getScriptCreateStatement() {
        return this.buildString(this.getClass().getSimpleName(), "(", Float.valueOf(this.entityX), ",", Float.valueOf(this.entityY), ",", this.editorMode, ")");
    }

    private void initializeTimers() {
        this.stayTimer = new UnthreadedTimer(1500L){

            @Override
            public void end() {
                this.reset();
                PiranhaPlant.this.upPhase = false;
            }
        };
        this.freqTimer = new UnthreadedTimer(this.frequency){

            @Override
            public void end() {
                this.reset();
                PiranhaPlant.this.upPhase = true;
            }
        };
    }

    @Override
    protected void createSprites(String spriteFilename) {
        try {
            BufferedImage green = ImageIO.read(new File("res/gfx/packs/" + MapScene.texturePackName + "/hazards/greenpiranhaplant.png"));
            BufferedImage red = ImageIO.read(new File("res/gfx/packs/" + MapScene.texturePackName + "/hazards/" + spriteFilename + ".png"));
            this.upLeftSprites = new BufferedImage[2];
            this.upLeftSprites[0] = green.getSubimage(0, 0, 32, 48);
            this.upLeftSprites[1] = red.getSubimage(0, 0, 32, 48);
            this.downLeftSprites = new BufferedImage[2];
            this.downLeftSprites[0] = green.getSubimage(32, 0, 32, 48);
            this.downLeftSprites[1] = red.getSubimage(32, 0, 32, 48);
            this.upSprites = new BufferedImage[2];
            this.upSprites[0] = Utility.getHorizontalFlippedCopy(this.upLeftSprites[0]);
            this.upSprites[1] = Utility.getHorizontalFlippedCopy(this.upLeftSprites[1]);
            this.downSprites = new BufferedImage[2];
            this.downSprites[0] = Utility.getHorizontalFlippedCopy(this.downLeftSprites[0]);
            this.downSprites[1] = Utility.getHorizontalFlippedCopy(this.downLeftSprites[1]);
            BufferedImage shortType = ImageIO.read(new File("res/gfx/packs/" + MapScene.texturePackName + "/hazards/shortpiranhaplant.png"));
            BufferedImage tall = ImageIO.read(new File("res/gfx/packs/" + MapScene.texturePackName + "/hazards/tallpiranhaplant.png"));
            BufferedImage[] shortFrames = new BufferedImage[]{shortType.getSubimage(0, 0, 32, 48), shortType.getSubimage(32, 0, 32, 48)};
            BufferedImage[] tallFrames = new BufferedImage[]{tall.getSubimage(0, 0, 32, 64), tall.getSubimage(32, 0, 32, 64)};
            this.shortTallAnims = new Animation[2];
            this.shortTallAnims[0] = new Animation(160L, shortFrames);
            this.shortTallAnims[1] = new Animation(160L, tallFrames);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void react(Interactive i, Direction direction) {
        if (i instanceof Entity && !(i instanceof PiranhaFireball)) {
            GameLogic.gamemode.reportKill(this, (Entity)i);
            ((Entity)i).die();
        }
    }

    @Override
    public void update(long timePassed) {
        if (this.editorMode) {
            this.updateImage(timePassed);
        } else {
            super.update(timePassed);
            if (this.canFire) {
                this.fireProjectile(this.assessPlayers());
            }
        }
    }

    @Override
    protected void updateMovement(long timePassed) {
        if (this.upPhase) {
            if (this.stayPhase) {
                this.stayTimer.update(timePassed);
                return;
            }
            if (this.counter > 64) {
                if (this.type == PlantType.GREEN || this.type == PlantType.RED) {
                    this.canFire = true;
                }
                this.stayPhase = true;
                this.counter = 0;
            } else {
                switch (this.or) {
                    case UP: {
                        this.moveOneNorth();
                        break;
                    }
                    case DOWN: {
                        this.moveOneSouth();
                        break;
                    }
                    case LEFT: {
                        this.moveOneWest();
                        break;
                    }
                    case RIGHT: {
                        this.moveOneEast();
                        break;
                    }
                }
                ++this.counter;
            }
        } else {
            if (!this.stayPhase) {
                this.freqTimer.update(timePassed);
                return;
            }
            if (this.counter > 64) {
                this.stayPhase = false;
                this.counter = 0;
            } else {
                switch (this.or) {
                    case UP: {
                        this.moveOneSouth();
                        break;
                    }
                    case DOWN: {
                        this.moveOneNorth();
                        break;
                    }
                    case LEFT: {
                        this.moveOneEast();
                        break;
                    }
                    case RIGHT: {
                        this.moveOneWest();
                        break;
                    }
                }
                ++this.counter;
            }
        }
    }

    @Override
    protected void updateImage(long timePassed) {
        block0 : switch (this.type) {
            case GREEN: {
                switch (this.or) {
                    case UP: {
                        switch (this.dir) {
                            case UP: {
                                this.currentImage = this.facingRight ? this.upSprites[0] : this.upLeftSprites[0];
                                break block0;
                            }
                            case DOWN: {
                                this.currentImage = this.facingRight ? this.downSprites[0] : this.downLeftSprites[0];
                                break block0;
                            }
                        }
                        break block0;
                    }
                    case DOWN: {
                        switch (this.dir) {
                            case UP: {
                                this.currentImage = this.facingRight ? this.downSprites[0] : this.downLeftSprites[0];
                                break block0;
                            }
                            case DOWN: {
                                this.currentImage = this.facingRight ? this.upSprites[0] : this.upLeftSprites[0];
                                break block0;
                            }
                        }
                        break block0;
                    }
                    case LEFT: {
                        switch (this.dir) {
                            case UP: {
                                this.currentImage = this.facingRight ? this.downSprites[0] : this.upSprites[0];
                                break block0;
                            }
                            case DOWN: {
                                this.currentImage = this.facingRight ? this.downLeftSprites[0] : this.upLeftSprites[0];
                                break block0;
                            }
                        }
                        break block0;
                    }
                    case RIGHT: {
                        switch (this.dir) {
                            case UP: {
                                this.currentImage = this.facingRight ? this.upLeftSprites[0] : this.downLeftSprites[0];
                                break block0;
                            }
                            case DOWN: {
                                this.currentImage = this.facingRight ? this.upSprites[0] : this.downSprites[0];
                                break block0;
                            }
                        }
                        break block0;
                    }
                }
                break;
            }
            case RED: {
                switch (this.or) {
                    case UP: {
                        switch (this.dir) {
                            case UP: {
                                this.currentImage = this.facingRight ? this.upSprites[1] : this.upLeftSprites[1];
                                break block0;
                            }
                            case DOWN: {
                                this.currentImage = this.facingRight ? this.downSprites[1] : this.downLeftSprites[1];
                                break block0;
                            }
                        }
                        break block0;
                    }
                    case DOWN: {
                        switch (this.dir) {
                            case UP: {
                                this.currentImage = this.facingRight ? this.downSprites[1] : this.downLeftSprites[1];
                                break block0;
                            }
                            case DOWN: {
                                this.currentImage = this.facingRight ? this.upSprites[1] : this.upLeftSprites[1];
                                break block0;
                            }
                        }
                        break block0;
                    }
                    case LEFT: {
                        switch (this.dir) {
                            case UP: {
                                this.currentImage = this.facingRight ? this.downSprites[1] : this.upSprites[1];
                                break block0;
                            }
                            case DOWN: {
                                this.currentImage = this.facingRight ? this.downLeftSprites[1] : this.upLeftSprites[1];
                                break block0;
                            }
                        }
                        break block0;
                    }
                    case RIGHT: {
                        switch (this.dir) {
                            case UP: {
                                this.currentImage = this.facingRight ? this.upLeftSprites[1] : this.downLeftSprites[1];
                                break block0;
                            }
                            case DOWN: {
                                this.currentImage = this.facingRight ? this.upSprites[1] : this.downSprites[1];
                                break block0;
                            }
                        }
                        break block0;
                    }
                }
                break;
            }
            case SHORT: {
                this.shortTallAnims[0].update(timePassed);
                this.currentImage = this.shortTallAnims[0].getImage();
                break;
            }
            case TALL: {
                this.shortTallAnims[1].update(timePassed);
                this.currentImage = this.shortTallAnims[1].getImage();
            }
        }
    }

    private void fireProjectile(int[] slope) {
        switch (this.or) {
            case UP: 
            case LEFT: {
                float originX = this.entityX + 16.0f;
                float originY = this.entityY + 16.0f;
                break;
            }
            case DOWN: {
                float originX = this.entityX + 16.0f;
                float originY = this.entityY + 32.0f;
                break;
            }
            case RIGHT: {
                float originX = this.entityX + 32.0f;
                float originY = this.entityY + 16.0f;
                break;
            }
            default: {
                float originX = this.entityX;
                float originY = this.entityY;
            }
        }
        PiranhaFireball p = new PiranhaFireball(originX -= 9.0f, originY -= 9.0f, slope[0], slope[1], this);
        p.spawn();
        this.canFire = false;
    }

    @Override
    public void collisionLogic() {
    }

    private int[] assessPlayers() {
        Set<Player> players = GameLogic.getActivePlayers();
        double shortestDistance = GameLogic.currentMap.MAP_WIDTH;
        float targetX = this.entityX;
        float targetY = this.entityY;
        Point2D.Float one = new Point2D.Float(this.entityX, this.entityY);
        Point2D.Float two = new Point2D.Float();
        for (Player p : players) {
            float f;
            two.x = p.entityX;
            two.y = p.entityY;
            float distance = (float)one.distance(two);
            if (!((double)f < shortestDistance)) continue;
            shortestDistance = distance;
            targetX = two.x;
            targetY = two.y;
        }
        int rise = 0;
        int run = 0;
        this.facingRight = targetX > this.entityX;
        this.dir = targetY < this.entityY ? Direction.UP : Direction.DOWN;
        block0 : switch (this.or) {
            case UP: 
            case DOWN: {
                run = this.facingRight ? 1 : -1;
                switch (this.dir) {
                    case UP: {
                        rise = -2;
                        break block0;
                    }
                    case DOWN: {
                        rise = 2;
                        break block0;
                    }
                }
                break;
            }
            case LEFT: 
            case RIGHT: {
                run = this.facingRight ? 2 : -2;
                switch (this.dir) {
                    case UP: {
                        rise = -1;
                        break block0;
                    }
                    case DOWN: {
                        rise = 1;
                        break block0;
                    }
                }
                break;
            }
        }
        if (targetX < this.entityX && targetY > this.entityY || targetX > this.entityX && targetY < this.entityY) {
            rise = -rise;
            run = -run;
        }
        return new int[]{rise, run};
    }

    @Override
    protected JComponent[] setupComponents() {
        JComponent[] list = new JComponent[2];
        this.frequencySlider = new JSlider(0, 1000, 10000, (int)this.frequency);
        this.frequencySlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                if (!source.getValueIsAdjusting()) {
                    PiranhaPlant.this.frequency = source.getValue();
                }
            }
        });
        JLabel frequencyLabel = new JLabel("Frequency", 0);
        frequencyLabel.setAlignmentX(0.5f);
        list[0] = frequencyLabel;
        list[1] = this.frequencySlider;
        return list;
    }

    @Override
    protected JMenu[] getSettingsMenuOptions() {
        JMenu[] toReturn = new JMenu[2];
        JMenu menu = new JMenu("Plant Type");
        ButtonGroup group = new ButtonGroup();
        JRadioButtonMenuItem greenButton = new JRadioButtonMenuItem("Green");
        greenButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PiranhaPlant.this.type = PlantType.GREEN;
                PiranhaPlant.this.setSize(STANDARD_DIM);
            }
        });
        group.add(greenButton);
        menu.add(greenButton);
        JRadioButtonMenuItem redButton = new JRadioButtonMenuItem("Red");
        redButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PiranhaPlant.this.type = PlantType.RED;
                PiranhaPlant.this.setSize(STANDARD_DIM);
            }
        });
        redButton.setSelected(true);
        group.add(redButton);
        menu.add(redButton);
        JRadioButtonMenuItem shortButton = new JRadioButtonMenuItem("Short");
        shortButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PiranhaPlant.this.type = PlantType.SHORT;
                PiranhaPlant.this.setSize(STANDARD_DIM);
            }
        });
        group.add(shortButton);
        menu.add(shortButton);
        JRadioButtonMenuItem tallButton = new JRadioButtonMenuItem("Tall");
        tallButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PiranhaPlant.this.type = PlantType.TALL;
                PiranhaPlant.this.setSize(TALL_DIM);
            }
        });
        group.add(tallButton);
        menu.add(tallButton);
        switch (this.type) {
            case GREEN: {
                greenButton.setSelected(true);
                break;
            }
            case RED: {
                redButton.setSelected(true);
                break;
            }
            case SHORT: {
                shortButton.setSelected(true);
                break;
            }
            case TALL: {
                tallButton.setSelected(true);
            }
        }
        menu.validate();
        toReturn[0] = menu;
        menu = new JMenu("Orientation");
        group = new ButtonGroup();
        JRadioButtonMenuItem upButton = new JRadioButtonMenuItem("Up");
        upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PiranhaPlant.this.rotateAll(Direction.UP);
            }
        });
        group.add(upButton);
        menu.add(upButton);
        JRadioButtonMenuItem downButton = new JRadioButtonMenuItem("Down");
        downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PiranhaPlant.this.rotateAll(Direction.DOWN);
            }
        });
        group.add(downButton);
        menu.add(downButton);
        JRadioButtonMenuItem leftButton = new JRadioButtonMenuItem("Left");
        leftButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PiranhaPlant.this.rotateAll(Direction.LEFT);
            }
        });
        group.add(leftButton);
        menu.add(leftButton);
        JRadioButtonMenuItem rightButton = new JRadioButtonMenuItem("Right");
        rightButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PiranhaPlant.this.rotateAll(Direction.RIGHT);
            }
        });
        group.add(rightButton);
        menu.add(rightButton);
        switch (this.or) {
            case UP: {
                upButton.setSelected(true);
                break;
            }
            case DOWN: {
                downButton.setSelected(true);
                break;
            }
            case LEFT: {
                leftButton.setSelected(true);
                break;
            }
            case RIGHT: {
                rightButton.setSelected(true);
                break;
            }
        }
        menu.validate();
        toReturn[1] = menu;
        return toReturn;
    }

    @Override
    protected LayoutManager getLayout() {
        return new GridLayout(0, 2);
    }

    public void setFrequency(long frequency) {
        this.frequency = frequency;
    }

    public PlantType getType() {
        return this.type;
    }

    private void rotateAll(Direction or) {
        block0 : switch (this.or) {
            case UP: {
                switch (or) {
                    case DOWN: {
                        for (int i = 0; i < 2; ++i) {
                            this.upSprites[i] = Utility.getVerticalFlippedCopy(this.upSprites[i]);
                            this.downSprites[i] = Utility.getVerticalFlippedCopy(this.downSprites[i]);
                            this.upLeftSprites[i] = Utility.getVerticalFlippedCopy(this.upLeftSprites[i]);
                            this.downLeftSprites[i] = Utility.getVerticalFlippedCopy(this.downLeftSprites[i]);
                            this.shortTallAnims[i] = Utility.getVerticalFlippedCopy(this.shortTallAnims[i]);
                        }
                        break block0;
                    }
                    case LEFT: {
                        for (int i = 0; i < 2; ++i) {
                            this.upSprites[i] = Utility.rotateImage90(this.upSprites[i], (byte)3);
                            this.downSprites[i] = Utility.rotateImage90(this.downSprites[i], (byte)3);
                            this.upLeftSprites[i] = Utility.rotateImage90(this.upLeftSprites[i], (byte)3);
                            this.downLeftSprites[i] = Utility.rotateImage90(this.downLeftSprites[i], (byte)3);
                            this.shortTallAnims[i] = Utility.rotateAnimation90(this.shortTallAnims[i], (byte)3);
                        }
                        break block0;
                    }
                    case RIGHT: {
                        for (int i = 0; i < 2; ++i) {
                            this.upSprites[i] = Utility.rotateImage90(this.upSprites[i], (byte)1);
                            this.downSprites[i] = Utility.rotateImage90(this.downSprites[i], (byte)1);
                            this.upLeftSprites[i] = Utility.rotateImage90(this.upLeftSprites[i], (byte)1);
                            this.downLeftSprites[i] = Utility.rotateImage90(this.downLeftSprites[i], (byte)1);
                            this.shortTallAnims[i] = Utility.rotateAnimation90(this.shortTallAnims[i], (byte)1);
                        }
                        break block0;
                    }
                }
                break;
            }
            case DOWN: {
                switch (or) {
                    case UP: {
                        for (int i = 0; i < 2; ++i) {
                            this.upSprites[i] = Utility.getVerticalFlippedCopy(this.upSprites[i]);
                            this.downSprites[i] = Utility.getVerticalFlippedCopy(this.downSprites[i]);
                            this.upLeftSprites[i] = Utility.getVerticalFlippedCopy(this.upLeftSprites[i]);
                            this.downLeftSprites[i] = Utility.getVerticalFlippedCopy(this.downLeftSprites[i]);
                            this.shortTallAnims[i] = Utility.getVerticalFlippedCopy(this.shortTallAnims[i]);
                        }
                        break block0;
                    }
                    case LEFT: {
                        for (int i = 0; i < 2; ++i) {
                            this.upSprites[i] = Utility.rotateImage90(this.upSprites[i], (byte)1);
                            this.downSprites[i] = Utility.rotateImage90(this.downSprites[i], (byte)1);
                            this.upLeftSprites[i] = Utility.rotateImage90(this.upLeftSprites[i], (byte)1);
                            this.downLeftSprites[i] = Utility.rotateImage90(this.downLeftSprites[i], (byte)1);
                            this.shortTallAnims[i] = Utility.rotateAnimation90(this.shortTallAnims[i], (byte)1);
                        }
                        break block0;
                    }
                    case RIGHT: {
                        for (int i = 0; i < 2; ++i) {
                            this.upSprites[i] = Utility.rotateImage90(this.upSprites[i], (byte)3);
                            this.downSprites[i] = Utility.rotateImage90(this.downSprites[i], (byte)3);
                            this.upLeftSprites[i] = Utility.rotateImage90(this.upLeftSprites[i], (byte)3);
                            this.downLeftSprites[i] = Utility.rotateImage90(this.downLeftSprites[i], (byte)3);
                            this.shortTallAnims[i] = Utility.rotateAnimation90(this.shortTallAnims[i], (byte)3);
                        }
                        break block0;
                    }
                }
                break;
            }
            case LEFT: {
                switch (or) {
                    case UP: {
                        for (int i = 0; i < 2; ++i) {
                            this.upSprites[i] = Utility.rotateImage90(this.upSprites[i], (byte)1);
                            this.downSprites[i] = Utility.rotateImage90(this.downSprites[i], (byte)1);
                            this.upLeftSprites[i] = Utility.rotateImage90(this.upLeftSprites[i], (byte)1);
                            this.downLeftSprites[i] = Utility.rotateImage90(this.downLeftSprites[i], (byte)1);
                            this.shortTallAnims[i] = Utility.rotateAnimation90(this.shortTallAnims[i], (byte)1);
                        }
                        break block0;
                    }
                    case DOWN: {
                        for (int i = 0; i < 2; ++i) {
                            this.upSprites[i] = Utility.rotateImage90(this.upSprites[i], (byte)3);
                            this.downSprites[i] = Utility.rotateImage90(this.downSprites[i], (byte)3);
                            this.upLeftSprites[i] = Utility.rotateImage90(this.upLeftSprites[i], (byte)3);
                            this.downLeftSprites[i] = Utility.rotateImage90(this.downLeftSprites[i], (byte)3);
                            this.shortTallAnims[i] = Utility.rotateAnimation90(this.shortTallAnims[i], (byte)3);
                        }
                        break block0;
                    }
                    case RIGHT: {
                        for (int i = 0; i < 2; ++i) {
                            this.upSprites[i] = Utility.getHorizontalFlippedCopy(this.upSprites[i]);
                            this.downSprites[i] = Utility.getHorizontalFlippedCopy(this.downSprites[i]);
                            this.upLeftSprites[i] = Utility.getHorizontalFlippedCopy(this.upLeftSprites[i]);
                            this.downLeftSprites[i] = Utility.getHorizontalFlippedCopy(this.downLeftSprites[i]);
                            this.shortTallAnims[i] = Utility.getHorizontalFlippedCopy(this.shortTallAnims[i]);
                        }
                        break block0;
                    }
                }
                break;
            }
            case RIGHT: {
                switch (or) {
                    case UP: {
                        for (int i = 0; i < 2; ++i) {
                            this.upSprites[i] = Utility.rotateImage90(this.upSprites[i], (byte)3);
                            this.downSprites[i] = Utility.rotateImage90(this.downSprites[i], (byte)3);
                            this.upLeftSprites[i] = Utility.rotateImage90(this.upLeftSprites[i], (byte)3);
                            this.downLeftSprites[i] = Utility.rotateImage90(this.downLeftSprites[i], (byte)3);
                            this.shortTallAnims[i] = Utility.rotateAnimation90(this.shortTallAnims[i], (byte)3);
                        }
                        break block0;
                    }
                    case DOWN: {
                        for (int i = 0; i < 2; ++i) {
                            this.upSprites[i] = Utility.rotateImage90(this.upSprites[i], (byte)1);
                            this.downSprites[i] = Utility.rotateImage90(this.downSprites[i], (byte)1);
                            this.upLeftSprites[i] = Utility.rotateImage90(this.upLeftSprites[i], (byte)1);
                            this.downLeftSprites[i] = Utility.rotateImage90(this.downLeftSprites[i], (byte)1);
                            this.shortTallAnims[i] = Utility.rotateAnimation90(this.shortTallAnims[i], (byte)1);
                        }
                        break block0;
                    }
                    case LEFT: {
                        for (int i = 0; i < 2; ++i) {
                            this.upSprites[i] = Utility.getHorizontalFlippedCopy(this.upSprites[i]);
                            this.downSprites[i] = Utility.getHorizontalFlippedCopy(this.downSprites[i]);
                            this.upLeftSprites[i] = Utility.getHorizontalFlippedCopy(this.upLeftSprites[i]);
                            this.downLeftSprites[i] = Utility.getHorizontalFlippedCopy(this.downLeftSprites[i]);
                            this.shortTallAnims[i] = Utility.getHorizontalFlippedCopy(this.shortTallAnims[i]);
                        }
                        break block0;
                    }
                }
                break;
            }
        }
        switch (or) {
            case UP: 
            case DOWN: {
                if (this.type != PlantType.TALL) {
                    this.setSize(STANDARD_DIM);
                    break;
                }
                this.setSize(TALL_DIM);
                break;
            }
            case LEFT: 
            case RIGHT: {
                if (this.type != PlantType.TALL) {
                    this.setSize(STANDARD_DIM_FLIPPED);
                    break;
                }
                this.setSize(TALL_DIM_FLIPPED);
                break;
            }
        }
        this.or = or;
    }

    @Override
    public Object clone() {
        PiranhaPlant p = new PiranhaPlant(this.entityX, this.entityY, this.editorMode);
        p.x = Math.round(this.entityX);
        p.y = Math.round(this.entityY);
        p.type = this.type;
        p.setSize(p.type == PlantType.TALL ? TALL_DIM : STANDARD_DIM);
        p.dir = this.dir;
        p.rotateAll(this.or);
        p.setFrequency(this.frequency);
        return p;
    }

    @Override
    public void iTileBumpTop() {
    }

    public static class PiranhaFireball
    extends FireballProjectile {
        private static final long serialVersionUID = -4643637218599344891L;

        public PiranhaFireball(float x, float y, float hspeed, float vspeed, Entity owner) {
            super(x, y, owner);
            this.hspeed = hspeed;
            this.vspeed = vspeed;
        }

        @Override
        public void react(Interactive i, Direction dir) {
            if (i instanceof Entity && !((Entity)i).equals(this.owner)) {
                GameLogic.gamemode.reportKill(this, (Entity)i);
                ((Entity)i).die();
                this.die();
            }
        }

        @Override
        public void die() {
            GameLogic.removeEntity(this);
        }

        @Override
        protected void updateMovement(long timePassed) {
            this.entityX += this.hspeed;
            this.x = (int)this.entityX;
            this.entityY += this.vspeed;
            this.y = (int)this.entityY;
        }

        @Override
        public void collisionLogic() {
        }
    }

    public static enum PlantType {
        GREEN,
        RED,
        SHORT,
        TALL;

    }
}

