/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.entity;

import com.dmgame.Animation;
import com.dmgame.Direction;
import com.dmgame.GameLogic;
import com.dmgame.Geometry;
import com.dmgame.Interactive;
import com.dmgame.MapScene;
import com.dmgame.SMWException;
import com.dmgame.SpriteColorModel;
import com.dmgame.Updatable;
import com.dmgame.Utility;
import com.dmgame.entity.DroppedBomb;
import com.dmgame.entity.EditableEntity;
import com.dmgame.entity.Entity;
import com.dmgame.entity.Holdable;
import com.dmgame.entity.KuriboShoe;
import com.dmgame.entity.Shell;
import com.dmgame.entity.SpikeShell;
import com.dmgame.entity.Team;
import com.dmgame.entity.ThrowBlockEntity;
import com.dmgame.entity.powerups.AbstractLifeMushroom;
import com.dmgame.entity.powerups.BobOmb;
import com.dmgame.entity.powerups.Bomb;
import com.dmgame.entity.powerups.Boomerang;
import com.dmgame.entity.powerups.BulletBill;
import com.dmgame.entity.powerups.DirectUsable;
import com.dmgame.entity.powerups.Feather;
import com.dmgame.entity.powerups.FireFlower;
import com.dmgame.entity.powerups.Hammer;
import com.dmgame.entity.powerups.IceWand;
import com.dmgame.entity.powerups.Leaf;
import com.dmgame.entity.powerups.ModBlock;
import com.dmgame.entity.powerups.MysteryMushroom;
import com.dmgame.entity.powerups.PWing;
import com.dmgame.entity.powerups.Podobo;
import com.dmgame.entity.powerups.PoisonMushroom;
import com.dmgame.entity.powerups.PowBlock;
import com.dmgame.entity.powerups.PowerUp;
import com.dmgame.entity.powerups.SlowdownClock;
import com.dmgame.entity.powerups.SpeedupClock;
import com.dmgame.entity.powerups.Starman;
import com.dmgame.entity.powerups.TanookiSuit;
import com.dmgame.map.InteractiveTile;
import com.dmgame.map.PhysicalTile;
import com.dmgame.map.Platform;
import com.dmgame.map.TileType;
import com.dmgame.map.Warp;
import com.dmgame.net.client.NetplayClient;
import com.dmgame.net.server.NetplayServer;
import com.dmgame.sound.Sound;
import com.dmgame.sound.SoundPlayer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;

public strictfp class Player
extends Entity
implements KeyListener {
    private static final long serialVersionUID = 8732937105819168061L;
    public Warp[][][] debugWarps;
    public static final int STAND = 0;
    public static final int WALK = 1;
    public static final int JUMP = 2;
    public static final int TURN = 3;
    public static final int DEAD = 4;
    public static final int SQUISHED = 5;
    public static final int STAND_LEFT = 6;
    public static final int WALK_LEFT = 7;
    public static final int JUMP_LEFT = 8;
    public static final int TURN_LEFT = 9;
    protected transient BufferedImage[] sprites;
    protected transient Animation walking;
    protected transient Animation walkingLeft;
    protected transient Animation spinAttack;
    protected transient Animation spinAttackLeft;
    protected transient byte animType;
    protected transient byte animNumber;
    protected static final byte IMAGE = 0;
    protected static final byte WALK_ANIM = 1;
    protected static final byte SPIN_ATTACK = 2;
    protected boolean[] controls;
    private static final int numberOfControls = 6;
    public static final int UP = 0;
    public static final int DOWN = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    public static final int TURBO = 4;
    public static final int USE_RESERVE = 5;
    protected int keyCodeLeft;
    protected int keyCodeRight;
    protected int keyCodeUp;
    protected int keyCodeDown;
    protected int keyCodeTurbo;
    protected int keyCodeUseReserve;
    public PhysicalTile[] fallTiles;
    public boolean canJump;
    protected boolean onFallthroughTile;
    public int airTime;
    protected PowerUp currentItem;
    protected PowerUp reserveItem;
    protected PowerUp inuseItem;
    protected Holdable heldItem;
    protected KuriboShoe shoe;
    protected int score;
    protected volatile boolean alive;
    protected final long MAX_DEATH_TIME = 1000L;
    public Warp targetWarp;
    public Warp entryWarp;
    protected Direction enteringDirection;
    protected Direction exitingDirection;
    protected final long WARP_DELAY = 2000L;
    protected int warpTime;
    protected boolean inWarp;
    protected boolean canWarp;
    protected boolean invincible;
    protected boolean alreadyAttacked;
    public boolean alreadyJumped;
    protected final long MAX_INVINCIBLE_TIME = 9000L;
    protected final int networkBytes;
    protected Runnable reserveBuffer;
    private static final int PLAYER_WIDTH = 24;
    private static final int PLAYER_X = 4;

    public Player(String skinName, float entityX, float entityY, int[] keyCodes, Team teamColor, int startScore) {
        super(skinName, entityX, entityY, teamColor);
        this.getClass();
        this.networkBytes = 23 + 3 + 6;
        this.reserveBuffer = new Runnable(){

            @Override
            public void run() {
                if (Player.this.inuseItem instanceof DirectUsable) {
                    ((DirectUsable)((Object)Player.this.inuseItem)).use();
                } else if (Player.this.inuseItem != null) {
                    Player.this.currentItem = (PowerUp)Player.this.inuseItem.clone();
                }
                Player.this.inuseItem = null;
            }
        };
        this.facingRight = true;
        this.onSlippery = false;
        this.canJump = false;
        this.airTime = 0;
        this.fallTiles = new PhysicalTile[3];
        this.onFallthroughTile = false;
        this.alive = true;
        this.score = startScore;
        this.width = 24;
        this.x += 4;
        this.controls = new boolean[6];
        if (keyCodes != null) {
            this.setKeyCodes(keyCodes);
        }
        this.alreadyAttacked = false;
        this.invincible = false;
        this.alreadyJumped = false;
        this.canWarp = true;
    }

    @Override
    public String getScriptCreateStatement() {
        return "null";
    }

    protected void warpMovement() {
        if (this.warpTime < 32) {
            switch (this.enteringDirection) {
                case NORTH: {
                    this.moveOneSouth();
                    break;
                }
                case SOUTH: {
                    this.moveOneNorth();
                    break;
                }
                case EAST: {
                    this.moveOneWest();
                    break;
                }
                case WEST: {
                    this.moveOneEast();
                    break;
                }
            }
        } else if (this.warpTime == 32) {
            this.relX = this.targetWarp.mapRelX;
            this.relY = this.targetWarp.mapRelY;
            this.entityX = this.targetWarp.useX;
            this.entityY = this.targetWarp.useY;
            if (this.targetWarp.dir == Direction.EAST) {
                this.facingRight = true;
            } else if (this.targetWarp.dir == Direction.WEST) {
                this.facingRight = false;
            }
        } else if (this.warpTime > 32 && this.warpTime < 64) {
            switch (this.exitingDirection) {
                case NORTH: {
                    this.moveOneNorth();
                    break;
                }
                case SOUTH: {
                    this.moveOneSouth();
                    break;
                }
                case EAST: {
                    this.moveOneEast();
                    break;
                }
                case WEST: {
                    this.moveOneWest();
                    break;
                }
            }
        } else {
            this.endWarp();
        }
        ++this.warpTime;
    }

    protected void setKeyCodes(int[] keyCodes) {
        if (keyCodes != null) {
            this.keyCodeLeft = keyCodes[2];
            this.keyCodeRight = keyCodes[3];
            this.keyCodeUp = keyCodes[0];
            this.keyCodeDown = keyCodes[1];
            this.keyCodeTurbo = keyCodes[4];
            this.keyCodeUseReserve = keyCodes[5];
        }
    }

    protected int[] getKeyCodes() {
        int[] codes = new int[6];
        codes[2] = this.keyCodeLeft;
        codes[3] = this.keyCodeRight;
        codes[0] = this.keyCodeUp;
        codes[1] = this.keyCodeDown;
        codes[4] = this.keyCodeTurbo;
        codes[5] = this.keyCodeUseReserve;
        return codes;
    }

    @Override
    protected void createSprites(String skinName) {
        File skinFile = new File("res/gfx/skins/" + skinName + ".png");
        File defaultSkin = new File("res/gfx/skins/default.png");
        try {
            BufferedImage skin = skinFile.exists() ? ImageIO.read(skinFile) : ImageIO.read(defaultSkin);
            BufferedImage flippedSkin = Utility.getHorizontalFlippedCopy(skin);
            this.teamColors = new SpriteColorModel(this.teamColor.colors, Color.RED, skin, flippedSkin);
            this.sprites = new BufferedImage[10];
            BufferedImage stand = skin.getSubimage(0, 0, 32, 32);
            BufferedImage walk = skin.getSubimage(32, 0, 32, 32);
            BufferedImage jump = skin.getSubimage(64, 0, 32, 32);
            BufferedImage turn = skin.getSubimage(96, 0, 32, 32);
            BufferedImage dead = skin.getSubimage(128, 0, 32, 32);
            BufferedImage squished = skin.getSubimage(160, 0, 32, 32);
            BufferedImage standLeft = flippedSkin.getSubimage(160, 0, 32, 32);
            BufferedImage walkLeft = flippedSkin.getSubimage(128, 0, 32, 32);
            BufferedImage jumpLeft = flippedSkin.getSubimage(96, 0, 32, 32);
            BufferedImage turnLeft = flippedSkin.getSubimage(64, 0, 32, 32);
            this.sprites[0] = stand;
            this.sprites[1] = walk;
            this.sprites[2] = jump;
            this.sprites[3] = turn;
            this.sprites[4] = dead;
            this.sprites[5] = squished;
            this.sprites[6] = standLeft;
            this.sprites[7] = walkLeft;
            this.sprites[8] = jumpLeft;
            this.sprites[9] = turnLeft;
            this.walking = new Animation(160L, walk, stand);
            this.walkingLeft = new Animation(160L, walkLeft, standLeft);
            this.spinAttack = new Animation(80L, turnLeft, turn, standLeft, turn, turnLeft, stand);
            this.spinAttackLeft = new Animation(80L, turn, turnLeft, stand, turnLeft, turn, standLeft);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.currentImage = this.sprites[2];
    }

    @Override
    protected void setTeamColor(Team teamColor) {
        try {
            this.teamColors.shiftColor(0, (byte)0);
        }
        catch (SMWException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.currentItem instanceof TanookiSuit && ((TanookiSuit)this.currentItem).combo) {
            e.consume();
            return;
        }
        this.keyPressed(e.getKeyCode());
        e.consume();
    }

    protected void keyPressed(int keyCode) {
        if (keyCode == this.keyCodeRight) {
            if (!this.controls[3]) {
                NetplayClient.sendKeyUpdate(this, 3, true);
            }
            this.facingRight = true;
            this.controls[3] = true;
            this.controls[2] = false;
        }
        if (keyCode == this.keyCodeLeft) {
            if (!this.controls[2]) {
                NetplayClient.sendKeyUpdate(this, 2, true);
            }
            this.facingRight = false;
            this.controls[2] = true;
            this.controls[3] = false;
        }
        if (keyCode == this.keyCodeDown) {
            if (!this.controls[1]) {
                NetplayClient.sendKeyUpdate(this, 1, true);
            }
            this.controls[1] = true;
        }
        if (keyCode == this.keyCodeUp) {
            NetplayClient.sendKeyUpdate(this, 0, true);
            this.controls[0] = true;
            if (this.currentItem instanceof Leaf && !((Leaf)this.currentItem).floating && !((Leaf)this.currentItem).spinAttacking) {
                ((Leaf)this.currentItem).floating = true;
            }
        }
        if (keyCode == this.keyCodeTurbo) {
            if (!this.controls[4]) {
                NetplayClient.sendKeyUpdate(this, 4, true);
            }
            this.controls[4] = true;
            if (this.currentItem instanceof Leaf && !this.alreadyAttacked && !((Leaf)this.currentItem).spinAttacking) {
                SoundPlayer.playSound(Sound.TAIL);
                ((Leaf)this.currentItem).spinAttacking = true;
                ((Leaf)this.currentItem).facingRight = this.facingRight;
                this.alreadyAttacked = true;
            } else if (this.currentItem instanceof Feather && !this.alreadyAttacked && !((Feather)this.currentItem).spinAttacking) {
                SoundPlayer.playSound(Sound.TAIL);
                ((Feather)this.currentItem).spinAttacking = true;
                ((Feather)this.currentItem).facingRight = this.facingRight;
                this.alreadyAttacked = true;
            } else if (this.currentItem instanceof TanookiSuit && !this.alreadyAttacked && this.controls[1] && !((TanookiSuit)this.currentItem).combo) {
                this.y = (int)((float)this.y - 26.0f);
                this.entityY -= 26.0f;
                ((TanookiSuit)this.currentItem).combo = true;
                ((TanookiSuit)this.currentItem).startTimer();
                this.alreadyAttacked = true;
            }
        }
        if (keyCode == this.keyCodeUseReserve) {
            if (!this.controls[5]) {
                NetplayClient.sendKeyUpdate(this, 5, true);
            }
            this.controls[5] = true;
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.keyReleased(e.getKeyCode());
        e.consume();
    }

    protected void keyReleased(int keyCode) {
        if (keyCode == this.keyCodeRight) {
            NetplayClient.sendKeyUpdate(this, 3, false);
            this.controls[3] = false;
        }
        if (keyCode == this.keyCodeLeft) {
            NetplayClient.sendKeyUpdate(this, 2, false);
            this.controls[2] = false;
        }
        if (keyCode == this.keyCodeDown) {
            NetplayClient.sendKeyUpdate(this, 1, false);
            this.controls[1] = false;
            if (this.currentItem instanceof TanookiSuit) {
                ((TanookiSuit)this.currentItem).combo = false;
                ((TanookiSuit)this.currentItem).forceStopTimer();
                this.alreadyAttacked = false;
            }
        }
        if (keyCode == this.keyCodeUp) {
            NetplayClient.sendKeyUpdate(this, 0, false);
            this.controls[0] = false;
            this.alreadyJumped = false;
        }
        if (keyCode == this.keyCodeTurbo) {
            NetplayClient.sendKeyUpdate(this, 4, false);
            this.controls[4] = false;
            if (this.currentItem instanceof TanookiSuit) {
                ((TanookiSuit)this.currentItem).combo = false;
                ((TanookiSuit)this.currentItem).forceStopTimer();
            }
            this.alreadyAttacked = false;
        }
        if (keyCode == this.keyCodeUseReserve) {
            NetplayClient.sendKeyUpdate(this, 5, false);
            this.controls[5] = false;
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        e.consume();
    }

    public void updateKey(int key, boolean pressed) {
        this.controls[key] = pressed;
        if (key == 3 && pressed) {
            this.facingRight = true;
        } else if (key == 2 && pressed) {
            this.facingRight = false;
        } else if (key == 0 && !pressed) {
            this.alreadyJumped = false;
        } else if (key == 1 && !pressed) {
            if (this.currentItem instanceof TanookiSuit) {
                ((TanookiSuit)this.currentItem).forceStopTimer();
                ((TanookiSuit)this.currentItem).combo = false;
                this.alreadyAttacked = false;
            }
        } else if (key == 4) {
            if (!pressed) {
                this.alreadyAttacked = false;
                if (this.currentItem instanceof TanookiSuit) {
                    ((TanookiSuit)this.currentItem).forceStopTimer();
                    ((TanookiSuit)this.currentItem).combo = false;
                }
            } else if (this.currentItem instanceof Leaf && !this.alreadyAttacked && !((Leaf)this.currentItem).spinAttacking) {
                ((Leaf)this.currentItem).spinAttacking = true;
                ((Leaf)this.currentItem).facingRight = this.facingRight;
                this.alreadyAttacked = true;
            } else if (this.currentItem instanceof Feather && !this.alreadyAttacked && !((Feather)this.currentItem).spinAttacking) {
                ((Feather)this.currentItem).spinAttacking = true;
                ((Feather)this.currentItem).facingRight = this.facingRight;
                this.alreadyAttacked = true;
            } else if (this.currentItem instanceof TanookiSuit && !this.alreadyAttacked && this.controls[1] && !((TanookiSuit)this.currentItem).combo) {
                this.y = (int)((float)this.y - 26.0f);
                this.entityY -= 26.0f;
                ((TanookiSuit)this.currentItem).combo = true;
                ((TanookiSuit)this.currentItem).startTimer();
                this.alreadyAttacked = true;
            }
        }
    }

    @Override
    public byte[] prepareNetworkUpdate() {
        byte[] baseData = super.prepareNetworkUpdate();
        byte[] updateData = new byte[this.networkBytes];
        System.arraycopy(baseData, 0, updateData, 0, baseData.length);
        this.getClass();
        updateData[23] = PowerUp.getIdByType(this.currentItem);
        this.getClass();
        updateData[23 + 1] = PowerUp.getIdByType(this.reserveItem);
        this.getClass();
        updateData[23 + 2] = (byte)this.score;
        int i = 3;
        while (i - 3 < this.controls.length) {
            this.getClass();
            updateData[23 + i] = (byte)(this.controls[i - 3] ? 0 : -1);
            ++i;
        }
        return updateData;
    }

    @Override
    public void getNetworkUpdate(float x, float y, float h, float v, byte[] extra) {
        super.getNetworkUpdate(x, y, h, v, extra);
        this.getClass();
        if (extra[23] != PowerUp.getIdByType(this.currentItem)) {
            this.getClass();
            this.currentItem = PowerUp.getById(extra[23], this.teamColor);
        }
        this.getClass();
        if (extra[23 + 1] != PowerUp.getIdByType(this.reserveItem)) {
            this.getClass();
            this.reserveItem = PowerUp.getById(extra[23 + 1], this.teamColor);
            if (this.reserveItem instanceof BulletBill) {
                ((BulletBill)this.reserveItem).teamColor = this.teamColor;
            }
        }
        this.getClass();
        this.score = extra[23 + 2];
        int i = 3;
        while (i - 3 < this.controls.length) {
            this.getClass();
            this.updateKey(i - 3, extra[23 + i] == 0);
            ++i;
        }
    }

    @Override
    public synchronized void update(long timePassed) {
        if (!this.alive) {
            return;
        }
        if (this.controls[5]) {
            this.useReserveItem();
        }
        if (this.heldItem != null && this.heldItem instanceof Updatable) {
            ((Updatable)((Object)this.heldItem)).update(timePassed);
        }
        if (this.currentItem != null && this.currentItem instanceof Updatable) {
            this.currentItem.update(timePassed);
        }
        if (this.onGround) {
            if (this.currentItem instanceof PWing) {
                ((PWing)this.currentItem).numJumps = 0;
            } else if (this.currentItem instanceof Feather) {
                ((Feather)this.currentItem).numJumps = 0;
            }
        }
        if (this.shoe != null) {
            this.shoe.combo = this.controls[1] && !this.onGround;
        }
        super.update(timePassed);
    }

    @Override
    protected synchronized void updateMovement(long timePassed) {
        if (this.frozen) {
            return;
        }
        if (this.isInWarp()) {
            this.warpMovement();
            return;
        }
        if (this.shoe != null && this.shoe.combo) {
            this.shoe.comboMovementRule(this);
            return;
        }
        if (this.currentItem instanceof Leaf && ((Leaf)this.currentItem).spinAttacking) {
            ((Leaf)this.currentItem).spinAttackingMovementPolicy(this);
            return;
        }
        if (this.currentItem instanceof Feather && ((Feather)this.currentItem).spinAttacking) {
            ((Feather)this.currentItem).spinAttackingMovementPolicy(this);
            return;
        }
        if (this.currentItem instanceof TanookiSuit && ((TanookiSuit)this.currentItem).combo) {
            ((TanookiSuit)this.currentItem).comboMovementRule(this);
            return;
        }
        this.height = 32;
        this.width = 24;
        this.x = 4;
        this.y = 0;
        if (this.controls[2] || this.controls[3]) {
            if (this.facingRight && this.canMoveRight) {
                this.hspeed += 0.3f;
            } else if (this.canMoveLeft) {
                this.hspeed -= 0.3f;
            }
        } else if (this.onGround) {
            if (this.facingRight && this.hspeed != 0.0f && this.canMoveRight) {
                this.hspeed = this.onSlippery ? (this.hspeed -= 0.05f) : (this.hspeed -= 0.2f);
                if (this.hspeed < 0.0f) {
                    this.hspeed = 0.0f;
                }
            } else if (this.hspeed != 0.0f && this.canMoveLeft) {
                this.hspeed = this.onSlippery ? (this.hspeed += 0.05f) : (this.hspeed += 0.2f);
                if (this.hspeed > 0.0f) {
                    this.hspeed = 0.0f;
                }
            }
        } else if (this.facingRight && this.hspeed != 0.0f && this.canMoveRight) {
            this.hspeed -= 0.05f;
            if (this.hspeed < 0.0f) {
                this.hspeed = 0.0f;
            }
        } else if (this.hspeed != 0.0f && this.canMoveLeft) {
            this.hspeed += 0.05f;
            if (this.hspeed > 0.0f) {
                this.hspeed = 0.0f;
            }
        }
        if (this.controls[0] && this.canMoveUp && !this.alreadyJumped) {
            if (this.canJump && this.onGround) {
                this.vspeed = -8.0f;
                this.airTime = 192;
                this.canJump = false;
                this.alreadyJumped = true;
                SoundPlayer.playSound(Sound.JUMP);
            } else if (this.currentItem instanceof PWing && ((PWing)this.currentItem).numJumps < 3) {
                ((PWing)this.currentItem).movementPolicy(this);
            } else if (this.currentItem instanceof Feather && ((Feather)this.currentItem).numJumps < 3) {
                ((Feather)this.currentItem).movementPolicy(this);
            }
        } else if (!this.controls[0]) {
            this.airTime = 0;
        }
        this.airTime = (int)((long)this.airTime - timePassed);
        if (this.shoe != null && !this.shoe.isPurple()) {
            if (this.airTime <= 0) {
                this.airTime = 0;
            }
            if (this.onGround && this.hspeed != 0.0f) {
                this.vspeed = -3.0f;
            }
        }
        if (this.currentItem instanceof PWing && ((PWing)this.currentItem).numJumps < 3 && ((PWing)this.currentItem).numJumps > 0 && this.controls[0]) {
            if (this.airTime <= 0) {
                this.airTime = 0;
            }
            this.vspeed = -2.0f;
        } else if (!this.onGround && this.airTime <= 0) {
            this.vspeed = this.currentItem instanceof Leaf && ((Leaf)this.currentItem).floating && this.vspeed > 0.0f ? 2.0f : (this.vspeed += 0.4f);
            this.airTime = 0;
        }
        if (this.controls[4]) {
            if (!this.alreadyAttacked) {
                if (this.currentItem instanceof FireFlower && this.ownedProjectiles < 2) {
                    ((FireFlower)this.currentItem).throwProjectile(this);
                } else if (this.currentItem instanceof Hammer && this.ownedProjectiles < 2) {
                    ((Hammer)this.currentItem).throwProjectile(this);
                } else if (this.currentItem instanceof IceWand && this.ownedProjectiles < 1) {
                    ((IceWand)this.currentItem).throwProjectile(this);
                } else if (this.currentItem instanceof Boomerang && this.ownedProjectiles < 1) {
                    ((Boomerang)this.currentItem).throwProjectile(this);
                } else if (this.currentItem instanceof Bomb && this.ownedProjectiles < 2) {
                    ++this.ownedProjectiles;
                    this.heldItem = new DroppedBomb(this);
                }
                this.alreadyAttacked = true;
            }
            if (this.currentItem instanceof BobOmb) {
                ((BobOmb)this.currentItem).explode(this);
            }
            if ((double)this.hspeed > 8.0 * GameLogic.speedMultiplier) {
                this.hspeed = (float)(8.0 * GameLogic.speedMultiplier);
            } else if ((double)this.hspeed < -8.0 * GameLogic.speedMultiplier) {
                this.hspeed = (float)(-8.0 * GameLogic.speedMultiplier);
            }
        } else {
            if (this.heldItem != null) {
                this.releaseItem();
            }
            if ((double)this.hspeed > 3.0 * GameLogic.speedMultiplier) {
                this.hspeed = (float)(3.0 * GameLogic.speedMultiplier);
            } else if ((double)this.hspeed < -3.0 * GameLogic.speedMultiplier) {
                this.hspeed = (float)(-3.0 * GameLogic.speedMultiplier);
            }
        }
        if (this.vspeed > 18.0f) {
            this.vspeed = 18.0f;
        } else if ((double)this.vspeed < -18.0 * GameLogic.speedMultiplier) {
            this.vspeed = (float)(-18.0 * GameLogic.speedMultiplier);
        }
        if (this.onGround && this.ridingPlatform != null) {
            this.entityX = (float)((double)this.entityX + this.ridingPlatform.hspeed);
            this.entityY = (float)((double)this.entityY + (this.ridingPlatform.vspeed + 1.0));
        }
        if (this.shoe == null || !this.shoe.isPurple() || !this.onGround) {
            this.entityX += this.hspeed;
        }
        this.entityY += this.vspeed;
        this.x = Math.round(this.entityX) + 4;
        this.y = Math.round(this.entityY);
        if (this.entityX < 0.0f) {
            this.entityX += (float)GameLogic.currentMap.MAP_WIDTH;
        } else if (this.entityX >= (float)GameLogic.currentMap.MAP_WIDTH) {
            this.entityX -= (float)GameLogic.currentMap.MAP_WIDTH;
        }
        if (this.entityY > (float)GameLogic.currentMap.MAP_HEIGHT) {
            this.entityY = -32.0f;
            this.fallTiles[0] = null;
            this.fallTiles[1] = null;
        }
    }

    @Override
    protected synchronized void updateImage(long timePassed) {
        Animation walkingLeftToUse;
        Animation walkingRightToUse;
        BufferedImage[] spritesToUse;
        this.teamColors.update();
        if (this.currentItem instanceof TanookiSuit && ((TanookiSuit)this.currentItem).combo) {
            this.currentImage = ((TanookiSuit)this.currentItem).getStoneGraphic();
            return;
        }
        if (this.currentItem instanceof Leaf && ((Leaf)this.currentItem).spinAttacking) {
            this.spinAttack.update(timePassed);
            this.spinAttackLeft.update(timePassed);
            this.currentImage = ((Leaf)this.currentItem).facingRight ? this.spinAttack.getImage() : this.spinAttackLeft.getImage();
            this.animType = (byte)2;
            this.animNumber = (byte)(((Leaf)this.currentItem).facingRight ? this.spinAttack.getCurrentIndex() : this.spinAttackLeft.getCurrentIndex());
            if (((Leaf)this.currentItem).facingRight) {
                switch (this.spinAttack.getCurrentIndex()) {
                    case 0: {
                        this.facingRight = true;
                        break;
                    }
                    case 1: {
                        this.facingRight = false;
                        break;
                    }
                    case 2: {
                        this.facingRight = false;
                        break;
                    }
                    case 3: {
                        this.facingRight = false;
                        break;
                    }
                    case 4: {
                        this.facingRight = true;
                        break;
                    }
                    case 5: {
                        this.facingRight = true;
                    }
                }
            } else {
                switch (this.spinAttackLeft.getCurrentIndex()) {
                    case 0: {
                        this.facingRight = false;
                        break;
                    }
                    case 1: {
                        this.facingRight = true;
                        break;
                    }
                    case 2: {
                        this.facingRight = true;
                        break;
                    }
                    case 3: {
                        this.facingRight = true;
                        break;
                    }
                    case 4: {
                        this.facingRight = false;
                        break;
                    }
                    case 5: {
                        this.facingRight = false;
                    }
                }
            }
            if (this.spinAttack.firstCycleCompleted() || this.spinAttackLeft.firstCycleCompleted()) {
                ((Leaf)this.currentItem).spinAttacking = false;
                this.facingRight = ((Leaf)this.currentItem).facingRight;
                this.spinAttack.reset();
                this.spinAttackLeft.reset();
            }
            return;
        }
        if (this.currentItem instanceof Feather && ((Feather)this.currentItem).spinAttacking) {
            this.spinAttack.update(timePassed);
            this.spinAttackLeft.update(timePassed);
            this.currentImage = ((Feather)this.currentItem).facingRight ? this.spinAttack.getImage() : this.spinAttackLeft.getImage();
            this.animType = (byte)2;
            this.animNumber = (byte)(((Feather)this.currentItem).facingRight ? this.spinAttack.getCurrentIndex() : this.spinAttackLeft.getCurrentIndex());
            if (((Feather)this.currentItem).facingRight) {
                switch (this.spinAttack.getCurrentIndex()) {
                    case 0: {
                        this.facingRight = true;
                        break;
                    }
                    case 1: {
                        this.facingRight = false;
                        break;
                    }
                    case 2: {
                        this.facingRight = false;
                        break;
                    }
                    case 3: {
                        this.facingRight = false;
                        break;
                    }
                    case 4: {
                        this.facingRight = true;
                        break;
                    }
                    case 5: {
                        this.facingRight = true;
                    }
                }
            } else {
                switch (this.spinAttackLeft.getCurrentIndex()) {
                    case 0: {
                        this.facingRight = false;
                        break;
                    }
                    case 1: {
                        this.facingRight = true;
                        break;
                    }
                    case 2: {
                        this.facingRight = true;
                        break;
                    }
                    case 3: {
                        this.facingRight = true;
                        break;
                    }
                    case 4: {
                        this.facingRight = false;
                        break;
                    }
                    case 5: {
                        this.facingRight = false;
                    }
                }
            }
            if (this.spinAttack.firstCycleCompleted() || this.spinAttackLeft.firstCycleCompleted()) {
                ((Feather)this.currentItem).spinAttacking = false;
                this.facingRight = ((Feather)this.currentItem).facingRight;
                this.spinAttack.reset();
                this.spinAttackLeft.reset();
            }
            return;
        }
        if (this.currentItem instanceof BobOmb) {
            spritesToUse = ((BobOmb)this.currentItem).sprites;
            walkingRightToUse = ((BobOmb)this.currentItem).walkingRight;
            walkingLeftToUse = ((BobOmb)this.currentItem).walkingLeft;
        } else {
            spritesToUse = this.sprites;
            walkingRightToUse = this.walking;
            walkingLeftToUse = this.walkingLeft;
        }
        if (this.onGround) {
            if (this.hspeed > 0.0f) {
                if (this.controls[2]) {
                    this.currentImage = spritesToUse[3];
                    this.animType = 0;
                    this.animNumber = (byte)3;
                } else {
                    walkingLeftToUse.reset();
                    walkingRightToUse.update(timePassed);
                    this.animType = 1;
                    if (this.currentItem instanceof Leaf) {
                        ((Leaf)this.currentItem).animations[0].update(timePassed);
                        ((Leaf)this.currentItem).animationsLeft[0].reset();
                    } else if (this.currentItem instanceof Feather) {
                        ((Feather)this.currentItem).animations[0].update(timePassed);
                        ((Feather)this.currentItem).animationsLeft[0].reset();
                    }
                    this.currentImage = walkingRightToUse.getImage();
                    this.animNumber = (byte)walkingRightToUse.getCurrentIndex();
                }
            } else if (this.hspeed < 0.0f) {
                if (this.controls[3]) {
                    this.currentImage = spritesToUse[9];
                    this.animType = 0;
                    this.animNumber = (byte)9;
                } else {
                    walkingRightToUse.reset();
                    walkingLeftToUse.update(timePassed);
                    this.animType = 1;
                    if (this.currentItem instanceof Leaf) {
                        ((Leaf)this.currentItem).animationsLeft[0].update(timePassed);
                        ((Leaf)this.currentItem).animations[0].reset();
                    } else if (this.currentItem instanceof Feather) {
                        ((Feather)this.currentItem).animationsLeft[0].update(timePassed);
                        ((Feather)this.currentItem).animations[0].reset();
                    }
                    this.currentImage = walkingLeftToUse.getImage();
                    this.animNumber = (byte)walkingLeftToUse.getCurrentIndex();
                }
            } else {
                walkingLeftToUse.reset();
                walkingRightToUse.reset();
                if (this.currentItem instanceof Leaf) {
                    ((Leaf)this.currentItem).animations[0].reset();
                    ((Leaf)this.currentItem).animationsLeft[0].reset();
                } else if (this.currentItem instanceof Feather) {
                    ((Feather)this.currentItem).animations[0].reset();
                    ((Feather)this.currentItem).animationsLeft[0].reset();
                }
                this.currentImage = this.facingRight ? spritesToUse[0] : spritesToUse[6];
                this.animType = 0;
                this.animNumber = (byte)(this.facingRight ? 0 : 6);
            }
        } else {
            if (this.currentItem instanceof Feather) {
                if (this.facingRight) {
                    if (this.vspeed <= 0.0f) {
                        ((Feather)this.currentItem).animations[1].update(timePassed);
                        ((Feather)this.currentItem).animationsLeft[1].reset();
                    } else {
                        ((Feather)this.currentItem).animations[2].update(timePassed);
                        ((Feather)this.currentItem).animationsLeft[2].reset();
                    }
                } else if (this.vspeed <= 0.0f) {
                    ((Feather)this.currentItem).animationsLeft[1].update(timePassed);
                    ((Feather)this.currentItem).animations[1].reset();
                } else {
                    ((Feather)this.currentItem).animationsLeft[2].update(timePassed);
                    ((Feather)this.currentItem).animations[2].reset();
                }
            }
            this.currentImage = this.facingRight ? spritesToUse[2] : spritesToUse[8];
            this.animType = 0;
            this.animNumber = (byte)(this.facingRight ? 2 : 8);
        }
    }

    @Override
    public synchronized void collisionLogic() {
        if (this.isInWarp()) {
            return;
        }
        if (this.canWarp) {
            this.entryWarp = null;
            this.targetWarp = null;
        }
        this.relX = (int)(this.getCenterX() / 32.0);
        this.relY = (int)(this.getCenterY() / 32.0);
        PhysicalTile[][] pTiles = new PhysicalTile[3][3];
        InteractiveTile[][] iTiles = new InteractiveTile[3][3];
        int warpLen = GameLogic.currentMap.warps.length;
        Warp[][][] warps = new Warp[warpLen][3][3];
        int useX = this.relX - 1;
        int useY = this.relY - 1;
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                int i;
                if (useY + y < 0 || useY + y > GameLogic.usePTiles[0].length - 1) {
                    pTiles[x][y] = null;
                    iTiles[x][y] = null;
                    continue;
                }
                if (useX + x < 0) {
                    pTiles[x][y] = GameLogic.usePTiles[GameLogic.usePTiles.length - 1][useY + y];
                    iTiles[x][y] = GameLogic.currentMap.iTiles[GameLogic.usePTiles.length - 1][useY + y];
                    for (i = 0; i < warpLen; ++i) {
                        warps[i][x][y] = GameLogic.currentMap.warps[i][GameLogic.usePTiles.length - 1][useY + y];
                    }
                    continue;
                }
                if (useX + x >= GameLogic.usePTiles.length) {
                    pTiles[x][y] = GameLogic.usePTiles[0][useY + y];
                    iTiles[x][y] = GameLogic.currentMap.iTiles[0][useY + y];
                    for (i = 0; i < warpLen; ++i) {
                        warps[i][x][y] = GameLogic.currentMap.warps[i][0][useY + y];
                    }
                    continue;
                }
                pTiles[x][y] = GameLogic.usePTiles[useX + x][useY + y];
                iTiles[x][y] = GameLogic.currentMap.iTiles[useX + x][useY + y];
                for (i = 0; i < warpLen; ++i) {
                    warps[i][x][y] = GameLogic.currentMap.warps[i][useX + x][useY + y];
                }
            }
        }
        this.debugWarps = warps;
        this.collisionLogic(pTiles, iTiles, warps, false);
        this.ridingPlatform = null;
        for (int i = 0; i < GameLogic.currentMap.platforms.size(); ++i) {
            Platform p = GameLogic.currentMap.platforms.get(i);
            if (!this.intersects(p)) continue;
            useX = (int)((this.entityX - (float)p.getCurrentX()) / 32.0f) - 2;
            useY = (int)((this.entityY - (float)p.getCurrentY()) / 32.0f) - 2;
            for (int x = 0; x < 3; ++x) {
                for (int y = 0; y < 3; ++y) {
                    if (useY + y < 0 || useY + y > p.pTiles[0].length - 1) {
                        pTiles[x][y] = null;
                        iTiles[x][y] = null;
                        continue;
                    }
                    if (useX + x < 0) {
                        pTiles[x][y] = p.pTiles[p.pTiles.length - 1][y];
                        iTiles[x][y] = p.iTiles[p.pTiles.length - 1][y];
                        continue;
                    }
                    if (useX + x >= p.pTiles.length) {
                        pTiles[x][y] = p.pTiles[0][y];
                        iTiles[x][y] = p.iTiles[0][y];
                        continue;
                    }
                    pTiles[x][y] = p.pTiles[useX + x][useY + y];
                    iTiles[x][y] = p.iTiles[useX + x][useY + y];
                }
            }
            if (!this.collisionLogic(pTiles, iTiles, warps, true)) continue;
            this.ridingPlatform = p;
        }
        if (!this.canMoveLeft && !this.canMoveRight) {
            GameLogic.gamemode.reportKill(null, this);
            this.die();
        }
    }

    protected synchronized boolean collisionLogic(PhysicalTile[][] pTiles, InteractiveTile[][] iTiles, Warp[][][] warps, boolean platformCollision) {
        int i;
        int checkHeight;
        int matches;
        Polygon p;
        Direction dir;
        boolean fromSide;
        Rectangle useBBox;
        Rectangle predictingBox = new Rectangle(this);
        predictingBox.x = (int)((float)predictingBox.x + this.hspeed);
        predictingBox.y = (int)((float)predictingBox.y + this.vspeed);
        Rectangle wrapBox = new Rectangle(predictingBox);
        wrapBox.translate(-GameLogic.currentMap.MAP_WIDTH, 0);
        this.canMoveUp = true;
        if (!platformCollision) {
            this.canMoveLeft = true;
            this.canMoveRight = true;
            this.canJump = false;
            this.onGround = false;
        }
        boolean foundGround = false;
        PhysicalTile checkTile = pTiles[0][1];
        if (checkTile != null && (checkTile.mask.intersects(predictingBox) || checkTile.mask.intersects(wrapBox))) {
            useBBox = checkTile.mask.intersects(predictingBox) ? predictingBox : wrapBox;
            Direction dir2 = Direction.LEFT;
            if (checkTile.type.willKill(dir2)) {
                GameLogic.gamemode.reportKill(null, this);
                this.die();
                return false;
            }
            if (checkTile.type.isSolid(dir2)) {
                boolean bl = this.onFallthroughTile = checkTile.type == TileType.FALLTHROUGH || checkTile.type == TileType.FALLTHROUGH_SLIPPERY;
                if ((this.controls[1] || this.fallTiles[0] != null && checkTile == this.fallTiles[0]) && this.onFallthroughTile) {
                    this.onGround = false;
                    this.fallTiles[0] = checkTile;
                } else if (this.vspeed >= 0.0f && checkTile.mask instanceof Polygon) {
                    this.entityY = Geometry.calculateVerticalCollision(checkTile.mask, useBBox, false);
                    this.y = (int)this.entityY;
                    this.airTime = 0;
                    this.vspeed = 0.0f;
                    this.onGround = true;
                    this.canJump = true;
                    foundGround = true;
                } else {
                    this.entityX = Geometry.calculateSideCollision(checkTile.mask, useBBox, true);
                    this.hspeed = 0.0f;
                    this.canMoveLeft = false;
                }
            }
            if (checkTile.type == TileType.INTERACTIVE && iTiles[0][1] != null) {
                iTiles[0][1].react(this, dir2);
            }
        }
        for (int id = 0; id < warps.length && this.entryWarp == null; ++id) {
            this.entryWarp = warps[id][0][1];
        }
        if (this.canWarp && this.entryWarp != null && !this.entryWarp.isLocked()) {
            System.out.println(this.entryWarp.getBBox());
            if (this.entryWarp.dir == Direction.EAST && this.controls[2] && this.intersects(this.entryWarp.getBBox())) {
                System.out.println(this.entryWarp);
                System.out.println(this);
                System.out.println("-----------");
                this.targetWarp = GameLogic.currentMap.getRandomWarpByID(this.entryWarp);
                this.enteringDirection = this.entryWarp.dir;
                this.exitingDirection = this.targetWarp.dir;
                this.warp();
            }
        }
        if (this.canWarp) {
            this.entryWarp = null;
        }
        predictingBox = new Rectangle(this);
        predictingBox.x = (int)((float)predictingBox.x + this.hspeed);
        predictingBox.y = (int)((float)predictingBox.y + this.vspeed);
        wrapBox = new Rectangle(predictingBox);
        wrapBox.translate(-GameLogic.currentMap.MAP_WIDTH, 0);
        checkTile = pTiles[1][1];
        if (checkTile != null && (checkTile.mask.intersects(predictingBox) || checkTile.mask.intersects(wrapBox))) {
            useBBox = checkTile.mask.intersects(predictingBox) ? predictingBox : wrapBox;
            Direction dir3 = Direction.DOWN;
            if (checkTile.type.willKill(dir3)) {
                GameLogic.gamemode.reportKill(null, this);
                this.die();
                return false;
            }
            if (checkTile.type.isSolid(dir3)) {
                boolean bl = this.onFallthroughTile = checkTile.type == TileType.FALLTHROUGH || checkTile.type == TileType.FALLTHROUGH_SLIPPERY;
                if ((this.controls[1] || this.fallTiles[1] != null && checkTile == this.fallTiles[1]) && this.onFallthroughTile) {
                    this.onGround = false;
                    this.fallTiles[1] = checkTile;
                } else if (checkTile.mask instanceof Polygon) {
                    this.entityY = Geometry.calculateVerticalCollision(checkTile.mask, useBBox, false) + 1;
                    this.y = (int)this.entityY;
                    this.vspeed = 0.0f;
                    this.airTime = 0;
                    this.onGround = true;
                    foundGround = true;
                    this.canJump = true;
                }
            }
            if (checkTile.type == TileType.INTERACTIVE && iTiles[1][1] != null) {
                iTiles[1][1].react(this, dir3);
            }
        }
        predictingBox = new Rectangle(this);
        predictingBox.x = (int)((float)predictingBox.x + this.hspeed);
        predictingBox.y = (int)((float)predictingBox.y + this.vspeed);
        wrapBox = new Rectangle(predictingBox);
        wrapBox.translate(-GameLogic.currentMap.MAP_WIDTH, 0);
        checkTile = pTiles[2][1];
        if (checkTile != null && (checkTile.mask.intersects(predictingBox) || checkTile.mask.intersects(wrapBox))) {
            useBBox = checkTile.mask.intersects(predictingBox) ? predictingBox : wrapBox;
            Direction dir4 = Direction.RIGHT;
            if (checkTile.type.willKill(dir4)) {
                GameLogic.gamemode.reportKill(null, this);
                this.die();
                return false;
            }
            if (checkTile.type.isSolid(dir4)) {
                boolean bl = this.onFallthroughTile = checkTile.type == TileType.FALLTHROUGH || checkTile.type == TileType.FALLTHROUGH_SLIPPERY;
                if ((this.controls[1] || this.fallTiles[2] != null && checkTile == this.fallTiles[2]) && this.onFallthroughTile) {
                    this.onGround = false;
                    this.fallTiles[2] = checkTile;
                } else if (checkTile.mask instanceof Polygon) {
                    this.entityY = Geometry.calculateVerticalCollision(checkTile.mask, useBBox, false) + 1;
                    this.y = (int)this.entityY;
                    this.airTime = 0;
                    this.vspeed = 0.0f;
                    this.onGround = true;
                    this.canJump = true;
                } else {
                    this.entityX = Geometry.calculateSideCollision(checkTile.mask, useBBox, false) - 4;
                    this.hspeed = 0.0f;
                    this.canMoveRight = false;
                }
            }
            if (checkTile.type == TileType.INTERACTIVE) {
                iTiles[2][1].react(this, dir4);
            }
        }
        for (int id = 0; id < warps.length && this.entryWarp == null; ++id) {
            this.entryWarp = warps[id][2][1];
        }
        if (this.canWarp && this.entryWarp != null && !this.entryWarp.isLocked() && this.intersects(this.entryWarp.getBBox())) {
            System.out.println(this.entryWarp.getBBox());
            if (this.entryWarp.dir == Direction.WEST && this.controls[3]) {
                this.targetWarp = GameLogic.currentMap.getRandomWarpByID(this.entryWarp);
                this.enteringDirection = this.entryWarp.dir;
                this.exitingDirection = this.targetWarp.dir;
                this.warp();
            }
        }
        if (this.canWarp) {
            this.entryWarp = null;
        }
        predictingBox = new Rectangle(this);
        predictingBox.x = (int)((float)predictingBox.x + this.hspeed);
        predictingBox.y = (int)((float)predictingBox.y + this.vspeed);
        wrapBox = new Rectangle(predictingBox);
        wrapBox.translate(-GameLogic.currentMap.MAP_WIDTH, 0);
        checkTile = pTiles[1][0];
        if (checkTile != null && (checkTile.mask.intersects(predictingBox) || checkTile.mask.intersects(wrapBox))) {
            useBBox = checkTile.mask.intersects(predictingBox) ? predictingBox : wrapBox;
            Direction dir5 = Direction.UP;
            if (checkTile.type.willKill(dir5)) {
                GameLogic.gamemode.reportKill(null, this);
                this.die();
                return false;
            }
            if (checkTile.type.isSolid(dir5)) {
                this.entityY = Geometry.calculateVerticalCollision(checkTile.mask, useBBox, true) + 1;
                this.vspeed = 0.0f;
                this.airTime = 0;
                this.canMoveUp = false;
            }
            if (checkTile.type == TileType.INTERACTIVE && iTiles[1][0] != null) {
                iTiles[1][0].react(this, dir5);
            }
        }
        for (int id = 0; id < warps.length && this.entryWarp == null; ++id) {
            this.entryWarp = warps[id][1][0];
        }
        if (this.canWarp && this.entryWarp != null && !this.entryWarp.isLocked()) {
            System.out.println(this.entryWarp.getBBox());
            if (this.entryWarp.dir == Direction.SOUTH && this.controls[0] && this.intersects(this.entryWarp.getBBox())) {
                this.targetWarp = GameLogic.currentMap.getRandomWarpByID(this.entryWarp);
                this.vspeed = 0.0f;
                this.hspeed = 0.0f;
                this.onGround = true;
                this.enteringDirection = this.entryWarp.dir;
                this.exitingDirection = this.targetWarp.dir;
                this.warp();
            }
        }
        if (this.canWarp) {
            this.entryWarp = null;
        }
        predictingBox = new Rectangle(this);
        predictingBox.x = (int)((float)predictingBox.x + this.hspeed);
        predictingBox.y = (int)((float)predictingBox.y + this.vspeed);
        wrapBox = new Rectangle(predictingBox);
        wrapBox.translate(-GameLogic.currentMap.MAP_WIDTH, 0);
        checkTile = pTiles[0][0];
        if (this.canMoveLeft && this.canMoveUp && checkTile != null && (checkTile.mask.intersects(predictingBox) || checkTile.mask.intersects(wrapBox))) {
            float slope;
            Rectangle rectangle = useBBox = checkTile.mask.intersects(predictingBox) ? predictingBox : wrapBox;
            fromSide = checkTile.mask.getBounds().x == (int)this.entityX ? false : (slope = ((float)checkTile.mask.getBounds().y - this.entityY) / ((float)checkTile.mask.getBounds().x - this.entityX)) < 1.0f;
            Direction direction = dir = fromSide ? Direction.LEFT : Direction.UP;
            if (checkTile.type.willKill(dir)) {
                GameLogic.gamemode.reportKill(null, this);
                this.die();
                return false;
            }
            if (checkTile.type.isSolid(dir)) {
                if (checkTile.mask instanceof Polygon) {
                    p = (Polygon)checkTile.mask;
                    matches = 0;
                    checkHeight = p.getBounds().y;
                    for (i = 0; i < p.npoints; ++i) {
                        if (p.ypoints[i] != checkHeight) continue;
                        ++matches;
                    }
                    if (matches < 2) {
                        this.entityY = Geometry.calculateVerticalCollision(checkTile.mask, useBBox, true);
                        this.airTime = 0;
                        this.vspeed = 0.0f;
                        this.onGround = true;
                        foundGround = true;
                    }
                }
                if (fromSide) {
                    this.entityX = Geometry.calculateSideCollision(checkTile.mask, useBBox, true);
                    this.hspeed = 0.0f;
                    this.canMoveLeft = false;
                } else {
                    this.entityY = Geometry.calculateVerticalCollision(checkTile.mask, useBBox, true);
                    this.vspeed = 0.0f;
                    this.airTime = 0;
                    this.canMoveUp = false;
                }
            }
            if (checkTile.type == TileType.INTERACTIVE && iTiles[0][0] != null) {
                iTiles[0][0].react(this, dir);
            }
        }
        predictingBox = new Rectangle(this);
        predictingBox.x = (int)((float)predictingBox.x + this.hspeed);
        predictingBox.y = (int)((float)predictingBox.y + this.vspeed);
        wrapBox = new Rectangle(predictingBox);
        wrapBox.translate(-GameLogic.currentMap.MAP_WIDTH, 0);
        checkTile = pTiles[2][0];
        if (this.canMoveRight && this.canMoveUp && checkTile != null && (checkTile.mask.intersects(predictingBox) || checkTile.mask.intersects(wrapBox))) {
            float slope;
            Rectangle rectangle = useBBox = checkTile.mask.intersects(predictingBox) ? predictingBox : wrapBox;
            fromSide = checkTile.mask.getBounds().x == (int)this.entityX ? false : (slope = ((float)checkTile.mask.getBounds().y - this.entityY) / ((float)checkTile.mask.getBounds().x - this.entityX)) < 1.0f;
            Direction direction = dir = fromSide ? Direction.RIGHT : Direction.UP;
            if (checkTile.type.willKill(dir)) {
                GameLogic.gamemode.reportKill(null, this);
                this.die();
                return false;
            }
            if (checkTile.type.isSolid(dir)) {
                if (checkTile.mask instanceof Polygon) {
                    p = (Polygon)checkTile.mask;
                    matches = 0;
                    checkHeight = p.getBounds().y + p.getBounds().height;
                    for (i = 0; i < p.npoints; ++i) {
                        if (p.ypoints[i] != checkHeight) continue;
                        ++matches;
                    }
                    if (matches < 2) {
                        this.entityY = Geometry.calculateVerticalCollision(checkTile.mask, useBBox, false);
                        this.airTime = 0;
                        this.vspeed = 0.0f;
                    }
                }
                if (fromSide) {
                    this.entityX = Geometry.calculateSideCollision(checkTile.mask, this, false) - 4;
                    this.hspeed = 0.0f;
                    this.canMoveRight = false;
                } else {
                    this.entityY = Geometry.calculateVerticalCollision(checkTile.mask, useBBox, true);
                    this.vspeed = 0.0f;
                    this.airTime = 0;
                    this.canMoveUp = false;
                }
            }
            if (checkTile.type == TileType.INTERACTIVE) {
                iTiles[2][0].react(this, dir);
            }
        }
        predictingBox = new Rectangle(this);
        predictingBox.x = (int)((float)predictingBox.x + this.hspeed);
        predictingBox.y = (int)((float)predictingBox.y + this.vspeed);
        wrapBox = new Rectangle(predictingBox);
        wrapBox.translate(-GameLogic.currentMap.MAP_WIDTH, 0);
        checkTile = pTiles[1][2];
        if (checkTile != null && (checkTile.mask.intersects(predictingBox) || checkTile.mask.intersects(wrapBox))) {
            useBBox = checkTile.mask.intersects(predictingBox) ? predictingBox : wrapBox;
            dir = Direction.DOWN;
            if (checkTile.type.willKill(dir)) {
                GameLogic.gamemode.reportKill(null, this);
                this.die();
                return false;
            }
            if (checkTile.type.isSolid(dir)) {
                boolean bl = this.onFallthroughTile = checkTile.type == TileType.FALLTHROUGH || checkTile.type == TileType.FALLTHROUGH_SLIPPERY;
                if ((this.controls[1] || this.fallTiles[1] != null && checkTile == this.fallTiles[1]) && this.onFallthroughTile) {
                    this.onGround = false;
                    this.fallTiles[1] = checkTile;
                } else if (!this.onFallthroughTile || this.vspeed >= 0.0f) {
                    this.entityY = Geometry.calculateVerticalCollision(checkTile.mask, useBBox, false) + 1;
                    this.vspeed = 0.0f;
                    this.airTime = 0;
                    this.onGround = true;
                    foundGround = true;
                    this.canJump = true;
                    this.fallTiles[1] = null;
                }
            }
            if (checkTile.type == TileType.INTERACTIVE && iTiles[1][2] != null) {
                iTiles[1][2].react(this, dir);
            }
        }
        for (int id = 0; id < warps.length && this.entryWarp == null; ++id) {
            this.entryWarp = warps[id][1][2];
        }
        if (this.canWarp && this.entryWarp != null && !this.entryWarp.isLocked()) {
            System.out.println(this.entryWarp.getBBox());
            if (this.entryWarp.dir == Direction.NORTH && this.controls[1] && this.intersects(this.entryWarp.getBBox())) {
                this.targetWarp = GameLogic.currentMap.getRandomWarpByID(this.entryWarp);
                this.vspeed = 0.0f;
                this.hspeed = 0.0f;
                this.onGround = true;
                this.enteringDirection = this.entryWarp.dir;
                this.exitingDirection = this.targetWarp.dir;
                this.warp();
            }
        }
        if (this.canWarp) {
            this.entryWarp = null;
        }
        predictingBox = new Rectangle(this);
        predictingBox.x = (int)((float)predictingBox.x + this.hspeed);
        predictingBox.y = (int)((float)predictingBox.y + this.vspeed);
        wrapBox = new Rectangle(predictingBox);
        wrapBox.translate(-GameLogic.currentMap.MAP_WIDTH, 0);
        checkTile = pTiles[0][2];
        if (this.canMoveLeft && !this.onGround && checkTile != null && (checkTile.mask.intersects(predictingBox) || checkTile.mask.intersects(wrapBox))) {
            useBBox = checkTile.mask.intersects(predictingBox) ? predictingBox : wrapBox;
            Direction dir6 = Direction.DOWN;
            if (checkTile.type.willKill(dir6)) {
                GameLogic.gamemode.reportKill(null, this);
                this.die();
                return false;
            }
            if (checkTile.type.isSolid(dir6)) {
                boolean bl = this.onFallthroughTile = checkTile.type == TileType.FALLTHROUGH || checkTile.type == TileType.FALLTHROUGH_SLIPPERY;
                if ((this.controls[1] || this.fallTiles[0] != null && checkTile == this.fallTiles[0] && this.onFallthroughTile) && this.onFallthroughTile) {
                    this.onGround = false;
                    this.fallTiles[0] = checkTile;
                } else if (checkTile.mask instanceof Polygon) {
                    p = (Polygon)checkTile.mask;
                    matches = 0;
                    checkHeight = p.getBounds().y + p.getBounds().height;
                    for (i = 0; i < p.npoints; ++i) {
                        if (p.ypoints[i] != checkHeight) continue;
                        ++matches;
                    }
                    if (matches < 2 && (!this.onFallthroughTile || this.vspeed >= 0.0f)) {
                        this.entityY = Geometry.calculateVerticalCollision(checkTile.mask, useBBox, false) + 1;
                        this.airTime = 0;
                        this.vspeed = 0.0f;
                        this.onGround = true;
                        foundGround = true;
                        this.canJump = true;
                        this.fallTiles[0] = null;
                    }
                } else if (this.canMoveLeft && (!this.onFallthroughTile || this.vspeed >= 0.0f)) {
                    this.entityY = Geometry.calculateVerticalCollision(checkTile.mask, useBBox, false) + 1;
                    this.vspeed = 0.0f;
                    this.airTime = 0;
                    this.onGround = true;
                    foundGround = true;
                    this.canJump = true;
                    this.fallTiles[0] = null;
                }
            }
            if (checkTile.type == TileType.INTERACTIVE && iTiles[0][2] != null) {
                iTiles[0][2].react(this, dir6);
            }
        }
        predictingBox = new Rectangle(this);
        predictingBox.x = (int)((float)predictingBox.x + this.hspeed);
        predictingBox.y = (int)((float)predictingBox.y + this.vspeed);
        wrapBox = new Rectangle(predictingBox);
        wrapBox.translate(-GameLogic.currentMap.MAP_WIDTH, 0);
        checkTile = pTiles[2][2];
        if (this.canMoveRight && !this.onGround && checkTile != null && (checkTile.mask.intersects(predictingBox) || checkTile.mask.intersects(wrapBox))) {
            useBBox = checkTile.mask.intersects(predictingBox) ? predictingBox : wrapBox;
            Direction dir7 = Direction.DOWN;
            if (checkTile.type.willKill(dir7)) {
                GameLogic.gamemode.reportKill(null, this);
                this.die();
                return false;
            }
            if (checkTile.type.isSolid(dir7)) {
                boolean bl = this.onFallthroughTile = checkTile.type == TileType.FALLTHROUGH || checkTile.type == TileType.FALLTHROUGH_SLIPPERY;
                if ((this.controls[1] || this.fallTiles[2] != null && checkTile == this.fallTiles[2]) && this.onFallthroughTile) {
                    this.onGround = false;
                    this.fallTiles[2] = checkTile;
                } else if (!this.onFallthroughTile || this.vspeed >= 0.0f) {
                    this.entityY = Geometry.calculateVerticalCollision(checkTile.mask, useBBox, false) + 1;
                    this.vspeed = 0.0f;
                    this.airTime = 0;
                    this.onGround = true;
                    foundGround = true;
                    this.canJump = true;
                    this.fallTiles[2] = null;
                }
            }
            if (checkTile.type == TileType.INTERACTIVE && iTiles[2][2] != null) {
                iTiles[2][2].react(this, dir7);
            }
        }
        return platformCollision && foundGround;
    }

    @Override
    public void spawn() {
        this.alive = true;
        this.setSize(24, 32);
        int relX = 0;
        int relY = 0;
        PhysicalTile p = null;
        do {
            relX = (int)(GameLogic.random.nextDouble() * (double)GameLogic.currentMap.REL_WIDTH);
            relY = (int)(GameLogic.random.nextDouble() * (double)GameLogic.currentMap.REL_HEIGHT);
            p = GameLogic.usePTiles[relX][relY];
        } while (!GameLogic.currentMap.spawnLocs[relX][relY] && p != null && (p == null || p.type != TileType.NONE) && p.type != TileType.FALLTHROUGH && p.type != TileType.FALLTHROUGH_SLIPPERY);
        this.entityX = relX * 32;
        this.entityY = relY * 32;
        this.x = (int)(this.entityX + 4.0f);
        this.y = (int)this.entityY;
        MapScene.w.addKeyListener(this);
        MapScene.fs.addKeyListener(this);
    }

    @Override
    public void die() {
        SoundPlayer.playSound(Sound.DEATH);
        this.alive = false;
        this.currentItem = null;
        this.invincible = false;
        this.setSize(0, 0);
        if (this.shoe != null) {
            KuriboShoe s = (KuriboShoe)this.shoe.clone();
            s.setLocation(this.entityX, this.entityY);
            GameLogic.addMapEntity(s);
        }
        this.shoe = null;
        this.currentImage = this.sprites[4];
        for (int i = 0; i < this.controls.length; ++i) {
            this.controls[i] = false;
        }
        if (!NetplayServer.running) {
            MapScene.w.removeKeyListener(this);
            MapScene.fs.removeKeyListener(this);
        }
        GameLogic.startDelayedAction(1000L, new Runnable(){

            @Override
            public void run() {
                Player.this.hspeed = 0.0f;
                Player.this.vspeed = 0.0f;
                Player.this.airTime = 0;
                Player.this.spawn();
            }
        });
    }

    public void squish() {
        SoundPlayer.playSound(Sound.SQUISH);
        this.alive = false;
        this.currentItem = null;
        this.invincible = false;
        this.setSize(0, 0);
        this.currentImage = this.sprites[5];
        for (int i = 0; i < this.controls.length; ++i) {
            this.controls[i] = false;
        }
        if (!NetplayServer.running) {
            MapScene.w.removeKeyListener(this);
            MapScene.fs.removeKeyListener(this);
        }
        GameLogic.startDelayedAction(1000L, new Runnable(){

            @Override
            public void run() {
                Player.this.spawn();
            }
        });
    }

    @Override
    public void react(Interactive i, Direction direction) {
        if (this.isInvincible() && i instanceof Entity && ((Entity)i).teamColor != this.teamColor) {
            ((Entity)i).die();
            GameLogic.gamemode.reportKill(this, (Entity)i);
        }
        if (i instanceof Player) {
            if (this.frozen) {
                this.die();
                this.frozen = false;
            } else {
                Player player = (Player)i;
                switch (direction) {
                    case DOWN: {
                        if (this.isTanookiCombo()) {
                            player.onGround = true;
                            break;
                        }
                        if (player.teamColor != this.teamColor && (!player.isTanookiCombo() || player.isTanookiCombo() && player.entityY + 26.0f < this.entityY)) {
                            GameLogic.gamemode.reportKill(player, this);
                            if (this.score > 0) {
                                this.squish();
                            } else {
                                this.die();
                            }
                        }
                        player.vspeed = -8.0f;
                        player.airTime = 192;
                        player.onGround = false;
                        break;
                    }
                    case LEFT: {
                        if (this.isTanookiCombo()) {
                            player.canMoveLeft = false;
                            break;
                        }
                        if (this.isAttackingCape() || this.isAttackingLeaf()) {
                            if (!this.facingRight || player.teamColor == this.teamColor) break;
                            GameLogic.gamemode.reportKill(this, player);
                            player.die();
                            break;
                        }
                        this.facingRight = true;
                        this.hspeed = Math.abs((player.hspeed + this.hspeed) / 2.0f);
                        this.canMoveLeft = false;
                        break;
                    }
                    case RIGHT: {
                        if (this.isTanookiCombo()) {
                            player.canMoveRight = false;
                            break;
                        }
                        if (this.isAttackingCape() || this.isAttackingLeaf()) {
                            if (this.facingRight || player.teamColor == this.teamColor) break;
                            GameLogic.gamemode.reportKill(this, player);
                            player.die();
                            break;
                        }
                        this.facingRight = false;
                        this.hspeed = -Math.abs((player.hspeed + this.hspeed) / 2.0f);
                        this.canMoveRight = false;
                        break;
                    }
                }
            }
        } else if (i instanceof PowerUp) {
            if (((PowerUp)i).canReact()) {
                ((PowerUp)i).playItemGetSound();
                this.addItem((PowerUp)i);
            }
        } else if (i instanceof Shell) {
            Shell shell = (Shell)i;
            if (this.invincible) {
                shell.die();
                GameLogic.gamemode.reportKill(this, shell);
            } else {
                switch (direction) {
                    case UP: {
                        if (shell instanceof SpikeShell) {
                            GameLogic.gamemode.reportKill(shell, this);
                            this.die();
                            break;
                        }
                        shell.currentImage = shell.idleSprite;
                        shell.moving = false;
                        shell.hspeed = 0.0f;
                        this.vspeed = -8.0f;
                        this.airTime = 192;
                        this.onGround = false;
                        break;
                    }
                    case LEFT: {
                        if (this.controls[4] && !this.facingRight) {
                            this.giveHoldItem((Shell)i);
                            break;
                        }
                        if (shell.moving) break;
                        shell.moving = true;
                        shell.hspeed = -5.0f;
                        break;
                    }
                    case RIGHT: {
                        if (this.controls[4] && this.facingRight) {
                            this.giveHoldItem((Shell)i);
                        }
                        if (shell.moving) break;
                        shell.moving = true;
                        shell.hspeed = 5.0f;
                        break;
                    }
                }
            }
        } else if (i instanceof KuriboShoe) {
            this.shoe = (KuriboShoe)i;
            this.currentItem = null;
            ((KuriboShoe)i).die();
        } else if (i instanceof Holdable) {
            switch (direction) {
                case LEFT: {
                    if (!this.controls[4] || this.facingRight) break;
                    this.giveHoldItem((Holdable)((Object)i));
                    break;
                }
                case RIGHT: {
                    if (!this.controls[4] || !this.facingRight) break;
                    this.giveHoldItem((Holdable)((Object)i));
                    break;
                }
            }
        }
    }

    protected void addItem(PowerUp item) {
        if (!item.canBeUsed()) {
            return;
        }
        item.setTeam(this.teamColor);
        if (item instanceof AbstractLifeMushroom) {
            this.score += ((AbstractLifeMushroom)item).lifeValue;
        } else if (item instanceof PoisonMushroom) {
            this.die();
        } else if (item instanceof MysteryMushroom) {
            ((MysteryMushroom)item).swap();
        } else if (item instanceof Starman) {
            this.teamColors.setInvincible(true);
            this.startInvincibleTimer();
        } else if (item instanceof BulletBill || item instanceof Podobo || item instanceof SlowdownClock || item instanceof SpeedupClock || item instanceof ModBlock || item instanceof PowBlock) {
            if (this.reserveItem == null) {
                this.reserveItem = item;
            }
        } else {
            if (item instanceof Leaf) {
                ((Leaf)item).setInStorage(true);
            } else if (item instanceof Feather) {
                ((Feather)item).setInStorage(true);
            }
            if (this.currentItem == null) {
                this.currentItem = item;
            } else if (this.reserveItem == null) {
                this.reserveItem = item;
            }
        }
        item.die();
    }

    protected void useReserveItem() {
        if (this.reserveItem == null || this.shoe != null || GameLogic.containsDelayedAction(this.reserveBuffer)) {
            return;
        }
        SoundPlayer.playSound(Sound.USESTOREDITEM);
        this.inuseItem = this.reserveItem;
        this.reserveItem = null;
        GameLogic.startDelayedAction(1000L, this.reserveBuffer);
    }

    public void giveHoldItem(Holdable item) {
        if (this.canHoldItem()) {
            if (item instanceof ThrowBlockEntity) {
                ((ThrowBlockEntity)item).startHoldTimer();
            } else if (item instanceof EditableEntity) {
                ((EditableEntity)((Object)item)).setTeamColor(this.teamColor);
                GameLogic.removeMapEntity((EditableEntity)((Object)item));
            } else if (item instanceof Entity) {
                ((Entity)((Object)item)).die();
            }
            this.heldItem = item;
        }
    }

    public boolean canHoldItem() {
        return !(this.heldItem != null || this.currentItem instanceof FireFlower || this.currentItem instanceof Hammer || this.currentItem instanceof IceWand || this.currentItem instanceof TanookiSuit && ((TanookiSuit)this.currentItem).combo || this.shoe != null && this.shoe.combo);
    }

    public void releaseItem() {
        this.heldItem.release(this);
        SoundPlayer.playSound(Sound.KICK);
        this.heldItem = null;
    }

    protected void warp() {
        this.canWarp = false;
        this.entryWarp.setLocked(true);
        Warp.setLockedCombinedWarp(this.targetWarp, true);
        this.warpTime = 0;
        this.inWarp = true;
        this.hspeed = 0.0f;
        this.vspeed = 0.0f;
        if (!NetplayServer.running) {
            MapScene.w.removeKeyListener(this);
            MapScene.fs.removeKeyListener(this);
        }
        for (int i = 0; i < this.controls.length; ++i) {
            this.controls[i] = false;
        }
        SoundPlayer.playSound(Sound.WARP);
    }

    protected void endWarp() {
        if (!NetplayServer.running) {
            MapScene.w.addKeyListener(this);
            MapScene.fs.addKeyListener(this);
        }
        SoundPlayer.playSound(Sound.WARP);
        this.inWarp = false;
        GameLogic.startDelayedAction(2000L, new Runnable(){

            @Override
            public void run() {
                Player.this.entryWarp.setLocked(false);
                Warp.setLockedCombinedWarp(Player.this.targetWarp, false);
                Player.this.entryWarp = null;
                Player.this.targetWarp = null;
                Player.this.canWarp = true;
            }
        });
    }

    @Override
    public synchronized void drawToScreen(Graphics2D g2D, float xPos, float yPos) {
        try {
            if (this.currentItem instanceof Feather) {
                ((Feather)this.currentItem).drawOverlayToScreen(g2D, this.facingRight ? xPos - 10.0f : xPos + 20.0f, yPos, this);
            } else if (this.currentItem instanceof Leaf) {
                ((Leaf)this.currentItem).drawOverlayToScreen(g2D, this.facingRight ? xPos - 10.0f : xPos + 20.0f, yPos + 10.0f, this);
            } else if (this.currentItem instanceof PWing) {
                ((PWing)this.currentItem).drawOverlayToScreen(g2D, this.facingRight ? xPos - 12.0f : xPos + 12.0f, yPos, this);
            }
            if (this.heldItem != null) {
                if (this.heldItem instanceof DroppedBomb) {
                    this.heldItem.drawToScreen(g2D, this.facingRight ? xPos + 16.0f : xPos - 16.0f, yPos - 6.0f);
                } else {
                    this.heldItem.drawToScreen(g2D, this.facingRight ? xPos + 16.0f : xPos - 16.0f, yPos);
                }
            }
            if (this.shoe == null) {
                super.drawToScreen(g2D, xPos, yPos);
            }
            if (this.frozen) {
                g2D.drawImage((Image)Entity.ICE_BLOCK, Math.round(xPos), Math.round(yPos), null);
            }
            if (this.shoe != null) {
                super.drawToScreen(g2D, xPos, yPos - 16.0f);
                this.shoe.drawOverlayToScreen(g2D, xPos, yPos, this.facingRight);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isControlDown() {
        return this.controls[4];
    }

    public boolean canNoteBlockBounce() {
        return this.controls[0] && !this.alreadyJumped;
    }

    public boolean isInWarp() {
        return this.inWarp;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public boolean isFacingRight() {
        return this.facingRight;
    }

    public boolean isHoldingItem() {
        return this.heldItem != null;
    }

    public boolean isInvincible() {
        return this.invincible;
    }

    protected void startInvincibleTimer() {
        this.invincible = true;
        SoundPlayer.stopMusic();
        SoundPlayer.playSound(Sound.STARMAN);
        GameLogic.startDelayedAction(9000L, new Runnable(){

            @Override
            public void run() {
                Player.this.invincible = false;
                Player.this.teamColors.setInvincible(false);
                SoundPlayer.stopSound(Sound.STARMAN);
                SoundPlayer.restartMusic();
            }
        });
    }

    public BufferedImage getDefaultImage() {
        return this.sprites[this.facingRight ? 0 : 6];
    }

    public BufferedImage getHUDImage() {
        return this.sprites[2];
    }

    public int getScore() {
        return this.score;
    }

    public boolean isAttackingCape() {
        return this.currentItem instanceof Feather && ((Feather)this.currentItem).spinAttacking;
    }

    public boolean isAttackingLeaf() {
        return this.currentItem instanceof Leaf && ((Leaf)this.currentItem).spinAttacking;
    }

    public boolean hasAttackItem() {
        return this.currentItem instanceof BobOmb || this.currentItem instanceof Boomerang || this.currentItem instanceof FireFlower || this.currentItem instanceof Hammer || this.currentItem instanceof IceWand;
    }

    public void changeScore(int i) {
        this.score += i;
        if (this.score <= 0) {
            super.die();
        }
    }

    public boolean isOnFallthroughTile() {
        return this.onFallthroughTile;
    }

    public boolean isAttackingShoe() {
        return this.shoe != null && this.shoe.combo;
    }

    public boolean isTanookiCombo() {
        return this.currentItem instanceof TanookiSuit && ((TanookiSuit)this.currentItem).combo;
    }

    public boolean isPWingCombo() {
        return this.currentItem instanceof PWing && ((PWing)this.currentItem).numJumps > 1;
    }

    @Override
    public void iTileBumpTop() {
        this.die();
    }

    public Warp getDestinationWarp() {
        return this.isInWarp() ? this.targetWarp : null;
    }

    public Warp getEntryWarp() {
        return this.isInWarp() ? this.entryWarp : null;
    }

    public PowerUp getCurrentItem() {
        return this.currentItem;
    }

    public void setCurrentItem(PowerUp powerUp) {
        this.currentItem = powerUp;
    }
}

