/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.entity;

import com.dmgame.Direction;
import com.dmgame.GameLogic;
import com.dmgame.Interactive;
import com.dmgame.MapScene;
import com.dmgame.SMWException;
import com.dmgame.SpriteColorModel;
import com.dmgame.Utility;
import com.dmgame.entity.Entity;
import com.dmgame.entity.Player;
import com.dmgame.entity.Team;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;

public class PodoboEntity
extends Entity {
    private static final long serialVersionUID = -8441593810234579593L;
    private transient BufferedImage normalSprite;
    private transient BufferedImage flippedSprite;
    private float maxHeight;
    private boolean maxHeightReached;
    public Entity spawningEntity;
    public static final int MAX_HEIGHT_CONSTANT = 2;

    public PodoboEntity(Entity spawningEntity) {
        super("podobo", (float)((int)(GameLogic.random.nextDouble() * (double)GameLogic.currentMap.MAP_WIDTH)), (float)(GameLogic.currentMap.MAP_HEIGHT + 32), spawningEntity != null ? spawningEntity.teamColor : Team.UNALLIED);
        this.spawningEntity = spawningEntity;
        this.maxHeight = (float)(GameLogic.random.nextDouble() * (double)GameLogic.currentMap.MAP_HEIGHT);
        this.maxHeightReached = false;
        this.hspeed = 0.0f;
        this.vspeed = -18.0f;
    }

    @Override
    public String getScriptCreateStatement() {
        return this.buildString(this.getClass().getSimpleName(), "(", "entities.get(", this.spawningEntity.entityID, "))");
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof PodoboEntity)) {
            return false;
        }
        PodoboEntity other = (PodoboEntity)obj;
        if (Float.floatToIntBits(this.maxHeight) != Float.floatToIntBits(other.maxHeight)) {
            return false;
        }
        if (this.maxHeightReached != other.maxHeightReached) {
            return false;
        }
        return !(this.spawningEntity == null ? other.spawningEntity != null : !this.spawningEntity.equals(other.spawningEntity));
    }

    @Override
    protected void createSprites(String spriteFilename) {
        try {
            this.normalSprite = ImageIO.read(new File("res/gfx/packs/" + MapScene.texturePackName + "/powerups/" + spriteFilename + ".png"));
            this.flippedSprite = Utility.getVerticalFlippedCopy(this.normalSprite);
            this.teamColors = new SpriteColorModel(this.teamColor.colors, Color.RED, this.normalSprite, this.flippedSprite);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void setTeamColor(Team teamColor) {
        try {
            float colorShift = 0.0f;
            switch (teamColor) {
                case GREEN: {
                    colorShift = 0.3f;
                    break;
                }
                case YELLOW: {
                    colorShift = 0.15f;
                    break;
                }
                case BLUE: {
                    colorShift = -0.3f;
                    break;
                }
                default: {
                    return;
                }
            }
            if (colorShift != 0.0f) {
                this.teamColors.shiftColor(colorShift, -1.0f, -1.0f, (byte)0);
            }
        }
        catch (SMWException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void react(Interactive i, Direction direction) {
        Entity e;
        if (i instanceof Entity && !((Entity)i).equals(this.spawningEntity) && (!((e = (Entity)i) instanceof PodoboEntity) || e instanceof PodoboEntity && !((PodoboEntity)e).spawningEntity.equals(this.spawningEntity))) {
            if (e instanceof Player) {
                if (((Player)e).teamColor == this.teamColor || ((Player)e).isInvincible()) {
                    return;
                }
                GameLogic.gamemode.reportKill(this.spawningEntity, e);
                e.die();
            }
            this.die();
        }
    }

    @Override
    public void update(long timePassed) {
        if (!this.maxHeightReached && this.entityY < this.maxHeight * 2.0f) {
            this.maxHeightReached = true;
        }
        super.update(timePassed);
    }

    @Override
    protected void updateMovement(long timePassed) {
        if (this.maxHeightReached) {
            this.vspeed += 0.4f;
        }
        if (this.vspeed > 18.0f) {
            this.vspeed = 18.0f;
        }
        this.entityX += this.hspeed;
        this.entityY += this.vspeed;
        this.x = (int)this.entityX;
        this.y = (int)this.entityY;
        if (this.entityX < 0.0f) {
            this.entityX += (float)GameLogic.currentMap.MAP_WIDTH;
        } else if (this.entityX > (float)GameLogic.currentMap.MAP_WIDTH) {
            this.entityX -= (float)GameLogic.currentMap.MAP_WIDTH;
        }
        if (this.entityY > (float)(GameLogic.currentMap.MAP_HEIGHT + 31)) {
            this.die();
        }
    }

    @Override
    protected void updateImage(long timePassed) {
        this.currentImage = this.vspeed > 0.0f ? this.flippedSprite : this.normalSprite;
    }

    @Override
    public void collisionLogic() {
    }

    @Override
    public void iTileBumpTop() {
    }
}

