/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.entity;

import com.dmgame.Animation;
import com.dmgame.Direction;
import com.dmgame.GameLogic;
import com.dmgame.Interactive;
import com.dmgame.MapScene;
import com.dmgame.PathFollower;
import com.dmgame.entity.EditableEntity;
import com.dmgame.entity.Entity;
import com.dmgame.entity.Team;
import com.dmgame.leveleditor.LevelEditorScene;
import com.dmgame.map.Map;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public strictfp class Rotodisc
extends EditableEntity {
    private static final long serialVersionUID = -3547680656665948331L;
    public static final transient int SPEED_MIN = 0;
    public static final transient int SPEED_MAX = 10;
    public static final transient int RADIUS_MIN = 0;
    public static final transient int RADIUS_MAX = 20;
    public transient ArrayList<Disc> discs;
    private float speed;
    private float radius;
    private int numDiscs;
    private Direction dir;
    private transient JSlider speedSlider;
    private transient JSlider radiusSlider;
    private transient JSpinner numDiscSpinner;
    public Ellipse2D.Float path;

    public Rotodisc(float entityX, float entityY, boolean editorMode) {
        super("rotodisc", entityX, entityY, editorMode);
        this.radius = 5.0f;
        this.speed = 5.0f;
        this.dir = Direction.CLOCKWISE;
        this.path = new Ellipse2D.Float(entityX + (float)(this.width / 2) - this.radius * 16.0f, entityY + (float)(this.height / 2) - this.radius * 16.0f, this.radius * 32.0f, this.radius * 32.0f);
        this.setNumDiscs(1);
    }

    @Override
    public String getScriptCreateStatement() {
        return this.buildString(this.getClass().getSimpleName(), "(", Float.valueOf(this.entityX), ",", Float.valueOf(this.entityY), ",", this.editorMode, ")");
    }

    public Rotodisc(float entityX, float entityY, boolean editorMode, int[] iParams, float[] dParams) {
        super("rotodisc", entityX, entityY, editorMode);
        this.radius = dParams[2];
        this.speed = 5.0f;
        this.path = new Ellipse2D.Float(entityX + (float)(this.width / 2) - this.radius * 16.0f, entityY + (float)(this.height / 2) - this.radius * 16.0f, this.radius * 32.0f, this.radius * 32.0f);
        this.setNumDiscs(iParams[0]);
    }

    @Override
    protected void createSprites(String spriteFilename) {
        try {
            this.currentImage = ImageIO.read(new File("res/gfx/leveleditor/centerrotation.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void react(Interactive i, Direction direction) {
    }

    @Override
    public void update(long timePassed) {
        super.update(timePassed);
        for (Disc d : this.discs) {
            if (this.editorMode) {
                d.updateImage(timePassed);
                continue;
            }
            d.update(timePassed);
        }
    }

    @Override
    protected void updateMovement(long timePassed) {
        this.x = (int)this.entityX;
        this.y = (int)this.entityY;
        if (this.entityX < 0.0f) {
            this.entityX += (float)GameLogic.currentMap.MAP_WIDTH;
        } else if (this.entityX > (float)GameLogic.currentMap.MAP_WIDTH) {
            this.entityX -= (float)GameLogic.currentMap.MAP_WIDTH;
        }
        if (this.entityY > (float)GameLogic.currentMap.MAP_HEIGHT) {
            this.entityY = -32.0f;
        }
        this.relX = (int)(this.entityX / 32.0f);
        this.relY = (int)(this.entityY / 32.0f);
    }

    @Override
    protected void updateImage(long timePassed) {
    }

    @Override
    public void collisionLogic() {
    }

    @Override
    public void drawToScreen(Graphics2D g2D, float xLoc, float yLoc) {
        for (Disc d : this.discs) {
            d.drawToScreen(g2D, d.entityX, d.entityY);
        }
    }

    @Override
    protected JComponent[] setupComponents() {
        JComponent[] toReturn = new JComponent[6];
        this.speedSlider = new JSlider(0, 0, 10, (int)this.speed);
        this.speedSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                Rotodisc.this.speed = source.getValue();
            }
        });
        JLabel speedLabel = new JLabel("Speed");
        speedLabel.setAlignmentX(0.5f);
        this.radiusSlider = new JSlider(0, 0, 20, (int)this.radius);
        this.radiusSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                Rotodisc.this.radius = source.getValue();
                Rotodisc.this.path.height = Rotodisc.this.radius * 32.0f;
                Rotodisc.this.path.width = Rotodisc.this.radius * 32.0f;
                Rotodisc.this.path.x = Rotodisc.this.entityX + (float)(Rotodisc.this.width / 2) - Rotodisc.this.radius * 16.0f;
                Rotodisc.this.path.y = Rotodisc.this.entityY + (float)(Rotodisc.this.height / 2) - Rotodisc.this.radius * 16.0f;
                Rotodisc.this.setDiscsPosition();
            }
        });
        JLabel radiusLabel = new JLabel("Radius");
        radiusLabel.setAlignmentX(0.5f);
        JLabel numDiscLabel = new JLabel("Number of Discs");
        SpinnerListModel numDiscModel = new SpinnerListModel(new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9"});
        numDiscModel.setValue(Integer.toString(this.numDiscs));
        this.numDiscSpinner = new JSpinner(numDiscModel);
        this.numDiscSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSpinner source = (JSpinner)e.getSource();
                Rotodisc.this.setNumDiscs(Integer.parseInt((String)source.getValue()));
            }
        });
        toReturn[0] = speedLabel;
        toReturn[1] = this.speedSlider;
        toReturn[2] = radiusLabel;
        toReturn[3] = this.radiusSlider;
        toReturn[4] = numDiscLabel;
        toReturn[5] = this.numDiscSpinner;
        return toReturn;
    }

    private void setNumDiscs(int numDiscs) {
        this.numDiscs = numDiscs;
        this.discs = new ArrayList(numDiscs);
        for (int i = 0; i < numDiscs; ++i) {
            this.discs.add(new Disc(this.entityX, this.entityY, (float)i / (float)numDiscs));
        }
    }

    public void setDiscsPosition() {
        for (int i = 0; i < this.numDiscs; ++i) {
            this.discs.get(i).resetPathFollower((float)i / (float)this.numDiscs);
        }
    }

    @Override
    public void setLocation(float entityX, float entityY) {
        super.setLocation(entityX, entityY);
        this.path.x = entityX + (float)(this.width / 2) - this.radius * 16.0f;
        this.path.y = entityY + (float)(this.height / 2) - this.radius * 16.0f;
        this.setDiscsPosition();
    }

    @Override
    public void setRelLocation(int relX, int relY) {
        super.setRelLocation(relX, relY);
        this.path.x = this.entityX + (float)(this.width / 2) - this.radius * 16.0f;
        this.path.y = this.entityY + (float)(this.height / 2) - this.radius * 16.0f;
        this.setDiscsPosition();
    }

    @Override
    protected JMenu[] getSettingsMenuOptions() {
        JMenu[] toReturn = new JMenu[1];
        JMenu menu = new JMenu("Direction");
        ButtonGroup group = new ButtonGroup();
        JRadioButtonMenuItem clockwiseButton = new JRadioButtonMenuItem("Clockwise");
        clockwiseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Rotodisc.this.dir = Direction.CLOCKWISE;
                for (Disc d : Rotodisc.this.discs) {
                    d.setPath(Rotodisc.this.dir);
                }
            }
        });
        group.add(clockwiseButton);
        menu.add(clockwiseButton);
        JRadioButtonMenuItem counterClockwiseButton = new JRadioButtonMenuItem("Counter-Clockwise");
        this.dir = Direction.COUNTER_CLOCKWISE;
        counterClockwiseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Rotodisc.this.dir = Direction.COUNTER_CLOCKWISE;
                for (Disc d : Rotodisc.this.discs) {
                    d.setPath(Rotodisc.this.dir);
                }
            }
        });
        group.add(counterClockwiseButton);
        menu.add(counterClockwiseButton);
        switch (this.dir) {
            case CLOCKWISE: {
                clockwiseButton.setSelected(true);
                break;
            }
            case COUNTER_CLOCKWISE: {
                counterClockwiseButton.setSelected(true);
                break;
            }
        }
        menu.validate();
        toReturn[0] = menu;
        return toReturn;
    }

    @Override
    protected LayoutManager getLayout() {
        return new GridLayout(0, 2);
    }

    @Override
    public Object clone() {
        Rotodisc r = new Rotodisc(this.entityX, this.entityY, this.editorMode);
        r.x = Math.round(this.entityX);
        r.y = Math.round(this.entityY);
        r.speed = this.speed;
        r.dir = this.dir;
        r.radius = this.radius;
        r.path = new Ellipse2D.Float(this.entityX + (float)(this.width / 2) - this.radius * 16.0f, this.entityY + (float)(this.height / 2) - this.radius * 16.0f, this.radius * 32.0f, this.radius * 32.0f);
        r.setNumDiscs(this.numDiscs);
        return r;
    }

    public float getRotodiscX() {
        return this.entityX;
    }

    public float getRotodiscY() {
        return this.entityY;
    }

    public int getNumDiscs() {
        return this.numDiscs;
    }

    public float getRadius() {
        return this.radius;
    }

    @Override
    public void iTileBumpTop() {
    }

    public strictfp class Disc
    extends Entity {
        private static final long serialVersionUID = 8196616512867664483L;
        private transient Animation anim;
        private PathFollower helper;

        public Disc(float entityX, float entityY, double startTime) {
            super("rotodisc", entityX, entityY, Team.UNALLIED);
            this.resetPathFollower(startTime);
        }

        @Override
        public String getScriptCreateStatement() {
            return "null";
        }

        @Override
        public void react(Interactive i, Direction direction) {
            if (i instanceof Entity && !((Entity)i instanceof Rotodisc) && !((Entity)i instanceof Disc)) {
                GameLogic.gamemode.reportKill(this, (Entity)i);
                ((Entity)i).die();
            }
        }

        @Override
        protected void createSprites(String spriteFilename) {
            try {
                BufferedImage sheet = ImageIO.read(new File("res/gfx/packs/" + MapScene.texturePackName + "/hazards/" + spriteFilename + ".png"));
                BufferedImage[] sprites = new BufferedImage[sheet.getWidth() / 32];
                for (int i = 0; i < sprites.length; ++i) {
                    sprites[i] = sheet.getSubimage(i * 32, 0, 32, 32);
                }
                this.anim = new Animation(90L, sprites);
                this.currentImage = this.anim.getImage();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        protected void setTeamColor(Team teamColor) {
        }

        @Override
        public void update(long timePassed) {
            super.update(timePassed);
            this.helper.update(timePassed);
        }

        @Override
        protected void updateMovement(long timePassed) {
            this.setMapLocation(this.helper.getCurrentPoint());
        }

        @Override
        protected void updateImage(long timePassed) {
            this.anim.update(timePassed);
            this.currentImage = this.anim.getImage();
        }

        private void setMapLocation(Point2D.Float point) {
            this.entityX = point.x - (float)(this.width / 2);
            this.entityY = point.y - (float)(this.height / 2);
            Map map = LevelEditorScene.isRunning() ? LevelEditorScene.map : GameLogic.currentMap;
            this.x = (int)this.entityX;
            this.y = (int)this.entityY;
            if (map != null) {
                if (this.entityX < 0.0f) {
                    this.entityX += (float)map.MAP_WIDTH;
                } else if (this.entityX > (float)map.MAP_WIDTH) {
                    this.entityX -= (float)map.MAP_WIDTH;
                }
            }
        }

        public void setPath(Direction dir) {
        }

        public void resetPathFollower(double startTime) {
            this.helper = new PathFollower(Rotodisc.this.path, Rotodisc.this.dir == Direction.COUNTER_CLOCKWISE, Rotodisc.this.speed, startTime);
            this.setMapLocation(this.helper.getCurrentPoint());
        }

        @Override
        public void collisionLogic() {
        }

        @Override
        public void iTileBumpTop() {
        }
    }
}

