/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.entity;

import com.dmgame.Animation;
import com.dmgame.GameLogic;
import com.dmgame.entity.Entity;
import com.dmgame.entity.Holdable;
import com.dmgame.entity.Player;
import com.dmgame.entity.Team;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;

public strictfp abstract class Shell
extends Entity
implements Holdable {
    private static final long serialVersionUID = 2315509213672231586L;
    protected transient Animation movingAnim;
    protected transient BufferedImage idleSprite;
    protected boolean moving;
    protected long maxLifeTime;
    protected Runnable life;

    public Shell(String spriteFilename, float x, float y, long maxLifeTime) {
        super(spriteFilename, x, y, Team.UNALLIED);
        this.ctypes.add(Entity.CollisionType.HORIZ_BOUNCE);
        this.maxLifeTime = maxLifeTime;
        this.currentImage = this.idleSprite;
        this.moving = false;
        this.hspeed = 0.0f;
        this.vspeed = 0.0f;
        this.life = new Runnable(){

            @Override
            public void run() {
                Shell.this.die();
            }
        };
        GameLogic.startDelayedAction(maxLifeTime, this.life);
    }

    @Override
    protected void createSprites(String spriteFilename) {
        try {
            BufferedImage main = ImageIO.read(new File("res/gfx/packs/Default/projectiles/" + spriteFilename + ".png"));
            BufferedImage[] sprites = new BufferedImage[4];
            this.idleSprite = sprites[0] = main.getSubimage(0, 0, 32, 32);
            sprites[1] = main.getSubimage(32, 0, 32, 32);
            sprites[2] = main.getSubimage(64, 0, 32, 32);
            sprites[3] = main.getSubimage(96, 0, 32, 32);
            this.movingAnim = new Animation(80L, sprites);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void setTeamColor(Team teamColor) {
    }

    @Override
    public void update(long timePassed) {
        super.update(timePassed);
        if (!this.moving) {
            GameLogic.removeDelayedAction(this.life);
        } else if (!GameLogic.containsDelayedAction(this.life)) {
            GameLogic.startDelayedAction(this.maxLifeTime, this.life);
        }
    }

    @Override
    protected void updateMovement(long timePassed) {
        if (!this.onGround) {
            this.vspeed += 0.4f;
        }
        if (this.vspeed > 18.0f) {
            this.vspeed = 18.0f;
        }
        this.entityX += this.hspeed;
        this.entityY += this.vspeed;
        if (this.hspeed > 0.0f) {
            if (this.hspeed > 5.0f) {
                this.hspeed -= 0.2f;
            }
        } else if (this.hspeed < 0.0f && this.hspeed < -5.0f) {
            this.hspeed += 0.2f;
        }
        this.moving = this.hspeed != 0.0f;
        this.x = (int)this.entityX;
        this.y = (int)this.entityY;
        if (this.entityX < 0.0f) {
            this.entityX += (float)GameLogic.currentMap.MAP_WIDTH;
        } else if (this.entityX > (float)GameLogic.currentMap.MAP_WIDTH) {
            this.entityX -= (float)GameLogic.currentMap.MAP_WIDTH;
        }
        if (this.entityY > (float)GameLogic.currentMap.MAP_HEIGHT) {
            this.entityY = -32.0f;
        }
    }

    @Override
    protected void updateImage(long timePassed) {
        if (this.moving) {
            this.movingAnim.update(timePassed);
            this.currentImage = this.movingAnim.getImage();
        } else {
            this.movingAnim.reset();
        }
    }

    @Override
    public void release(Entity thrower) {
        this.entityX = ((Player)thrower).facingRight ? thrower.entityX + 16.0f : thrower.entityX - 16.0f;
        this.entityY = thrower.entityY;
        this.hspeed = ((Player)thrower).facingRight ? 1.0f : -1.0f;
        this.spawn();
    }

    @Override
    public BufferedImage getHeldImage() {
        return this.idleSprite;
    }

    @Override
    public void iTileBumpTop() {
        if (this.canReact) {
            this.vspeed = -3.0f;
        }
    }
}

