/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.entity;

import com.dmgame.Direction;
import com.dmgame.GameLogic;
import com.dmgame.Interactive;
import com.dmgame.MapScene;
import com.dmgame.entity.EditableEntity;
import com.dmgame.entity.Entity;
import com.dmgame.entity.Holdable;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JMenu;

public class Spike
extends EditableEntity
implements Holdable {
    private static final long serialVersionUID = -7616785503241650071L;

    public Spike(float entityX, float entityY, boolean editorMode) {
        super("spike", entityX, entityY, editorMode);
    }

    @Override
    public String getScriptCreateStatement() {
        return this.buildString(this.getClass().getSimpleName(), "(", Float.valueOf(this.entityX), ",", Float.valueOf(this.entityY), ",", this.editorMode, ")");
    }

    @Override
    protected void createSprites(String spriteFilename) {
        try {
            this.currentImage = ImageIO.read(new File("res/gfx/packs/" + MapScene.texturePackName + "/mapobjects/" + spriteFilename + ".png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void react(Interactive i, Direction direction) {
        if (i instanceof Entity) {
            Entity e = (Entity)i;
            switch (direction) {
                case DOWN: {
                    GameLogic.gamemode.reportKill(this, e);
                    e.die();
                    break;
                }
                case LEFT: {
                    if (!e.facingRight) break;
                    e.canMoveRight = false;
                    break;
                }
                case RIGHT: {
                    if (e.facingRight) break;
                    e.canMoveLeft = false;
                    break;
                }
                case UP: {
                    e.canMoveUp = false;
                    break;
                }
            }
        }
    }

    @Override
    protected void updateMovement(long timePassed) {
        if (!this.onGround) {
            this.vspeed += 0.4f;
        }
        if (this.vspeed > 18.0f) {
            this.vspeed = 18.0f;
        }
        if (this.onGround) {
            if (this.facingRight && this.hspeed != 0.0f && this.canMoveRight) {
                this.hspeed = this.onSlippery ? (this.hspeed -= 0.05f) : (this.hspeed -= 0.2f);
                if (this.hspeed < 0.0f) {
                    this.hspeed = 0.0f;
                }
            } else if (this.hspeed != 0.0f && this.canMoveLeft) {
                this.hspeed = this.onSlippery ? (this.hspeed += 0.05f) : (this.hspeed += 0.2f);
                if (this.hspeed > 0.0f) {
                    this.hspeed = 0.0f;
                }
            }
        } else if (this.facingRight && this.hspeed != 0.0f && this.canMoveRight) {
            this.hspeed -= 0.05f;
            if (this.hspeed < 0.0f) {
                this.hspeed = 0.0f;
            }
        } else if (this.hspeed != 0.0f && this.canMoveLeft) {
            this.hspeed += 0.05f;
            if (this.hspeed > 0.0f) {
                this.hspeed = 0.0f;
            }
        }
        this.entityX += this.hspeed;
        this.entityY += this.vspeed;
        this.x = (int)this.entityX;
        this.y = (int)this.entityY;
        if (this.entityX < 0.0f) {
            this.entityX += (float)GameLogic.currentMap.MAP_WIDTH;
        } else if (this.entityX > (float)GameLogic.currentMap.MAP_WIDTH) {
            this.entityX -= (float)GameLogic.currentMap.MAP_WIDTH;
        }
        if (this.entityY > (float)GameLogic.currentMap.MAP_HEIGHT) {
            this.entityY = -32.0f;
        }
    }

    @Override
    protected void updateImage(long timePassed) {
    }

    @Override
    public BufferedImage getHeldImage() {
        return this.getImage();
    }

    @Override
    public void release(Entity thrower) {
        this.facingRight = thrower.facingRight;
        this.entityX = thrower.facingRight ? thrower.entityX + 16.0f : thrower.entityX - 16.0f;
        this.entityY = thrower.entityY;
        this.hspeed = thrower.facingRight ? 3.0f : -3.0f;
        this.vspeed = -3.0f;
        this.spawn();
    }

    @Override
    protected JComponent[] setupComponents() {
        return null;
    }

    @Override
    protected JMenu[] getSettingsMenuOptions() {
        return null;
    }

    @Override
    protected LayoutManager getLayout() {
        return null;
    }

    @Override
    public Object clone() {
        Spike s = new Spike(this.entityX, this.entityY, this.editorMode);
        s.x = Math.round(this.entityX);
        s.y = Math.round(this.entityY);
        return s;
    }

    @Override
    public void iTileBumpTop() {
        this.vspeed = -3.0f;
    }
}

