/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.entity;

import com.dmgame.Animation;
import com.dmgame.Direction;
import com.dmgame.GameLogic;
import com.dmgame.Interactive;
import com.dmgame.MapScene;
import com.dmgame.entity.EditableEntity;
import com.dmgame.entity.Entity;
import com.dmgame.entity.Holdable;
import com.dmgame.entity.Player;
import com.dmgame.sound.Sound;
import com.dmgame.sound.SoundPlayer;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;

public class Spring
extends EditableEntity
implements Holdable {
    private static final long serialVersionUID = -1811012890921999582L;
    public static int GREEN = 0;
    public static int ORANGE = 1;
    private SpringColor color = SpringColor.GREEN;
    private transient boolean bouncing = false;
    public transient Animation[] bounceAnim;
    public transient BufferedImage[] sprites;

    public Spring(float entityX, float entityY, boolean editorMode) {
        super("greenspring", entityX, entityY, editorMode);
    }

    public Spring(float entityX, float entityY, int color) {
        this(entityX, entityY, false);
        if (color == 1) {
            this.setOrange();
        }
    }

    @Override
    public String getScriptCreateStatement() {
        return this.buildString(this.getClass().getSimpleName(), "(", Float.valueOf(this.entityX), ",", Float.valueOf(this.entityY), ",", this.color == SpringColor.ORANGE ? ORANGE : GREEN, ")");
    }

    @Override
    protected void createSprites(String spriteFilename) {
        try {
            BufferedImage[] spritesGreen = new BufferedImage[4];
            BufferedImage green = ImageIO.read(new File("res/gfx/packs/" + MapScene.texturePackName + "/mapobjects/" + spriteFilename + ".png"));
            spritesGreen[0] = green.getSubimage(0, 0, 32, 32);
            spritesGreen[1] = green.getSubimage(32, 0, 32, 32);
            spritesGreen[2] = green.getSubimage(64, 0, 32, 32);
            spritesGreen[3] = green.getSubimage(96, 0, 32, 32);
            BufferedImage[] spritesOrange = new BufferedImage[4];
            BufferedImage orange = ImageIO.read(new File("res/gfx/packs/" + MapScene.texturePackName + "/mapobjects/orangespring.png"));
            spritesOrange[0] = orange.getSubimage(0, 0, 32, 32);
            spritesOrange[1] = orange.getSubimage(32, 0, 32, 32);
            spritesOrange[2] = orange.getSubimage(64, 0, 32, 32);
            spritesOrange[3] = orange.getSubimage(96, 0, 32, 32);
            this.sprites = new BufferedImage[2];
            this.sprites[Spring.GREEN] = spritesGreen[0];
            this.sprites[Spring.ORANGE] = spritesOrange[0];
            this.bounceAnim = new Animation[2];
            this.bounceAnim[Spring.GREEN] = new Animation(80L, spritesGreen);
            this.bounceAnim[Spring.ORANGE] = new Animation(80L, spritesOrange);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void react(Interactive i, Direction direction) {
        if (i instanceof Entity) {
            Entity e = (Entity)i;
            if (i instanceof Player && direction == Direction.DOWN) {
                SoundPlayer.playSound(Sound.BUMP);
            }
            switch (direction) {
                case DOWN: {
                    e.vspeed = -6.0f;
                    e.onGround = false;
                    if (e instanceof Player && !((Player)e).alreadyJumped) {
                        SoundPlayer.playSound(Sound.SPRING);
                        ((Player)e).airTime = 192;
                        ((Player)e).alreadyJumped = true;
                    }
                    this.bouncing = true;
                    break;
                }
                case LEFT: {
                    if (!e.facingRight) break;
                    e.canMoveRight = false;
                    break;
                }
                case RIGHT: {
                    if (e.facingRight) break;
                    e.canMoveLeft = false;
                    break;
                }
                case UP: {
                    e.canMoveUp = false;
                    break;
                }
            }
        }
    }

    @Override
    protected void updateMovement(long timePassed) {
        if (!this.onGround) {
            this.vspeed += 0.4f;
        }
        if (this.vspeed > 18.0f) {
            this.vspeed = 18.0f;
        }
        if (this.onGround) {
            if (this.facingRight && this.hspeed != 0.0f && this.canMoveRight) {
                this.hspeed = this.onSlippery ? (this.hspeed -= 0.05f) : (this.hspeed -= 0.2f);
                if (this.hspeed < 0.0f) {
                    this.hspeed = 0.0f;
                }
            } else if (this.hspeed != 0.0f && this.canMoveLeft) {
                this.hspeed = this.onSlippery ? (this.hspeed += 0.05f) : (this.hspeed += 0.2f);
                if (this.hspeed > 0.0f) {
                    this.hspeed = 0.0f;
                }
            }
        } else if (this.facingRight && this.hspeed != 0.0f && this.canMoveRight) {
            this.hspeed -= 0.05f;
            if (this.hspeed < 0.0f) {
                this.hspeed = 0.0f;
            }
        } else if (this.hspeed != 0.0f && this.canMoveLeft) {
            this.hspeed += 0.05f;
            if (this.hspeed > 0.0f) {
                this.hspeed = 0.0f;
            }
        }
        this.entityX += this.hspeed;
        this.entityY += this.vspeed;
        this.x = (int)this.entityX;
        this.y = (int)this.entityY;
        if (this.entityX < 0.0f) {
            this.entityX += (float)GameLogic.currentMap.MAP_WIDTH;
        } else if (this.entityX > (float)GameLogic.currentMap.MAP_WIDTH) {
            this.entityX -= (float)GameLogic.currentMap.MAP_WIDTH;
        }
        if (this.entityY > (float)GameLogic.currentMap.MAP_HEIGHT) {
            this.entityY = -32.0f;
        }
    }

    @Override
    protected void updateImage(long timePassed) {
        switch (this.color) {
            case GREEN: {
                if (this.bouncing) {
                    this.bounceAnim[GREEN].update(timePassed);
                    if (this.bounceAnim[GREEN].firstCycleCompleted()) {
                        this.bouncing = false;
                    }
                    this.currentImage = this.bounceAnim[GREEN].getImage();
                    break;
                }
                this.bounceAnim[GREEN].reset();
                this.currentImage = this.sprites[GREEN];
                break;
            }
            case ORANGE: {
                if (this.bouncing) {
                    this.bounceAnim[ORANGE].update(timePassed);
                    if (this.bounceAnim[ORANGE].firstCycleCompleted()) {
                        this.bouncing = false;
                    }
                    this.currentImage = this.bounceAnim[ORANGE].getImage();
                    break;
                }
                this.bounceAnim[ORANGE].reset();
                this.currentImage = this.sprites[ORANGE];
            }
        }
    }

    @Override
    public BufferedImage getHeldImage() {
        switch (this.color) {
            case GREEN: {
                return this.sprites[GREEN];
            }
            case ORANGE: {
                return this.sprites[ORANGE];
            }
        }
        return null;
    }

    @Override
    public void release(Entity thrower) {
        this.facingRight = thrower.facingRight;
        this.entityX = thrower.facingRight ? thrower.entityX + 16.0f : thrower.entityX - 16.0f;
        this.entityY = thrower.entityY;
        this.hspeed = thrower.facingRight ? 3.0f : -3.0f;
        this.vspeed = -3.0f;
        this.spawn();
    }

    @Override
    protected JComponent[] setupComponents() {
        return null;
    }

    @Override
    protected JMenu[] getSettingsMenuOptions() {
        JMenu[] toReturn = new JMenu[1];
        JMenu menu = new JMenu("Spring Type");
        ButtonGroup group = new ButtonGroup();
        JRadioButtonMenuItem greenButton = new JRadioButtonMenuItem("Green");
        greenButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Spring.this.color = SpringColor.GREEN;
            }
        });
        group.add(greenButton);
        menu.add(greenButton);
        JRadioButtonMenuItem orangeButton = new JRadioButtonMenuItem("Orange");
        orangeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Spring.this.color = SpringColor.ORANGE;
            }
        });
        group.add(orangeButton);
        menu.add(orangeButton);
        switch (this.color) {
            case GREEN: {
                greenButton.setSelected(true);
                break;
            }
            case ORANGE: {
                orangeButton.setSelected(true);
            }
        }
        menu.validate();
        toReturn[0] = menu;
        return toReturn;
    }

    @Override
    protected LayoutManager getLayout() {
        return null;
    }

    @Override
    public Object clone() {
        Spring s = new Spring(this.entityX, this.entityY, this.editorMode);
        s.x = Math.round(this.entityX);
        s.y = Math.round(this.entityY);
        s.color = this.color;
        return s;
    }

    @Override
    public void iTileBumpTop() {
        this.vspeed = -3.0f;
    }

    public Spring setOrange() {
        this.color = SpringColor.ORANGE;
        return this;
    }

    protected static enum SpringColor {
        GREEN,
        ORANGE;

    }
}

