/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.entity;

import com.dmgame.ColorSet;
import com.dmgame.GameLogic;
import com.dmgame.entity.Entity;
import java.util.HashSet;
import java.util.Set;

public enum Team {
    RED(ColorSet.redColorSet),
    YELLOW(ColorSet.yellowColorSet),
    BLUE(ColorSet.blueColorSet),
    GREEN(ColorSet.greenColorSet),
    UNALLIED;

    public ColorSet colors;

    private Team() {
        this.colors = ColorSet.defaultColorSet;
    }

    private Team(ColorSet set) {
        this.colors = set;
    }

    public static Team getTeamByString(String s) {
        switch (s.toLowerCase()) {
            case "red": {
                return RED;
            }
            case "yellow": {
                return YELLOW;
            }
            case "blue": {
                return BLUE;
            }
            case "green": {
                return GREEN;
            }
        }
        return UNALLIED;
    }

    public static synchronized Set<Entity> getEntitiesByTeam(Team teamColor) {
        HashSet<Entity> toReturn = new HashSet<Entity>();
        for (Entity e : GameLogic.entities.values()) {
            if (e.teamColor != teamColor) continue;
            toReturn.add(e);
        }
        return toReturn;
    }
}

