/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.entity;

import com.dmgame.Animation;
import com.dmgame.Direction;
import com.dmgame.GameLogic;
import com.dmgame.Interactive;
import com.dmgame.entity.Entity;
import com.dmgame.entity.Holdable;
import com.dmgame.entity.Player;
import com.dmgame.entity.Team;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;

public strictfp abstract class ThrowBlockEntity
extends Entity
implements Holdable {
    private static final long serialVersionUID = 3007048670386728831L;
    protected transient Animation throwAnim;
    protected long maxLifeTime;
    protected boolean canKill;
    public static final long KILL_DELAY = 50L;
    public static final long MAX_HOLD_TIME = 3000L;
    protected Entity thrower;
    protected Runnable die;

    public ThrowBlockEntity(String spriteFilename, float x, float y, long maxLifeTime, Entity thrower) {
        super(spriteFilename, x, y, thrower.teamColor);
        this.maxLifeTime = maxLifeTime;
        this.thrower = thrower;
        this.hspeed = 0.0f;
        this.vspeed = 0.0f;
        this.canKill = false;
    }

    @Override
    protected void createSprites(String spriteFilename) {
        try {
            BufferedImage main = ImageIO.read(new File("res/gfx/packs/Default/projectiles/" + spriteFilename + ".png"));
            BufferedImage[] sprites = new BufferedImage[]{main.getSubimage(0, 0, 32, 32), main.getSubimage(32, 0, 32, 32), main.getSubimage(64, 0, 32, 32), main.getSubimage(96, 0, 32, 32)};
            this.throwAnim = new Animation(30L, sprites);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void setTeamColor(Team teamColor) {
    }

    @Override
    public void react(Interactive i, Direction direction) {
        if (i instanceof Entity && ((Entity)i).teamColor == Team.GREEN) {
            System.out.println();
        }
        if (this.canKill && i instanceof Entity && this.teamColor != ((Entity)i).teamColor) {
            GameLogic.gamemode.reportKill(this.thrower, (Entity)i);
            ((Entity)i).die();
        }
    }

    @Override
    protected void updateMovement(long timePassed) {
        if (!this.onGround) {
            this.vspeed += 0.4f;
        }
        if (this.vspeed > 18.0f) {
            this.vspeed = 18.0f;
        }
        this.entityX += this.hspeed;
        this.entityY += this.vspeed;
        this.x = (int)this.entityX;
        this.y = (int)this.entityY;
        if (this.entityX < 0.0f) {
            this.entityX += (float)GameLogic.currentMap.MAP_WIDTH;
        } else if (this.entityX > (float)GameLogic.currentMap.MAP_WIDTH) {
            this.entityX -= (float)GameLogic.currentMap.MAP_WIDTH;
        }
        if (this.entityY > (float)GameLogic.currentMap.MAP_HEIGHT) {
            this.entityY = -32.0f;
        }
    }

    @Override
    protected void updateImage(long timePassed) {
        this.throwAnim.update(timePassed);
        this.currentImage = this.throwAnim.getImage();
    }

    @Override
    public BufferedImage getHeldImage() {
        return this.throwAnim.getImage();
    }

    public void startHoldTimer() {
        GameLogic.startDelayedAction(3000L, new Runnable(){

            @Override
            public void run() {
                if (((Player)ThrowBlockEntity.this.thrower).isHoldingItem() && ((Player)ThrowBlockEntity.this.thrower).heldItem.equals(ThrowBlockEntity.this)) {
                    ((Player)ThrowBlockEntity.this.thrower).heldItem = null;
                }
            }
        });
    }

    public void startCanKillTimer() {
        GameLogic.startDelayedAction(50L, new Runnable(){

            @Override
            public void run() {
                ThrowBlockEntity.this.canKill = true;
            }
        });
    }

    public void startLifeTimer() {
        this.die = new Runnable(){

            @Override
            public void run() {
                ThrowBlockEntity.this.die();
                GameLogic.removeEntity(ThrowBlockEntity.this);
            }
        };
        GameLogic.startDelayedAction(this.maxLifeTime, this.die);
    }

    @Override
    public void release(Entity thrower) {
        this.entityX = ((Player)thrower).facingRight ? thrower.entityX + 16.0f : thrower.entityX - 16.0f;
        this.entityY = thrower.entityY;
        this.hspeed = ((Player)thrower).facingRight ? 10.0f : -10.0f;
        this.vspeed = 0.0f;
        this.spawn();
        this.startCanKillTimer();
        this.startLifeTimer();
    }

    protected abstract void createParticles();

    @Override
    public void iTileBumpTop() {
        this.vspeed = -3.0f;
    }
}

